# kubernetes.client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: release-1.22
- Package version: 22.6.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/kubernetes-client/python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/kubernetes-client/python.git`)

Then import the package:
```python
import kubernetes.client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import kubernetes.client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import kubernetes.client
from kubernetes.client.rest import ApiException
from pprint import pprint

configuration = kubernetes.client.Configuration()
# Configure API key authorization: BearerToken
configuration.api_key['authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['authorization'] = 'Bearer'

# Defining host is optional and default to http://localhost
configuration.host = "http://localhost"

# Defining host is optional and default to http://localhost
configuration.host = "http://localhost"
# Enter a context with an instance of the API kubernetes.client
with kubernetes.client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = kubernetes.client.WellKnownApi(api_client)
    
    try:
        api_response = api_instance.get_service_account_issuer_open_id_configuration()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling WellKnownApi->get_service_account_issuer_open_id_configuration: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*WellKnownApi* | [**get_service_account_issuer_open_id_configuration**](docs/WellKnownApi.md#get_service_account_issuer_open_id_configuration) | **GET** /.well-known/openid-configuration/ | 
*AdmissionregistrationApi* | [**get_api_group**](docs/AdmissionregistrationApi.md#get_api_group) | **GET** /apis/admissionregistration.k8s.io/ | 
*AdmissionregistrationV1Api* | [**create_mutating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#create_mutating_webhook_configuration) | **POST** /apis/admissionregistration.k8s.io/v1/mutatingwebhookconfigurations | 
*AdmissionregistrationV1Api* | [**create_validating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#create_validating_webhook_configuration) | **POST** /apis/admissionregistration.k8s.io/v1/validatingwebhookconfigurations | 
*AdmissionregistrationV1Api* | [**delete_collection_mutating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#delete_collection_mutating_webhook_configuration) | **DELETE** /apis/admissionregistration.k8s.io/v1/mutatingwebhookconfigurations | 
*AdmissionregistrationV1Api* | [**delete_collection_validating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#delete_collection_validating_webhook_configuration) | **DELETE** /apis/admissionregistration.k8s.io/v1/validatingwebhookconfigurations | 
*AdmissionregistrationV1Api* | [**delete_mutating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#delete_mutating_webhook_configuration) | **DELETE** /apis/admissionregistration.k8s.io/v1/mutatingwebhookconfigurations/{name} | 
*AdmissionregistrationV1Api* | [**delete_validating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#delete_validating_webhook_configuration) | **DELETE** /apis/admissionregistration.k8s.io/v1/validatingwebhookconfigurations/{name} | 
*AdmissionregistrationV1Api* | [**get_api_resources**](docs/AdmissionregistrationV1Api.md#get_api_resources) | **GET** /apis/admissionregistration.k8s.io/v1/ | 
*AdmissionregistrationV1Api* | [**list_mutating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#list_mutating_webhook_configuration) | **GET** /apis/admissionregistration.k8s.io/v1/mutatingwebhookconfigurations | 
*AdmissionregistrationV1Api* | [**list_validating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#list_validating_webhook_configuration) | **GET** /apis/admissionregistration.k8s.io/v1/validatingwebhookconfigurations | 
*AdmissionregistrationV1Api* | [**patch_mutating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#patch_mutating_webhook_configuration) | **PATCH** /apis/admissionregistration.k8s.io/v1/mutatingwebhookconfigurations/{name} | 
*AdmissionregistrationV1Api* | [**patch_validating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#patch_validating_webhook_configuration) | **PATCH** /apis/admissionregistration.k8s.io/v1/validatingwebhookconfigurations/{name} | 
*AdmissionregistrationV1Api* | [**read_mutating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#read_mutating_webhook_configuration) | **GET** /apis/admissionregistration.k8s.io/v1/mutatingwebhookconfigurations/{name} | 
*AdmissionregistrationV1Api* | [**read_validating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#read_validating_webhook_configuration) | **GET** /apis/admissionregistration.k8s.io/v1/validatingwebhookconfigurations/{name} | 
*AdmissionregistrationV1Api* | [**replace_mutating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#replace_mutating_webhook_configuration) | **PUT** /apis/admissionregistration.k8s.io/v1/mutatingwebhookconfigurations/{name} | 
*AdmissionregistrationV1Api* | [**replace_validating_webhook_configuration**](docs/AdmissionregistrationV1Api.md#replace_validating_webhook_configuration) | **PUT** /apis/admissionregistration.k8s.io/v1/validatingwebhookconfigurations/{name} | 
*ApiextensionsApi* | [**get_api_group**](docs/ApiextensionsApi.md#get_api_group) | **GET** /apis/apiextensions.k8s.io/ | 
*ApiextensionsV1Api* | [**create_custom_resource_definition**](docs/ApiextensionsV1Api.md#create_custom_resource_definition) | **POST** /apis/apiextensions.k8s.io/v1/customresourcedefinitions | 
*ApiextensionsV1Api* | [**delete_collection_custom_resource_definition**](docs/ApiextensionsV1Api.md#delete_collection_custom_resource_definition) | **DELETE** /apis/apiextensions.k8s.io/v1/customresourcedefinitions | 
*ApiextensionsV1Api* | [**delete_custom_resource_definition**](docs/ApiextensionsV1Api.md#delete_custom_resource_definition) | **DELETE** /apis/apiextensions.k8s.io/v1/customresourcedefinitions/{name} | 
*ApiextensionsV1Api* | [**get_api_resources**](docs/ApiextensionsV1Api.md#get_api_resources) | **GET** /apis/apiextensions.k8s.io/v1/ | 
*ApiextensionsV1Api* | [**list_custom_resource_definition**](docs/ApiextensionsV1Api.md#list_custom_resource_definition) | **GET** /apis/apiextensions.k8s.io/v1/customresourcedefinitions | 
*ApiextensionsV1Api* | [**patch_custom_resource_definition**](docs/ApiextensionsV1Api.md#patch_custom_resource_definition) | **PATCH** /apis/apiextensions.k8s.io/v1/customresourcedefinitions/{name} | 
*ApiextensionsV1Api* | [**patch_custom_resource_definition_status**](docs/ApiextensionsV1Api.md#patch_custom_resource_definition_status) | **PATCH** /apis/apiextensions.k8s.io/v1/customresourcedefinitions/{name}/status | 
*ApiextensionsV1Api* | [**read_custom_resource_definition**](docs/ApiextensionsV1Api.md#read_custom_resource_definition) | **GET** /apis/apiextensions.k8s.io/v1/customresourcedefinitions/{name} | 
*ApiextensionsV1Api* | [**read_custom_resource_definition_status**](docs/ApiextensionsV1Api.md#read_custom_resource_definition_status) | **GET** /apis/apiextensions.k8s.io/v1/customresourcedefinitions/{name}/status | 
*ApiextensionsV1Api* | [**replace_custom_resource_definition**](docs/ApiextensionsV1Api.md#replace_custom_resource_definition) | **PUT** /apis/apiextensions.k8s.io/v1/customresourcedefinitions/{name} | 
*ApiextensionsV1Api* | [**replace_custom_resource_definition_status**](docs/ApiextensionsV1Api.md#replace_custom_resource_definition_status) | **PUT** /apis/apiextensions.k8s.io/v1/customresourcedefinitions/{name}/status | 
*ApiregistrationApi* | [**get_api_group**](docs/ApiregistrationApi.md#get_api_group) | **GET** /apis/apiregistration.k8s.io/ | 
*ApiregistrationV1Api* | [**create_api_service**](docs/ApiregistrationV1Api.md#create_api_service) | **POST** /apis/apiregistration.k8s.io/v1/apiservices | 
*ApiregistrationV1Api* | [**delete_api_service**](docs/ApiregistrationV1Api.md#delete_api_service) | **DELETE** /apis/apiregistration.k8s.io/v1/apiservices/{name} | 
*ApiregistrationV1Api* | [**delete_collection_api_service**](docs/ApiregistrationV1Api.md#delete_collection_api_service) | **DELETE** /apis/apiregistration.k8s.io/v1/apiservices | 
*ApiregistrationV1Api* | [**get_api_resources**](docs/ApiregistrationV1Api.md#get_api_resources) | **GET** /apis/apiregistration.k8s.io/v1/ | 
*ApiregistrationV1Api* | [**list_api_service**](docs/ApiregistrationV1Api.md#list_api_service) | **GET** /apis/apiregistration.k8s.io/v1/apiservices | 
*ApiregistrationV1Api* | [**patch_api_service**](docs/ApiregistrationV1Api.md#patch_api_service) | **PATCH** /apis/apiregistration.k8s.io/v1/apiservices/{name} | 
*ApiregistrationV1Api* | [**patch_api_service_status**](docs/ApiregistrationV1Api.md#patch_api_service_status) | **PATCH** /apis/apiregistration.k8s.io/v1/apiservices/{name}/status | 
*ApiregistrationV1Api* | [**read_api_service**](docs/ApiregistrationV1Api.md#read_api_service) | **GET** /apis/apiregistration.k8s.io/v1/apiservices/{name} | 
*ApiregistrationV1Api* | [**read_api_service_status**](docs/ApiregistrationV1Api.md#read_api_service_status) | **GET** /apis/apiregistration.k8s.io/v1/apiservices/{name}/status | 
*ApiregistrationV1Api* | [**replace_api_service**](docs/ApiregistrationV1Api.md#replace_api_service) | **PUT** /apis/apiregistration.k8s.io/v1/apiservices/{name} | 
*ApiregistrationV1Api* | [**replace_api_service_status**](docs/ApiregistrationV1Api.md#replace_api_service_status) | **PUT** /apis/apiregistration.k8s.io/v1/apiservices/{name}/status | 
*ApisApi* | [**get_api_versions**](docs/ApisApi.md#get_api_versions) | **GET** /apis/ | 
*AppsApi* | [**get_api_group**](docs/AppsApi.md#get_api_group) | **GET** /apis/apps/ | 
*AppsV1Api* | [**create_namespaced_controller_revision**](docs/AppsV1Api.md#create_namespaced_controller_revision) | **POST** /apis/apps/v1/namespaces/{namespace}/controllerrevisions | 
*AppsV1Api* | [**create_namespaced_daemon_set**](docs/AppsV1Api.md#create_namespaced_daemon_set) | **POST** /apis/apps/v1/namespaces/{namespace}/daemonsets | 
*AppsV1Api* | [**create_namespaced_deployment**](docs/AppsV1Api.md#create_namespaced_deployment) | **POST** /apis/apps/v1/namespaces/{namespace}/deployments | 
*AppsV1Api* | [**create_namespaced_replica_set**](docs/AppsV1Api.md#create_namespaced_replica_set) | **POST** /apis/apps/v1/namespaces/{namespace}/replicasets | 
*AppsV1Api* | [**create_namespaced_stateful_set**](docs/AppsV1Api.md#create_namespaced_stateful_set) | **POST** /apis/apps/v1/namespaces/{namespace}/statefulsets | 
*AppsV1Api* | [**delete_collection_namespaced_controller_revision**](docs/AppsV1Api.md#delete_collection_namespaced_controller_revision) | **DELETE** /apis/apps/v1/namespaces/{namespace}/controllerrevisions | 
*AppsV1Api* | [**delete_collection_namespaced_daemon_set**](docs/AppsV1Api.md#delete_collection_namespaced_daemon_set) | **DELETE** /apis/apps/v1/namespaces/{namespace}/daemonsets | 
*AppsV1Api* | [**delete_collection_namespaced_deployment**](docs/AppsV1Api.md#delete_collection_namespaced_deployment) | **DELETE** /apis/apps/v1/namespaces/{namespace}/deployments | 
*AppsV1Api* | [**delete_collection_namespaced_replica_set**](docs/AppsV1Api.md#delete_collection_namespaced_replica_set) | **DELETE** /apis/apps/v1/namespaces/{namespace}/replicasets | 
*AppsV1Api* | [**delete_collection_namespaced_stateful_set**](docs/AppsV1Api.md#delete_collection_namespaced_stateful_set) | **DELETE** /apis/apps/v1/namespaces/{namespace}/statefulsets | 
*AppsV1Api* | [**delete_namespaced_controller_revision**](docs/AppsV1Api.md#delete_namespaced_controller_revision) | **DELETE** /apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name} | 
*AppsV1Api* | [**delete_namespaced_daemon_set**](docs/AppsV1Api.md#delete_namespaced_daemon_set) | **DELETE** /apis/apps/v1/namespaces/{namespace}/daemonsets/{name} | 
*AppsV1Api* | [**delete_namespaced_deployment**](docs/AppsV1Api.md#delete_namespaced_deployment) | **DELETE** /apis/apps/v1/namespaces/{namespace}/deployments/{name} | 
*AppsV1Api* | [**delete_namespaced_replica_set**](docs/AppsV1Api.md#delete_namespaced_replica_set) | **DELETE** /apis/apps/v1/namespaces/{namespace}/replicasets/{name} | 
*AppsV1Api* | [**delete_namespaced_stateful_set**](docs/AppsV1Api.md#delete_namespaced_stateful_set) | **DELETE** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name} | 
*AppsV1Api* | [**get_api_resources**](docs/AppsV1Api.md#get_api_resources) | **GET** /apis/apps/v1/ | 
*AppsV1Api* | [**list_controller_revision_for_all_namespaces**](docs/AppsV1Api.md#list_controller_revision_for_all_namespaces) | **GET** /apis/apps/v1/controllerrevisions | 
*AppsV1Api* | [**list_daemon_set_for_all_namespaces**](docs/AppsV1Api.md#list_daemon_set_for_all_namespaces) | **GET** /apis/apps/v1/daemonsets | 
*AppsV1Api* | [**list_deployment_for_all_namespaces**](docs/AppsV1Api.md#list_deployment_for_all_namespaces) | **GET** /apis/apps/v1/deployments | 
*AppsV1Api* | [**list_namespaced_controller_revision**](docs/AppsV1Api.md#list_namespaced_controller_revision) | **GET** /apis/apps/v1/namespaces/{namespace}/controllerrevisions | 
*AppsV1Api* | [**list_namespaced_daemon_set**](docs/AppsV1Api.md#list_namespaced_daemon_set) | **GET** /apis/apps/v1/namespaces/{namespace}/daemonsets | 
*AppsV1Api* | [**list_namespaced_deployment**](docs/AppsV1Api.md#list_namespaced_deployment) | **GET** /apis/apps/v1/namespaces/{namespace}/deployments | 
*AppsV1Api* | [**list_namespaced_replica_set**](docs/AppsV1Api.md#list_namespaced_replica_set) | **GET** /apis/apps/v1/namespaces/{namespace}/replicasets | 
*AppsV1Api* | [**list_namespaced_stateful_set**](docs/AppsV1Api.md#list_namespaced_stateful_set) | **GET** /apis/apps/v1/namespaces/{namespace}/statefulsets | 
*AppsV1Api* | [**list_replica_set_for_all_namespaces**](docs/AppsV1Api.md#list_replica_set_for_all_namespaces) | **GET** /apis/apps/v1/replicasets | 
*AppsV1Api* | [**list_stateful_set_for_all_namespaces**](docs/AppsV1Api.md#list_stateful_set_for_all_namespaces) | **GET** /apis/apps/v1/statefulsets | 
*AppsV1Api* | [**patch_namespaced_controller_revision**](docs/AppsV1Api.md#patch_namespaced_controller_revision) | **PATCH** /apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name} | 
*AppsV1Api* | [**patch_namespaced_daemon_set**](docs/AppsV1Api.md#patch_namespaced_daemon_set) | **PATCH** /apis/apps/v1/namespaces/{namespace}/daemonsets/{name} | 
*AppsV1Api* | [**patch_namespaced_daemon_set_status**](docs/AppsV1Api.md#patch_namespaced_daemon_set_status) | **PATCH** /apis/apps/v1/namespaces/{namespace}/daemonsets/{name}/status | 
*AppsV1Api* | [**patch_namespaced_deployment**](docs/AppsV1Api.md#patch_namespaced_deployment) | **PATCH** /apis/apps/v1/namespaces/{namespace}/deployments/{name} | 
*AppsV1Api* | [**patch_namespaced_deployment_scale**](docs/AppsV1Api.md#patch_namespaced_deployment_scale) | **PATCH** /apis/apps/v1/namespaces/{namespace}/deployments/{name}/scale | 
*AppsV1Api* | [**patch_namespaced_deployment_status**](docs/AppsV1Api.md#patch_namespaced_deployment_status) | **PATCH** /apis/apps/v1/namespaces/{namespace}/deployments/{name}/status | 
*AppsV1Api* | [**patch_namespaced_replica_set**](docs/AppsV1Api.md#patch_namespaced_replica_set) | **PATCH** /apis/apps/v1/namespaces/{namespace}/replicasets/{name} | 
*AppsV1Api* | [**patch_namespaced_replica_set_scale**](docs/AppsV1Api.md#patch_namespaced_replica_set_scale) | **PATCH** /apis/apps/v1/namespaces/{namespace}/replicasets/{name}/scale | 
*AppsV1Api* | [**patch_namespaced_replica_set_status**](docs/AppsV1Api.md#patch_namespaced_replica_set_status) | **PATCH** /apis/apps/v1/namespaces/{namespace}/replicasets/{name}/status | 
*AppsV1Api* | [**patch_namespaced_stateful_set**](docs/AppsV1Api.md#patch_namespaced_stateful_set) | **PATCH** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name} | 
*AppsV1Api* | [**patch_namespaced_stateful_set_scale**](docs/AppsV1Api.md#patch_namespaced_stateful_set_scale) | **PATCH** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/scale | 
*AppsV1Api* | [**patch_namespaced_stateful_set_status**](docs/AppsV1Api.md#patch_namespaced_stateful_set_status) | **PATCH** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/status | 
*AppsV1Api* | [**read_namespaced_controller_revision**](docs/AppsV1Api.md#read_namespaced_controller_revision) | **GET** /apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name} | 
*AppsV1Api* | [**read_namespaced_daemon_set**](docs/AppsV1Api.md#read_namespaced_daemon_set) | **GET** /apis/apps/v1/namespaces/{namespace}/daemonsets/{name} | 
*AppsV1Api* | [**read_namespaced_daemon_set_status**](docs/AppsV1Api.md#read_namespaced_daemon_set_status) | **GET** /apis/apps/v1/namespaces/{namespace}/daemonsets/{name}/status | 
*AppsV1Api* | [**read_namespaced_deployment**](docs/AppsV1Api.md#read_namespaced_deployment) | **GET** /apis/apps/v1/namespaces/{namespace}/deployments/{name} | 
*AppsV1Api* | [**read_namespaced_deployment_scale**](docs/AppsV1Api.md#read_namespaced_deployment_scale) | **GET** /apis/apps/v1/namespaces/{namespace}/deployments/{name}/scale | 
*AppsV1Api* | [**read_namespaced_deployment_status**](docs/AppsV1Api.md#read_namespaced_deployment_status) | **GET** /apis/apps/v1/namespaces/{namespace}/deployments/{name}/status | 
*AppsV1Api* | [**read_namespaced_replica_set**](docs/AppsV1Api.md#read_namespaced_replica_set) | **GET** /apis/apps/v1/namespaces/{namespace}/replicasets/{name} | 
*AppsV1Api* | [**read_namespaced_replica_set_scale**](docs/AppsV1Api.md#read_namespaced_replica_set_scale) | **GET** /apis/apps/v1/namespaces/{namespace}/replicasets/{name}/scale | 
*AppsV1Api* | [**read_namespaced_replica_set_status**](docs/AppsV1Api.md#read_namespaced_replica_set_status) | **GET** /apis/apps/v1/namespaces/{namespace}/replicasets/{name}/status | 
*AppsV1Api* | [**read_namespaced_stateful_set**](docs/AppsV1Api.md#read_namespaced_stateful_set) | **GET** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name} | 
*AppsV1Api* | [**read_namespaced_stateful_set_scale**](docs/AppsV1Api.md#read_namespaced_stateful_set_scale) | **GET** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/scale | 
*AppsV1Api* | [**read_namespaced_stateful_set_status**](docs/AppsV1Api.md#read_namespaced_stateful_set_status) | **GET** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/status | 
*AppsV1Api* | [**replace_namespaced_controller_revision**](docs/AppsV1Api.md#replace_namespaced_controller_revision) | **PUT** /apis/apps/v1/namespaces/{namespace}/controllerrevisions/{name} | 
*AppsV1Api* | [**replace_namespaced_daemon_set**](docs/AppsV1Api.md#replace_namespaced_daemon_set) | **PUT** /apis/apps/v1/namespaces/{namespace}/daemonsets/{name} | 
*AppsV1Api* | [**replace_namespaced_daemon_set_status**](docs/AppsV1Api.md#replace_namespaced_daemon_set_status) | **PUT** /apis/apps/v1/namespaces/{namespace}/daemonsets/{name}/status | 
*AppsV1Api* | [**replace_namespaced_deployment**](docs/AppsV1Api.md#replace_namespaced_deployment) | **PUT** /apis/apps/v1/namespaces/{namespace}/deployments/{name} | 
*AppsV1Api* | [**replace_namespaced_deployment_scale**](docs/AppsV1Api.md#replace_namespaced_deployment_scale) | **PUT** /apis/apps/v1/namespaces/{namespace}/deployments/{name}/scale | 
*AppsV1Api* | [**replace_namespaced_deployment_status**](docs/AppsV1Api.md#replace_namespaced_deployment_status) | **PUT** /apis/apps/v1/namespaces/{namespace}/deployments/{name}/status | 
*AppsV1Api* | [**replace_namespaced_replica_set**](docs/AppsV1Api.md#replace_namespaced_replica_set) | **PUT** /apis/apps/v1/namespaces/{namespace}/replicasets/{name} | 
*AppsV1Api* | [**replace_namespaced_replica_set_scale**](docs/AppsV1Api.md#replace_namespaced_replica_set_scale) | **PUT** /apis/apps/v1/namespaces/{namespace}/replicasets/{name}/scale | 
*AppsV1Api* | [**replace_namespaced_replica_set_status**](docs/AppsV1Api.md#replace_namespaced_replica_set_status) | **PUT** /apis/apps/v1/namespaces/{namespace}/replicasets/{name}/status | 
*AppsV1Api* | [**replace_namespaced_stateful_set**](docs/AppsV1Api.md#replace_namespaced_stateful_set) | **PUT** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name} | 
*AppsV1Api* | [**replace_namespaced_stateful_set_scale**](docs/AppsV1Api.md#replace_namespaced_stateful_set_scale) | **PUT** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/scale | 
*AppsV1Api* | [**replace_namespaced_stateful_set_status**](docs/AppsV1Api.md#replace_namespaced_stateful_set_status) | **PUT** /apis/apps/v1/namespaces/{namespace}/statefulsets/{name}/status | 
*AuthenticationApi* | [**get_api_group**](docs/AuthenticationApi.md#get_api_group) | **GET** /apis/authentication.k8s.io/ | 
*AuthenticationV1Api* | [**create_token_review**](docs/AuthenticationV1Api.md#create_token_review) | **POST** /apis/authentication.k8s.io/v1/tokenreviews | 
*AuthenticationV1Api* | [**get_api_resources**](docs/AuthenticationV1Api.md#get_api_resources) | **GET** /apis/authentication.k8s.io/v1/ | 
*AuthorizationApi* | [**get_api_group**](docs/AuthorizationApi.md#get_api_group) | **GET** /apis/authorization.k8s.io/ | 
*AuthorizationV1Api* | [**create_namespaced_local_subject_access_review**](docs/AuthorizationV1Api.md#create_namespaced_local_subject_access_review) | **POST** /apis/authorization.k8s.io/v1/namespaces/{namespace}/localsubjectaccessreviews | 
*AuthorizationV1Api* | [**create_self_subject_access_review**](docs/AuthorizationV1Api.md#create_self_subject_access_review) | **POST** /apis/authorization.k8s.io/v1/selfsubjectaccessreviews | 
*AuthorizationV1Api* | [**create_self_subject_rules_review**](docs/AuthorizationV1Api.md#create_self_subject_rules_review) | **POST** /apis/authorization.k8s.io/v1/selfsubjectrulesreviews | 
*AuthorizationV1Api* | [**create_subject_access_review**](docs/AuthorizationV1Api.md#create_subject_access_review) | **POST** /apis/authorization.k8s.io/v1/subjectaccessreviews | 
*AuthorizationV1Api* | [**get_api_resources**](docs/AuthorizationV1Api.md#get_api_resources) | **GET** /apis/authorization.k8s.io/v1/ | 
*AutoscalingApi* | [**get_api_group**](docs/AutoscalingApi.md#get_api_group) | **GET** /apis/autoscaling/ | 
*AutoscalingV1Api* | [**create_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#create_namespaced_horizontal_pod_autoscaler) | **POST** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV1Api* | [**delete_collection_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#delete_collection_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV1Api* | [**delete_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#delete_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV1Api* | [**get_api_resources**](docs/AutoscalingV1Api.md#get_api_resources) | **GET** /apis/autoscaling/v1/ | 
*AutoscalingV1Api* | [**list_horizontal_pod_autoscaler_for_all_namespaces**](docs/AutoscalingV1Api.md#list_horizontal_pod_autoscaler_for_all_namespaces) | **GET** /apis/autoscaling/v1/horizontalpodautoscalers | 
*AutoscalingV1Api* | [**list_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#list_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV1Api* | [**patch_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#patch_namespaced_horizontal_pod_autoscaler) | **PATCH** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV1Api* | [**patch_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV1Api.md#patch_namespaced_horizontal_pod_autoscaler_status) | **PATCH** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV1Api* | [**read_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#read_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV1Api* | [**read_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV1Api.md#read_namespaced_horizontal_pod_autoscaler_status) | **GET** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV1Api* | [**replace_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV1Api.md#replace_namespaced_horizontal_pod_autoscaler) | **PUT** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV1Api* | [**replace_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV1Api.md#replace_namespaced_horizontal_pod_autoscaler_status) | **PUT** /apis/autoscaling/v1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2beta1Api* | [**create_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta1Api.md#create_namespaced_horizontal_pod_autoscaler) | **POST** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2beta1Api* | [**delete_collection_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta1Api.md#delete_collection_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2beta1Api* | [**delete_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta1Api.md#delete_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2beta1Api* | [**get_api_resources**](docs/AutoscalingV2beta1Api.md#get_api_resources) | **GET** /apis/autoscaling/v2beta1/ | 
*AutoscalingV2beta1Api* | [**list_horizontal_pod_autoscaler_for_all_namespaces**](docs/AutoscalingV2beta1Api.md#list_horizontal_pod_autoscaler_for_all_namespaces) | **GET** /apis/autoscaling/v2beta1/horizontalpodautoscalers | 
*AutoscalingV2beta1Api* | [**list_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta1Api.md#list_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2beta1Api* | [**patch_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta1Api.md#patch_namespaced_horizontal_pod_autoscaler) | **PATCH** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2beta1Api* | [**patch_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2beta1Api.md#patch_namespaced_horizontal_pod_autoscaler_status) | **PATCH** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2beta1Api* | [**read_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta1Api.md#read_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2beta1Api* | [**read_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2beta1Api.md#read_namespaced_horizontal_pod_autoscaler_status) | **GET** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2beta1Api* | [**replace_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta1Api.md#replace_namespaced_horizontal_pod_autoscaler) | **PUT** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2beta1Api* | [**replace_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2beta1Api.md#replace_namespaced_horizontal_pod_autoscaler_status) | **PUT** /apis/autoscaling/v2beta1/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2beta2Api* | [**create_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta2Api.md#create_namespaced_horizontal_pod_autoscaler) | **POST** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2beta2Api* | [**delete_collection_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta2Api.md#delete_collection_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2beta2Api* | [**delete_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta2Api.md#delete_namespaced_horizontal_pod_autoscaler) | **DELETE** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2beta2Api* | [**get_api_resources**](docs/AutoscalingV2beta2Api.md#get_api_resources) | **GET** /apis/autoscaling/v2beta2/ | 
*AutoscalingV2beta2Api* | [**list_horizontal_pod_autoscaler_for_all_namespaces**](docs/AutoscalingV2beta2Api.md#list_horizontal_pod_autoscaler_for_all_namespaces) | **GET** /apis/autoscaling/v2beta2/horizontalpodautoscalers | 
*AutoscalingV2beta2Api* | [**list_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta2Api.md#list_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers | 
*AutoscalingV2beta2Api* | [**patch_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta2Api.md#patch_namespaced_horizontal_pod_autoscaler) | **PATCH** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2beta2Api* | [**patch_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2beta2Api.md#patch_namespaced_horizontal_pod_autoscaler_status) | **PATCH** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2beta2Api* | [**read_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta2Api.md#read_namespaced_horizontal_pod_autoscaler) | **GET** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2beta2Api* | [**read_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2beta2Api.md#read_namespaced_horizontal_pod_autoscaler_status) | **GET** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*AutoscalingV2beta2Api* | [**replace_namespaced_horizontal_pod_autoscaler**](docs/AutoscalingV2beta2Api.md#replace_namespaced_horizontal_pod_autoscaler) | **PUT** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers/{name} | 
*AutoscalingV2beta2Api* | [**replace_namespaced_horizontal_pod_autoscaler_status**](docs/AutoscalingV2beta2Api.md#replace_namespaced_horizontal_pod_autoscaler_status) | **PUT** /apis/autoscaling/v2beta2/namespaces/{namespace}/horizontalpodautoscalers/{name}/status | 
*BatchApi* | [**get_api_group**](docs/BatchApi.md#get_api_group) | **GET** /apis/batch/ | 
*BatchV1Api* | [**create_namespaced_cron_job**](docs/BatchV1Api.md#create_namespaced_cron_job) | **POST** /apis/batch/v1/namespaces/{namespace}/cronjobs | 
*BatchV1Api* | [**create_namespaced_job**](docs/BatchV1Api.md#create_namespaced_job) | **POST** /apis/batch/v1/namespaces/{namespace}/jobs | 
*BatchV1Api* | [**delete_collection_namespaced_cron_job**](docs/BatchV1Api.md#delete_collection_namespaced_cron_job) | **DELETE** /apis/batch/v1/namespaces/{namespace}/cronjobs | 
*BatchV1Api* | [**delete_collection_namespaced_job**](docs/BatchV1Api.md#delete_collection_namespaced_job) | **DELETE** /apis/batch/v1/namespaces/{namespace}/jobs | 
*BatchV1Api* | [**delete_namespaced_cron_job**](docs/BatchV1Api.md#delete_namespaced_cron_job) | **DELETE** /apis/batch/v1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV1Api* | [**delete_namespaced_job**](docs/BatchV1Api.md#delete_namespaced_job) | **DELETE** /apis/batch/v1/namespaces/{namespace}/jobs/{name} | 
*BatchV1Api* | [**get_api_resources**](docs/BatchV1Api.md#get_api_resources) | **GET** /apis/batch/v1/ | 
*BatchV1Api* | [**list_cron_job_for_all_namespaces**](docs/BatchV1Api.md#list_cron_job_for_all_namespaces) | **GET** /apis/batch/v1/cronjobs | 
*BatchV1Api* | [**list_job_for_all_namespaces**](docs/BatchV1Api.md#list_job_for_all_namespaces) | **GET** /apis/batch/v1/jobs | 
*BatchV1Api* | [**list_namespaced_cron_job**](docs/BatchV1Api.md#list_namespaced_cron_job) | **GET** /apis/batch/v1/namespaces/{namespace}/cronjobs | 
*BatchV1Api* | [**list_namespaced_job**](docs/BatchV1Api.md#list_namespaced_job) | **GET** /apis/batch/v1/namespaces/{namespace}/jobs | 
*BatchV1Api* | [**patch_namespaced_cron_job**](docs/BatchV1Api.md#patch_namespaced_cron_job) | **PATCH** /apis/batch/v1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV1Api* | [**patch_namespaced_cron_job_status**](docs/BatchV1Api.md#patch_namespaced_cron_job_status) | **PATCH** /apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status | 
*BatchV1Api* | [**patch_namespaced_job**](docs/BatchV1Api.md#patch_namespaced_job) | **PATCH** /apis/batch/v1/namespaces/{namespace}/jobs/{name} | 
*BatchV1Api* | [**patch_namespaced_job_status**](docs/BatchV1Api.md#patch_namespaced_job_status) | **PATCH** /apis/batch/v1/namespaces/{namespace}/jobs/{name}/status | 
*BatchV1Api* | [**read_namespaced_cron_job**](docs/BatchV1Api.md#read_namespaced_cron_job) | **GET** /apis/batch/v1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV1Api* | [**read_namespaced_cron_job_status**](docs/BatchV1Api.md#read_namespaced_cron_job_status) | **GET** /apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status | 
*BatchV1Api* | [**read_namespaced_job**](docs/BatchV1Api.md#read_namespaced_job) | **GET** /apis/batch/v1/namespaces/{namespace}/jobs/{name} | 
*BatchV1Api* | [**read_namespaced_job_status**](docs/BatchV1Api.md#read_namespaced_job_status) | **GET** /apis/batch/v1/namespaces/{namespace}/jobs/{name}/status | 
*BatchV1Api* | [**replace_namespaced_cron_job**](docs/BatchV1Api.md#replace_namespaced_cron_job) | **PUT** /apis/batch/v1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV1Api* | [**replace_namespaced_cron_job_status**](docs/BatchV1Api.md#replace_namespaced_cron_job_status) | **PUT** /apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status | 
*BatchV1Api* | [**replace_namespaced_job**](docs/BatchV1Api.md#replace_namespaced_job) | **PUT** /apis/batch/v1/namespaces/{namespace}/jobs/{name} | 
*BatchV1Api* | [**replace_namespaced_job_status**](docs/BatchV1Api.md#replace_namespaced_job_status) | **PUT** /apis/batch/v1/namespaces/{namespace}/jobs/{name}/status | 
*BatchV1beta1Api* | [**create_namespaced_cron_job**](docs/BatchV1beta1Api.md#create_namespaced_cron_job) | **POST** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs | 
*BatchV1beta1Api* | [**delete_collection_namespaced_cron_job**](docs/BatchV1beta1Api.md#delete_collection_namespaced_cron_job) | **DELETE** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs | 
*BatchV1beta1Api* | [**delete_namespaced_cron_job**](docs/BatchV1beta1Api.md#delete_namespaced_cron_job) | **DELETE** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV1beta1Api* | [**get_api_resources**](docs/BatchV1beta1Api.md#get_api_resources) | **GET** /apis/batch/v1beta1/ | 
*BatchV1beta1Api* | [**list_cron_job_for_all_namespaces**](docs/BatchV1beta1Api.md#list_cron_job_for_all_namespaces) | **GET** /apis/batch/v1beta1/cronjobs | 
*BatchV1beta1Api* | [**list_namespaced_cron_job**](docs/BatchV1beta1Api.md#list_namespaced_cron_job) | **GET** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs | 
*BatchV1beta1Api* | [**patch_namespaced_cron_job**](docs/BatchV1beta1Api.md#patch_namespaced_cron_job) | **PATCH** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV1beta1Api* | [**patch_namespaced_cron_job_status**](docs/BatchV1beta1Api.md#patch_namespaced_cron_job_status) | **PATCH** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs/{name}/status | 
*BatchV1beta1Api* | [**read_namespaced_cron_job**](docs/BatchV1beta1Api.md#read_namespaced_cron_job) | **GET** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV1beta1Api* | [**read_namespaced_cron_job_status**](docs/BatchV1beta1Api.md#read_namespaced_cron_job_status) | **GET** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs/{name}/status | 
*BatchV1beta1Api* | [**replace_namespaced_cron_job**](docs/BatchV1beta1Api.md#replace_namespaced_cron_job) | **PUT** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs/{name} | 
*BatchV1beta1Api* | [**replace_namespaced_cron_job_status**](docs/BatchV1beta1Api.md#replace_namespaced_cron_job_status) | **PUT** /apis/batch/v1beta1/namespaces/{namespace}/cronjobs/{name}/status | 
*CertificatesApi* | [**get_api_group**](docs/CertificatesApi.md#get_api_group) | **GET** /apis/certificates.k8s.io/ | 
*CertificatesV1Api* | [**create_certificate_signing_request**](docs/CertificatesV1Api.md#create_certificate_signing_request) | **POST** /apis/certificates.k8s.io/v1/certificatesigningrequests | 
*CertificatesV1Api* | [**delete_certificate_signing_request**](docs/CertificatesV1Api.md#delete_certificate_signing_request) | **DELETE** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name} | 
*CertificatesV1Api* | [**delete_collection_certificate_signing_request**](docs/CertificatesV1Api.md#delete_collection_certificate_signing_request) | **DELETE** /apis/certificates.k8s.io/v1/certificatesigningrequests | 
*CertificatesV1Api* | [**get_api_resources**](docs/CertificatesV1Api.md#get_api_resources) | **GET** /apis/certificates.k8s.io/v1/ | 
*CertificatesV1Api* | [**list_certificate_signing_request**](docs/CertificatesV1Api.md#list_certificate_signing_request) | **GET** /apis/certificates.k8s.io/v1/certificatesigningrequests | 
*CertificatesV1Api* | [**patch_certificate_signing_request**](docs/CertificatesV1Api.md#patch_certificate_signing_request) | **PATCH** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name} | 
*CertificatesV1Api* | [**patch_certificate_signing_request_approval**](docs/CertificatesV1Api.md#patch_certificate_signing_request_approval) | **PATCH** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/approval | 
*CertificatesV1Api* | [**patch_certificate_signing_request_status**](docs/CertificatesV1Api.md#patch_certificate_signing_request_status) | **PATCH** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/status | 
*CertificatesV1Api* | [**read_certificate_signing_request**](docs/CertificatesV1Api.md#read_certificate_signing_request) | **GET** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name} | 
*CertificatesV1Api* | [**read_certificate_signing_request_approval**](docs/CertificatesV1Api.md#read_certificate_signing_request_approval) | **GET** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/approval | 
*CertificatesV1Api* | [**read_certificate_signing_request_status**](docs/CertificatesV1Api.md#read_certificate_signing_request_status) | **GET** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/status | 
*CertificatesV1Api* | [**replace_certificate_signing_request**](docs/CertificatesV1Api.md#replace_certificate_signing_request) | **PUT** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name} | 
*CertificatesV1Api* | [**replace_certificate_signing_request_approval**](docs/CertificatesV1Api.md#replace_certificate_signing_request_approval) | **PUT** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/approval | 
*CertificatesV1Api* | [**replace_certificate_signing_request_status**](docs/CertificatesV1Api.md#replace_certificate_signing_request_status) | **PUT** /apis/certificates.k8s.io/v1/certificatesigningrequests/{name}/status | 
*CoordinationApi* | [**get_api_group**](docs/CoordinationApi.md#get_api_group) | **GET** /apis/coordination.k8s.io/ | 
*CoordinationV1Api* | [**create_namespaced_lease**](docs/CoordinationV1Api.md#create_namespaced_lease) | **POST** /apis/coordination.k8s.io/v1/namespaces/{namespace}/leases | 
*CoordinationV1Api* | [**delete_collection_namespaced_lease**](docs/CoordinationV1Api.md#delete_collection_namespaced_lease) | **DELETE** /apis/coordination.k8s.io/v1/namespaces/{namespace}/leases | 
*CoordinationV1Api* | [**delete_namespaced_lease**](docs/CoordinationV1Api.md#delete_namespaced_lease) | **DELETE** /apis/coordination.k8s.io/v1/namespaces/{namespace}/leases/{name} | 
*CoordinationV1Api* | [**get_api_resources**](docs/CoordinationV1Api.md#get_api_resources) | **GET** /apis/coordination.k8s.io/v1/ | 
*CoordinationV1Api* | [**list_lease_for_all_namespaces**](docs/CoordinationV1Api.md#list_lease_for_all_namespaces) | **GET** /apis/coordination.k8s.io/v1/leases | 
*CoordinationV1Api* | [**list_namespaced_lease**](docs/CoordinationV1Api.md#list_namespaced_lease) | **GET** /apis/coordination.k8s.io/v1/namespaces/{namespace}/leases | 
*CoordinationV1Api* | [**patch_namespaced_lease**](docs/CoordinationV1Api.md#patch_namespaced_lease) | **PATCH** /apis/coordination.k8s.io/v1/namespaces/{namespace}/leases/{name} | 
*CoordinationV1Api* | [**read_namespaced_lease**](docs/CoordinationV1Api.md#read_namespaced_lease) | **GET** /apis/coordination.k8s.io/v1/namespaces/{namespace}/leases/{name} | 
*CoordinationV1Api* | [**replace_namespaced_lease**](docs/CoordinationV1Api.md#replace_namespaced_lease) | **PUT** /apis/coordination.k8s.io/v1/namespaces/{namespace}/leases/{name} | 
*CoreApi* | [**get_api_versions**](docs/CoreApi.md#get_api_versions) | **GET** /api/ | 
*CoreV1Api* | [**connect_delete_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_delete_namespaced_pod_proxy) | **DELETE** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_delete_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_delete_namespaced_pod_proxy_with_path) | **DELETE** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_delete_namespaced_service_proxy**](docs/CoreV1Api.md#connect_delete_namespaced_service_proxy) | **DELETE** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_delete_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_delete_namespaced_service_proxy_with_path) | **DELETE** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_delete_node_proxy**](docs/CoreV1Api.md#connect_delete_node_proxy) | **DELETE** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_delete_node_proxy_with_path**](docs/CoreV1Api.md#connect_delete_node_proxy_with_path) | **DELETE** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_get_namespaced_pod_attach**](docs/CoreV1Api.md#connect_get_namespaced_pod_attach) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/attach | 
*CoreV1Api* | [**connect_get_namespaced_pod_exec**](docs/CoreV1Api.md#connect_get_namespaced_pod_exec) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/exec | 
*CoreV1Api* | [**connect_get_namespaced_pod_portforward**](docs/CoreV1Api.md#connect_get_namespaced_pod_portforward) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/portforward | 
*CoreV1Api* | [**connect_get_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_get_namespaced_pod_proxy) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_get_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_get_namespaced_pod_proxy_with_path) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_get_namespaced_service_proxy**](docs/CoreV1Api.md#connect_get_namespaced_service_proxy) | **GET** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_get_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_get_namespaced_service_proxy_with_path) | **GET** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_get_node_proxy**](docs/CoreV1Api.md#connect_get_node_proxy) | **GET** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_get_node_proxy_with_path**](docs/CoreV1Api.md#connect_get_node_proxy_with_path) | **GET** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_head_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_head_namespaced_pod_proxy) | **HEAD** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_head_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_head_namespaced_pod_proxy_with_path) | **HEAD** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_head_namespaced_service_proxy**](docs/CoreV1Api.md#connect_head_namespaced_service_proxy) | **HEAD** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_head_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_head_namespaced_service_proxy_with_path) | **HEAD** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_head_node_proxy**](docs/CoreV1Api.md#connect_head_node_proxy) | **HEAD** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_head_node_proxy_with_path**](docs/CoreV1Api.md#connect_head_node_proxy_with_path) | **HEAD** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_options_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_options_namespaced_pod_proxy) | **OPTIONS** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_options_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_options_namespaced_pod_proxy_with_path) | **OPTIONS** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_options_namespaced_service_proxy**](docs/CoreV1Api.md#connect_options_namespaced_service_proxy) | **OPTIONS** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_options_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_options_namespaced_service_proxy_with_path) | **OPTIONS** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_options_node_proxy**](docs/CoreV1Api.md#connect_options_node_proxy) | **OPTIONS** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_options_node_proxy_with_path**](docs/CoreV1Api.md#connect_options_node_proxy_with_path) | **OPTIONS** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_patch_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_patch_namespaced_pod_proxy) | **PATCH** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_patch_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_patch_namespaced_pod_proxy_with_path) | **PATCH** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_patch_namespaced_service_proxy**](docs/CoreV1Api.md#connect_patch_namespaced_service_proxy) | **PATCH** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_patch_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_patch_namespaced_service_proxy_with_path) | **PATCH** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_patch_node_proxy**](docs/CoreV1Api.md#connect_patch_node_proxy) | **PATCH** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_patch_node_proxy_with_path**](docs/CoreV1Api.md#connect_patch_node_proxy_with_path) | **PATCH** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_post_namespaced_pod_attach**](docs/CoreV1Api.md#connect_post_namespaced_pod_attach) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/attach | 
*CoreV1Api* | [**connect_post_namespaced_pod_exec**](docs/CoreV1Api.md#connect_post_namespaced_pod_exec) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/exec | 
*CoreV1Api* | [**connect_post_namespaced_pod_portforward**](docs/CoreV1Api.md#connect_post_namespaced_pod_portforward) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/portforward | 
*CoreV1Api* | [**connect_post_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_post_namespaced_pod_proxy) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_post_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_post_namespaced_pod_proxy_with_path) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_post_namespaced_service_proxy**](docs/CoreV1Api.md#connect_post_namespaced_service_proxy) | **POST** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_post_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_post_namespaced_service_proxy_with_path) | **POST** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_post_node_proxy**](docs/CoreV1Api.md#connect_post_node_proxy) | **POST** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_post_node_proxy_with_path**](docs/CoreV1Api.md#connect_post_node_proxy_with_path) | **POST** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_put_namespaced_pod_proxy**](docs/CoreV1Api.md#connect_put_namespaced_pod_proxy) | **PUT** /api/v1/namespaces/{namespace}/pods/{name}/proxy | 
*CoreV1Api* | [**connect_put_namespaced_pod_proxy_with_path**](docs/CoreV1Api.md#connect_put_namespaced_pod_proxy_with_path) | **PUT** /api/v1/namespaces/{namespace}/pods/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_put_namespaced_service_proxy**](docs/CoreV1Api.md#connect_put_namespaced_service_proxy) | **PUT** /api/v1/namespaces/{namespace}/services/{name}/proxy | 
*CoreV1Api* | [**connect_put_namespaced_service_proxy_with_path**](docs/CoreV1Api.md#connect_put_namespaced_service_proxy_with_path) | **PUT** /api/v1/namespaces/{namespace}/services/{name}/proxy/{path} | 
*CoreV1Api* | [**connect_put_node_proxy**](docs/CoreV1Api.md#connect_put_node_proxy) | **PUT** /api/v1/nodes/{name}/proxy | 
*CoreV1Api* | [**connect_put_node_proxy_with_path**](docs/CoreV1Api.md#connect_put_node_proxy_with_path) | **PUT** /api/v1/nodes/{name}/proxy/{path} | 
*CoreV1Api* | [**create_namespace**](docs/CoreV1Api.md#create_namespace) | **POST** /api/v1/namespaces | 
*CoreV1Api* | [**create_namespaced_binding**](docs/CoreV1Api.md#create_namespaced_binding) | **POST** /api/v1/namespaces/{namespace}/bindings | 
*CoreV1Api* | [**create_namespaced_config_map**](docs/CoreV1Api.md#create_namespaced_config_map) | **POST** /api/v1/namespaces/{namespace}/configmaps | 
*CoreV1Api* | [**create_namespaced_endpoints**](docs/CoreV1Api.md#create_namespaced_endpoints) | **POST** /api/v1/namespaces/{namespace}/endpoints | 
*CoreV1Api* | [**create_namespaced_event**](docs/CoreV1Api.md#create_namespaced_event) | **POST** /api/v1/namespaces/{namespace}/events | 
*CoreV1Api* | [**create_namespaced_limit_range**](docs/CoreV1Api.md#create_namespaced_limit_range) | **POST** /api/v1/namespaces/{namespace}/limitranges | 
*CoreV1Api* | [**create_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#create_namespaced_persistent_volume_claim) | **POST** /api/v1/namespaces/{namespace}/persistentvolumeclaims | 
*CoreV1Api* | [**create_namespaced_pod**](docs/CoreV1Api.md#create_namespaced_pod) | **POST** /api/v1/namespaces/{namespace}/pods | 
*CoreV1Api* | [**create_namespaced_pod_binding**](docs/CoreV1Api.md#create_namespaced_pod_binding) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/binding | 
*CoreV1Api* | [**create_namespaced_pod_eviction**](docs/CoreV1Api.md#create_namespaced_pod_eviction) | **POST** /api/v1/namespaces/{namespace}/pods/{name}/eviction | 
*CoreV1Api* | [**create_namespaced_pod_template**](docs/CoreV1Api.md#create_namespaced_pod_template) | **POST** /api/v1/namespaces/{namespace}/podtemplates | 
*CoreV1Api* | [**create_namespaced_replication_controller**](docs/CoreV1Api.md#create_namespaced_replication_controller) | **POST** /api/v1/namespaces/{namespace}/replicationcontrollers | 
*CoreV1Api* | [**create_namespaced_resource_quota**](docs/CoreV1Api.md#create_namespaced_resource_quota) | **POST** /api/v1/namespaces/{namespace}/resourcequotas | 
*CoreV1Api* | [**create_namespaced_secret**](docs/CoreV1Api.md#create_namespaced_secret) | **POST** /api/v1/namespaces/{namespace}/secrets | 
*CoreV1Api* | [**create_namespaced_service**](docs/CoreV1Api.md#create_namespaced_service) | **POST** /api/v1/namespaces/{namespace}/services | 
*CoreV1Api* | [**create_namespaced_service_account**](docs/CoreV1Api.md#create_namespaced_service_account) | **POST** /api/v1/namespaces/{namespace}/serviceaccounts | 
*CoreV1Api* | [**create_namespaced_service_account_token**](docs/CoreV1Api.md#create_namespaced_service_account_token) | **POST** /api/v1/namespaces/{namespace}/serviceaccounts/{name}/token | 
*CoreV1Api* | [**create_node**](docs/CoreV1Api.md#create_node) | **POST** /api/v1/nodes | 
*CoreV1Api* | [**create_persistent_volume**](docs/CoreV1Api.md#create_persistent_volume) | **POST** /api/v1/persistentvolumes | 
*CoreV1Api* | [**delete_collection_namespaced_config_map**](docs/CoreV1Api.md#delete_collection_namespaced_config_map) | **DELETE** /api/v1/namespaces/{namespace}/configmaps | 
*CoreV1Api* | [**delete_collection_namespaced_endpoints**](docs/CoreV1Api.md#delete_collection_namespaced_endpoints) | **DELETE** /api/v1/namespaces/{namespace}/endpoints | 
*CoreV1Api* | [**delete_collection_namespaced_event**](docs/CoreV1Api.md#delete_collection_namespaced_event) | **DELETE** /api/v1/namespaces/{namespace}/events | 
*CoreV1Api* | [**delete_collection_namespaced_limit_range**](docs/CoreV1Api.md#delete_collection_namespaced_limit_range) | **DELETE** /api/v1/namespaces/{namespace}/limitranges | 
*CoreV1Api* | [**delete_collection_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#delete_collection_namespaced_persistent_volume_claim) | **DELETE** /api/v1/namespaces/{namespace}/persistentvolumeclaims | 
*CoreV1Api* | [**delete_collection_namespaced_pod**](docs/CoreV1Api.md#delete_collection_namespaced_pod) | **DELETE** /api/v1/namespaces/{namespace}/pods | 
*CoreV1Api* | [**delete_collection_namespaced_pod_template**](docs/CoreV1Api.md#delete_collection_namespaced_pod_template) | **DELETE** /api/v1/namespaces/{namespace}/podtemplates | 
*CoreV1Api* | [**delete_collection_namespaced_replication_controller**](docs/CoreV1Api.md#delete_collection_namespaced_replication_controller) | **DELETE** /api/v1/namespaces/{namespace}/replicationcontrollers | 
*CoreV1Api* | [**delete_collection_namespaced_resource_quota**](docs/CoreV1Api.md#delete_collection_namespaced_resource_quota) | **DELETE** /api/v1/namespaces/{namespace}/resourcequotas | 
*CoreV1Api* | [**delete_collection_namespaced_secret**](docs/CoreV1Api.md#delete_collection_namespaced_secret) | **DELETE** /api/v1/namespaces/{namespace}/secrets | 
*CoreV1Api* | [**delete_collection_namespaced_service_account**](docs/CoreV1Api.md#delete_collection_namespaced_service_account) | **DELETE** /api/v1/namespaces/{namespace}/serviceaccounts | 
*CoreV1Api* | [**delete_collection_node**](docs/CoreV1Api.md#delete_collection_node) | **DELETE** /api/v1/nodes | 
*CoreV1Api* | [**delete_collection_persistent_volume**](docs/CoreV1Api.md#delete_collection_persistent_volume) | **DELETE** /api/v1/persistentvolumes | 
*CoreV1Api* | [**delete_namespace**](docs/CoreV1Api.md#delete_namespace) | **DELETE** /api/v1/namespaces/{name} | 
*CoreV1Api* | [**delete_namespaced_config_map**](docs/CoreV1Api.md#delete_namespaced_config_map) | **DELETE** /api/v1/namespaces/{namespace}/configmaps/{name} | 
*CoreV1Api* | [**delete_namespaced_endpoints**](docs/CoreV1Api.md#delete_namespaced_endpoints) | **DELETE** /api/v1/namespaces/{namespace}/endpoints/{name} | 
*CoreV1Api* | [**delete_namespaced_event**](docs/CoreV1Api.md#delete_namespaced_event) | **DELETE** /api/v1/namespaces/{namespace}/events/{name} | 
*CoreV1Api* | [**delete_namespaced_limit_range**](docs/CoreV1Api.md#delete_namespaced_limit_range) | **DELETE** /api/v1/namespaces/{namespace}/limitranges/{name} | 
*CoreV1Api* | [**delete_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#delete_namespaced_persistent_volume_claim) | **DELETE** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name} | 
*CoreV1Api* | [**delete_namespaced_pod**](docs/CoreV1Api.md#delete_namespaced_pod) | **DELETE** /api/v1/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**delete_namespaced_pod_template**](docs/CoreV1Api.md#delete_namespaced_pod_template) | **DELETE** /api/v1/namespaces/{namespace}/podtemplates/{name} | 
*CoreV1Api* | [**delete_namespaced_replication_controller**](docs/CoreV1Api.md#delete_namespaced_replication_controller) | **DELETE** /api/v1/namespaces/{namespace}/replicationcontrollers/{name} | 
*CoreV1Api* | [**delete_namespaced_resource_quota**](docs/CoreV1Api.md#delete_namespaced_resource_quota) | **DELETE** /api/v1/namespaces/{namespace}/resourcequotas/{name} | 
*CoreV1Api* | [**delete_namespaced_secret**](docs/CoreV1Api.md#delete_namespaced_secret) | **DELETE** /api/v1/namespaces/{namespace}/secrets/{name} | 
*CoreV1Api* | [**delete_namespaced_service**](docs/CoreV1Api.md#delete_namespaced_service) | **DELETE** /api/v1/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**delete_namespaced_service_account**](docs/CoreV1Api.md#delete_namespaced_service_account) | **DELETE** /api/v1/namespaces/{namespace}/serviceaccounts/{name} | 
*CoreV1Api* | [**delete_node**](docs/CoreV1Api.md#delete_node) | **DELETE** /api/v1/nodes/{name} | 
*CoreV1Api* | [**delete_persistent_volume**](docs/CoreV1Api.md#delete_persistent_volume) | **DELETE** /api/v1/persistentvolumes/{name} | 
*CoreV1Api* | [**get_api_resources**](docs/CoreV1Api.md#get_api_resources) | **GET** /api/v1/ | 
*CoreV1Api* | [**list_component_status**](docs/CoreV1Api.md#list_component_status) | **GET** /api/v1/componentstatuses | 
*CoreV1Api* | [**list_config_map_for_all_namespaces**](docs/CoreV1Api.md#list_config_map_for_all_namespaces) | **GET** /api/v1/configmaps | 
*CoreV1Api* | [**list_endpoints_for_all_namespaces**](docs/CoreV1Api.md#list_endpoints_for_all_namespaces) | **GET** /api/v1/endpoints | 
*CoreV1Api* | [**list_event_for_all_namespaces**](docs/CoreV1Api.md#list_event_for_all_namespaces) | **GET** /api/v1/events | 
*CoreV1Api* | [**list_limit_range_for_all_namespaces**](docs/CoreV1Api.md#list_limit_range_for_all_namespaces) | **GET** /api/v1/limitranges | 
*CoreV1Api* | [**list_namespace**](docs/CoreV1Api.md#list_namespace) | **GET** /api/v1/namespaces | 
*CoreV1Api* | [**list_namespaced_config_map**](docs/CoreV1Api.md#list_namespaced_config_map) | **GET** /api/v1/namespaces/{namespace}/configmaps | 
*CoreV1Api* | [**list_namespaced_endpoints**](docs/CoreV1Api.md#list_namespaced_endpoints) | **GET** /api/v1/namespaces/{namespace}/endpoints | 
*CoreV1Api* | [**list_namespaced_event**](docs/CoreV1Api.md#list_namespaced_event) | **GET** /api/v1/namespaces/{namespace}/events | 
*CoreV1Api* | [**list_namespaced_limit_range**](docs/CoreV1Api.md#list_namespaced_limit_range) | **GET** /api/v1/namespaces/{namespace}/limitranges | 
*CoreV1Api* | [**list_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#list_namespaced_persistent_volume_claim) | **GET** /api/v1/namespaces/{namespace}/persistentvolumeclaims | 
*CoreV1Api* | [**list_namespaced_pod**](docs/CoreV1Api.md#list_namespaced_pod) | **GET** /api/v1/namespaces/{namespace}/pods | 
*CoreV1Api* | [**list_namespaced_pod_template**](docs/CoreV1Api.md#list_namespaced_pod_template) | **GET** /api/v1/namespaces/{namespace}/podtemplates | 
*CoreV1Api* | [**list_namespaced_replication_controller**](docs/CoreV1Api.md#list_namespaced_replication_controller) | **GET** /api/v1/namespaces/{namespace}/replicationcontrollers | 
*CoreV1Api* | [**list_namespaced_resource_quota**](docs/CoreV1Api.md#list_namespaced_resource_quota) | **GET** /api/v1/namespaces/{namespace}/resourcequotas | 
*CoreV1Api* | [**list_namespaced_secret**](docs/CoreV1Api.md#list_namespaced_secret) | **GET** /api/v1/namespaces/{namespace}/secrets | 
*CoreV1Api* | [**list_namespaced_service**](docs/CoreV1Api.md#list_namespaced_service) | **GET** /api/v1/namespaces/{namespace}/services | 
*CoreV1Api* | [**list_namespaced_service_account**](docs/CoreV1Api.md#list_namespaced_service_account) | **GET** /api/v1/namespaces/{namespace}/serviceaccounts | 
*CoreV1Api* | [**list_node**](docs/CoreV1Api.md#list_node) | **GET** /api/v1/nodes | 
*CoreV1Api* | [**list_persistent_volume**](docs/CoreV1Api.md#list_persistent_volume) | **GET** /api/v1/persistentvolumes | 
*CoreV1Api* | [**list_persistent_volume_claim_for_all_namespaces**](docs/CoreV1Api.md#list_persistent_volume_claim_for_all_namespaces) | **GET** /api/v1/persistentvolumeclaims | 
*CoreV1Api* | [**list_pod_for_all_namespaces**](docs/CoreV1Api.md#list_pod_for_all_namespaces) | **GET** /api/v1/pods | 
*CoreV1Api* | [**list_pod_template_for_all_namespaces**](docs/CoreV1Api.md#list_pod_template_for_all_namespaces) | **GET** /api/v1/podtemplates | 
*CoreV1Api* | [**list_replication_controller_for_all_namespaces**](docs/CoreV1Api.md#list_replication_controller_for_all_namespaces) | **GET** /api/v1/replicationcontrollers | 
*CoreV1Api* | [**list_resource_quota_for_all_namespaces**](docs/CoreV1Api.md#list_resource_quota_for_all_namespaces) | **GET** /api/v1/resourcequotas | 
*CoreV1Api* | [**list_secret_for_all_namespaces**](docs/CoreV1Api.md#list_secret_for_all_namespaces) | **GET** /api/v1/secrets | 
*CoreV1Api* | [**list_service_account_for_all_namespaces**](docs/CoreV1Api.md#list_service_account_for_all_namespaces) | **GET** /api/v1/serviceaccounts | 
*CoreV1Api* | [**list_service_for_all_namespaces**](docs/CoreV1Api.md#list_service_for_all_namespaces) | **GET** /api/v1/services | 
*CoreV1Api* | [**patch_namespace**](docs/CoreV1Api.md#patch_namespace) | **PATCH** /api/v1/namespaces/{name} | 
*CoreV1Api* | [**patch_namespace_status**](docs/CoreV1Api.md#patch_namespace_status) | **PATCH** /api/v1/namespaces/{name}/status | 
*CoreV1Api* | [**patch_namespaced_config_map**](docs/CoreV1Api.md#patch_namespaced_config_map) | **PATCH** /api/v1/namespaces/{namespace}/configmaps/{name} | 
*CoreV1Api* | [**patch_namespaced_endpoints**](docs/CoreV1Api.md#patch_namespaced_endpoints) | **PATCH** /api/v1/namespaces/{namespace}/endpoints/{name} | 
*CoreV1Api* | [**patch_namespaced_event**](docs/CoreV1Api.md#patch_namespaced_event) | **PATCH** /api/v1/namespaces/{namespace}/events/{name} | 
*CoreV1Api* | [**patch_namespaced_limit_range**](docs/CoreV1Api.md#patch_namespaced_limit_range) | **PATCH** /api/v1/namespaces/{namespace}/limitranges/{name} | 
*CoreV1Api* | [**patch_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#patch_namespaced_persistent_volume_claim) | **PATCH** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name} | 
*CoreV1Api* | [**patch_namespaced_persistent_volume_claim_status**](docs/CoreV1Api.md#patch_namespaced_persistent_volume_claim_status) | **PATCH** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}/status | 
*CoreV1Api* | [**patch_namespaced_pod**](docs/CoreV1Api.md#patch_namespaced_pod) | **PATCH** /api/v1/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**patch_namespaced_pod_ephemeralcontainers**](docs/CoreV1Api.md#patch_namespaced_pod_ephemeralcontainers) | **PATCH** /api/v1/namespaces/{namespace}/pods/{name}/ephemeralcontainers | 
*CoreV1Api* | [**patch_namespaced_pod_status**](docs/CoreV1Api.md#patch_namespaced_pod_status) | **PATCH** /api/v1/namespaces/{namespace}/pods/{name}/status | 
*CoreV1Api* | [**patch_namespaced_pod_template**](docs/CoreV1Api.md#patch_namespaced_pod_template) | **PATCH** /api/v1/namespaces/{namespace}/podtemplates/{name} | 
*CoreV1Api* | [**patch_namespaced_replication_controller**](docs/CoreV1Api.md#patch_namespaced_replication_controller) | **PATCH** /api/v1/namespaces/{namespace}/replicationcontrollers/{name} | 
*CoreV1Api* | [**patch_namespaced_replication_controller_scale**](docs/CoreV1Api.md#patch_namespaced_replication_controller_scale) | **PATCH** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*CoreV1Api* | [**patch_namespaced_replication_controller_status**](docs/CoreV1Api.md#patch_namespaced_replication_controller_status) | **PATCH** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/status | 
*CoreV1Api* | [**patch_namespaced_resource_quota**](docs/CoreV1Api.md#patch_namespaced_resource_quota) | **PATCH** /api/v1/namespaces/{namespace}/resourcequotas/{name} | 
*CoreV1Api* | [**patch_namespaced_resource_quota_status**](docs/CoreV1Api.md#patch_namespaced_resource_quota_status) | **PATCH** /api/v1/namespaces/{namespace}/resourcequotas/{name}/status | 
*CoreV1Api* | [**patch_namespaced_secret**](docs/CoreV1Api.md#patch_namespaced_secret) | **PATCH** /api/v1/namespaces/{namespace}/secrets/{name} | 
*CoreV1Api* | [**patch_namespaced_service**](docs/CoreV1Api.md#patch_namespaced_service) | **PATCH** /api/v1/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**patch_namespaced_service_account**](docs/CoreV1Api.md#patch_namespaced_service_account) | **PATCH** /api/v1/namespaces/{namespace}/serviceaccounts/{name} | 
*CoreV1Api* | [**patch_namespaced_service_status**](docs/CoreV1Api.md#patch_namespaced_service_status) | **PATCH** /api/v1/namespaces/{namespace}/services/{name}/status | 
*CoreV1Api* | [**patch_node**](docs/CoreV1Api.md#patch_node) | **PATCH** /api/v1/nodes/{name} | 
*CoreV1Api* | [**patch_node_status**](docs/CoreV1Api.md#patch_node_status) | **PATCH** /api/v1/nodes/{name}/status | 
*CoreV1Api* | [**patch_persistent_volume**](docs/CoreV1Api.md#patch_persistent_volume) | **PATCH** /api/v1/persistentvolumes/{name} | 
*CoreV1Api* | [**patch_persistent_volume_status**](docs/CoreV1Api.md#patch_persistent_volume_status) | **PATCH** /api/v1/persistentvolumes/{name}/status | 
*CoreV1Api* | [**read_component_status**](docs/CoreV1Api.md#read_component_status) | **GET** /api/v1/componentstatuses/{name} | 
*CoreV1Api* | [**read_namespace**](docs/CoreV1Api.md#read_namespace) | **GET** /api/v1/namespaces/{name} | 
*CoreV1Api* | [**read_namespace_status**](docs/CoreV1Api.md#read_namespace_status) | **GET** /api/v1/namespaces/{name}/status | 
*CoreV1Api* | [**read_namespaced_config_map**](docs/CoreV1Api.md#read_namespaced_config_map) | **GET** /api/v1/namespaces/{namespace}/configmaps/{name} | 
*CoreV1Api* | [**read_namespaced_endpoints**](docs/CoreV1Api.md#read_namespaced_endpoints) | **GET** /api/v1/namespaces/{namespace}/endpoints/{name} | 
*CoreV1Api* | [**read_namespaced_event**](docs/CoreV1Api.md#read_namespaced_event) | **GET** /api/v1/namespaces/{namespace}/events/{name} | 
*CoreV1Api* | [**read_namespaced_limit_range**](docs/CoreV1Api.md#read_namespaced_limit_range) | **GET** /api/v1/namespaces/{namespace}/limitranges/{name} | 
*CoreV1Api* | [**read_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#read_namespaced_persistent_volume_claim) | **GET** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name} | 
*CoreV1Api* | [**read_namespaced_persistent_volume_claim_status**](docs/CoreV1Api.md#read_namespaced_persistent_volume_claim_status) | **GET** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}/status | 
*CoreV1Api* | [**read_namespaced_pod**](docs/CoreV1Api.md#read_namespaced_pod) | **GET** /api/v1/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**read_namespaced_pod_ephemeralcontainers**](docs/CoreV1Api.md#read_namespaced_pod_ephemeralcontainers) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/ephemeralcontainers | 
*CoreV1Api* | [**read_namespaced_pod_log**](docs/CoreV1Api.md#read_namespaced_pod_log) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/log | 
*CoreV1Api* | [**read_namespaced_pod_status**](docs/CoreV1Api.md#read_namespaced_pod_status) | **GET** /api/v1/namespaces/{namespace}/pods/{name}/status | 
*CoreV1Api* | [**read_namespaced_pod_template**](docs/CoreV1Api.md#read_namespaced_pod_template) | **GET** /api/v1/namespaces/{namespace}/podtemplates/{name} | 
*CoreV1Api* | [**read_namespaced_replication_controller**](docs/CoreV1Api.md#read_namespaced_replication_controller) | **GET** /api/v1/namespaces/{namespace}/replicationcontrollers/{name} | 
*CoreV1Api* | [**read_namespaced_replication_controller_scale**](docs/CoreV1Api.md#read_namespaced_replication_controller_scale) | **GET** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*CoreV1Api* | [**read_namespaced_replication_controller_status**](docs/CoreV1Api.md#read_namespaced_replication_controller_status) | **GET** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/status | 
*CoreV1Api* | [**read_namespaced_resource_quota**](docs/CoreV1Api.md#read_namespaced_resource_quota) | **GET** /api/v1/namespaces/{namespace}/resourcequotas/{name} | 
*CoreV1Api* | [**read_namespaced_resource_quota_status**](docs/CoreV1Api.md#read_namespaced_resource_quota_status) | **GET** /api/v1/namespaces/{namespace}/resourcequotas/{name}/status | 
*CoreV1Api* | [**read_namespaced_secret**](docs/CoreV1Api.md#read_namespaced_secret) | **GET** /api/v1/namespaces/{namespace}/secrets/{name} | 
*CoreV1Api* | [**read_namespaced_service**](docs/CoreV1Api.md#read_namespaced_service) | **GET** /api/v1/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**read_namespaced_service_account**](docs/CoreV1Api.md#read_namespaced_service_account) | **GET** /api/v1/namespaces/{namespace}/serviceaccounts/{name} | 
*CoreV1Api* | [**read_namespaced_service_status**](docs/CoreV1Api.md#read_namespaced_service_status) | **GET** /api/v1/namespaces/{namespace}/services/{name}/status | 
*CoreV1Api* | [**read_node**](docs/CoreV1Api.md#read_node) | **GET** /api/v1/nodes/{name} | 
*CoreV1Api* | [**read_node_status**](docs/CoreV1Api.md#read_node_status) | **GET** /api/v1/nodes/{name}/status | 
*CoreV1Api* | [**read_persistent_volume**](docs/CoreV1Api.md#read_persistent_volume) | **GET** /api/v1/persistentvolumes/{name} | 
*CoreV1Api* | [**read_persistent_volume_status**](docs/CoreV1Api.md#read_persistent_volume_status) | **GET** /api/v1/persistentvolumes/{name}/status | 
*CoreV1Api* | [**replace_namespace**](docs/CoreV1Api.md#replace_namespace) | **PUT** /api/v1/namespaces/{name} | 
*CoreV1Api* | [**replace_namespace_finalize**](docs/CoreV1Api.md#replace_namespace_finalize) | **PUT** /api/v1/namespaces/{name}/finalize | 
*CoreV1Api* | [**replace_namespace_status**](docs/CoreV1Api.md#replace_namespace_status) | **PUT** /api/v1/namespaces/{name}/status | 
*CoreV1Api* | [**replace_namespaced_config_map**](docs/CoreV1Api.md#replace_namespaced_config_map) | **PUT** /api/v1/namespaces/{namespace}/configmaps/{name} | 
*CoreV1Api* | [**replace_namespaced_endpoints**](docs/CoreV1Api.md#replace_namespaced_endpoints) | **PUT** /api/v1/namespaces/{namespace}/endpoints/{name} | 
*CoreV1Api* | [**replace_namespaced_event**](docs/CoreV1Api.md#replace_namespaced_event) | **PUT** /api/v1/namespaces/{namespace}/events/{name} | 
*CoreV1Api* | [**replace_namespaced_limit_range**](docs/CoreV1Api.md#replace_namespaced_limit_range) | **PUT** /api/v1/namespaces/{namespace}/limitranges/{name} | 
*CoreV1Api* | [**replace_namespaced_persistent_volume_claim**](docs/CoreV1Api.md#replace_namespaced_persistent_volume_claim) | **PUT** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name} | 
*CoreV1Api* | [**replace_namespaced_persistent_volume_claim_status**](docs/CoreV1Api.md#replace_namespaced_persistent_volume_claim_status) | **PUT** /api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}/status | 
*CoreV1Api* | [**replace_namespaced_pod**](docs/CoreV1Api.md#replace_namespaced_pod) | **PUT** /api/v1/namespaces/{namespace}/pods/{name} | 
*CoreV1Api* | [**replace_namespaced_pod_ephemeralcontainers**](docs/CoreV1Api.md#replace_namespaced_pod_ephemeralcontainers) | **PUT** /api/v1/namespaces/{namespace}/pods/{name}/ephemeralcontainers | 
*CoreV1Api* | [**replace_namespaced_pod_status**](docs/CoreV1Api.md#replace_namespaced_pod_status) | **PUT** /api/v1/namespaces/{namespace}/pods/{name}/status | 
*CoreV1Api* | [**replace_namespaced_pod_template**](docs/CoreV1Api.md#replace_namespaced_pod_template) | **PUT** /api/v1/namespaces/{namespace}/podtemplates/{name} | 
*CoreV1Api* | [**replace_namespaced_replication_controller**](docs/CoreV1Api.md#replace_namespaced_replication_controller) | **PUT** /api/v1/namespaces/{namespace}/replicationcontrollers/{name} | 
*CoreV1Api* | [**replace_namespaced_replication_controller_scale**](docs/CoreV1Api.md#replace_namespaced_replication_controller_scale) | **PUT** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale | 
*CoreV1Api* | [**replace_namespaced_replication_controller_status**](docs/CoreV1Api.md#replace_namespaced_replication_controller_status) | **PUT** /api/v1/namespaces/{namespace}/replicationcontrollers/{name}/status | 
*CoreV1Api* | [**replace_namespaced_resource_quota**](docs/CoreV1Api.md#replace_namespaced_resource_quota) | **PUT** /api/v1/namespaces/{namespace}/resourcequotas/{name} | 
*CoreV1Api* | [**replace_namespaced_resource_quota_status**](docs/CoreV1Api.md#replace_namespaced_resource_quota_status) | **PUT** /api/v1/namespaces/{namespace}/resourcequotas/{name}/status | 
*CoreV1Api* | [**replace_namespaced_secret**](docs/CoreV1Api.md#replace_namespaced_secret) | **PUT** /api/v1/namespaces/{namespace}/secrets/{name} | 
*CoreV1Api* | [**replace_namespaced_service**](docs/CoreV1Api.md#replace_namespaced_service) | **PUT** /api/v1/namespaces/{namespace}/services/{name} | 
*CoreV1Api* | [**replace_namespaced_service_account**](docs/CoreV1Api.md#replace_namespaced_service_account) | **PUT** /api/v1/namespaces/{namespace}/serviceaccounts/{name} | 
*CoreV1Api* | [**replace_namespaced_service_status**](docs/CoreV1Api.md#replace_namespaced_service_status) | **PUT** /api/v1/namespaces/{namespace}/services/{name}/status | 
*CoreV1Api* | [**replace_node**](docs/CoreV1Api.md#replace_node) | **PUT** /api/v1/nodes/{name} | 
*CoreV1Api* | [**replace_node_status**](docs/CoreV1Api.md#replace_node_status) | **PUT** /api/v1/nodes/{name}/status | 
*CoreV1Api* | [**replace_persistent_volume**](docs/CoreV1Api.md#replace_persistent_volume) | **PUT** /api/v1/persistentvolumes/{name} | 
*CoreV1Api* | [**replace_persistent_volume_status**](docs/CoreV1Api.md#replace_persistent_volume_status) | **PUT** /api/v1/persistentvolumes/{name}/status | 
*CustomObjectsApi* | [**create_cluster_custom_object**](docs/CustomObjectsApi.md#create_cluster_custom_object) | **POST** /apis/{group}/{version}/{plural} | 
*CustomObjectsApi* | [**create_namespaced_custom_object**](docs/CustomObjectsApi.md#create_namespaced_custom_object) | **POST** /apis/{group}/{version}/namespaces/{namespace}/{plural} | 
*CustomObjectsApi* | [**delete_cluster_custom_object**](docs/CustomObjectsApi.md#delete_cluster_custom_object) | **DELETE** /apis/{group}/{version}/{plural}/{name} | 
*CustomObjectsApi* | [**delete_collection_cluster_custom_object**](docs/CustomObjectsApi.md#delete_collection_cluster_custom_object) | **DELETE** /apis/{group}/{version}/{plural} | 
*CustomObjectsApi* | [**delete_collection_namespaced_custom_object**](docs/CustomObjectsApi.md#delete_collection_namespaced_custom_object) | **DELETE** /apis/{group}/{version}/namespaces/{namespace}/{plural} | 
*CustomObjectsApi* | [**delete_namespaced_custom_object**](docs/CustomObjectsApi.md#delete_namespaced_custom_object) | **DELETE** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name} | 
*CustomObjectsApi* | [**get_cluster_custom_object**](docs/CustomObjectsApi.md#get_cluster_custom_object) | **GET** /apis/{group}/{version}/{plural}/{name} | 
*CustomObjectsApi* | [**get_cluster_custom_object_scale**](docs/CustomObjectsApi.md#get_cluster_custom_object_scale) | **GET** /apis/{group}/{version}/{plural}/{name}/scale | 
*CustomObjectsApi* | [**get_cluster_custom_object_status**](docs/CustomObjectsApi.md#get_cluster_custom_object_status) | **GET** /apis/{group}/{version}/{plural}/{name}/status | 
*CustomObjectsApi* | [**get_namespaced_custom_object**](docs/CustomObjectsApi.md#get_namespaced_custom_object) | **GET** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name} | 
*CustomObjectsApi* | [**get_namespaced_custom_object_scale**](docs/CustomObjectsApi.md#get_namespaced_custom_object_scale) | **GET** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale | 
*CustomObjectsApi* | [**get_namespaced_custom_object_status**](docs/CustomObjectsApi.md#get_namespaced_custom_object_status) | **GET** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status | 
*CustomObjectsApi* | [**list_cluster_custom_object**](docs/CustomObjectsApi.md#list_cluster_custom_object) | **GET** /apis/{group}/{version}/{plural} | 
*CustomObjectsApi* | [**list_namespaced_custom_object**](docs/CustomObjectsApi.md#list_namespaced_custom_object) | **GET** /apis/{group}/{version}/namespaces/{namespace}/{plural} | 
*CustomObjectsApi* | [**patch_cluster_custom_object**](docs/CustomObjectsApi.md#patch_cluster_custom_object) | **PATCH** /apis/{group}/{version}/{plural}/{name} | 
*CustomObjectsApi* | [**patch_cluster_custom_object_scale**](docs/CustomObjectsApi.md#patch_cluster_custom_object_scale) | **PATCH** /apis/{group}/{version}/{plural}/{name}/scale | 
*CustomObjectsApi* | [**patch_cluster_custom_object_status**](docs/CustomObjectsApi.md#patch_cluster_custom_object_status) | **PATCH** /apis/{group}/{version}/{plural}/{name}/status | 
*CustomObjectsApi* | [**patch_namespaced_custom_object**](docs/CustomObjectsApi.md#patch_namespaced_custom_object) | **PATCH** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name} | 
*CustomObjectsApi* | [**patch_namespaced_custom_object_scale**](docs/CustomObjectsApi.md#patch_namespaced_custom_object_scale) | **PATCH** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale | 
*CustomObjectsApi* | [**patch_namespaced_custom_object_status**](docs/CustomObjectsApi.md#patch_namespaced_custom_object_status) | **PATCH** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status | 
*CustomObjectsApi* | [**replace_cluster_custom_object**](docs/CustomObjectsApi.md#replace_cluster_custom_object) | **PUT** /apis/{group}/{version}/{plural}/{name} | 
*CustomObjectsApi* | [**replace_cluster_custom_object_scale**](docs/CustomObjectsApi.md#replace_cluster_custom_object_scale) | **PUT** /apis/{group}/{version}/{plural}/{name}/scale | 
*CustomObjectsApi* | [**replace_cluster_custom_object_status**](docs/CustomObjectsApi.md#replace_cluster_custom_object_status) | **PUT** /apis/{group}/{version}/{plural}/{name}/status | 
*CustomObjectsApi* | [**replace_namespaced_custom_object**](docs/CustomObjectsApi.md#replace_namespaced_custom_object) | **PUT** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name} | 
*CustomObjectsApi* | [**replace_namespaced_custom_object_scale**](docs/CustomObjectsApi.md#replace_namespaced_custom_object_scale) | **PUT** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale | 
*CustomObjectsApi* | [**replace_namespaced_custom_object_status**](docs/CustomObjectsApi.md#replace_namespaced_custom_object_status) | **PUT** /apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status | 
*DiscoveryApi* | [**get_api_group**](docs/DiscoveryApi.md#get_api_group) | **GET** /apis/discovery.k8s.io/ | 
*DiscoveryV1Api* | [**create_namespaced_endpoint_slice**](docs/DiscoveryV1Api.md#create_namespaced_endpoint_slice) | **POST** /apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices | 
*DiscoveryV1Api* | [**delete_collection_namespaced_endpoint_slice**](docs/DiscoveryV1Api.md#delete_collection_namespaced_endpoint_slice) | **DELETE** /apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices | 
*DiscoveryV1Api* | [**delete_namespaced_endpoint_slice**](docs/DiscoveryV1Api.md#delete_namespaced_endpoint_slice) | **DELETE** /apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name} | 
*DiscoveryV1Api* | [**get_api_resources**](docs/DiscoveryV1Api.md#get_api_resources) | **GET** /apis/discovery.k8s.io/v1/ | 
*DiscoveryV1Api* | [**list_endpoint_slice_for_all_namespaces**](docs/DiscoveryV1Api.md#list_endpoint_slice_for_all_namespaces) | **GET** /apis/discovery.k8s.io/v1/endpointslices | 
*DiscoveryV1Api* | [**list_namespaced_endpoint_slice**](docs/DiscoveryV1Api.md#list_namespaced_endpoint_slice) | **GET** /apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices | 
*DiscoveryV1Api* | [**patch_namespaced_endpoint_slice**](docs/DiscoveryV1Api.md#patch_namespaced_endpoint_slice) | **PATCH** /apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name} | 
*DiscoveryV1Api* | [**read_namespaced_endpoint_slice**](docs/DiscoveryV1Api.md#read_namespaced_endpoint_slice) | **GET** /apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name} | 
*DiscoveryV1Api* | [**replace_namespaced_endpoint_slice**](docs/DiscoveryV1Api.md#replace_namespaced_endpoint_slice) | **PUT** /apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name} | 
*DiscoveryV1beta1Api* | [**create_namespaced_endpoint_slice**](docs/DiscoveryV1beta1Api.md#create_namespaced_endpoint_slice) | **POST** /apis/discovery.k8s.io/v1beta1/namespaces/{namespace}/endpointslices | 
*DiscoveryV1beta1Api* | [**delete_collection_namespaced_endpoint_slice**](docs/DiscoveryV1beta1Api.md#delete_collection_namespaced_endpoint_slice) | **DELETE** /apis/discovery.k8s.io/v1beta1/namespaces/{namespace}/endpointslices | 
*DiscoveryV1beta1Api* | [**delete_namespaced_endpoint_slice**](docs/DiscoveryV1beta1Api.md#delete_namespaced_endpoint_slice) | **DELETE** /apis/discovery.k8s.io/v1beta1/namespaces/{namespace}/endpointslices/{name} | 
*DiscoveryV1beta1Api* | [**get_api_resources**](docs/DiscoveryV1beta1Api.md#get_api_resources) | **GET** /apis/discovery.k8s.io/v1beta1/ | 
*DiscoveryV1beta1Api* | [**list_endpoint_slice_for_all_namespaces**](docs/DiscoveryV1beta1Api.md#list_endpoint_slice_for_all_namespaces) | **GET** /apis/discovery.k8s.io/v1beta1/endpointslices | 
*DiscoveryV1beta1Api* | [**list_namespaced_endpoint_slice**](docs/DiscoveryV1beta1Api.md#list_namespaced_endpoint_slice) | **GET** /apis/discovery.k8s.io/v1beta1/namespaces/{namespace}/endpointslices | 
*DiscoveryV1beta1Api* | [**patch_namespaced_endpoint_slice**](docs/DiscoveryV1beta1Api.md#patch_namespaced_endpoint_slice) | **PATCH** /apis/discovery.k8s.io/v1beta1/namespaces/{namespace}/endpointslices/{name} | 
*DiscoveryV1beta1Api* | [**read_namespaced_endpoint_slice**](docs/DiscoveryV1beta1Api.md#read_namespaced_endpoint_slice) | **GET** /apis/discovery.k8s.io/v1beta1/namespaces/{namespace}/endpointslices/{name} | 
*DiscoveryV1beta1Api* | [**replace_namespaced_endpoint_slice**](docs/DiscoveryV1beta1Api.md#replace_namespaced_endpoint_slice) | **PUT** /apis/discovery.k8s.io/v1beta1/namespaces/{namespace}/endpointslices/{name} | 
*EventsApi* | [**get_api_group**](docs/EventsApi.md#get_api_group) | **GET** /apis/events.k8s.io/ | 
*EventsV1Api* | [**create_namespaced_event**](docs/EventsV1Api.md#create_namespaced_event) | **POST** /apis/events.k8s.io/v1/namespaces/{namespace}/events | 
*EventsV1Api* | [**delete_collection_namespaced_event**](docs/EventsV1Api.md#delete_collection_namespaced_event) | **DELETE** /apis/events.k8s.io/v1/namespaces/{namespace}/events | 
*EventsV1Api* | [**delete_namespaced_event**](docs/EventsV1Api.md#delete_namespaced_event) | **DELETE** /apis/events.k8s.io/v1/namespaces/{namespace}/events/{name} | 
*EventsV1Api* | [**get_api_resources**](docs/EventsV1Api.md#get_api_resources) | **GET** /apis/events.k8s.io/v1/ | 
*EventsV1Api* | [**list_event_for_all_namespaces**](docs/EventsV1Api.md#list_event_for_all_namespaces) | **GET** /apis/events.k8s.io/v1/events | 
*EventsV1Api* | [**list_namespaced_event**](docs/EventsV1Api.md#list_namespaced_event) | **GET** /apis/events.k8s.io/v1/namespaces/{namespace}/events | 
*EventsV1Api* | [**patch_namespaced_event**](docs/EventsV1Api.md#patch_namespaced_event) | **PATCH** /apis/events.k8s.io/v1/namespaces/{namespace}/events/{name} | 
*EventsV1Api* | [**read_namespaced_event**](docs/EventsV1Api.md#read_namespaced_event) | **GET** /apis/events.k8s.io/v1/namespaces/{namespace}/events/{name} | 
*EventsV1Api* | [**replace_namespaced_event**](docs/EventsV1Api.md#replace_namespaced_event) | **PUT** /apis/events.k8s.io/v1/namespaces/{namespace}/events/{name} | 
*EventsV1beta1Api* | [**create_namespaced_event**](docs/EventsV1beta1Api.md#create_namespaced_event) | **POST** /apis/events.k8s.io/v1beta1/namespaces/{namespace}/events | 
*EventsV1beta1Api* | [**delete_collection_namespaced_event**](docs/EventsV1beta1Api.md#delete_collection_namespaced_event) | **DELETE** /apis/events.k8s.io/v1beta1/namespaces/{namespace}/events | 
*EventsV1beta1Api* | [**delete_namespaced_event**](docs/EventsV1beta1Api.md#delete_namespaced_event) | **DELETE** /apis/events.k8s.io/v1beta1/namespaces/{namespace}/events/{name} | 
*EventsV1beta1Api* | [**get_api_resources**](docs/EventsV1beta1Api.md#get_api_resources) | **GET** /apis/events.k8s.io/v1beta1/ | 
*EventsV1beta1Api* | [**list_event_for_all_namespaces**](docs/EventsV1beta1Api.md#list_event_for_all_namespaces) | **GET** /apis/events.k8s.io/v1beta1/events | 
*EventsV1beta1Api* | [**list_namespaced_event**](docs/EventsV1beta1Api.md#list_namespaced_event) | **GET** /apis/events.k8s.io/v1beta1/namespaces/{namespace}/events | 
*EventsV1beta1Api* | [**patch_namespaced_event**](docs/EventsV1beta1Api.md#patch_namespaced_event) | **PATCH** /apis/events.k8s.io/v1beta1/namespaces/{namespace}/events/{name} | 
*EventsV1beta1Api* | [**read_namespaced_event**](docs/EventsV1beta1Api.md#read_namespaced_event) | **GET** /apis/events.k8s.io/v1beta1/namespaces/{namespace}/events/{name} | 
*EventsV1beta1Api* | [**replace_namespaced_event**](docs/EventsV1beta1Api.md#replace_namespaced_event) | **PUT** /apis/events.k8s.io/v1beta1/namespaces/{namespace}/events/{name} | 
*FlowcontrolApiserverApi* | [**get_api_group**](docs/FlowcontrolApiserverApi.md#get_api_group) | **GET** /apis/flowcontrol.apiserver.k8s.io/ | 
*FlowcontrolApiserverV1beta1Api* | [**create_flow_schema**](docs/FlowcontrolApiserverV1beta1Api.md#create_flow_schema) | **POST** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas | 
*FlowcontrolApiserverV1beta1Api* | [**create_priority_level_configuration**](docs/FlowcontrolApiserverV1beta1Api.md#create_priority_level_configuration) | **POST** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations | 
*FlowcontrolApiserverV1beta1Api* | [**delete_collection_flow_schema**](docs/FlowcontrolApiserverV1beta1Api.md#delete_collection_flow_schema) | **DELETE** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas | 
*FlowcontrolApiserverV1beta1Api* | [**delete_collection_priority_level_configuration**](docs/FlowcontrolApiserverV1beta1Api.md#delete_collection_priority_level_configuration) | **DELETE** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations | 
*FlowcontrolApiserverV1beta1Api* | [**delete_flow_schema**](docs/FlowcontrolApiserverV1beta1Api.md#delete_flow_schema) | **DELETE** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas/{name} | 
*FlowcontrolApiserverV1beta1Api* | [**delete_priority_level_configuration**](docs/FlowcontrolApiserverV1beta1Api.md#delete_priority_level_configuration) | **DELETE** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations/{name} | 
*FlowcontrolApiserverV1beta1Api* | [**get_api_resources**](docs/FlowcontrolApiserverV1beta1Api.md#get_api_resources) | **GET** /apis/flowcontrol.apiserver.k8s.io/v1beta1/ | 
*FlowcontrolApiserverV1beta1Api* | [**list_flow_schema**](docs/FlowcontrolApiserverV1beta1Api.md#list_flow_schema) | **GET** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas | 
*FlowcontrolApiserverV1beta1Api* | [**list_priority_level_configuration**](docs/FlowcontrolApiserverV1beta1Api.md#list_priority_level_configuration) | **GET** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations | 
*FlowcontrolApiserverV1beta1Api* | [**patch_flow_schema**](docs/FlowcontrolApiserverV1beta1Api.md#patch_flow_schema) | **PATCH** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas/{name} | 
*FlowcontrolApiserverV1beta1Api* | [**patch_flow_schema_status**](docs/FlowcontrolApiserverV1beta1Api.md#patch_flow_schema_status) | **PATCH** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas/{name}/status | 
*FlowcontrolApiserverV1beta1Api* | [**patch_priority_level_configuration**](docs/FlowcontrolApiserverV1beta1Api.md#patch_priority_level_configuration) | **PATCH** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations/{name} | 
*FlowcontrolApiserverV1beta1Api* | [**patch_priority_level_configuration_status**](docs/FlowcontrolApiserverV1beta1Api.md#patch_priority_level_configuration_status) | **PATCH** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations/{name}/status | 
*FlowcontrolApiserverV1beta1Api* | [**read_flow_schema**](docs/FlowcontrolApiserverV1beta1Api.md#read_flow_schema) | **GET** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas/{name} | 
*FlowcontrolApiserverV1beta1Api* | [**read_flow_schema_status**](docs/FlowcontrolApiserverV1beta1Api.md#read_flow_schema_status) | **GET** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas/{name}/status | 
*FlowcontrolApiserverV1beta1Api* | [**read_priority_level_configuration**](docs/FlowcontrolApiserverV1beta1Api.md#read_priority_level_configuration) | **GET** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations/{name} | 
*FlowcontrolApiserverV1beta1Api* | [**read_priority_level_configuration_status**](docs/FlowcontrolApiserverV1beta1Api.md#read_priority_level_configuration_status) | **GET** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations/{name}/status | 
*FlowcontrolApiserverV1beta1Api* | [**replace_flow_schema**](docs/FlowcontrolApiserverV1beta1Api.md#replace_flow_schema) | **PUT** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas/{name} | 
*FlowcontrolApiserverV1beta1Api* | [**replace_flow_schema_status**](docs/FlowcontrolApiserverV1beta1Api.md#replace_flow_schema_status) | **PUT** /apis/flowcontrol.apiserver.k8s.io/v1beta1/flowschemas/{name}/status | 
*FlowcontrolApiserverV1beta1Api* | [**replace_priority_level_configuration**](docs/FlowcontrolApiserverV1beta1Api.md#replace_priority_level_configuration) | **PUT** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations/{name} | 
*FlowcontrolApiserverV1beta1Api* | [**replace_priority_level_configuration_status**](docs/FlowcontrolApiserverV1beta1Api.md#replace_priority_level_configuration_status) | **PUT** /apis/flowcontrol.apiserver.k8s.io/v1beta1/prioritylevelconfigurations/{name}/status | 
*InternalApiserverApi* | [**get_api_group**](docs/InternalApiserverApi.md#get_api_group) | **GET** /apis/internal.apiserver.k8s.io/ | 
*InternalApiserverV1alpha1Api* | [**create_storage_version**](docs/InternalApiserverV1alpha1Api.md#create_storage_version) | **POST** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions | 
*InternalApiserverV1alpha1Api* | [**delete_collection_storage_version**](docs/InternalApiserverV1alpha1Api.md#delete_collection_storage_version) | **DELETE** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions | 
*InternalApiserverV1alpha1Api* | [**delete_storage_version**](docs/InternalApiserverV1alpha1Api.md#delete_storage_version) | **DELETE** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions/{name} | 
*InternalApiserverV1alpha1Api* | [**get_api_resources**](docs/InternalApiserverV1alpha1Api.md#get_api_resources) | **GET** /apis/internal.apiserver.k8s.io/v1alpha1/ | 
*InternalApiserverV1alpha1Api* | [**list_storage_version**](docs/InternalApiserverV1alpha1Api.md#list_storage_version) | **GET** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions | 
*InternalApiserverV1alpha1Api* | [**patch_storage_version**](docs/InternalApiserverV1alpha1Api.md#patch_storage_version) | **PATCH** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions/{name} | 
*InternalApiserverV1alpha1Api* | [**patch_storage_version_status**](docs/InternalApiserverV1alpha1Api.md#patch_storage_version_status) | **PATCH** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions/{name}/status | 
*InternalApiserverV1alpha1Api* | [**read_storage_version**](docs/InternalApiserverV1alpha1Api.md#read_storage_version) | **GET** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions/{name} | 
*InternalApiserverV1alpha1Api* | [**read_storage_version_status**](docs/InternalApiserverV1alpha1Api.md#read_storage_version_status) | **GET** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions/{name}/status | 
*InternalApiserverV1alpha1Api* | [**replace_storage_version**](docs/InternalApiserverV1alpha1Api.md#replace_storage_version) | **PUT** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions/{name} | 
*InternalApiserverV1alpha1Api* | [**replace_storage_version_status**](docs/InternalApiserverV1alpha1Api.md#replace_storage_version_status) | **PUT** /apis/internal.apiserver.k8s.io/v1alpha1/storageversions/{name}/status | 
*LogsApi* | [**log_file_handler**](docs/LogsApi.md#log_file_handler) | **GET** /logs/{logpath} | 
*LogsApi* | [**log_file_list_handler**](docs/LogsApi.md#log_file_list_handler) | **GET** /logs/ | 
*NetworkingApi* | [**get_api_group**](docs/NetworkingApi.md#get_api_group) | **GET** /apis/networking.k8s.io/ | 
*NetworkingV1Api* | [**create_ingress_class**](docs/NetworkingV1Api.md#create_ingress_class) | **POST** /apis/networking.k8s.io/v1/ingressclasses | 
*NetworkingV1Api* | [**create_namespaced_ingress**](docs/NetworkingV1Api.md#create_namespaced_ingress) | **POST** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses | 
*NetworkingV1Api* | [**create_namespaced_network_policy**](docs/NetworkingV1Api.md#create_namespaced_network_policy) | **POST** /apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies | 
*NetworkingV1Api* | [**delete_collection_ingress_class**](docs/NetworkingV1Api.md#delete_collection_ingress_class) | **DELETE** /apis/networking.k8s.io/v1/ingressclasses | 
*NetworkingV1Api* | [**delete_collection_namespaced_ingress**](docs/NetworkingV1Api.md#delete_collection_namespaced_ingress) | **DELETE** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses | 
*NetworkingV1Api* | [**delete_collection_namespaced_network_policy**](docs/NetworkingV1Api.md#delete_collection_namespaced_network_policy) | **DELETE** /apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies | 
*NetworkingV1Api* | [**delete_ingress_class**](docs/NetworkingV1Api.md#delete_ingress_class) | **DELETE** /apis/networking.k8s.io/v1/ingressclasses/{name} | 
*NetworkingV1Api* | [**delete_namespaced_ingress**](docs/NetworkingV1Api.md#delete_namespaced_ingress) | **DELETE** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name} | 
*NetworkingV1Api* | [**delete_namespaced_network_policy**](docs/NetworkingV1Api.md#delete_namespaced_network_policy) | **DELETE** /apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name} | 
*NetworkingV1Api* | [**get_api_resources**](docs/NetworkingV1Api.md#get_api_resources) | **GET** /apis/networking.k8s.io/v1/ | 
*NetworkingV1Api* | [**list_ingress_class**](docs/NetworkingV1Api.md#list_ingress_class) | **GET** /apis/networking.k8s.io/v1/ingressclasses | 
*NetworkingV1Api* | [**list_ingress_for_all_namespaces**](docs/NetworkingV1Api.md#list_ingress_for_all_namespaces) | **GET** /apis/networking.k8s.io/v1/ingresses | 
*NetworkingV1Api* | [**list_namespaced_ingress**](docs/NetworkingV1Api.md#list_namespaced_ingress) | **GET** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses | 
*NetworkingV1Api* | [**list_namespaced_network_policy**](docs/NetworkingV1Api.md#list_namespaced_network_policy) | **GET** /apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies | 
*NetworkingV1Api* | [**list_network_policy_for_all_namespaces**](docs/NetworkingV1Api.md#list_network_policy_for_all_namespaces) | **GET** /apis/networking.k8s.io/v1/networkpolicies | 
*NetworkingV1Api* | [**patch_ingress_class**](docs/NetworkingV1Api.md#patch_ingress_class) | **PATCH** /apis/networking.k8s.io/v1/ingressclasses/{name} | 
*NetworkingV1Api* | [**patch_namespaced_ingress**](docs/NetworkingV1Api.md#patch_namespaced_ingress) | **PATCH** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name} | 
*NetworkingV1Api* | [**patch_namespaced_ingress_status**](docs/NetworkingV1Api.md#patch_namespaced_ingress_status) | **PATCH** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status | 
*NetworkingV1Api* | [**patch_namespaced_network_policy**](docs/NetworkingV1Api.md#patch_namespaced_network_policy) | **PATCH** /apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name} | 
*NetworkingV1Api* | [**read_ingress_class**](docs/NetworkingV1Api.md#read_ingress_class) | **GET** /apis/networking.k8s.io/v1/ingressclasses/{name} | 
*NetworkingV1Api* | [**read_namespaced_ingress**](docs/NetworkingV1Api.md#read_namespaced_ingress) | **GET** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name} | 
*NetworkingV1Api* | [**read_namespaced_ingress_status**](docs/NetworkingV1Api.md#read_namespaced_ingress_status) | **GET** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status | 
*NetworkingV1Api* | [**read_namespaced_network_policy**](docs/NetworkingV1Api.md#read_namespaced_network_policy) | **GET** /apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name} | 
*NetworkingV1Api* | [**replace_ingress_class**](docs/NetworkingV1Api.md#replace_ingress_class) | **PUT** /apis/networking.k8s.io/v1/ingressclasses/{name} | 
*NetworkingV1Api* | [**replace_namespaced_ingress**](docs/NetworkingV1Api.md#replace_namespaced_ingress) | **PUT** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name} | 
*NetworkingV1Api* | [**replace_namespaced_ingress_status**](docs/NetworkingV1Api.md#replace_namespaced_ingress_status) | **PUT** /apis/networking.k8s.io/v1/namespaces/{namespace}/ingresses/{name}/status | 
*NetworkingV1Api* | [**replace_namespaced_network_policy**](docs/NetworkingV1Api.md#replace_namespaced_network_policy) | **PUT** /apis/networking.k8s.io/v1/namespaces/{namespace}/networkpolicies/{name} | 
*NodeApi* | [**get_api_group**](docs/NodeApi.md#get_api_group) | **GET** /apis/node.k8s.io/ | 
*NodeV1Api* | [**create_runtime_class**](docs/NodeV1Api.md#create_runtime_class) | **POST** /apis/node.k8s.io/v1/runtimeclasses | 
*NodeV1Api* | [**delete_collection_runtime_class**](docs/NodeV1Api.md#delete_collection_runtime_class) | **DELETE** /apis/node.k8s.io/v1/runtimeclasses | 
*NodeV1Api* | [**delete_runtime_class**](docs/NodeV1Api.md#delete_runtime_class) | **DELETE** /apis/node.k8s.io/v1/runtimeclasses/{name} | 
*NodeV1Api* | [**get_api_resources**](docs/NodeV1Api.md#get_api_resources) | **GET** /apis/node.k8s.io/v1/ | 
*NodeV1Api* | [**list_runtime_class**](docs/NodeV1Api.md#list_runtime_class) | **GET** /apis/node.k8s.io/v1/runtimeclasses | 
*NodeV1Api* | [**patch_runtime_class**](docs/NodeV1Api.md#patch_runtime_class) | **PATCH** /apis/node.k8s.io/v1/runtimeclasses/{name} | 
*NodeV1Api* | [**read_runtime_class**](docs/NodeV1Api.md#read_runtime_class) | **GET** /apis/node.k8s.io/v1/runtimeclasses/{name} | 
*NodeV1Api* | [**replace_runtime_class**](docs/NodeV1Api.md#replace_runtime_class) | **PUT** /apis/node.k8s.io/v1/runtimeclasses/{name} | 
*NodeV1alpha1Api* | [**create_runtime_class**](docs/NodeV1alpha1Api.md#create_runtime_class) | **POST** /apis/node.k8s.io/v1alpha1/runtimeclasses | 
*NodeV1alpha1Api* | [**delete_collection_runtime_class**](docs/NodeV1alpha1Api.md#delete_collection_runtime_class) | **DELETE** /apis/node.k8s.io/v1alpha1/runtimeclasses | 
*NodeV1alpha1Api* | [**delete_runtime_class**](docs/NodeV1alpha1Api.md#delete_runtime_class) | **DELETE** /apis/node.k8s.io/v1alpha1/runtimeclasses/{name} | 
*NodeV1alpha1Api* | [**get_api_resources**](docs/NodeV1alpha1Api.md#get_api_resources) | **GET** /apis/node.k8s.io/v1alpha1/ | 
*NodeV1alpha1Api* | [**list_runtime_class**](docs/NodeV1alpha1Api.md#list_runtime_class) | **GET** /apis/node.k8s.io/v1alpha1/runtimeclasses | 
*NodeV1alpha1Api* | [**patch_runtime_class**](docs/NodeV1alpha1Api.md#patch_runtime_class) | **PATCH** /apis/node.k8s.io/v1alpha1/runtimeclasses/{name} | 
*NodeV1alpha1Api* | [**read_runtime_class**](docs/NodeV1alpha1Api.md#read_runtime_class) | **GET** /apis/node.k8s.io/v1alpha1/runtimeclasses/{name} | 
*NodeV1alpha1Api* | [**replace_runtime_class**](docs/NodeV1alpha1Api.md#replace_runtime_class) | **PUT** /apis/node.k8s.io/v1alpha1/runtimeclasses/{name} | 
*NodeV1beta1Api* | [**create_runtime_class**](docs/NodeV1beta1Api.md#create_runtime_class) | **POST** /apis/node.k8s.io/v1beta1/runtimeclasses | 
*NodeV1beta1Api* | [**delete_collection_runtime_class**](docs/NodeV1beta1Api.md#delete_collection_runtime_class) | **DELETE** /apis/node.k8s.io/v1beta1/runtimeclasses | 
*NodeV1beta1Api* | [**delete_runtime_class**](docs/NodeV1beta1Api.md#delete_runtime_class) | **DELETE** /apis/node.k8s.io/v1beta1/runtimeclasses/{name} | 
*NodeV1beta1Api* | [**get_api_resources**](docs/NodeV1beta1Api.md#get_api_resources) | **GET** /apis/node.k8s.io/v1beta1/ | 
*NodeV1beta1Api* | [**list_runtime_class**](docs/NodeV1beta1Api.md#list_runtime_class) | **GET** /apis/node.k8s.io/v1beta1/runtimeclasses | 
*NodeV1beta1Api* | [**patch_runtime_class**](docs/NodeV1beta1Api.md#patch_runtime_class) | **PATCH** /apis/node.k8s.io/v1beta1/runtimeclasses/{name} | 
*NodeV1beta1Api* | [**read_runtime_class**](docs/NodeV1beta1Api.md#read_runtime_class) | **GET** /apis/node.k8s.io/v1beta1/runtimeclasses/{name} | 
*NodeV1beta1Api* | [**replace_runtime_class**](docs/NodeV1beta1Api.md#replace_runtime_class) | **PUT** /apis/node.k8s.io/v1beta1/runtimeclasses/{name} | 
*OpenidApi* | [**get_service_account_issuer_open_id_keyset**](docs/OpenidApi.md#get_service_account_issuer_open_id_keyset) | **GET** /openid/v1/jwks/ | 
*PolicyApi* | [**get_api_group**](docs/PolicyApi.md#get_api_group) | **GET** /apis/policy/ | 
*PolicyV1Api* | [**create_namespaced_pod_disruption_budget**](docs/PolicyV1Api.md#create_namespaced_pod_disruption_budget) | **POST** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1Api* | [**delete_collection_namespaced_pod_disruption_budget**](docs/PolicyV1Api.md#delete_collection_namespaced_pod_disruption_budget) | **DELETE** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1Api* | [**delete_namespaced_pod_disruption_budget**](docs/PolicyV1Api.md#delete_namespaced_pod_disruption_budget) | **DELETE** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1Api* | [**get_api_resources**](docs/PolicyV1Api.md#get_api_resources) | **GET** /apis/policy/v1/ | 
*PolicyV1Api* | [**list_namespaced_pod_disruption_budget**](docs/PolicyV1Api.md#list_namespaced_pod_disruption_budget) | **GET** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1Api* | [**list_pod_disruption_budget_for_all_namespaces**](docs/PolicyV1Api.md#list_pod_disruption_budget_for_all_namespaces) | **GET** /apis/policy/v1/poddisruptionbudgets | 
*PolicyV1Api* | [**patch_namespaced_pod_disruption_budget**](docs/PolicyV1Api.md#patch_namespaced_pod_disruption_budget) | **PATCH** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1Api* | [**patch_namespaced_pod_disruption_budget_status**](docs/PolicyV1Api.md#patch_namespaced_pod_disruption_budget_status) | **PATCH** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*PolicyV1Api* | [**read_namespaced_pod_disruption_budget**](docs/PolicyV1Api.md#read_namespaced_pod_disruption_budget) | **GET** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1Api* | [**read_namespaced_pod_disruption_budget_status**](docs/PolicyV1Api.md#read_namespaced_pod_disruption_budget_status) | **GET** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*PolicyV1Api* | [**replace_namespaced_pod_disruption_budget**](docs/PolicyV1Api.md#replace_namespaced_pod_disruption_budget) | **PUT** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1Api* | [**replace_namespaced_pod_disruption_budget_status**](docs/PolicyV1Api.md#replace_namespaced_pod_disruption_budget_status) | **PUT** /apis/policy/v1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*PolicyV1beta1Api* | [**create_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#create_namespaced_pod_disruption_budget) | **POST** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1beta1Api* | [**create_pod_security_policy**](docs/PolicyV1beta1Api.md#create_pod_security_policy) | **POST** /apis/policy/v1beta1/podsecuritypolicies | 
*PolicyV1beta1Api* | [**delete_collection_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#delete_collection_namespaced_pod_disruption_budget) | **DELETE** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1beta1Api* | [**delete_collection_pod_security_policy**](docs/PolicyV1beta1Api.md#delete_collection_pod_security_policy) | **DELETE** /apis/policy/v1beta1/podsecuritypolicies | 
*PolicyV1beta1Api* | [**delete_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#delete_namespaced_pod_disruption_budget) | **DELETE** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1beta1Api* | [**delete_pod_security_policy**](docs/PolicyV1beta1Api.md#delete_pod_security_policy) | **DELETE** /apis/policy/v1beta1/podsecuritypolicies/{name} | 
*PolicyV1beta1Api* | [**get_api_resources**](docs/PolicyV1beta1Api.md#get_api_resources) | **GET** /apis/policy/v1beta1/ | 
*PolicyV1beta1Api* | [**list_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#list_namespaced_pod_disruption_budget) | **GET** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets | 
*PolicyV1beta1Api* | [**list_pod_disruption_budget_for_all_namespaces**](docs/PolicyV1beta1Api.md#list_pod_disruption_budget_for_all_namespaces) | **GET** /apis/policy/v1beta1/poddisruptionbudgets | 
*PolicyV1beta1Api* | [**list_pod_security_policy**](docs/PolicyV1beta1Api.md#list_pod_security_policy) | **GET** /apis/policy/v1beta1/podsecuritypolicies | 
*PolicyV1beta1Api* | [**patch_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#patch_namespaced_pod_disruption_budget) | **PATCH** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1beta1Api* | [**patch_namespaced_pod_disruption_budget_status**](docs/PolicyV1beta1Api.md#patch_namespaced_pod_disruption_budget_status) | **PATCH** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*PolicyV1beta1Api* | [**patch_pod_security_policy**](docs/PolicyV1beta1Api.md#patch_pod_security_policy) | **PATCH** /apis/policy/v1beta1/podsecuritypolicies/{name} | 
*PolicyV1beta1Api* | [**read_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#read_namespaced_pod_disruption_budget) | **GET** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1beta1Api* | [**read_namespaced_pod_disruption_budget_status**](docs/PolicyV1beta1Api.md#read_namespaced_pod_disruption_budget_status) | **GET** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*PolicyV1beta1Api* | [**read_pod_security_policy**](docs/PolicyV1beta1Api.md#read_pod_security_policy) | **GET** /apis/policy/v1beta1/podsecuritypolicies/{name} | 
*PolicyV1beta1Api* | [**replace_namespaced_pod_disruption_budget**](docs/PolicyV1beta1Api.md#replace_namespaced_pod_disruption_budget) | **PUT** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name} | 
*PolicyV1beta1Api* | [**replace_namespaced_pod_disruption_budget_status**](docs/PolicyV1beta1Api.md#replace_namespaced_pod_disruption_budget_status) | **PUT** /apis/policy/v1beta1/namespaces/{namespace}/poddisruptionbudgets/{name}/status | 
*PolicyV1beta1Api* | [**replace_pod_security_policy**](docs/PolicyV1beta1Api.md#replace_pod_security_policy) | **PUT** /apis/policy/v1beta1/podsecuritypolicies/{name} | 
*RbacAuthorizationApi* | [**get_api_group**](docs/RbacAuthorizationApi.md#get_api_group) | **GET** /apis/rbac.authorization.k8s.io/ | 
*RbacAuthorizationV1Api* | [**create_cluster_role**](docs/RbacAuthorizationV1Api.md#create_cluster_role) | **POST** /apis/rbac.authorization.k8s.io/v1/clusterroles | 
*RbacAuthorizationV1Api* | [**create_cluster_role_binding**](docs/RbacAuthorizationV1Api.md#create_cluster_role_binding) | **POST** /apis/rbac.authorization.k8s.io/v1/clusterrolebindings | 
*RbacAuthorizationV1Api* | [**create_namespaced_role**](docs/RbacAuthorizationV1Api.md#create_namespaced_role) | **POST** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1Api* | [**create_namespaced_role_binding**](docs/RbacAuthorizationV1Api.md#create_namespaced_role_binding) | **POST** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1Api* | [**delete_cluster_role**](docs/RbacAuthorizationV1Api.md#delete_cluster_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1/clusterroles/{name} | 
*RbacAuthorizationV1Api* | [**delete_cluster_role_binding**](docs/RbacAuthorizationV1Api.md#delete_cluster_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1/clusterrolebindings/{name} | 
*RbacAuthorizationV1Api* | [**delete_collection_cluster_role**](docs/RbacAuthorizationV1Api.md#delete_collection_cluster_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1/clusterroles | 
*RbacAuthorizationV1Api* | [**delete_collection_cluster_role_binding**](docs/RbacAuthorizationV1Api.md#delete_collection_cluster_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1/clusterrolebindings | 
*RbacAuthorizationV1Api* | [**delete_collection_namespaced_role**](docs/RbacAuthorizationV1Api.md#delete_collection_namespaced_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1Api* | [**delete_collection_namespaced_role_binding**](docs/RbacAuthorizationV1Api.md#delete_collection_namespaced_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1Api* | [**delete_namespaced_role**](docs/RbacAuthorizationV1Api.md#delete_namespaced_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1Api* | [**delete_namespaced_role_binding**](docs/RbacAuthorizationV1Api.md#delete_namespaced_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1Api* | [**get_api_resources**](docs/RbacAuthorizationV1Api.md#get_api_resources) | **GET** /apis/rbac.authorization.k8s.io/v1/ | 
*RbacAuthorizationV1Api* | [**list_cluster_role**](docs/RbacAuthorizationV1Api.md#list_cluster_role) | **GET** /apis/rbac.authorization.k8s.io/v1/clusterroles | 
*RbacAuthorizationV1Api* | [**list_cluster_role_binding**](docs/RbacAuthorizationV1Api.md#list_cluster_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1/clusterrolebindings | 
*RbacAuthorizationV1Api* | [**list_namespaced_role**](docs/RbacAuthorizationV1Api.md#list_namespaced_role) | **GET** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1Api* | [**list_namespaced_role_binding**](docs/RbacAuthorizationV1Api.md#list_namespaced_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1Api* | [**list_role_binding_for_all_namespaces**](docs/RbacAuthorizationV1Api.md#list_role_binding_for_all_namespaces) | **GET** /apis/rbac.authorization.k8s.io/v1/rolebindings | 
*RbacAuthorizationV1Api* | [**list_role_for_all_namespaces**](docs/RbacAuthorizationV1Api.md#list_role_for_all_namespaces) | **GET** /apis/rbac.authorization.k8s.io/v1/roles | 
*RbacAuthorizationV1Api* | [**patch_cluster_role**](docs/RbacAuthorizationV1Api.md#patch_cluster_role) | **PATCH** /apis/rbac.authorization.k8s.io/v1/clusterroles/{name} | 
*RbacAuthorizationV1Api* | [**patch_cluster_role_binding**](docs/RbacAuthorizationV1Api.md#patch_cluster_role_binding) | **PATCH** /apis/rbac.authorization.k8s.io/v1/clusterrolebindings/{name} | 
*RbacAuthorizationV1Api* | [**patch_namespaced_role**](docs/RbacAuthorizationV1Api.md#patch_namespaced_role) | **PATCH** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1Api* | [**patch_namespaced_role_binding**](docs/RbacAuthorizationV1Api.md#patch_namespaced_role_binding) | **PATCH** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1Api* | [**read_cluster_role**](docs/RbacAuthorizationV1Api.md#read_cluster_role) | **GET** /apis/rbac.authorization.k8s.io/v1/clusterroles/{name} | 
*RbacAuthorizationV1Api* | [**read_cluster_role_binding**](docs/RbacAuthorizationV1Api.md#read_cluster_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1/clusterrolebindings/{name} | 
*RbacAuthorizationV1Api* | [**read_namespaced_role**](docs/RbacAuthorizationV1Api.md#read_namespaced_role) | **GET** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1Api* | [**read_namespaced_role_binding**](docs/RbacAuthorizationV1Api.md#read_namespaced_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1Api* | [**replace_cluster_role**](docs/RbacAuthorizationV1Api.md#replace_cluster_role) | **PUT** /apis/rbac.authorization.k8s.io/v1/clusterroles/{name} | 
*RbacAuthorizationV1Api* | [**replace_cluster_role_binding**](docs/RbacAuthorizationV1Api.md#replace_cluster_role_binding) | **PUT** /apis/rbac.authorization.k8s.io/v1/clusterrolebindings/{name} | 
*RbacAuthorizationV1Api* | [**replace_namespaced_role**](docs/RbacAuthorizationV1Api.md#replace_namespaced_role) | **PUT** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1Api* | [**replace_namespaced_role_binding**](docs/RbacAuthorizationV1Api.md#replace_namespaced_role_binding) | **PUT** /apis/rbac.authorization.k8s.io/v1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**create_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#create_cluster_role) | **POST** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles | 
*RbacAuthorizationV1alpha1Api* | [**create_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#create_cluster_role_binding) | **POST** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings | 
*RbacAuthorizationV1alpha1Api* | [**create_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#create_namespaced_role) | **POST** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1alpha1Api* | [**create_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#create_namespaced_role_binding) | **POST** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1alpha1Api* | [**delete_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#delete_cluster_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**delete_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#delete_cluster_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**delete_collection_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#delete_collection_cluster_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles | 
*RbacAuthorizationV1alpha1Api* | [**delete_collection_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#delete_collection_cluster_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings | 
*RbacAuthorizationV1alpha1Api* | [**delete_collection_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#delete_collection_namespaced_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1alpha1Api* | [**delete_collection_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#delete_collection_namespaced_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1alpha1Api* | [**delete_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#delete_namespaced_role) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**delete_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#delete_namespaced_role_binding) | **DELETE** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**get_api_resources**](docs/RbacAuthorizationV1alpha1Api.md#get_api_resources) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/ | 
*RbacAuthorizationV1alpha1Api* | [**list_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#list_cluster_role) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles | 
*RbacAuthorizationV1alpha1Api* | [**list_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#list_cluster_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings | 
*RbacAuthorizationV1alpha1Api* | [**list_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#list_namespaced_role) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles | 
*RbacAuthorizationV1alpha1Api* | [**list_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#list_namespaced_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings | 
*RbacAuthorizationV1alpha1Api* | [**list_role_binding_for_all_namespaces**](docs/RbacAuthorizationV1alpha1Api.md#list_role_binding_for_all_namespaces) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/rolebindings | 
*RbacAuthorizationV1alpha1Api* | [**list_role_for_all_namespaces**](docs/RbacAuthorizationV1alpha1Api.md#list_role_for_all_namespaces) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/roles | 
*RbacAuthorizationV1alpha1Api* | [**patch_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#patch_cluster_role) | **PATCH** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**patch_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#patch_cluster_role_binding) | **PATCH** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**patch_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#patch_namespaced_role) | **PATCH** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**patch_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#patch_namespaced_role_binding) | **PATCH** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**read_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#read_cluster_role) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**read_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#read_cluster_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**read_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#read_namespaced_role) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**read_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#read_namespaced_role_binding) | **GET** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**replace_cluster_role**](docs/RbacAuthorizationV1alpha1Api.md#replace_cluster_role) | **PUT** /apis/rbac.authorization.k8s.io/v1alpha1/clusterroles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**replace_cluster_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#replace_cluster_role_binding) | **PUT** /apis/rbac.authorization.k8s.io/v1alpha1/clusterrolebindings/{name} | 
*RbacAuthorizationV1alpha1Api* | [**replace_namespaced_role**](docs/RbacAuthorizationV1alpha1Api.md#replace_namespaced_role) | **PUT** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/roles/{name} | 
*RbacAuthorizationV1alpha1Api* | [**replace_namespaced_role_binding**](docs/RbacAuthorizationV1alpha1Api.md#replace_namespaced_role_binding) | **PUT** /apis/rbac.authorization.k8s.io/v1alpha1/namespaces/{namespace}/rolebindings/{name} | 
*SchedulingApi* | [**get_api_group**](docs/SchedulingApi.md#get_api_group) | **GET** /apis/scheduling.k8s.io/ | 
*SchedulingV1Api* | [**create_priority_class**](docs/SchedulingV1Api.md#create_priority_class) | **POST** /apis/scheduling.k8s.io/v1/priorityclasses | 
*SchedulingV1Api* | [**delete_collection_priority_class**](docs/SchedulingV1Api.md#delete_collection_priority_class) | **DELETE** /apis/scheduling.k8s.io/v1/priorityclasses | 
*SchedulingV1Api* | [**delete_priority_class**](docs/SchedulingV1Api.md#delete_priority_class) | **DELETE** /apis/scheduling.k8s.io/v1/priorityclasses/{name} | 
*SchedulingV1Api* | [**get_api_resources**](docs/SchedulingV1Api.md#get_api_resources) | **GET** /apis/scheduling.k8s.io/v1/ | 
*SchedulingV1Api* | [**list_priority_class**](docs/SchedulingV1Api.md#list_priority_class) | **GET** /apis/scheduling.k8s.io/v1/priorityclasses | 
*SchedulingV1Api* | [**patch_priority_class**](docs/SchedulingV1Api.md#patch_priority_class) | **PATCH** /apis/scheduling.k8s.io/v1/priorityclasses/{name} | 
*SchedulingV1Api* | [**read_priority_class**](docs/SchedulingV1Api.md#read_priority_class) | **GET** /apis/scheduling.k8s.io/v1/priorityclasses/{name} | 
*SchedulingV1Api* | [**replace_priority_class**](docs/SchedulingV1Api.md#replace_priority_class) | **PUT** /apis/scheduling.k8s.io/v1/priorityclasses/{name} | 
*SchedulingV1alpha1Api* | [**create_priority_class**](docs/SchedulingV1alpha1Api.md#create_priority_class) | **POST** /apis/scheduling.k8s.io/v1alpha1/priorityclasses | 
*SchedulingV1alpha1Api* | [**delete_collection_priority_class**](docs/SchedulingV1alpha1Api.md#delete_collection_priority_class) | **DELETE** /apis/scheduling.k8s.io/v1alpha1/priorityclasses | 
*SchedulingV1alpha1Api* | [**delete_priority_class**](docs/SchedulingV1alpha1Api.md#delete_priority_class) | **DELETE** /apis/scheduling.k8s.io/v1alpha1/priorityclasses/{name} | 
*SchedulingV1alpha1Api* | [**get_api_resources**](docs/SchedulingV1alpha1Api.md#get_api_resources) | **GET** /apis/scheduling.k8s.io/v1alpha1/ | 
*SchedulingV1alpha1Api* | [**list_priority_class**](docs/SchedulingV1alpha1Api.md#list_priority_class) | **GET** /apis/scheduling.k8s.io/v1alpha1/priorityclasses | 
*SchedulingV1alpha1Api* | [**patch_priority_class**](docs/SchedulingV1alpha1Api.md#patch_priority_class) | **PATCH** /apis/scheduling.k8s.io/v1alpha1/priorityclasses/{name} | 
*SchedulingV1alpha1Api* | [**read_priority_class**](docs/SchedulingV1alpha1Api.md#read_priority_class) | **GET** /apis/scheduling.k8s.io/v1alpha1/priorityclasses/{name} | 
*SchedulingV1alpha1Api* | [**replace_priority_class**](docs/SchedulingV1alpha1Api.md#replace_priority_class) | **PUT** /apis/scheduling.k8s.io/v1alpha1/priorityclasses/{name} | 
*StorageApi* | [**get_api_group**](docs/StorageApi.md#get_api_group) | **GET** /apis/storage.k8s.io/ | 
*StorageV1Api* | [**create_csi_driver**](docs/StorageV1Api.md#create_csi_driver) | **POST** /apis/storage.k8s.io/v1/csidrivers | 
*StorageV1Api* | [**create_csi_node**](docs/StorageV1Api.md#create_csi_node) | **POST** /apis/storage.k8s.io/v1/csinodes | 
*StorageV1Api* | [**create_storage_class**](docs/StorageV1Api.md#create_storage_class) | **POST** /apis/storage.k8s.io/v1/storageclasses | 
*StorageV1Api* | [**create_volume_attachment**](docs/StorageV1Api.md#create_volume_attachment) | **POST** /apis/storage.k8s.io/v1/volumeattachments | 
*StorageV1Api* | [**delete_collection_csi_driver**](docs/StorageV1Api.md#delete_collection_csi_driver) | **DELETE** /apis/storage.k8s.io/v1/csidrivers | 
*StorageV1Api* | [**delete_collection_csi_node**](docs/StorageV1Api.md#delete_collection_csi_node) | **DELETE** /apis/storage.k8s.io/v1/csinodes | 
*StorageV1Api* | [**delete_collection_storage_class**](docs/StorageV1Api.md#delete_collection_storage_class) | **DELETE** /apis/storage.k8s.io/v1/storageclasses | 
*StorageV1Api* | [**delete_collection_volume_attachment**](docs/StorageV1Api.md#delete_collection_volume_attachment) | **DELETE** /apis/storage.k8s.io/v1/volumeattachments | 
*StorageV1Api* | [**delete_csi_driver**](docs/StorageV1Api.md#delete_csi_driver) | **DELETE** /apis/storage.k8s.io/v1/csidrivers/{name} | 
*StorageV1Api* | [**delete_csi_node**](docs/StorageV1Api.md#delete_csi_node) | **DELETE** /apis/storage.k8s.io/v1/csinodes/{name} | 
*StorageV1Api* | [**delete_storage_class**](docs/StorageV1Api.md#delete_storage_class) | **DELETE** /apis/storage.k8s.io/v1/storageclasses/{name} | 
*StorageV1Api* | [**delete_volume_attachment**](docs/StorageV1Api.md#delete_volume_attachment) | **DELETE** /apis/storage.k8s.io/v1/volumeattachments/{name} | 
*StorageV1Api* | [**get_api_resources**](docs/StorageV1Api.md#get_api_resources) | **GET** /apis/storage.k8s.io/v1/ | 
*StorageV1Api* | [**list_csi_driver**](docs/StorageV1Api.md#list_csi_driver) | **GET** /apis/storage.k8s.io/v1/csidrivers | 
*StorageV1Api* | [**list_csi_node**](docs/StorageV1Api.md#list_csi_node) | **GET** /apis/storage.k8s.io/v1/csinodes | 
*StorageV1Api* | [**list_storage_class**](docs/StorageV1Api.md#list_storage_class) | **GET** /apis/storage.k8s.io/v1/storageclasses | 
*StorageV1Api* | [**list_volume_attachment**](docs/StorageV1Api.md#list_volume_attachment) | **GET** /apis/storage.k8s.io/v1/volumeattachments | 
*StorageV1Api* | [**patch_csi_driver**](docs/StorageV1Api.md#patch_csi_driver) | **PATCH** /apis/storage.k8s.io/v1/csidrivers/{name} | 
*StorageV1Api* | [**patch_csi_node**](docs/StorageV1Api.md#patch_csi_node) | **PATCH** /apis/storage.k8s.io/v1/csinodes/{name} | 
*StorageV1Api* | [**patch_storage_class**](docs/StorageV1Api.md#patch_storage_class) | **PATCH** /apis/storage.k8s.io/v1/storageclasses/{name} | 
*StorageV1Api* | [**patch_volume_attachment**](docs/StorageV1Api.md#patch_volume_attachment) | **PATCH** /apis/storage.k8s.io/v1/volumeattachments/{name} | 
*StorageV1Api* | [**patch_volume_attachment_status**](docs/StorageV1Api.md#patch_volume_attachment_status) | **PATCH** /apis/storage.k8s.io/v1/volumeattachments/{name}/status | 
*StorageV1Api* | [**read_csi_driver**](docs/StorageV1Api.md#read_csi_driver) | **GET** /apis/storage.k8s.io/v1/csidrivers/{name} | 
*StorageV1Api* | [**read_csi_node**](docs/StorageV1Api.md#read_csi_node) | **GET** /apis/storage.k8s.io/v1/csinodes/{name} | 
*StorageV1Api* | [**read_storage_class**](docs/StorageV1Api.md#read_storage_class) | **GET** /apis/storage.k8s.io/v1/storageclasses/{name} | 
*StorageV1Api* | [**read_volume_attachment**](docs/StorageV1Api.md#read_volume_attachment) | **GET** /apis/storage.k8s.io/v1/volumeattachments/{name} | 
*StorageV1Api* | [**read_volume_attachment_status**](docs/StorageV1Api.md#read_volume_attachment_status) | **GET** /apis/storage.k8s.io/v1/volumeattachments/{name}/status | 
*StorageV1Api* | [**replace_csi_driver**](docs/StorageV1Api.md#replace_csi_driver) | **PUT** /apis/storage.k8s.io/v1/csidrivers/{name} | 
*StorageV1Api* | [**replace_csi_node**](docs/StorageV1Api.md#replace_csi_node) | **PUT** /apis/storage.k8s.io/v1/csinodes/{name} | 
*StorageV1Api* | [**replace_storage_class**](docs/StorageV1Api.md#replace_storage_class) | **PUT** /apis/storage.k8s.io/v1/storageclasses/{name} | 
*StorageV1Api* | [**replace_volume_attachment**](docs/StorageV1Api.md#replace_volume_attachment) | **PUT** /apis/storage.k8s.io/v1/volumeattachments/{name} | 
*StorageV1Api* | [**replace_volume_attachment_status**](docs/StorageV1Api.md#replace_volume_attachment_status) | **PUT** /apis/storage.k8s.io/v1/volumeattachments/{name}/status | 
*StorageV1alpha1Api* | [**create_namespaced_csi_storage_capacity**](docs/StorageV1alpha1Api.md#create_namespaced_csi_storage_capacity) | **POST** /apis/storage.k8s.io/v1alpha1/namespaces/{namespace}/csistoragecapacities | 
*StorageV1alpha1Api* | [**create_volume_attachment**](docs/StorageV1alpha1Api.md#create_volume_attachment) | **POST** /apis/storage.k8s.io/v1alpha1/volumeattachments | 
*StorageV1alpha1Api* | [**delete_collection_namespaced_csi_storage_capacity**](docs/StorageV1alpha1Api.md#delete_collection_namespaced_csi_storage_capacity) | **DELETE** /apis/storage.k8s.io/v1alpha1/namespaces/{namespace}/csistoragecapacities | 
*StorageV1alpha1Api* | [**delete_collection_volume_attachment**](docs/StorageV1alpha1Api.md#delete_collection_volume_attachment) | **DELETE** /apis/storage.k8s.io/v1alpha1/volumeattachments | 
*StorageV1alpha1Api* | [**delete_namespaced_csi_storage_capacity**](docs/StorageV1alpha1Api.md#delete_namespaced_csi_storage_capacity) | **DELETE** /apis/storage.k8s.io/v1alpha1/namespaces/{namespace}/csistoragecapacities/{name} | 
*StorageV1alpha1Api* | [**delete_volume_attachment**](docs/StorageV1alpha1Api.md#delete_volume_attachment) | **DELETE** /apis/storage.k8s.io/v1alpha1/volumeattachments/{name} | 
*StorageV1alpha1Api* | [**get_api_resources**](docs/StorageV1alpha1Api.md#get_api_resources) | **GET** /apis/storage.k8s.io/v1alpha1/ | 
*StorageV1alpha1Api* | [**list_csi_storage_capacity_for_all_namespaces**](docs/StorageV1alpha1Api.md#list_csi_storage_capacity_for_all_namespaces) | **GET** /apis/storage.k8s.io/v1alpha1/csistoragecapacities | 
*StorageV1alpha1Api* | [**list_namespaced_csi_storage_capacity**](docs/StorageV1alpha1Api.md#list_namespaced_csi_storage_capacity) | **GET** /apis/storage.k8s.io/v1alpha1/namespaces/{namespace}/csistoragecapacities | 
*StorageV1alpha1Api* | [**list_volume_attachment**](docs/StorageV1alpha1Api.md#list_volume_attachment) | **GET** /apis/storage.k8s.io/v1alpha1/volumeattachments | 
*StorageV1alpha1Api* | [**patch_namespaced_csi_storage_capacity**](docs/StorageV1alpha1Api.md#patch_namespaced_csi_storage_capacity) | **PATCH** /apis/storage.k8s.io/v1alpha1/namespaces/{namespace}/csistoragecapacities/{name} | 
*StorageV1alpha1Api* | [**patch_volume_attachment**](docs/StorageV1alpha1Api.md#patch_volume_attachment) | **PATCH** /apis/storage.k8s.io/v1alpha1/volumeattachments/{name} | 
*StorageV1alpha1Api* | [**read_namespaced_csi_storage_capacity**](docs/StorageV1alpha1Api.md#read_namespaced_csi_storage_capacity) | **GET** /apis/storage.k8s.io/v1alpha1/namespaces/{namespace}/csistoragecapacities/{name} | 
*StorageV1alpha1Api* | [**read_volume_attachment**](docs/StorageV1alpha1Api.md#read_volume_attachment) | **GET** /apis/storage.k8s.io/v1alpha1/volumeattachments/{name} | 
*StorageV1alpha1Api* | [**replace_namespaced_csi_storage_capacity**](docs/StorageV1alpha1Api.md#replace_namespaced_csi_storage_capacity) | **PUT** /apis/storage.k8s.io/v1alpha1/namespaces/{namespace}/csistoragecapacities/{name} | 
*StorageV1alpha1Api* | [**replace_volume_attachment**](docs/StorageV1alpha1Api.md#replace_volume_attachment) | **PUT** /apis/storage.k8s.io/v1alpha1/volumeattachments/{name} | 
*StorageV1beta1Api* | [**create_namespaced_csi_storage_capacity**](docs/StorageV1beta1Api.md#create_namespaced_csi_storage_capacity) | **POST** /apis/storage.k8s.io/v1beta1/namespaces/{namespace}/csistoragecapacities | 
*StorageV1beta1Api* | [**delete_collection_namespaced_csi_storage_capacity**](docs/StorageV1beta1Api.md#delete_collection_namespaced_csi_storage_capacity) | **DELETE** /apis/storage.k8s.io/v1beta1/namespaces/{namespace}/csistoragecapacities | 
*StorageV1beta1Api* | [**delete_namespaced_csi_storage_capacity**](docs/StorageV1beta1Api.md#delete_namespaced_csi_storage_capacity) | **DELETE** /apis/storage.k8s.io/v1beta1/namespaces/{namespace}/csistoragecapacities/{name} | 
*StorageV1beta1Api* | [**get_api_resources**](docs/StorageV1beta1Api.md#get_api_resources) | **GET** /apis/storage.k8s.io/v1beta1/ | 
*StorageV1beta1Api* | [**list_csi_storage_capacity_for_all_namespaces**](docs/StorageV1beta1Api.md#list_csi_storage_capacity_for_all_namespaces) | **GET** /apis/storage.k8s.io/v1beta1/csistoragecapacities | 
*StorageV1beta1Api* | [**list_namespaced_csi_storage_capacity**](docs/StorageV1beta1Api.md#list_namespaced_csi_storage_capacity) | **GET** /apis/storage.k8s.io/v1beta1/namespaces/{namespace}/csistoragecapacities | 
*StorageV1beta1Api* | [**patch_namespaced_csi_storage_capacity**](docs/StorageV1beta1Api.md#patch_namespaced_csi_storage_capacity) | **PATCH** /apis/storage.k8s.io/v1beta1/namespaces/{namespace}/csistoragecapacities/{name} | 
*StorageV1beta1Api* | [**read_namespaced_csi_storage_capacity**](docs/StorageV1beta1Api.md#read_namespaced_csi_storage_capacity) | **GET** /apis/storage.k8s.io/v1beta1/namespaces/{namespace}/csistoragecapacities/{name} | 
*StorageV1beta1Api* | [**replace_namespaced_csi_storage_capacity**](docs/StorageV1beta1Api.md#replace_namespaced_csi_storage_capacity) | **PUT** /apis/storage.k8s.io/v1beta1/namespaces/{namespace}/csistoragecapacities/{name} | 
*VersionApi* | [**get_code**](docs/VersionApi.md#get_code) | **GET** /version/ | 


## Documentation For Models

 - [AdmissionregistrationV1ServiceReference](docs/AdmissionregistrationV1ServiceReference.md)
 - [AdmissionregistrationV1WebhookClientConfig](docs/AdmissionregistrationV1WebhookClientConfig.md)
 - [ApiextensionsV1ServiceReference](docs/ApiextensionsV1ServiceReference.md)
 - [ApiextensionsV1WebhookClientConfig](docs/ApiextensionsV1WebhookClientConfig.md)
 - [ApiregistrationV1ServiceReference](docs/ApiregistrationV1ServiceReference.md)
 - [AuthenticationV1TokenRequest](docs/AuthenticationV1TokenRequest.md)
 - [CoreV1EndpointPort](docs/CoreV1EndpointPort.md)
 - [CoreV1Event](docs/CoreV1Event.md)
 - [CoreV1EventList](docs/CoreV1EventList.md)
 - [CoreV1EventSeries](docs/CoreV1EventSeries.md)
 - [DiscoveryV1EndpointPort](docs/DiscoveryV1EndpointPort.md)
 - [EventsV1Event](docs/EventsV1Event.md)
 - [EventsV1EventList](docs/EventsV1EventList.md)
 - [EventsV1EventSeries](docs/EventsV1EventSeries.md)
 - [StorageV1TokenRequest](docs/StorageV1TokenRequest.md)
 - [V1APIGroup](docs/V1APIGroup.md)
 - [V1APIGroupList](docs/V1APIGroupList.md)
 - [V1APIResource](docs/V1APIResource.md)
 - [V1APIResourceList](docs/V1APIResourceList.md)
 - [V1APIService](docs/V1APIService.md)
 - [V1APIServiceCondition](docs/V1APIServiceCondition.md)
 - [V1APIServiceList](docs/V1APIServiceList.md)
 - [V1APIServiceSpec](docs/V1APIServiceSpec.md)
 - [V1APIServiceStatus](docs/V1APIServiceStatus.md)
 - [V1APIVersions](docs/V1APIVersions.md)
 - [V1AWSElasticBlockStoreVolumeSource](docs/V1AWSElasticBlockStoreVolumeSource.md)
 - [V1Affinity](docs/V1Affinity.md)
 - [V1AggregationRule](docs/V1AggregationRule.md)
 - [V1AttachedVolume](docs/V1AttachedVolume.md)
 - [V1AzureDiskVolumeSource](docs/V1AzureDiskVolumeSource.md)
 - [V1AzureFilePersistentVolumeSource](docs/V1AzureFilePersistentVolumeSource.md)
 - [V1AzureFileVolumeSource](docs/V1AzureFileVolumeSource.md)
 - [V1Binding](docs/V1Binding.md)
 - [V1BoundObjectReference](docs/V1BoundObjectReference.md)
 - [V1CSIDriver](docs/V1CSIDriver.md)
 - [V1CSIDriverList](docs/V1CSIDriverList.md)
 - [V1CSIDriverSpec](docs/V1CSIDriverSpec.md)
 - [V1CSINode](docs/V1CSINode.md)
 - [V1CSINodeDriver](docs/V1CSINodeDriver.md)
 - [V1CSINodeList](docs/V1CSINodeList.md)
 - [V1CSINodeSpec](docs/V1CSINodeSpec.md)
 - [V1CSIPersistentVolumeSource](docs/V1CSIPersistentVolumeSource.md)
 - [V1CSIVolumeSource](docs/V1CSIVolumeSource.md)
 - [V1Capabilities](docs/V1Capabilities.md)
 - [V1CephFSPersistentVolumeSource](docs/V1CephFSPersistentVolumeSource.md)
 - [V1CephFSVolumeSource](docs/V1CephFSVolumeSource.md)
 - [V1CertificateSigningRequest](docs/V1CertificateSigningRequest.md)
 - [V1CertificateSigningRequestCondition](docs/V1CertificateSigningRequestCondition.md)
 - [V1CertificateSigningRequestList](docs/V1CertificateSigningRequestList.md)
 - [V1CertificateSigningRequestSpec](docs/V1CertificateSigningRequestSpec.md)
 - [V1CertificateSigningRequestStatus](docs/V1CertificateSigningRequestStatus.md)
 - [V1CinderPersistentVolumeSource](docs/V1CinderPersistentVolumeSource.md)
 - [V1CinderVolumeSource](docs/V1CinderVolumeSource.md)
 - [V1ClientIPConfig](docs/V1ClientIPConfig.md)
 - [V1ClusterRole](docs/V1ClusterRole.md)
 - [V1ClusterRoleBinding](docs/V1ClusterRoleBinding.md)
 - [V1ClusterRoleBindingList](docs/V1ClusterRoleBindingList.md)
 - [V1ClusterRoleList](docs/V1ClusterRoleList.md)
 - [V1ComponentCondition](docs/V1ComponentCondition.md)
 - [V1ComponentStatus](docs/V1ComponentStatus.md)
 - [V1ComponentStatusList](docs/V1ComponentStatusList.md)
 - [V1Condition](docs/V1Condition.md)
 - [V1ConfigMap](docs/V1ConfigMap.md)
 - [V1ConfigMapEnvSource](docs/V1ConfigMapEnvSource.md)
 - [V1ConfigMapKeySelector](docs/V1ConfigMapKeySelector.md)
 - [V1ConfigMapList](docs/V1ConfigMapList.md)
 - [V1ConfigMapNodeConfigSource](docs/V1ConfigMapNodeConfigSource.md)
 - [V1ConfigMapProjection](docs/V1ConfigMapProjection.md)
 - [V1ConfigMapVolumeSource](docs/V1ConfigMapVolumeSource.md)
 - [V1Container](docs/V1Container.md)
 - [V1ContainerImage](docs/V1ContainerImage.md)
 - [V1ContainerPort](docs/V1ContainerPort.md)
 - [V1ContainerState](docs/V1ContainerState.md)
 - [V1ContainerStateRunning](docs/V1ContainerStateRunning.md)
 - [V1ContainerStateTerminated](docs/V1ContainerStateTerminated.md)
 - [V1ContainerStateWaiting](docs/V1ContainerStateWaiting.md)
 - [V1ContainerStatus](docs/V1ContainerStatus.md)
 - [V1ControllerRevision](docs/V1ControllerRevision.md)
 - [V1ControllerRevisionList](docs/V1ControllerRevisionList.md)
 - [V1CronJob](docs/V1CronJob.md)
 - [V1CronJobList](docs/V1CronJobList.md)
 - [V1CronJobSpec](docs/V1CronJobSpec.md)
 - [V1CronJobStatus](docs/V1CronJobStatus.md)
 - [V1CrossVersionObjectReference](docs/V1CrossVersionObjectReference.md)
 - [V1CustomResourceColumnDefinition](docs/V1CustomResourceColumnDefinition.md)
 - [V1CustomResourceConversion](docs/V1CustomResourceConversion.md)
 - [V1CustomResourceDefinition](docs/V1CustomResourceDefinition.md)
 - [V1CustomResourceDefinitionCondition](docs/V1CustomResourceDefinitionCondition.md)
 - [V1CustomResourceDefinitionList](docs/V1CustomResourceDefinitionList.md)
 - [V1CustomResourceDefinitionNames](docs/V1CustomResourceDefinitionNames.md)
 - [V1CustomResourceDefinitionSpec](docs/V1CustomResourceDefinitionSpec.md)
 - [V1CustomResourceDefinitionStatus](docs/V1CustomResourceDefinitionStatus.md)
 - [V1CustomResourceDefinitionVersion](docs/V1CustomResourceDefinitionVersion.md)
 - [V1CustomResourceSubresourceScale](docs/V1CustomResourceSubresourceScale.md)
 - [V1CustomResourceSubresources](docs/V1CustomResourceSubresources.md)
 - [V1CustomResourceValidation](docs/V1CustomResourceValidation.md)
 - [V1DaemonEndpoint](docs/V1DaemonEndpoint.md)
 - [V1DaemonSet](docs/V1DaemonSet.md)
 - [V1DaemonSetCondition](docs/V1DaemonSetCondition.md)
 - [V1DaemonSetList](docs/V1DaemonSetList.md)
 - [V1DaemonSetSpec](docs/V1DaemonSetSpec.md)
 - [V1DaemonSetStatus](docs/V1DaemonSetStatus.md)
 - [V1DaemonSetUpdateStrategy](docs/V1DaemonSetUpdateStrategy.md)
 - [V1DeleteOptions](docs/V1DeleteOptions.md)
 - [V1Deployment](docs/V1Deployment.md)
 - [V1DeploymentCondition](docs/V1DeploymentCondition.md)
 - [V1DeploymentList](docs/V1DeploymentList.md)
 - [V1DeploymentSpec](docs/V1DeploymentSpec.md)
 - [V1DeploymentStatus](docs/V1DeploymentStatus.md)
 - [V1DeploymentStrategy](docs/V1DeploymentStrategy.md)
 - [V1DownwardAPIProjection](docs/V1DownwardAPIProjection.md)
 - [V1DownwardAPIVolumeFile](docs/V1DownwardAPIVolumeFile.md)
 - [V1DownwardAPIVolumeSource](docs/V1DownwardAPIVolumeSource.md)
 - [V1EmptyDirVolumeSource](docs/V1EmptyDirVolumeSource.md)
 - [V1Endpoint](docs/V1Endpoint.md)
 - [V1EndpointAddress](docs/V1EndpointAddress.md)
 - [V1EndpointConditions](docs/V1EndpointConditions.md)
 - [V1EndpointHints](docs/V1EndpointHints.md)
 - [V1EndpointSlice](docs/V1EndpointSlice.md)
 - [V1EndpointSliceList](docs/V1EndpointSliceList.md)
 - [V1EndpointSubset](docs/V1EndpointSubset.md)
 - [V1Endpoints](docs/V1Endpoints.md)
 - [V1EndpointsList](docs/V1EndpointsList.md)
 - [V1EnvFromSource](docs/V1EnvFromSource.md)
 - [V1EnvVar](docs/V1EnvVar.md)
 - [V1EnvVarSource](docs/V1EnvVarSource.md)
 - [V1EphemeralContainer](docs/V1EphemeralContainer.md)
 - [V1EphemeralVolumeSource](docs/V1EphemeralVolumeSource.md)
 - [V1EventSource](docs/V1EventSource.md)
 - [V1Eviction](docs/V1Eviction.md)
 - [V1ExecAction](docs/V1ExecAction.md)
 - [V1ExternalDocumentation](docs/V1ExternalDocumentation.md)
 - [V1FCVolumeSource](docs/V1FCVolumeSource.md)
 - [V1FlexPersistentVolumeSource](docs/V1FlexPersistentVolumeSource.md)
 - [V1FlexVolumeSource](docs/V1FlexVolumeSource.md)
 - [V1FlockerVolumeSource](docs/V1FlockerVolumeSource.md)
 - [V1ForZone](docs/V1ForZone.md)
 - [V1GCEPersistentDiskVolumeSource](docs/V1GCEPersistentDiskVolumeSource.md)
 - [V1GitRepoVolumeSource](docs/V1GitRepoVolumeSource.md)
 - [V1GlusterfsPersistentVolumeSource](docs/V1GlusterfsPersistentVolumeSource.md)
 - [V1GlusterfsVolumeSource](docs/V1GlusterfsVolumeSource.md)
 - [V1GroupVersionForDiscovery](docs/V1GroupVersionForDiscovery.md)
 - [V1HTTPGetAction](docs/V1HTTPGetAction.md)
 - [V1HTTPHeader](docs/V1HTTPHeader.md)
 - [V1HTTPIngressPath](docs/V1HTTPIngressPath.md)
 - [V1HTTPIngressRuleValue](docs/V1HTTPIngressRuleValue.md)
 - [V1Handler](docs/V1Handler.md)
 - [V1HorizontalPodAutoscaler](docs/V1HorizontalPodAutoscaler.md)
 - [V1HorizontalPodAutoscalerList](docs/V1HorizontalPodAutoscalerList.md)
 - [V1HorizontalPodAutoscalerSpec](docs/V1HorizontalPodAutoscalerSpec.md)
 - [V1HorizontalPodAutoscalerStatus](docs/V1HorizontalPodAutoscalerStatus.md)
 - [V1HostAlias](docs/V1HostAlias.md)
 - [V1HostPathVolumeSource](docs/V1HostPathVolumeSource.md)
 - [V1IPBlock](docs/V1IPBlock.md)
 - [V1ISCSIPersistentVolumeSource](docs/V1ISCSIPersistentVolumeSource.md)
 - [V1ISCSIVolumeSource](docs/V1ISCSIVolumeSource.md)
 - [V1Ingress](docs/V1Ingress.md)
 - [V1IngressBackend](docs/V1IngressBackend.md)
 - [V1IngressClass](docs/V1IngressClass.md)
 - [V1IngressClassList](docs/V1IngressClassList.md)
 - [V1IngressClassParametersReference](docs/V1IngressClassParametersReference.md)
 - [V1IngressClassSpec](docs/V1IngressClassSpec.md)
 - [V1IngressList](docs/V1IngressList.md)
 - [V1IngressRule](docs/V1IngressRule.md)
 - [V1IngressServiceBackend](docs/V1IngressServiceBackend.md)
 - [V1IngressSpec](docs/V1IngressSpec.md)
 - [V1IngressStatus](docs/V1IngressStatus.md)
 - [V1IngressTLS](docs/V1IngressTLS.md)
 - [V1JSONSchemaProps](docs/V1JSONSchemaProps.md)
 - [V1Job](docs/V1Job.md)
 - [V1JobCondition](docs/V1JobCondition.md)
 - [V1JobList](docs/V1JobList.md)
 - [V1JobSpec](docs/V1JobSpec.md)
 - [V1JobStatus](docs/V1JobStatus.md)
 - [V1JobTemplateSpec](docs/V1JobTemplateSpec.md)
 - [V1KeyToPath](docs/V1KeyToPath.md)
 - [V1LabelSelector](docs/V1LabelSelector.md)
 - [V1LabelSelectorRequirement](docs/V1LabelSelectorRequirement.md)
 - [V1Lease](docs/V1Lease.md)
 - [V1LeaseList](docs/V1LeaseList.md)
 - [V1LeaseSpec](docs/V1LeaseSpec.md)
 - [V1Lifecycle](docs/V1Lifecycle.md)
 - [V1LimitRange](docs/V1LimitRange.md)
 - [V1LimitRangeItem](docs/V1LimitRangeItem.md)
 - [V1LimitRangeList](docs/V1LimitRangeList.md)
 - [V1LimitRangeSpec](docs/V1LimitRangeSpec.md)
 - [V1ListMeta](docs/V1ListMeta.md)
 - [V1LoadBalancerIngress](docs/V1LoadBalancerIngress.md)
 - [V1LoadBalancerStatus](docs/V1LoadBalancerStatus.md)
 - [V1LocalObjectReference](docs/V1LocalObjectReference.md)
 - [V1LocalSubjectAccessReview](docs/V1LocalSubjectAccessReview.md)
 - [V1LocalVolumeSource](docs/V1LocalVolumeSource.md)
 - [V1ManagedFieldsEntry](docs/V1ManagedFieldsEntry.md)
 - [V1MutatingWebhook](docs/V1MutatingWebhook.md)
 - [V1MutatingWebhookConfiguration](docs/V1MutatingWebhookConfiguration.md)
 - [V1MutatingWebhookConfigurationList](docs/V1MutatingWebhookConfigurationList.md)
 - [V1NFSVolumeSource](docs/V1NFSVolumeSource.md)
 - [V1Namespace](docs/V1Namespace.md)
 - [V1NamespaceCondition](docs/V1NamespaceCondition.md)
 - [V1NamespaceList](docs/V1NamespaceList.md)
 - [V1NamespaceSpec](docs/V1NamespaceSpec.md)
 - [V1NamespaceStatus](docs/V1NamespaceStatus.md)
 - [V1NetworkPolicy](docs/V1NetworkPolicy.md)
 - [V1NetworkPolicyEgressRule](docs/V1NetworkPolicyEgressRule.md)
 - [V1NetworkPolicyIngressRule](docs/V1NetworkPolicyIngressRule.md)
 - [V1NetworkPolicyList](docs/V1NetworkPolicyList.md)
 - [V1NetworkPolicyPeer](docs/V1NetworkPolicyPeer.md)
 - [V1NetworkPolicyPort](docs/V1NetworkPolicyPort.md)
 - [V1NetworkPolicySpec](docs/V1NetworkPolicySpec.md)
 - [V1Node](docs/V1Node.md)
 - [V1NodeAddress](docs/V1NodeAddress.md)
 - [V1NodeAffinity](docs/V1NodeAffinity.md)
 - [V1NodeCondition](docs/V1NodeCondition.md)
 - [V1NodeConfigSource](docs/V1NodeConfigSource.md)
 - [V1NodeConfigStatus](docs/V1NodeConfigStatus.md)
 - [V1NodeDaemonEndpoints](docs/V1NodeDaemonEndpoints.md)
 - [V1NodeList](docs/V1NodeList.md)
 - [V1NodeSelector](docs/V1NodeSelector.md)
 - [V1NodeSelectorRequirement](docs/V1NodeSelectorRequirement.md)
 - [V1NodeSelectorTerm](docs/V1NodeSelectorTerm.md)
 - [V1NodeSpec](docs/V1NodeSpec.md)
 - [V1NodeStatus](docs/V1NodeStatus.md)
 - [V1NodeSystemInfo](docs/V1NodeSystemInfo.md)
 - [V1NonResourceAttributes](docs/V1NonResourceAttributes.md)
 - [V1NonResourceRule](docs/V1NonResourceRule.md)
 - [V1ObjectFieldSelector](docs/V1ObjectFieldSelector.md)
 - [V1ObjectMeta](docs/V1ObjectMeta.md)
 - [V1ObjectReference](docs/V1ObjectReference.md)
 - [V1Overhead](docs/V1Overhead.md)
 - [V1OwnerReference](docs/V1OwnerReference.md)
 - [V1PersistentVolume](docs/V1PersistentVolume.md)
 - [V1PersistentVolumeClaim](docs/V1PersistentVolumeClaim.md)
 - [V1PersistentVolumeClaimCondition](docs/V1PersistentVolumeClaimCondition.md)
 - [V1PersistentVolumeClaimList](docs/V1PersistentVolumeClaimList.md)
 - [V1PersistentVolumeClaimSpec](docs/V1PersistentVolumeClaimSpec.md)
 - [V1PersistentVolumeClaimStatus](docs/V1PersistentVolumeClaimStatus.md)
 - [V1PersistentVolumeClaimTemplate](docs/V1PersistentVolumeClaimTemplate.md)
 - [V1PersistentVolumeClaimVolumeSource](docs/V1PersistentVolumeClaimVolumeSource.md)
 - [V1PersistentVolumeList](docs/V1PersistentVolumeList.md)
 - [V1PersistentVolumeSpec](docs/V1PersistentVolumeSpec.md)
 - [V1PersistentVolumeStatus](docs/V1PersistentVolumeStatus.md)
 - [V1PhotonPersistentDiskVolumeSource](docs/V1PhotonPersistentDiskVolumeSource.md)
 - [V1Pod](docs/V1Pod.md)
 - [V1PodAffinity](docs/V1PodAffinity.md)
 - [V1PodAffinityTerm](docs/V1PodAffinityTerm.md)
 - [V1PodAntiAffinity](docs/V1PodAntiAffinity.md)
 - [V1PodCondition](docs/V1PodCondition.md)
 - [V1PodDNSConfig](docs/V1PodDNSConfig.md)
 - [V1PodDNSConfigOption](docs/V1PodDNSConfigOption.md)
 - [V1PodDisruptionBudget](docs/V1PodDisruptionBudget.md)
 - [V1PodDisruptionBudgetList](docs/V1PodDisruptionBudgetList.md)
 - [V1PodDisruptionBudgetSpec](docs/V1PodDisruptionBudgetSpec.md)
 - [V1PodDisruptionBudgetStatus](docs/V1PodDisruptionBudgetStatus.md)
 - [V1PodIP](docs/V1PodIP.md)
 - [V1PodList](docs/V1PodList.md)
 - [V1PodReadinessGate](docs/V1PodReadinessGate.md)
 - [V1PodSecurityContext](docs/V1PodSecurityContext.md)
 - [V1PodSpec](docs/V1PodSpec.md)
 - [V1PodStatus](docs/V1PodStatus.md)
 - [V1PodTemplate](docs/V1PodTemplate.md)
 - [V1PodTemplateList](docs/V1PodTemplateList.md)
 - [V1PodTemplateSpec](docs/V1PodTemplateSpec.md)
 - [V1PolicyRule](docs/V1PolicyRule.md)
 - [V1PortStatus](docs/V1PortStatus.md)
 - [V1PortworxVolumeSource](docs/V1PortworxVolumeSource.md)
 - [V1Preconditions](docs/V1Preconditions.md)
 - [V1PreferredSchedulingTerm](docs/V1PreferredSchedulingTerm.md)
 - [V1PriorityClass](docs/V1PriorityClass.md)
 - [V1PriorityClassList](docs/V1PriorityClassList.md)
 - [V1Probe](docs/V1Probe.md)
 - [V1ProjectedVolumeSource](docs/V1ProjectedVolumeSource.md)
 - [V1QuobyteVolumeSource](docs/V1QuobyteVolumeSource.md)
 - [V1RBDPersistentVolumeSource](docs/V1RBDPersistentVolumeSource.md)
 - [V1RBDVolumeSource](docs/V1RBDVolumeSource.md)
 - [V1ReplicaSet](docs/V1ReplicaSet.md)
 - [V1ReplicaSetCondition](docs/V1ReplicaSetCondition.md)
 - [V1ReplicaSetList](docs/V1ReplicaSetList.md)
 - [V1ReplicaSetSpec](docs/V1ReplicaSetSpec.md)
 - [V1ReplicaSetStatus](docs/V1ReplicaSetStatus.md)
 - [V1ReplicationController](docs/V1ReplicationController.md)
 - [V1ReplicationControllerCondition](docs/V1ReplicationControllerCondition.md)
 - [V1ReplicationControllerList](docs/V1ReplicationControllerList.md)
 - [V1ReplicationControllerSpec](docs/V1ReplicationControllerSpec.md)
 - [V1ReplicationControllerStatus](docs/V1ReplicationControllerStatus.md)
 - [V1ResourceAttributes](docs/V1ResourceAttributes.md)
 - [V1ResourceFieldSelector](docs/V1ResourceFieldSelector.md)
 - [V1ResourceQuota](docs/V1ResourceQuota.md)
 - [V1ResourceQuotaList](docs/V1ResourceQuotaList.md)
 - [V1ResourceQuotaSpec](docs/V1ResourceQuotaSpec.md)
 - [V1ResourceQuotaStatus](docs/V1ResourceQuotaStatus.md)
 - [V1ResourceRequirements](docs/V1ResourceRequirements.md)
 - [V1ResourceRule](docs/V1ResourceRule.md)
 - [V1Role](docs/V1Role.md)
 - [V1RoleBinding](docs/V1RoleBinding.md)
 - [V1RoleBindingList](docs/V1RoleBindingList.md)
 - [V1RoleList](docs/V1RoleList.md)
 - [V1RoleRef](docs/V1RoleRef.md)
 - [V1RollingUpdateDaemonSet](docs/V1RollingUpdateDaemonSet.md)
 - [V1RollingUpdateDeployment](docs/V1RollingUpdateDeployment.md)
 - [V1RollingUpdateStatefulSetStrategy](docs/V1RollingUpdateStatefulSetStrategy.md)
 - [V1RuleWithOperations](docs/V1RuleWithOperations.md)
 - [V1RuntimeClass](docs/V1RuntimeClass.md)
 - [V1RuntimeClassList](docs/V1RuntimeClassList.md)
 - [V1SELinuxOptions](docs/V1SELinuxOptions.md)
 - [V1Scale](docs/V1Scale.md)
 - [V1ScaleIOPersistentVolumeSource](docs/V1ScaleIOPersistentVolumeSource.md)
 - [V1ScaleIOVolumeSource](docs/V1ScaleIOVolumeSource.md)
 - [V1ScaleSpec](docs/V1ScaleSpec.md)
 - [V1ScaleStatus](docs/V1ScaleStatus.md)
 - [V1Scheduling](docs/V1Scheduling.md)
 - [V1ScopeSelector](docs/V1ScopeSelector.md)
 - [V1ScopedResourceSelectorRequirement](docs/V1ScopedResourceSelectorRequirement.md)
 - [V1SeccompProfile](docs/V1SeccompProfile.md)
 - [V1Secret](docs/V1Secret.md)
 - [V1SecretEnvSource](docs/V1SecretEnvSource.md)
 - [V1SecretKeySelector](docs/V1SecretKeySelector.md)
 - [V1SecretList](docs/V1SecretList.md)
 - [V1SecretProjection](docs/V1SecretProjection.md)
 - [V1SecretReference](docs/V1SecretReference.md)
 - [V1SecretVolumeSource](docs/V1SecretVolumeSource.md)
 - [V1SecurityContext](docs/V1SecurityContext.md)
 - [V1SelfSubjectAccessReview](docs/V1SelfSubjectAccessReview.md)
 - [V1SelfSubjectAccessReviewSpec](docs/V1SelfSubjectAccessReviewSpec.md)
 - [V1SelfSubjectRulesReview](docs/V1SelfSubjectRulesReview.md)
 - [V1SelfSubjectRulesReviewSpec](docs/V1SelfSubjectRulesReviewSpec.md)
 - [V1ServerAddressByClientCIDR](docs/V1ServerAddressByClientCIDR.md)
 - [V1Service](docs/V1Service.md)
 - [V1ServiceAccount](docs/V1ServiceAccount.md)
 - [V1ServiceAccountList](docs/V1ServiceAccountList.md)
 - [V1ServiceAccountTokenProjection](docs/V1ServiceAccountTokenProjection.md)
 - [V1ServiceBackendPort](docs/V1ServiceBackendPort.md)
 - [V1ServiceList](docs/V1ServiceList.md)
 - [V1ServicePort](docs/V1ServicePort.md)
 - [V1ServiceSpec](docs/V1ServiceSpec.md)
 - [V1ServiceStatus](docs/V1ServiceStatus.md)
 - [V1SessionAffinityConfig](docs/V1SessionAffinityConfig.md)
 - [V1StatefulSet](docs/V1StatefulSet.md)
 - [V1StatefulSetCondition](docs/V1StatefulSetCondition.md)
 - [V1StatefulSetList](docs/V1StatefulSetList.md)
 - [V1StatefulSetSpec](docs/V1StatefulSetSpec.md)
 - [V1StatefulSetStatus](docs/V1StatefulSetStatus.md)
 - [V1StatefulSetUpdateStrategy](docs/V1StatefulSetUpdateStrategy.md)
 - [V1Status](docs/V1Status.md)
 - [V1StatusCause](docs/V1StatusCause.md)
 - [V1StatusDetails](docs/V1StatusDetails.md)
 - [V1StorageClass](docs/V1StorageClass.md)
 - [V1StorageClassList](docs/V1StorageClassList.md)
 - [V1StorageOSPersistentVolumeSource](docs/V1StorageOSPersistentVolumeSource.md)
 - [V1StorageOSVolumeSource](docs/V1StorageOSVolumeSource.md)
 - [V1Subject](docs/V1Subject.md)
 - [V1SubjectAccessReview](docs/V1SubjectAccessReview.md)
 - [V1SubjectAccessReviewSpec](docs/V1SubjectAccessReviewSpec.md)
 - [V1SubjectAccessReviewStatus](docs/V1SubjectAccessReviewStatus.md)
 - [V1SubjectRulesReviewStatus](docs/V1SubjectRulesReviewStatus.md)
 - [V1Sysctl](docs/V1Sysctl.md)
 - [V1TCPSocketAction](docs/V1TCPSocketAction.md)
 - [V1Taint](docs/V1Taint.md)
 - [V1TokenRequestSpec](docs/V1TokenRequestSpec.md)
 - [V1TokenRequestStatus](docs/V1TokenRequestStatus.md)
 - [V1TokenReview](docs/V1TokenReview.md)
 - [V1TokenReviewSpec](docs/V1TokenReviewSpec.md)
 - [V1TokenReviewStatus](docs/V1TokenReviewStatus.md)
 - [V1Toleration](docs/V1Toleration.md)
 - [V1TopologySelectorLabelRequirement](docs/V1TopologySelectorLabelRequirement.md)
 - [V1TopologySelectorTerm](docs/V1TopologySelectorTerm.md)
 - [V1TopologySpreadConstraint](docs/V1TopologySpreadConstraint.md)
 - [V1TypedLocalObjectReference](docs/V1TypedLocalObjectReference.md)
 - [V1UncountedTerminatedPods](docs/V1UncountedTerminatedPods.md)
 - [V1UserInfo](docs/V1UserInfo.md)
 - [V1ValidatingWebhook](docs/V1ValidatingWebhook.md)
 - [V1ValidatingWebhookConfiguration](docs/V1ValidatingWebhookConfiguration.md)
 - [V1ValidatingWebhookConfigurationList](docs/V1ValidatingWebhookConfigurationList.md)
 - [V1Volume](docs/V1Volume.md)
 - [V1VolumeAttachment](docs/V1VolumeAttachment.md)
 - [V1VolumeAttachmentList](docs/V1VolumeAttachmentList.md)
 - [V1VolumeAttachmentSource](docs/V1VolumeAttachmentSource.md)
 - [V1VolumeAttachmentSpec](docs/V1VolumeAttachmentSpec.md)
 - [V1VolumeAttachmentStatus](docs/V1VolumeAttachmentStatus.md)
 - [V1VolumeDevice](docs/V1VolumeDevice.md)
 - [V1VolumeError](docs/V1VolumeError.md)
 - [V1VolumeMount](docs/V1VolumeMount.md)
 - [V1VolumeNodeAffinity](docs/V1VolumeNodeAffinity.md)
 - [V1VolumeNodeResources](docs/V1VolumeNodeResources.md)
 - [V1VolumeProjection](docs/V1VolumeProjection.md)
 - [V1VsphereVirtualDiskVolumeSource](docs/V1VsphereVirtualDiskVolumeSource.md)
 - [V1WatchEvent](docs/V1WatchEvent.md)
 - [V1WebhookConversion](docs/V1WebhookConversion.md)
 - [V1WeightedPodAffinityTerm](docs/V1WeightedPodAffinityTerm.md)
 - [V1WindowsSecurityContextOptions](docs/V1WindowsSecurityContextOptions.md)
 - [V1alpha1AggregationRule](docs/V1alpha1AggregationRule.md)
 - [V1alpha1CSIStorageCapacity](docs/V1alpha1CSIStorageCapacity.md)
 - [V1alpha1CSIStorageCapacityList](docs/V1alpha1CSIStorageCapacityList.md)
 - [V1alpha1ClusterRole](docs/V1alpha1ClusterRole.md)
 - [V1alpha1ClusterRoleBinding](docs/V1alpha1ClusterRoleBinding.md)
 - [V1alpha1ClusterRoleBindingList](docs/V1alpha1ClusterRoleBindingList.md)
 - [V1alpha1ClusterRoleList](docs/V1alpha1ClusterRoleList.md)
 - [V1alpha1Overhead](docs/V1alpha1Overhead.md)
 - [V1alpha1PolicyRule](docs/V1alpha1PolicyRule.md)
 - [V1alpha1PriorityClass](docs/V1alpha1PriorityClass.md)
 - [V1alpha1PriorityClassList](docs/V1alpha1PriorityClassList.md)
 - [V1alpha1Role](docs/V1alpha1Role.md)
 - [V1alpha1RoleBinding](docs/V1alpha1RoleBinding.md)
 - [V1alpha1RoleBindingList](docs/V1alpha1RoleBindingList.md)
 - [V1alpha1RoleList](docs/V1alpha1RoleList.md)
 - [V1alpha1RoleRef](docs/V1alpha1RoleRef.md)
 - [V1alpha1RuntimeClass](docs/V1alpha1RuntimeClass.md)
 - [V1alpha1RuntimeClassList](docs/V1alpha1RuntimeClassList.md)
 - [V1alpha1RuntimeClassSpec](docs/V1alpha1RuntimeClassSpec.md)
 - [V1alpha1Scheduling](docs/V1alpha1Scheduling.md)
 - [V1alpha1ServerStorageVersion](docs/V1alpha1ServerStorageVersion.md)
 - [V1alpha1StorageVersion](docs/V1alpha1StorageVersion.md)
 - [V1alpha1StorageVersionCondition](docs/V1alpha1StorageVersionCondition.md)
 - [V1alpha1StorageVersionList](docs/V1alpha1StorageVersionList.md)
 - [V1alpha1StorageVersionStatus](docs/V1alpha1StorageVersionStatus.md)
 - [V1alpha1Subject](docs/V1alpha1Subject.md)
 - [V1alpha1VolumeAttachment](docs/V1alpha1VolumeAttachment.md)
 - [V1alpha1VolumeAttachmentList](docs/V1alpha1VolumeAttachmentList.md)
 - [V1alpha1VolumeAttachmentSource](docs/V1alpha1VolumeAttachmentSource.md)
 - [V1alpha1VolumeAttachmentSpec](docs/V1alpha1VolumeAttachmentSpec.md)
 - [V1alpha1VolumeAttachmentStatus](docs/V1alpha1VolumeAttachmentStatus.md)
 - [V1alpha1VolumeError](docs/V1alpha1VolumeError.md)
 - [V1beta1AllowedCSIDriver](docs/V1beta1AllowedCSIDriver.md)
 - [V1beta1AllowedFlexVolume](docs/V1beta1AllowedFlexVolume.md)
 - [V1beta1AllowedHostPath](docs/V1beta1AllowedHostPath.md)
 - [V1beta1CSIStorageCapacity](docs/V1beta1CSIStorageCapacity.md)
 - [V1beta1CSIStorageCapacityList](docs/V1beta1CSIStorageCapacityList.md)
 - [V1beta1CronJob](docs/V1beta1CronJob.md)
 - [V1beta1CronJobList](docs/V1beta1CronJobList.md)
 - [V1beta1CronJobSpec](docs/V1beta1CronJobSpec.md)
 - [V1beta1CronJobStatus](docs/V1beta1CronJobStatus.md)
 - [V1beta1Endpoint](docs/V1beta1Endpoint.md)
 - [V1beta1EndpointConditions](docs/V1beta1EndpointConditions.md)
 - [V1beta1EndpointHints](docs/V1beta1EndpointHints.md)
 - [V1beta1EndpointPort](docs/V1beta1EndpointPort.md)
 - [V1beta1EndpointSlice](docs/V1beta1EndpointSlice.md)
 - [V1beta1EndpointSliceList](docs/V1beta1EndpointSliceList.md)
 - [V1beta1Event](docs/V1beta1Event.md)
 - [V1beta1EventList](docs/V1beta1EventList.md)
 - [V1beta1EventSeries](docs/V1beta1EventSeries.md)
 - [V1beta1FSGroupStrategyOptions](docs/V1beta1FSGroupStrategyOptions.md)
 - [V1beta1FlowDistinguisherMethod](docs/V1beta1FlowDistinguisherMethod.md)
 - [V1beta1FlowSchema](docs/V1beta1FlowSchema.md)
 - [V1beta1FlowSchemaCondition](docs/V1beta1FlowSchemaCondition.md)
 - [V1beta1FlowSchemaList](docs/V1beta1FlowSchemaList.md)
 - [V1beta1FlowSchemaSpec](docs/V1beta1FlowSchemaSpec.md)
 - [V1beta1FlowSchemaStatus](docs/V1beta1FlowSchemaStatus.md)
 - [V1beta1ForZone](docs/V1beta1ForZone.md)
 - [V1beta1GroupSubject](docs/V1beta1GroupSubject.md)
 - [V1beta1HostPortRange](docs/V1beta1HostPortRange.md)
 - [V1beta1IDRange](docs/V1beta1IDRange.md)
 - [V1beta1JobTemplateSpec](docs/V1beta1JobTemplateSpec.md)
 - [V1beta1LimitResponse](docs/V1beta1LimitResponse.md)
 - [V1beta1LimitedPriorityLevelConfiguration](docs/V1beta1LimitedPriorityLevelConfiguration.md)
 - [V1beta1NonResourcePolicyRule](docs/V1beta1NonResourcePolicyRule.md)
 - [V1beta1Overhead](docs/V1beta1Overhead.md)
 - [V1beta1PodDisruptionBudget](docs/V1beta1PodDisruptionBudget.md)
 - [V1beta1PodDisruptionBudgetList](docs/V1beta1PodDisruptionBudgetList.md)
 - [V1beta1PodDisruptionBudgetSpec](docs/V1beta1PodDisruptionBudgetSpec.md)
 - [V1beta1PodDisruptionBudgetStatus](docs/V1beta1PodDisruptionBudgetStatus.md)
 - [V1beta1PodSecurityPolicy](docs/V1beta1PodSecurityPolicy.md)
 - [V1beta1PodSecurityPolicyList](docs/V1beta1PodSecurityPolicyList.md)
 - [V1beta1PodSecurityPolicySpec](docs/V1beta1PodSecurityPolicySpec.md)
 - [V1beta1PolicyRulesWithSubjects](docs/V1beta1PolicyRulesWithSubjects.md)
 - [V1beta1PriorityLevelConfiguration](docs/V1beta1PriorityLevelConfiguration.md)
 - [V1beta1PriorityLevelConfigurationCondition](docs/V1beta1PriorityLevelConfigurationCondition.md)
 - [V1beta1PriorityLevelConfigurationList](docs/V1beta1PriorityLevelConfigurationList.md)
 - [V1beta1PriorityLevelConfigurationReference](docs/V1beta1PriorityLevelConfigurationReference.md)
 - [V1beta1PriorityLevelConfigurationSpec](docs/V1beta1PriorityLevelConfigurationSpec.md)
 - [V1beta1PriorityLevelConfigurationStatus](docs/V1beta1PriorityLevelConfigurationStatus.md)
 - [V1beta1QueuingConfiguration](docs/V1beta1QueuingConfiguration.md)
 - [V1beta1ResourcePolicyRule](docs/V1beta1ResourcePolicyRule.md)
 - [V1beta1RunAsGroupStrategyOptions](docs/V1beta1RunAsGroupStrategyOptions.md)
 - [V1beta1RunAsUserStrategyOptions](docs/V1beta1RunAsUserStrategyOptions.md)
 - [V1beta1RuntimeClass](docs/V1beta1RuntimeClass.md)
 - [V1beta1RuntimeClassList](docs/V1beta1RuntimeClassList.md)
 - [V1beta1RuntimeClassStrategyOptions](docs/V1beta1RuntimeClassStrategyOptions.md)
 - [V1beta1SELinuxStrategyOptions](docs/V1beta1SELinuxStrategyOptions.md)
 - [V1beta1Scheduling](docs/V1beta1Scheduling.md)
 - [V1beta1ServiceAccountSubject](docs/V1beta1ServiceAccountSubject.md)
 - [V1beta1Subject](docs/V1beta1Subject.md)
 - [V1beta1SupplementalGroupsStrategyOptions](docs/V1beta1SupplementalGroupsStrategyOptions.md)
 - [V1beta1UserSubject](docs/V1beta1UserSubject.md)
 - [V2beta1ContainerResourceMetricSource](docs/V2beta1ContainerResourceMetricSource.md)
 - [V2beta1ContainerResourceMetricStatus](docs/V2beta1ContainerResourceMetricStatus.md)
 - [V2beta1CrossVersionObjectReference](docs/V2beta1CrossVersionObjectReference.md)
 - [V2beta1ExternalMetricSource](docs/V2beta1ExternalMetricSource.md)
 - [V2beta1ExternalMetricStatus](docs/V2beta1ExternalMetricStatus.md)
 - [V2beta1HorizontalPodAutoscaler](docs/V2beta1HorizontalPodAutoscaler.md)
 - [V2beta1HorizontalPodAutoscalerCondition](docs/V2beta1HorizontalPodAutoscalerCondition.md)
 - [V2beta1HorizontalPodAutoscalerList](docs/V2beta1HorizontalPodAutoscalerList.md)
 - [V2beta1HorizontalPodAutoscalerSpec](docs/V2beta1HorizontalPodAutoscalerSpec.md)
 - [V2beta1HorizontalPodAutoscalerStatus](docs/V2beta1HorizontalPodAutoscalerStatus.md)
 - [V2beta1MetricSpec](docs/V2beta1MetricSpec.md)
 - [V2beta1MetricStatus](docs/V2beta1MetricStatus.md)
 - [V2beta1ObjectMetricSource](docs/V2beta1ObjectMetricSource.md)
 - [V2beta1ObjectMetricStatus](docs/V2beta1ObjectMetricStatus.md)
 - [V2beta1PodsMetricSource](docs/V2beta1PodsMetricSource.md)
 - [V2beta1PodsMetricStatus](docs/V2beta1PodsMetricStatus.md)
 - [V2beta1ResourceMetricSource](docs/V2beta1ResourceMetricSource.md)
 - [V2beta1ResourceMetricStatus](docs/V2beta1ResourceMetricStatus.md)
 - [V2beta2ContainerResourceMetricSource](docs/V2beta2ContainerResourceMetricSource.md)
 - [V2beta2ContainerResourceMetricStatus](docs/V2beta2ContainerResourceMetricStatus.md)
 - [V2beta2CrossVersionObjectReference](docs/V2beta2CrossVersionObjectReference.md)
 - [V2beta2ExternalMetricSource](docs/V2beta2ExternalMetricSource.md)
 - [V2beta2ExternalMetricStatus](docs/V2beta2ExternalMetricStatus.md)
 - [V2beta2HPAScalingPolicy](docs/V2beta2HPAScalingPolicy.md)
 - [V2beta2HPAScalingRules](docs/V2beta2HPAScalingRules.md)
 - [V2beta2HorizontalPodAutoscaler](docs/V2beta2HorizontalPodAutoscaler.md)
 - [V2beta2HorizontalPodAutoscalerBehavior](docs/V2beta2HorizontalPodAutoscalerBehavior.md)
 - [V2beta2HorizontalPodAutoscalerCondition](docs/V2beta2HorizontalPodAutoscalerCondition.md)
 - [V2beta2HorizontalPodAutoscalerList](docs/V2beta2HorizontalPodAutoscalerList.md)
 - [V2beta2HorizontalPodAutoscalerSpec](docs/V2beta2HorizontalPodAutoscalerSpec.md)
 - [V2beta2HorizontalPodAutoscalerStatus](docs/V2beta2HorizontalPodAutoscalerStatus.md)
 - [V2beta2MetricIdentifier](docs/V2beta2MetricIdentifier.md)
 - [V2beta2MetricSpec](docs/V2beta2MetricSpec.md)
 - [V2beta2MetricStatus](docs/V2beta2MetricStatus.md)
 - [V2beta2MetricTarget](docs/V2beta2MetricTarget.md)
 - [V2beta2MetricValueStatus](docs/V2beta2MetricValueStatus.md)
 - [V2beta2ObjectMetricSource](docs/V2beta2ObjectMetricSource.md)
 - [V2beta2ObjectMetricStatus](docs/V2beta2ObjectMetricStatus.md)
 - [V2beta2PodsMetricSource](docs/V2beta2PodsMetricSource.md)
 - [V2beta2PodsMetricStatus](docs/V2beta2PodsMetricStatus.md)
 - [V2beta2ResourceMetricSource](docs/V2beta2ResourceMetricSource.md)
 - [V2beta2ResourceMetricStatus](docs/V2beta2ResourceMetricStatus.md)
 - [VersionInfo](docs/VersionInfo.md)


## Documentation For Authorization


## BearerToken

- **Type**: API key
- **API key parameter name**: authorization
- **Location**: HTTP header


## Author




