% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clusterGenes}
\alias{clusterGenes}
\title{Clusters genes by pseudotime trend.}
\usage{
clusterGenes(expr_matrix, k, method = function(x) {     as.dist((1 -
  cor(Matrix::t(x)))/2) }, ...)
}
\arguments{
\item{expr_matrix}{A matrix of expression values to cluster together. Rows 
are genes, columns are cells.}

\item{k}{How many clusters to create}

\item{method}{The distance function to use during clustering}

\item{...}{Extra parameters to pass to pam() during clustering}
}
\value{
a pam cluster object
}
\description{
This function takes a matrix of expression values and performs k-means 
clustering on the genes.
}
\examples{
\dontrun{
full_model_fits <- fitModel(HSMM[sample(nrow(fData(HSMM_filtered)), 100),],  
   modelFormulaStr="~sm.ns(Pseudotime)")
expression_curve_matrix <- responseMatrix(full_model_fits)
clusters <- clusterGenes(expression_curve_matrix, k=4)
plot_clusters(HSMM_filtered[ordering_genes,], clusters)
}
}
