\name{cellCounts}
\alias{cellCounts}
\title{Map and quantify single cell RNA-seq data generated by 10X Genomics}
\description{Process raw 10X scRNA-seq data and generate UMI counts for each gene in each cell.}
\usage{
cellCounts(

    # input data
    index,
    sample.index,
    input.mode = "BCL",
    cell.barcode = NULL,
  
    # specify the aligner used for read mapping
    aligner = "align",
  
    # parameters used by featureCounts for assigning and counting UMIs
    annot.inbuilt = "mm10",
    annot.ext = NULL,
    isGTFAnnotationFile = FALSE,
    GTF.featureType = "exon",
    GTF.attrType = "gene_id",
    useMetaFeatures = TRUE,
    
    # number of threads
    nthreads = 10,

    # other parameters passed to align, subjunc and featureCounts functions 
    ...)
}
\arguments{
  \item{index}{ A character string providing the base name of index files created for a reference genome by the \code{\link{buildindex}} function.}
  \item{sample.index}{ A data frame containing index set name for each sample and other sample-related information. The data frame must contain four columns with column headers named \code{InputDirectory}, \code{Lane}, \code{SampleName} and \code{IndexSetName}. Note that this is not the Sample Sheet generated by the Illumina sequencer. \code{cellCounts} uses the index set names provided in this data frame to generate a Sample Sheet and then uses this Sample Sheet to demultiplex all the samples. The name of an index set provided for a sample specifies the set of indices that were used for the sequencing of the sample. An example of the index set name is "SI-P01-A2". The column \code{InputDirectory} of this data frame includes one or more directories in which raw sequencing data are saved. See below for more details.}
  \item{input.mode}{ Specify the input mode. Currently only the BCL-format input is supported (\code{"BCL"}).}
  \item{cell.barcode}{ A character string giving the name of a text file (can be gzipped) that contains the set of cell barcodes used in sample preparation. If \code{NULL}, a cell barcode set will be determined for the input data by \code{cellCounts} based on the matching of cell barcodes sequences of the first 100,000 reads in the data with the three cell barcode sets used by 10X Genomics. \code{NULL} by default.}
  \item{aligner}{ Specify the name of the aligner used for read mapping. Currently it has only one possible value \code{"align"}, indicating that the \code{\link{align}} function will be used for mapping.}
  \item{annot.inbuilt}{ Specify an inbuilt annotation for UMI counting. See \code{\link{featureCounts}} for more details. \code{"mm10"} by default.}
  \item{annot.ext}{ Specify an external annotation for UMI counting. See \code{\link{featureCounts}} for more details. \code{NULL} by default.}
  \item{isGTFAnnotationFile}{ See \code{\link{featureCounts}} for more details. \code{FALSE} by default.}
  \item{GTF.featureType}{ See \code{\link{featureCounts}} for more details. \code{"exon"} by default.}
  \item{GTF.attrType}{ See \code{\link{featureCounts}} for more details. \code{"gene_id"} by default.} 
  \item{useMetaFeatures}{ Specify if UMI counting should be carried out at the meta-feature level (eg. gene level).  See \code{\link{featureCounts}} for more details. \code{TRUE} by default.}
  \item{nthreads}{ A numeric value giving the number of threads used for read mapping and counting. \code{10} by default.}
  \item{...}{other parameters passed to \code{\link{align}} and and \code{\link{featureCounts}} functions.}
}

\details{
The \code{cellCounts} function takes as input raw scRNA-seq read data generated from the 10X Genomics platform.
It utilizes the read mapping and counting functions included in the Rsubread package to process the scRNA-seq data.
It calls the \code{\link{align}} function to map reads to a reference genome and calls the \code{\link{featureCounts}} function to assign reads to genes. 
It performs sample demultiplexing, cell barcode demultiplexing and read deduplication before producing UMI counts for each gene in each cell.
The \code{cellCounts} function is able to process multiple datasets stored in multiple different directories at the same time.

Sample-related information should be provided to the \code{sample.index} parameter.
This includes the name of index set used for each sample, sample name, the flowcell lane used for the sequencing of each sample and the location where the sample data were saved.
All these information should be stored in a \code{data.frame} object, which can then be provided to the \code{sample.index} parameter.
Below is an example of the \code{data.frame} object provided to \code{sample.index}:

\preformatted{
InputDirectory		Lane		SampleName	IndexSetName
/path/to/dataset1	1		Sample1		SI-GA-E1
/path/to/dataset1	1		Sample2		SI-GA-E2
/path/to/dataset1	2		Sample1		SI-GA-E1
/path/to/dataset1	2		Sample2		SI-GA-E2
/path/to/dataset2	1		Sample3		SI-GA-E3
/path/to/dataset2	1		Sample4		SI-GA-E4
/path/to/dataset2	2		Sample3		SI-GA-E3
/path/to/dataset2	2		Sample4		SI-GA-E4
...
}
}

\value{
The \code{cellCounts} function returns a \code{List} object to R, and it also outputs three gzipped FASTQ files and one BAM file for each sample.
The three gzipped FASTQ files include cell barcode and UMI sequences (R1), sample index sequences (I1) and the actual genomic sequences of the reads (R2), respectively. 
The BAM file includes location-sorted read mapping results.

The returned \code{List} object contains the following components:

\item{counts}{a \code{List} object including UMI counts for each sample. Each component in this object is a matrix that contains UMI counts for a sample. Rows in the matrix are genes and columns are cells.}

\item{annotation}{a \code{data.frame} object containing an annotation (eg. a gene annotation). UMIs were assigned to features (eg. genes) in this annotation. Rows in the annotation are features. Columns of the annotation include \code{GeneID}, \code{Chr}, \code{Start}, \code{End} and \code{Length}.}

\item{sample.info}{a \code{data.frame} object containing sample information and also statistics related to the quantification result. It includes the following columns: \code{SampleName}, \code{InputDirectory}, \code{TotalCells}, \code{HighConfidenceCells}, \code{RescuedCells}, \code{TotalUMI}, \code{TotalReads}, \code{MappedReads} and \code{AssignedReads}. The order of samples in this object is the same as that in the components \code{counts} and \code{cell.confidence}.}

\item{cell.confidence}{a \code{List} object indicating if a cell is a high-confidence cell or a rescued cell (low confidence). Each component in the \code{List} object corresponds to a sample. Each component is a logical vector with a \code{TRUE} value indicating a high-confidence cell.}
}

\author{Yang Liao and Wei Shi}

\seealso{
\code{\link{buildindex}}, \code{\link{align}}, \code{\link{featureCounts}}
}

%\examples{}
