% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_cactustree.R
\name{layout_tbl_graph_cactustree}
\alias{layout_tbl_graph_cactustree}
\title{Calculate nodes as fractal circle buds}
\usage{
layout_tbl_graph_cactustree(
  graph,
  direction = "out",
  weight = NULL,
  scale_factor = 0.75,
  overlap = 0.5,
  upright = FALSE,
  circular = FALSE
)
}
\arguments{
\item{graph}{An \code{tbl_graph} object}

\item{direction}{The direction of the tree in the graph. \code{'out'} (default)
means that parents point towards their children, while \code{'in'} means that
children point towards their parent.}

\item{weight}{An optional node variable to use as weight. If \code{NULL} all leaf
nodes will be assigned a weight of \code{1}.}

\item{scale_factor}{A scaling factor for the circles in the layout. The
radius will be calculated as \code{total_weight ^ scale_factor} with \code{total_weight}
being the weight of the node and all it's children.}

\item{overlap}{How much is the center of child nodes offset from the
periphery of their parent as a proportion of their own radius.}

\item{upright}{Logical. Should the children of the root only be distributed
around the top half of the root or all the way around.}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Ignored.}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{r}, \code{leaf}, \code{depth},
\code{circular} as well as any information stored as node variables in the
tbl_graph object.
}
\description{
The cactustree layout is a hierarchical layout optimised for use with
hierarchical edge bundling (\code{\link[=geom_conn_bundle]{geom_conn_bundle()}}). It is a fractal layout
that places node children as circles on the periphery of their parent circle,
each circle scaled by the total weight of their children.
}
\note{
cactustree is a layout intended for trees, that is, graphs where nodes
only have one parent and zero or more children. If the provided graph does
not fit this format an attempt to convert it to such a format will be made.
}
\references{
Dang, T., Forbes, A. (2017). \emph{CactusTree: A Tree Drawing Approach
for Hierarchical Edge Bundling}. 2017 IEEE Pacific Visualization Symposium,
210-214. https://doi.org/10.1109/PACIFICVIS.2017.8031596
}
\seealso{
Other layout_tbl_graph_*: 
\code{\link{layout_tbl_graph_auto}()},
\code{\link{layout_tbl_graph_backbone}()},
\code{\link{layout_tbl_graph_centrality}()},
\code{\link{layout_tbl_graph_circlepack}()},
\code{\link{layout_tbl_graph_dendrogram}()},
\code{\link{layout_tbl_graph_eigen}()},
\code{\link{layout_tbl_graph_fabric}()},
\code{\link{layout_tbl_graph_focus}()},
\code{\link{layout_tbl_graph_hive}()},
\code{\link{layout_tbl_graph_htree}()},
\code{\link{layout_tbl_graph_igraph}()},
\code{\link{layout_tbl_graph_linear}()},
\code{\link{layout_tbl_graph_manual}()},
\code{\link{layout_tbl_graph_matrix}()},
\code{\link{layout_tbl_graph_metro}()},
\code{\link{layout_tbl_graph_partition}()},
\code{\link{layout_tbl_graph_pmds}()},
\code{\link{layout_tbl_graph_sf}()},
\code{\link{layout_tbl_graph_stress}()},
\code{\link{layout_tbl_graph_treemap}()},
\code{\link{layout_tbl_graph_unrooted}()}
}
\concept{layout_tbl_graph_*}
