% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_stress.R, R/layouts.R
\name{layout_centrality}
\alias{layout_centrality}
\alias{layout_with_centrality}
\alias{layout_igraph_centrality}
\title{radial centrality layout}
\usage{
layout_with_centrality(
  g,
  cent,
  scale = TRUE,
  iter = 500,
  tol = 1e-04,
  tseq = seq(0, 1, 0.2)
)

layout_igraph_centrality(
  g,
  cent,
  scale = TRUE,
  iter = 500,
  tol = 1e-04,
  tseq = seq(0, 1, 0.2),
  circular
)
}
\arguments{
\item{g}{igraph object}

\item{cent}{centrality scores}

\item{scale}{logical. should centrality scores be scaled to \eqn{[0,100]}? (Default: TRUE)}

\item{iter}{number of iterations during stress optimization}

\item{tol}{stopping criterion for stress optimization}

\item{tseq}{numeric vector. increasing sequence of coefficients to combine regular stress and constraint stress. See details.}

\item{circular}{not used}
}
\value{
matrix of xy coordinates
}
\description{
arranges nodes in concentric circles according to a centrality index.
}
\details{
The function optimizes a convex combination of regular stress and a constrained stress function which forces
nodes to be arranged on concentric circles. The vector \code{tseq} is the sequence of parameters used for the convex combination.
In iteration i of the algorithm \eqn{tseq[i]} is used to combine regular and constraint stress as \eqn{(1-tseq[i])*stress_{regular}+tseq[i]*stress_{constraint}}. The sequence must be increasing, start at zero and end at one. The default setting should be a good choice for most graphs.

The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'.
'ggraph' natively supports the layout.
}
\examples{
library(igraph)
library(ggraph)

g <- sample_gnp(10,0.4)
\dontrun{
ggraph(g,layout="centrality",centrality = closeness(g))+
  draw_circle(use = "cent")+
  geom_edge_link0()+
  geom_node_point(shape = 21,fill = "grey25",size = 5)+
  theme_graph()+
  coord_fixed()
}
}
\references{
Brandes, U., & Pich, C. (2011). More flexible radial layout. Journal of Graph Algorithms and Applications, 15(1), 157-173.
}
\seealso{
\link{layout_centrality_group}
}
