% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{diverging_pal}
\alias{diverging_pal}
\title{Diverging palette}
\usage{
diverging_pal(n)
}
\arguments{
\item{n}{The number of colors in the palette. The maximum is eleven
currently.}
}
\value{
A character vector of RGB color codes.
}
\description{
This is the \sQuote{PuOr} palette from \url{https://colorbrewer2.org/}.
It has at most eleven colors.
}
\details{
This is similar to \code{\link{sequential_pal}}, but it also puts
emphasis on the mid-range values, plus the the two extreme ends.
Use this palette, if you have such a quantity to mark with vertex
colors.
}
\examples{
\dontrun{
library(igraphdata)
data(foodwebs)
fw <- foodwebs[[1]] \%>\%
  induced_subgraph(V(.)[ECO == 1]) \%>\%
  add_layout_(with_fr()) \%>\%
  set_vertex_attr("label", value = seq_len(gorder(.))) \%>\%
  set_vertex_attr("size", value = 10) \%>\%
  set_edge_attr("arrow.size", value = 0.3)

V(fw)$color <- scales::dscale(V(fw)$Biomass \%>\% cut(10), diverging_pal)
plot(fw)

data(karate)
karate <- karate \%>\%
  add_layout_(with_kk()) \%>\%
  set_vertex_attr("size", value = 10)

V(karate)$color <- scales::dscale(degree(karate) \%>\% cut(5), diverging_pal)
plot(karate)
}
}
\seealso{
Other palettes: 
\code{\link{categorical_pal}()},
\code{\link{r_pal}()},
\code{\link{sequential_pal}()}
}
\concept{palettes}
