% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ablation.R
\name{plotAblation}
\alias{plotAblation}
\title{Create plot from an ablation log}
\usage{
plotAblation(
  ablog,
  pdf_file = NULL,
  width = 20,
  height = 7,
  type = c("mean", "boxplot", "rank"),
  n = 0L,
  mar = NULL,
  ylab = "Mean configuration cost",
  ylim = NULL,
  rename_labels = NULL,
  ...
)
}
\arguments{
\item{ablog}{(\code{list()}|\code{character(1)}) Ablation log object returned by \code{\link[=ablation]{ablation()}}. Alternatively, the path to an \code{.Rdata} file, e.g., \code{"log-ablation.Rdata"}, from which the object will be loaded.}

\item{pdf_file}{Output filename.}

\item{width}{Width provided to create the PDF file.}

\item{height}{Height provided to create the PDF file.}

\item{type}{Type of plot. Supported values are \code{"mean"} and \code{"boxplot"}. Adding \code{"rank"} will plot rank per instance instead of raw cost value.}

\item{n}{\code{integer(1)}\cr Number of parameters included in the plot. By default all parameters are included.}

\item{mar}{Vector with the margins for the ablation plot.}

\item{ylab}{Label of y-axis.}

\item{ylim}{Numeric vector of length 2 giving the y-axis range.}

\item{rename_labels}{\code{character()}\cr Renaming table for nicer labels. For example, \code{c("No value"="NA", "LongParameterName"="LPN")}.}

\item{...}{Further graphical parameters may also be supplied as
arguments. See \code{\link[graphics:plot.default]{graphics::plot.default()}}.}
}
\description{
Create plot from an ablation log
}
\examples{
logfile <- file.path(system.file(package="irace"), "exdata", "log-ablation.Rdata")
plotAblation(ablog = logfile)
plotAblation(ablog = logfile, type = "mean")
plotAblation(ablog = logfile, type = c("rank","boxplot"), rename_labels = c(
            "localsearch"="ls", algorithm="algo", source="default"))
}
\seealso{
\code{\link[=ablation]{ablation()}} \code{\link[=ablation_cmdline]{ablation_cmdline()}}
}
\author{
Leslie Pérez Cáceres and Manuel López-Ibáñez
}
\concept{ablation}
