% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSD.linesplot.r
\name{linesplot}
\alias{linesplot}
\alias{LSD.linesplot}
\title{One-dimensional scatterplot}
\usage{
linesplot(
  x,
  labels = NULL,
  col = "black",
  cols = NULL,
  alpha = 25,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = "",
  las = 1,
  outline = TRUE,
  cexbox = 0.6,
  addboxes = FALSE,
  border = "black",
  range = 1.5,
  lwd = 1.5,
  main = "LSD.linesplot",
  ...
)
}
\arguments{
\item{x}{numeric data as vector, matrix, list or data.frame.}

\item{labels}{a character vector of labels.}

\item{col}{a R build-in color.}

\item{cols}{a character vector of R build-in colors.}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{xlim}{x limits, standard graphics parameter.}

\item{ylim}{y limits, standard graphics parameter.}

\item{xlab}{x label, standard graphics parameter.}

\item{ylab}{y label, standard graphics parameter.}

\item{las}{las=1: horizontal text, las=2: vertical text (x-axis labels).}

\item{outline}{logical: if \code{TRUE} (by default), outliers are plotted.}

\item{cexbox}{a numerical value giving the amount by which the boxes should be magnified relative to the default.}

\item{addboxes}{logical: if \code{TRUE} (\code{FALSE} by default), boxplots be added to the plot.}

\item{border}{a R build-in color for the box and the whiskers (if \code{addboxes = TRUE}).}

\item{range}{this determines how far the plot whiskers extend out from the box.}

\item{lwd}{linewidth of the box and whiskers.}

\item{main}{title(s) of the plot, standard graphics parameter.}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
Visualize one-dimensional data in its every detail.
}
\examples{
l = list()
for (i in 1:10){l[[i]] = rnorm(100,sqrt(i^2.5),1+i/2)}

linesplot(l,alpha=25,border="darkred",addboxes = TRUE,outline=FALSE)
}
\seealso{
\code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\author{
Bjoern Schwalb
}
\keyword{boxplotlike}
