% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctl_new_pillar_list.R
\name{ctl_new_pillar_list}
\alias{ctl_new_pillar_list}
\title{Customize the appearance of compound pillars in your tibble subclass}
\usage{
ctl_new_pillar_list(
  controller,
  x,
  width,
  ...,
  title = NULL,
  first_pillar = NULL
)
}
\arguments{
\item{controller}{The object of class \code{"tbl"} currently printed.}

\item{x}{A vector, can also be a data frame, matrix, or array.}

\item{width}{The available width, can be a vector for multiple tiers.
If \code{NULL}, only the first pillar is instantiated.}

\item{...}{These dots are for future extensions and must be empty.}

\item{title}{The title, derived from the name of the column in the data.}

\item{first_pillar}{Can be passed to this method if the first pillar
for a compound pillar (or the pillar itself for a simple pillar)
has been constructed already.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Gain full control over the appearance of the pillars of your tibble subclass
in its body.
This method is intended for implementers of subclasses of the \code{"tbl"} class.
Users will rarely need them, and we also expect the default implementation
to be sufficient for the vast majority of cases.
}
\details{
\code{ctl_new_pillar_list()} is called to construct a list of pillars.
If \code{x} is a regular (one-dimensional) vector, the list contains one pillar
constructed by \code{\link[=ctl_new_pillar]{ctl_new_pillar()}}.
This method also works for compound columns: columns that are data frames,
matrices or arrays, with the following behavior:
\itemize{
\item If \code{width} is \code{NULL}, the method always returns a list of length one
containing one pillar object that represents the first sub-column in this
compound column.
\item Otherwise, the returned list contains one pillar object for all sub-columns
that can be fit in the available horizontal space.
These pillar objects are obtained by calling \code{ctl_new_pillar_list()}
with \code{width = NULL} on each sub-column until the available width is
exhausted.
}

This method is called to initiate the construction of all pillars
in the tibble to be printed.
To ensure that all packed columns that fit the available space are printed,
\code{ctl_new_pillar_list()} may be called twice on the same input:
once with \code{width = NULL}, and
once with \code{width} corresponding to the then known available space
and with \code{first_pillar} set to the pillar object constructed in the
first call.
}
\examples{
\dontshow{if (rlang::is_installed("palmerpenguins") && requireNamespace("tibble")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Simple column
ctl_new_pillar_list(
  tibble::tibble(),
  palmerpenguins::penguins$weight[1:3],
  width = 10
)

# Packed data frame: unknown width
ctl_new_pillar_list(
  tibble::tibble(),
  palmerpenguins::penguins[1:3, ],
  width = NULL
)

# Packed data frame: known width
ctl_new_pillar_list(
  tibble::tibble(),
  palmerpenguins::penguins,
  width = 60
)

# Deeply packed data frame with known width:
# showing only the first sub-column even if the width is sufficient
ctl_new_pillar_list(
  tibble::tibble(),
  tibble::tibble(x = tibble::tibble(b = 1, c = 2), y = 3),
  width = 60
)

# Packed matrix: unknown width
ctl_new_pillar_list(tibble::tibble(), matrix(1:6, ncol = 2), width = NULL)

# Packed matrix: known width
ctl_new_pillar_list(tibble::tibble(), matrix(1:6, ncol = 2), width = 60)

# Packed array
ctl_new_pillar_list(tibble::tibble(), Titanic, width = 60)
\dontshow{\}) # examplesIf}
}
