## ----echo=TRUE----------------------------------------------------------------
library(pwr)
pwr.p.test(h = ES.h(p1 = 0.75, p2 = 0.50),
           sig.level = 0.05,
           power = 0.80,
           alternative = "greater")

## ----fig.height=5, fig.width=5------------------------------------------------
p.out <- pwr.p.test(h = ES.h(p1 = 0.75, p2 = 0.50),
                    sig.level = 0.05,
                    power = 0.80,
                    alternative = "greater")
plot(p.out)

## -----------------------------------------------------------------------------
pwr.p.test(h = ES.h(p1 = 0.75, p2 = 0.50),
           sig.level = 0.01,
           n = 40,
           alternative = "greater")


## -----------------------------------------------------------------------------
pwr.p.test(h = ES.h(p1 = 0.75, p2 = 0.50),
           sig.level = 0.01,
           n = 40)

## -----------------------------------------------------------------------------
pwr.p.test(h = ES.h(p1 = 0.65, p2 = 0.50),
           sig.level = 0.05,
           power = 0.80)


## -----------------------------------------------------------------------------
cohen.ES(test = "r", size = "medium")

## -----------------------------------------------------------------------------
pwr.r.test(r="medium", power=0.8)

## -----------------------------------------------------------------------------
pwr.p.test(h = c(0.2,0.5,0.8),
           n = 20,
           sig.level = 0.05)


## -----------------------------------------------------------------------------
n <- seq(10,100,10)
p.out <- pwr.p.test(h = 0.5,
                    n = n,
                    sig.level = 0.05)
data.frame(n, power = sprintf("%.2f%%", p.out$power * 100))


## -----------------------------------------------------------------------------
pwr.p.test(h = 0.5, n = n, sig.level = 0.05)$power

## -----------------------------------------------------------------------------
pwr.2p.test(h = ES.h(p1 = 0.55, p2 = 0.50), sig.level = 0.05, power = .80)


## -----------------------------------------------------------------------------
pwr.2p.test(h = ES.h(p1 = 0.10, p2 = 0.05), sig.level = 0.05, power = .80)


## ----fig.height=5, fig.width=5------------------------------------------------
addSegs <- function(p1, p2){
  tp1 <- ES.h(p1, 0); tp2 <- ES.h(p2, 0)
  segments(p1,0,p1,tp1, col="blue"); segments(p2,0,p2,tp2,col="blue")
  segments(0, tp1, p1, tp1, col="red"); segments(0, tp2, p2, tp2, col="red")
}

curve(expr = ES.h(p1 = x, p2 = 0), xlim = c(0,1),
      xlab = "proportion", ylab = "transformed proportion")
addSegs(p1 = 0.50, p2 = 0.55) # 50% vs 55%
addSegs(p1 = 0.05, p2 = 0.10) # 5% vs 10%

## -----------------------------------------------------------------------------
power.prop.test(p1 = 0.55, p2 = 0.50, sig.level = 0.05, power = .80)


## -----------------------------------------------------------------------------
pwr.2p.test(h = 0.2, sig.level = 0.05, power = .80)


## -----------------------------------------------------------------------------
cohen.ES(test = "p", size = "small")
pwr.2p2n.test(h = 0.2, n1 = 543, n2 = 675, sig.level = 0.05)

## -----------------------------------------------------------------------------
pwr.2p2n.test(h = 0.2, n1 = 763, power = 0.8, sig.level = 0.05)


## -----------------------------------------------------------------------------
cohen.ES(test = "t", size = "medium")
pwr.t.test(n = 30, d = 0.5, sig.level = 0.05)

## -----------------------------------------------------------------------------
pwr.t.test(d = 0.5, power = 0.80, sig.level = 0.05)


## -----------------------------------------------------------------------------
d <- 0.75/2.25
pwr.t.test(d = d, power = 0.80, sig.level = 0.05)


## -----------------------------------------------------------------------------
power.t.test(delta = 0.75, sd = 2.25, sig.level = 0.05, power = 0.8)


## -----------------------------------------------------------------------------
d <- 0.50/2.25
pwr.t.test(d = d, sig.level = 0.05, power = 0.90, alternative = "greater",
           type = "one.sample")


## -----------------------------------------------------------------------------
power.t.test(delta = 0.50, sd = 2.25, power = 0.90, sig.level = 0.05,
             alternative = "one.sided", type = "one.sample")


## -----------------------------------------------------------------------------
pwr.t.test(n = 24, d = 0.08 / 0.25,
           type = "paired", alternative = "greater")


## -----------------------------------------------------------------------------
pwr.t.test(d = 0.08 / 0.25, power = 0.8,
           type = "paired", alternative = "greater")


## -----------------------------------------------------------------------------
pwr.t.test(d = 0.08 / (0.1 * sqrt(2)), power = 0.8,
           type = "paired", alternative = "greater")


## -----------------------------------------------------------------------------
pwr.t2n.test(n1 = 28, n2 = 35, d = 0.5)


## -----------------------------------------------------------------------------
null <- rep(0.25, 4)
alt <- c(3/8, rep((5/8)/3, 3))
ES.w1(null,alt)


## -----------------------------------------------------------------------------
pwr.chisq.test(w=ES.w1(null,alt), N=100, df=(4-1), sig.level=0.05)


## -----------------------------------------------------------------------------
pwr.chisq.test(w=ES.w1(null,alt), df=(4-1), power=0.8, sig.level = 0.05)


## -----------------------------------------------------------------------------
prob <- matrix(c(0.1,0.2,0.4,0.3), ncol=2,
               dimnames = list(c("M","F"),c("Floss","No Floss")))
prob


## -----------------------------------------------------------------------------
ES.w2(prob)


## -----------------------------------------------------------------------------
pwr.chisq.test(w = ES.w2(prob), N = 100, df = 1, sig.level = 0.01)


## -----------------------------------------------------------------------------
pwr.chisq.test(w = ES.w2(prob), power = 0.9, df = 1, sig.level = 0.01)


## -----------------------------------------------------------------------------
cohen.ES(test = "chisq", size = "small")
pwr.chisq.test(w = 0.1, power = 0.9, df = 1, sig.level = 0.01)


## -----------------------------------------------------------------------------
pwr.2p.test(h = 0.2, sig.level = 0.01, power = 0.9)


## -----------------------------------------------------------------------------
cohen.ES(test = "r", size = "small")
pwr.r.test(r = 0.1, sig.level = 0.01, power = 0.8, alternative = "greater")


## -----------------------------------------------------------------------------
pwr.r.test(r = 0.1, sig.level = 0.01, power = 0.8)


## -----------------------------------------------------------------------------
cohen.ES(test = "anov", size = "medium")
pwr.anova.test(k = 3, f = 0.25, sig.level = 0.01, power = 0.9)


## -----------------------------------------------------------------------------
pwr.anova.test(k = 3, f = 5/3, sig.level = 0.01, power = 0.9)

## -----------------------------------------------------------------------------
power.anova.test(groups = 3,
                 within.var = 3^2,
                 between.var = 5^2 * (3/2),
                 sig.level = 0.01, power = 0.90)

## -----------------------------------------------------------------------------
pwr.f2.test(u = 2, f2 = 0.3/(1 - 0.3), sig.level = 0.001, power = 0.8)

## -----------------------------------------------------------------------------
pwr.f2.test(u = 2, v = 40 - 2 - 1, f2 = 0.3/(1 - 0.3), sig.level = 0.01)


