% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcDiagnose.R
\name{getPartialCor}
\alias{getPartialCor}
\title{Calculates partial correlation coefficients after retrieving data matrix froma fitted regression model}
\usage{
getPartialCor(model, dvonly = TRUE)
}
\arguments{
\item{model}{A fitted regression model, such as output from
lm(). Any object that has methods model.matrix and model.frame
will be sufficient.}

\item{dvonly}{Default = TRUE. Only show first column of the full
partial correlation matrix. That corresponds to the partial correlation of each predictor with y. I mean, r[yx].[others]}
}
\value{
A column or matrix of partial correlation coefficients
}
\description{
The input is a fitted regression model, from which the design
matrix is retrieved, along with the dependent variable. The
partial correlation is calculated using matrix algebra that
has not been closely inspected for numerical precision.  That is to
say, it is in the stats book style, rather than the numerically
optimized calculating format that functions like \code{lm()} have adopted.
}
\details{
I often criticize partial correlations because they change in a
very unstable way as terms are added or removed in regression
models. Nevertheless, I teach with books that endorse them, and in
order to have something to criticize, I need to have a function
like this. There are other packages that offer partial correlation
calculations, but they are either 1) not easy to install from CRAN
because of dependencies or 2) do not directly calculate the values
we want to see.

To students. 1) This gives the same result as the function
\code{cov2pcor} in \code{gRbase}, so far as I can tell. Why use
this?  Simply for convenenience.  We have found that installing
gRbase is a problem because it depends on packages in
Bioconductor.  2) By default, I show only one column of output,
the partial correlations involving the dependent variable as
something being explained. The other columns that would depict the
dependent variable as a predictor of the independent variables
have been omitted. You can let me know if you think that's wrong.

Please note I have not gone out of my way to make this calculation
"numerically stable."  It does not use any orthogonal matrix
calculations; it is using the same textbook theoretical stats
formula that is used by cov2pcor in gRbase and in every other
package or online source I could find. I prepared a little
WorkingExample file matrix-partial-correlations-1.R that
discusses this, in case you are interested (http://pj.freefaculty.org/R).
}
\author{
Paul E. Johnson \email{pauljohn@ku.edu}
}
