% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2-accessors.R
\name{s2_is_collection}
\alias{s2_is_collection}
\alias{s2_dimension}
\alias{s2_num_points}
\alias{s2_is_empty}
\alias{s2_area}
\alias{s2_length}
\alias{s2_perimeter}
\alias{s2_x}
\alias{s2_y}
\alias{s2_distance}
\alias{s2_max_distance}
\title{S2 Geography Accessors}
\usage{
s2_is_collection(x)

s2_dimension(x)

s2_num_points(x)

s2_is_empty(x)

s2_area(x, radius = s2_earth_radius_meters())

s2_length(x, radius = s2_earth_radius_meters())

s2_perimeter(x, radius = s2_earth_radius_meters())

s2_x(x)

s2_y(x)

s2_distance(x, y, radius = s2_earth_radius_meters())

s2_max_distance(x, y, radius = s2_earth_radius_meters())
}
\arguments{
\item{x, y}{\link[=as_s2_geography]{geography vectors}. These inputs
are passed to \code{\link[=as_s2_geography]{as_s2_geography()}}, so you can pass other objects
(e.g., character vectors of well-known text) directly.}

\item{radius}{Radius of the earth. Defaults to the average radius of
the earth in meters as defined by \code{\link[=s2_earth_radius_meters]{s2_earth_radius_meters()}}.}
}
\description{
Accessors extract information about \link[=as_s2_geography]{geography vectors}.
}
\examples{
# s2_is_collection() tests for multiple geometries in one feature
s2_is_collection(c("POINT (-64 45)", "MULTIPOINT ((-64 45), (8 72))"))

# s2_dimension() returns 0 for point, 1  for line, 2 for polygon
s2_dimension(
  c(
    "GEOMETRYCOLLECTION EMPTY",
    "POINT (-64 45)",
    "LINESTRING (-64 45, 8 72)",
    "POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))",
    "GEOMETRYCOLLECTION (POINT (-64 45), LINESTRING (-64 45, 8 72))"
   )
)

# s2_num_points() counts points
s2_num_points(c("POINT (-64 45)", "LINESTRING (-64 45, 8 72)"))

# s2_is_empty tests for emptiness
s2_is_empty(c("POINT (-64 45)", "POINT EMPTY"))

# calculate area, length, and perimeter
s2_area("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))")
s2_perimeter("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))")
s2_length(s2_boundary("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))"))

# extract x and y coordinates from points
s2_x(c("POINT (-64 45)", "POINT EMPTY"))
s2_y(c("POINT (-64 45)", "POINT EMPTY"))

# calculate minimum and maximum distance between two geometries
s2_distance(
  "POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))",
  "POINT (-64 45)"
)
s2_max_distance(
  "POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))",
  "POINT (-64 45)"
)

}
\seealso{
BigQuery's geography function reference:
\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_iscollection}{ST_ISCOLLECTION}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_dimension}{ST_DIMENSION}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_numpoints}{ST_NUMPOINTS}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_isempty}{ST_ISEMPTY}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_area}{ST_AREA}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_length}{ST_LENGTH}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_perimeter}{ST_PERIMETER}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_x}{ST_X}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_y}{ST_Y}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_distance}{ST_DISTANCE}
\item \href{https://cloud.google.com/bigquery/docs/reference/standard-sql/geography_functions#st_maxdistance}{ST_MAXDISTANCE}
}
}
