% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.tpm.R
\name{power.tpm}
\alias{power.tpm}
\title{Statistical power of truncated product method test under Gaussian mixture model.}
\usage{
power.tpm(alpha, n, tau1, eps = 0, mu = 0)
}
\arguments{
\item{alpha}{- type-I error rate.}

\item{n}{- dimension parameter, i.e. the number of input p-values.}

\item{tau1}{- truncation parameter. 0 < tau1 <= 1. tau1 > 0.}

\item{eps}{- mixing parameter of the Gaussian mixture.}

\item{mu}{- mean of non standard Gaussian model.}
}
\value{
Power of the truncated product method test.
}
\description{
Statistical power of truncated product method test under Gaussian mixture model.
}
\details{
We consider the following hypothesis test,
\deqn{H_0: X_i\sim F_0, H_a: X_i\sim (1-\epsilon)F_0+\epsilon F_1}
, where \eqn{\epsilon} is the mixing parameter,
\eqn{F_0} is the standard normal CDF and \eqn{F = F_1} is the CDF of normal distribution with \eqn{\mu} defined by mu and \eqn{\sigma = 1}.
}
\examples{
alpha = 0.05
#If the alternative hypothesis Gaussian mixture with eps = 0.1 and mu = 1.2:#
power.tpm(alpha, 100, 0.05, eps = 0.1, mu = 1.2)
}
\references{
1. Hong Zhang and Zheyang Wu. "TFisher Tests: Optimal and Adaptive Thresholding for Combining p-Values", submitted.
}
\seealso{
\code{\link{stat.soft}} for the definition of the statistic.
}
