% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tour_length.R
\name{tour_length}
\alias{tour_length}
\alias{tour_length.TSP}
\alias{tour_length.ATSP}
\alias{tour_length.ETSP}
\alias{tour_length.TOUR}
\alias{tour_length.integer}
\title{Calculate the length of a tour}
\usage{
tour_length(x, ...)

\method{tour_length}{TSP}(x, order, ...)

\method{tour_length}{ATSP}(x, order, ...)

\method{tour_length}{ETSP}(x, order, ...)

\method{tour_length}{TOUR}(x, tsp = NULL, ...)

\method{tour_length}{integer}(x, tsp = NULL, ...)
}
\arguments{
\item{x}{a TSP problem or a \link{TOUR}.}

\item{...}{further arguments are currently unused.}

\item{order}{an object of class \code{TOUR}}

\item{tsp}{as TSP object.}
}
\description{
Calculate the length of a \link{TOUR} for a \link{TSP}.
}
\details{
If no \code{tsp} is specified, then the tour length stored in \code{x} as
attribute \code{"tour_length"} is returned.  If \code{tsp} is given then the
tour length is recalculated using the specified TSP problem.

If a distance in the tour is infinite, the result is also infinite. If the
tour contains positive and negative infinite distances then the method
returns \code{NA}.
}
\examples{

data("USCA50")

## original order
tour_length(solve_TSP(USCA50, method="identity"))

## length of a manually created (random) tour
tour <- TOUR(sample(seq(n_of_cities(USCA50))))
tour
tour_length(tour)
tour_length(tour, USCA50)
}
\seealso{
Other TOUR: 
\code{\link{TOUR}()},
\code{\link{cut_tour}()},
\code{\link{solve_TSP}()}
}
\author{
Michael Hahsler
}
\concept{TOUR}
\keyword{optimize}
