#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    i18n
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_i18n
  @@language_table,@@language_list=nil,nil
  class Languages
    def language
      def table
        @@language_table ||= {
          am:    { c: 'am',    n: 'Amharic',           t: 'Amharic',                     xlp: 'amharic'          },
          bg:    { c: 'bg',    n: 'Bulgarian',         t: 'Български (Bəlgarski)',       xlp: 'bulgarian'        },
          bn:    { c: 'bn',    n: 'Bengali',           t: 'Bengali',                     xlp: 'bengali'          },
          br:    { c: 'br',    n: 'Breton',            t: 'Breton',                      xlp: 'breton'           },
          ca:    { c: 'ca',    n: 'Catalan',           t: 'catalan',                     xlp: 'catalan'          },
          cs:    { c: 'cs',    n: 'Czech',             t: 'česky',                       xlp: 'czech'            },
          cy:    { c: 'cy',    n: 'Welsh',             t: 'Welsh',                       xlp: 'welsh'            },
          da:    { c: 'da',    n: 'Danish',            t: 'dansk',                       xlp: 'danish'           },
          de:    { c: 'de',    n: 'German',            t: 'Deutsch',                     xlp: 'german'           },
          el:    { c: 'el',    n: 'Greek',             t: 'Ελληνικά (Ellinika)',         xlp: 'greek'            },
          en:    { c: 'en',    n: 'English',           t: 'English',                     xlp: 'english'          },
          eo:    { c: 'eo',    n: 'Esperanto',         t: 'Esperanto',                   xlp: 'esperanto'        },
          es:    { c: 'es',    n: 'Spanish',           t: 'español',                     xlp: 'spanish'          },
          et:    { c: 'et',    n: 'Estonian',          t: 'Estonian',                    xlp: 'estonian'         },
          eu:    { c: 'eu',    n: 'Basque',            t: 'basque',                      xlp: 'basque'           },
          fi:    { c: 'fi',    n: 'Finnish',           t: 'suomi',                       xlp: 'finnish'          },
          fr:    { c: 'fr',    n: 'French',            t: 'français',                    xlp: 'french'           },
          ga:    { c: 'ga',    n: 'Irish',             t: 'Irish',                       xlp: 'irish'            },
          gl:    { c: 'gl',    n: 'Galician',          t: 'Galician',                    xlp: 'galician'         },
          he:    { c: 'he',    n: 'Hebrew',            t: 'Hebrew',                      xlp: 'hebrew'           },
          hi:    { c: 'hi',    n: 'Hindi',             t: 'Hindi',                       xlp: 'hindi'            },
          hr:    { c: 'hr',    n: 'Croatian',          t: 'Croatian',                    xlp: 'croatian'         },
          hy:    { c: 'hy',    n: 'Armenian',          t: 'Armenian',                    xlp: 'armenian'         },
          ia:    { c: 'ia',    n: 'Interlingua',       t: 'Interlingua',                 xlp: 'interlingua'      },
          is:    { c: 'is',    n: 'Icelandic',         t: 'Icelandic',                   xlp: 'icelandic'        },
          it:    { c: 'it',    n: 'Italian',           t: 'Italiano',                    xlp: 'italian'          },
          ja:    { c: 'ja',    n: 'Japanese',          t: '日本語 (Nihongo)',            xlp: 'japanese'         },
          ko:    { c: 'ko',    n: 'Korean',            t: 'Korean',                      xlp: 'korean'           },
          la:    { c: 'la',    n: 'Latin',             t: 'Latin',                       xlp: 'latin'            },
          lo:    { c: 'lo',    n: 'Lao',               t: 'Lao',                         xlp: 'lao'              },
          lt:    { c: 'lt',    n: 'Lithuanian',        t: 'Lithuanian',                  xlp: 'lithuanian'       },
          lv:    { c: 'lv',    n: 'Latvian',           t: 'Latvian',                     xlp: 'latvian'          },
          ml:    { c: 'ml',    n: 'Malayalam',         t: 'Malayalam',                   xlp: 'malayalam'        },
          mr:    { c: 'mr',    n: 'Marathi',           t: 'Marathi',                     xlp: 'marathi'          },
          nl:    { c: 'nl',    n: 'Dutch',             t: 'Nederlands',                  xlp: 'dutch'            },
          no:    { c: 'no',    n: 'Norwegian',         t: 'norsk',                       xlp: 'norsk'            },
          nn:    { c: 'nn',    n: 'Norwegian Nynorsk', t: 'nynorsk',                     xlp: 'nynorsk'          },
          oc:    { c: 'oc',    n: 'Occitan',           t: 'Occitan',                     xlp: 'occitan'          },
          pl:    { c: 'pl',    n: 'Polish',            t: 'polski',                      xlp: 'polish'           },
          pt:    { c: 'pt',    n: 'Portuguese',        t: 'Português',                   xlp: 'portuges'         },
          pt_BR: { c: 'pt_BR', n: 'Portuguese Brazil', t: 'Brazilian Português',         xlp: 'brazilian'        },
          ro:    { c: 'ro',    n: 'Romanian',          t: 'română',                      xlp: 'romanian'         },
          ru:    { c: 'ru',    n: 'Russian',           t: 'Русский (Russkij)',           xlp: 'russian'          },
          sa:    { c: 'sa',    n: 'Sanskrit',          t: 'Sanskrit',                    xlp: 'sanskrit'         },
          se:    { c: 'se',    n: 'Sami',              t: 'Samin',                       xlp: 'samin'            },
          sk:    { c: 'sk',    n: 'Slovak',            t: 'slovensky',                   xlp: 'slovak'           },
          sl:    { c: 'sl',    n: 'Slovenian',         t: 'Slovenian',                   xlp: 'slovenian'        },
          sq:    { c: 'sq',    n: 'Albanian',          t: 'Albanian',                    xlp: 'albanian'         },
          sr:    { c: 'sr',    n: 'Serbian',           t: 'Serbian',                     xlp: 'serbian'          },
          sv:    { c: 'sv',    n: 'Swedish',           t: 'svenska',                     xlp: 'swedish'          },
          ta:    { c: 'ta',    n: 'Tamil',             t: 'Tamil',                       xlp: 'tamil'            },
          te:    { c: 'te',    n: 'Telugu',            t: 'Telugu',                      xlp: 'telugu'           },
          th:    { c: 'th',    n: 'Thai',              t: 'Thai',                        xlp: 'thai'             },
          tk:    { c: 'tk',    n: 'Turkmen',           t: 'Turkmen',                     xlp: 'turkmen'          },
          tr:    { c: 'tr',    n: 'Turkish',           t: 'Türkçe',                      xlp: 'turkish'          },
          uk:    { c: 'uk',    n: 'Ukranian',          t: 'українська (ukrajins\'ka)',   xlp: 'ukrainian'        },
          ur:    { c: 'ur',    n: 'Urdu',              t: 'Urdu',                        xlp: 'urdu'             },
          us:    { c: 'en',    n: 'English (American)',t: 'English',                     xlp: 'english'          },
          vi:    { c: 'vi',    n: 'Vietnamese',        t: 'Vietnamese',                  xlp: 'vietnamese'       },
          zh:    { c: 'zh',    n: 'Chinese',           t: '中文',                        xlp: 'chinese'          },
          en:    { c: 'en',    n: 'English',           t: 'English',                     xlp: 'english'          },
          xx:    { c: 'xx',    n: 'Default',           t: 'English',                     xlp: 'english'          },
        }
      end
      def list
        @@language_list ||= {
          'am'    => table[:am],
          'bg'    => table[:bg],
          'bn'    => table[:bn],
          'br'    => table[:br],
          'ca'    => table[:ca],
          'cs'    => table[:cs],
          'cy'    => table[:cy],
          'da'    => table[:da],
          'de'    => table[:de],
          'el'    => table[:el],
          'en'    => table[:en],
          'eo'    => table[:eo],
          'es'    => table[:es],
          'et'    => table[:et],
          'eu'    => table[:eu],
          'fi'    => table[:fi],
          'fr'    => table[:fr],
          'ga'    => table[:ga],
          'gl'    => table[:gl],
          'he'    => table[:he],
          'hi'    => table[:hi],
          'hr'    => table[:hr],
          'hy'    => table[:hy],
          'ia'    => table[:ia],
          'is'    => table[:is],
          'it'    => table[:it],
          'ja'    => table[:ja],
          'ko'    => table[:ko],
          'la'    => table[:la],
          'lo'    => table[:lo],
          'lt'    => table[:lt],
          'lv'    => table[:lv],
          'ml'    => table[:ml],
          'mr'    => table[:mr],
          'nl'    => table[:nl],
          'no'    => table[:no],
          'nn'    => table[:nn],
          'oc'    => table[:oc],
          'pl'    => table[:pl],
          'pt'    => table[:pt],
          'pt_BR' => table[:pt_BR],
          'ro'    => table[:ro],
          'ru'    => table[:ru],
          'sa'    => table[:sa],
          'se'    => table[:se],
          'sk'    => table[:sk],
          'sl'    => table[:sl],
          'sq'    => table[:sq],
          'sr'    => table[:sr],
          'sv'    => table[:sv],
          'ta'    => table[:ta],
          'te'    => table[:te],
          'th'    => table[:th],
          'tk'    => table[:tk],
          'tr'    => table[:tr],
          'uk'    => table[:uk],
          'ur'    => table[:ur],
          'us'    => table[:en],
          'vi'    => table[:vi],
          'zh'    => table[:zh],
          'en'    => table[:en],
          'xx'    => table[:en]
        }
      end
      self
    end
  end
  class Alphabet
    def initialize(lng_code)
      @lng_code=lng_code
    end
    def hash_arrays
      @alph=case @lng_code
      when /en/                                                              #english
        {
          u: %w[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z],
          l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z]
        }
      when /da|no|nn/                                                        #danish, norwegian
        {
          u: %w[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z Å Æ Ø],
          l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z å æ ø]
          #u: %W[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z Æ Ø Å],
          #l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z æ ø å]
        }
      when /sv/                                                              #swedish
        {
          u: %w[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z Å Ä Ö],
          l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z å ä ö]
        }
      else                                                                   #english default
        {
          u: %w[A B C D E F G H I J K L M N O P Q R S T U V W X Y Z],
          l: %w[a b c d e f g h i j k l m n o p q r s t u v w x y z]
        }
      end
    end
    def hash_strings
      { u: hash_arrays[:u].join, l: hash_arrays[:l].join }
    end
  end
end
__END__
Language Lists
* po4a c:
  <http://www.debian.org/international/l10n/po/>
  Px[:lng_lst] see constants.rb
* polyglossia xlp:
  <http://mirrors.ctan.org/macros/xetex/latex/polyglossia/polyglossia.pdf>
  missing from (:c) list:
    arabic asturian bahasai bahasam coptic divehi farsi lsorbian magyar scottish syriac usorbian
note ISO_639-1
  <http://en.wikipedia.org/wiki/ISO_639-1>
  <http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes>
also note ISO_639-2
  <http://en.wikipedia.org/wiki/ISO_639-2>
  <http://en.wikipedia.org/wiki/List_of_ISO_639-2_codes>

Px[:lng_lst] # constants.rb

module SiSU_TextTranslation
  class Language
    def initialize(md)
      @md=md
    end
    def tex_name(char)
      @lang=if char
        case char
        when 'sq'    then 'albanian'
        when 'am'    then 'amharic'
       #when 'ar'    then 'arabic'         # see polyglossia
        when 'hy'    then 'armenian'
       #when ''      then 'asturian'       # polyglossia
       #when ''      then 'bahasai'        # polyglossia
       #when ''      then 'bahasam'        # polyglossia
        when 'eu'    then 'basque'
        when 'bn'    then 'bengali'
        when 'pt_BR' then 'brazilian'
        when 'br'    then 'breton'
        when 'bg'    then 'bulgarian'
        when 'ca'    then 'catalan'        # see polyglossia
       #when ''      then 'coptic'         # polyglossia
        when 'hr'    then 'croatian'
        when 'cs'    then 'czech'
        when 'da'    then 'danish'
       #when ''      then 'divehi'         # polyglossia
        when 'nl'    then 'dutch'          # see polyglossia
        when 'en'    then 'english'        # see polyglossia
        when 'eo'    then 'esperanto'      # see polyglossia
        when 'et'    then 'estonian'
        when 'gl'    then 'galician'
        when 'de'    then 'german'
        when 'el'    then 'greek'          #gl ?
        when 'he'    then 'hebrew'
        when 'hi'    then 'hindi'
        when 'is'    then 'icelandic'
        when 'ia'    then 'interlingua'
        when 'ga'    then 'irish'
        when 'it'    then 'italian'
       #when ''      then 'farsi'          # polyglossia
        when 'fi'    then 'finnish'
        when 'fr'    then 'french'
        when 'lo'    then 'lao'
        when 'la'    then 'latin'
        when 'lv'    then 'latvian'
        when 'lt'    then 'lithuanian'
       #when ''      then 'lsorbian'       # polyglossia
       #when ''      then 'magyar'         # polyglossia
        when 'ml'    then 'malayalam'
        when 'mr'    then 'marathi'
       #when 'hu'    then 'magyar'
        when 'no'    then 'norske'
        when 'nn'    then 'nynorsk'
        when 'oc'    then 'occitan'
        when 'pl'    then 'polish'
        when 'pt'    then 'portuges'
        when 'ro'    then 'romanian'
        when 'ru'    then 'russian'
        when 'se'    then 'samin'          #(check sami?)
        when 'sa'    then 'sanskrit'
        when 'sr'    then 'serbian'
       #when ''      then 'scottish'       # polyglossia  (gd (Gaelic (Scots)))
        when 'sk'    then 'slovak'
        when 'sl'    then 'slovenian'
        when 'es'    then 'spanish'
        when 'sv'    then 'swedish'
        when 'ta'    then 'tamil'
        when 'te'    then 'telugu'
        when 'th'    then 'thai'
        when 'tr'    then 'turkish'
        when 'tk'    then 'turkmen'
        when 'uk'    then 'ukrainian'
        when 'ur'    then 'urdu'
       #when ''      then 'usorbian'       # polyglossia
        when 'vi'    then 'vietnamese'
        when 'cy'    then 'welsh'
        when 'us'    then 'USenglish'      # depreciated, see iso-639-2
        else         then 'english'
        end
      else            'english'
      end
    end
  end
end
__END__
