#define XERR "cron"
#include "cron.ih"

    // via Fork

void Cron::parentProcess()
{
        // stream sending commands to the (remote) ssh server via the child
    OFdStream toChild(d_childInput.writeOnly());
    d_toChild = &toChild;

    defineRun();                            // define the bash _run_ function
    
                // add private ssh keys to ssh-agent. Those keys must be
                // available when ssh-cron starts. Commands sent to remote
                // hosts can thereafter use the private keys to connect, even
                // if the private keys are locally made unavailable once
                // ssh-cron has started.
    childExec("/usr/bin/ssh-add");

    thread{ &Cron::cronCmds, this }.detach();

    d_server.open(d_options.uds());
    d_server.listen();

    Signal::instance().add(SIGTERM, *this);
    Signal::instance().add(SIGINT, *this);

    while (true)
    {
        int fd = d_server.accept();

        d_in.reset(new IFdStream{ fd });        // cf. sshcron/tocron.cc
        d_out.reset(new OFdStream{ fd });

        string line;
        if (not getline(*d_in, line))
        {
            d_in->clear();
            continue;
        }

        request(line);                      // process the received request
    }
}







