'use strict'

var STR_UNDEFINED = 'undefined'
var STR_OBJECT    = 'object'
var HAS_OWN       = Object.prototype.hasOwnProperty

var copyListIf = require('./copyListIf')

/**
 * Copies all properties named in the namedKeys, from source to destination,
 * but only if the property does not already exist in the destination object
 *
 *      copyKeysIf({name: 'jon',age:5, year: 2006}, {aname: 'test'}, {name:'aname' ,age: true})
 *      // => {aname: 'test', age: 5}
 *
 * @param {Object} source
 * @param {Object} destination
 * @param {Object} namedKeys an object with keys denoting the properties to be copied
 *
 * @return {Object} destination
 */
module.exports = function(source, destination, namedKeys){
    if (arguments.length < 3 ){
        namedKeys = destination
        destination = null
    }

    destination = destination || {}

    if (!namedKeys || Array.isArray(namedKeys)){
        return copyListIf(source, destination, namedKeys)
    }

    if (
               source != null && typeof source    === STR_OBJECT &&
            namedKeys != null && typeof namedKeys === STR_OBJECT
        ) {

            var typeOfNamedProperty
            var namedPropertyValue
            var newPropertyName

            for (var propName in namedKeys) if ( HAS_OWN.call(namedKeys, propName) ) {

                namedPropertyValue  = namedKeys[propName]
                typeOfNamedProperty = typeof namedPropertyValue
                newPropertyName     = typeOfNamedProperty == 'string'? namedPropertyValue : propName

                if (
                        typeof      source[propName]        !== STR_UNDEFINED &&
                        typeof destination[newPropertyName] === STR_UNDEFINED
                    ) {
                    destination[newPropertyName] = source[propName]
                }

            }
        }

    return destination
}