describe('Find', function(){

    var should = require('should')

    var find = require('../index').find

    it('should find in an array', function(){
        var obj = {
            name: 'three'
        }

        var found = find(function(it){
            return it.name == 'three'
        }, [2, obj, 4])

        found
            .should
            .equal(obj)
    })

    it('should find in an object', function(){
        var obj = {
            name: 'three'
        }

        var found = find(function(it){
            return it.name == 'three'
        }, {
            key: 'x',
            unknown: obj
        })


        found
            .should
            .equal(obj)
    })

    it('should be curried', function(){
        var findFirst = find(function(obj, i, arr){
            if (i == 0){
                return obj
            }
        })

        findFirst([4,5,6])
            .should
            .equal(4)

        findFirst([14,5,6])
            .should
            .equal(14)
    })

    it('should work with onFound', function(){
        var index = find(function(n){
            return n == 4
        }, [5,4,7,9], function(n, i){
            return i
        })

        should(index).equal(1)
    })
})