<?php

namespace App\Command;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\Finder\Finder;
use Ramsey\Uuid\Uuid;

use App\Entity\Script;

class ScriptCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;

    public function __construct(ContainerInterface $container,EntityManagerInterface $em)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
    }


    protected function configure()
    {
        $this
            ->setName('app:Script')
            ->setDescription('Script to call')
            ->setHelp('Script to call')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output           = $output;
        $this->filesystem       = new Filesystem();
        $this->rootlog          = $this->container->get('kernel')->getLogDir()."/";

        $output->writeln('APP = Scripts');

        $this->callscript("addapikey");
        $this->callscript("moveimages");

        $output->writeln('');

        return Command::SUCCESS;
    }


    private function callscript($name) {    
        $script=$this->em->getRepository("App:Script")->findOneBy(["name"=>$name]);
        if(!$script) {
            //$this->writelnred("== SCRIPT = ".$name);
            $this->$name();

            $script=new Script();
            $script->setName($name);
            $this->em->persist($script);
            $this->em->flush();
            $this->writeln("");                  
        }
    }

    private function addapikey() {
        $users=$this->em->getRepository("App:User")->findBy(["apikey"=>null]);
        foreach($users as $user) {
            $key = Uuid::uuid4();
            $user->setApikey($key);                  
            $this->em->persist($user);
            $this->em->flush();            
        }
    }

    private function moveimages() {
        $fs = new Filesystem();
        
        $whiteboardwidgets=$this->em->getRepository("App:Whiteboardwidget")->findAll();
        $dir=$this->container->get('kernel')->getProjectDir()."/public/uploads";
        $racine=$dir."/whiteboard";
        foreach($whiteboardwidgets as $whiteboardwidget) {
            if($whiteboardwidget->getFiletype()=="image") {
                $id=$whiteboardwidget->getWhiteboard()->getId();
                $file=$whiteboardwidget->getFile();
                $fs->mkdir($racine."/".$id);
                if($fs->exists($racine."/".$file)) {
                    $fs->rename($racine."/".$file,$racine."/".$id."/".$file, true);
                }
            }
        }

        $scrumwidgets=$this->em->getRepository("App:Scrumwidget")->findAll();
        $dir=$this->container->get('kernel')->getProjectDir()."/public/uploads";
        $racine=$dir."/scrum";
        foreach($scrumwidgets as $scrumwidget) {
            if($scrumwidget->getFiletype()=="image") {
                $id=$scrumwidget->getScrumcolumn()->getScrum()->getId();
                $file=$scrumwidget->getFile();
                $fs->mkdir($racine."/".$id);
                if($fs->exists($racine."/".$file)) {
                    $fs->rename($racine."/".$file,$racine."/".$id."/".$file, true);
                }
            }
        }

        $timelines=$this->em->getRepository("App:Timeline")->findAll();
        $dir=$this->container->get('kernel')->getProjectDir()."/public/uploads";
        $racine=$dir."/timeline";
        foreach($timelines as $timeline) {
            if($timeline->getUsebackground()) {
                $id=$timeline->getId();
                $file=$timeline->getBackground();
                $fs->mkdir($racine."/".$id);
                if($fs->exists($racine."/".$file)) {
                    $fs->rename($racine."/".$file,$racine."/".$id."/".$file, true);
                }
            }
        }        

        $timelinesegments=$this->em->getRepository("App:Timelinesegment")->findAll();
        $dir=$this->container->get('kernel')->getProjectDir()."/public/uploads";
        $racine=$dir."/timeline";
        foreach($timelinesegments as $timelinesegment) {
            if($timelinesegment->getUsebackground()) {
                $id=$timelinesegment->getTimeline()->getId();
                $file=$timelinesegment->getBackground();
                $fs->mkdir($racine."/".$id);
                if($fs->exists($racine."/".$file)) {
                    $fs->rename($racine."/".$file,$racine."/".$id."/".$file, true);
                }
            }
        }        

        $timelinedates=$this->em->getRepository("App:Timelinedate")->findAll();
        $dir=$this->container->get('kernel')->getProjectDir()."/public/uploads";
        $racine=$dir."/timeline";
        foreach($timelinedates as $timelinedate) {
            if($timelinedate->getUsebackground()) {
                $id=$timelinedate->getTimeline()->getId();
                $file=$timelinedate->getBackground();
                $fs->mkdir($racine."/".$id);
                if($fs->exists($racine."/".$file)) {
                    $fs->rename($racine."/".$file,$racine."/".$id."/".$file, true);
                }
            }
        }
        
        // Rangement des fichiers uploadés dans ckeditor
        $directory=$this->container->get('kernel')->getProjectDir()."/public/uploads/ckeditor";
        if($fs->exists($directory)) {
            $finder = new Finder();
            $finder->in($directory)->files();

            foreach (iterator_to_array($finder) as $file) {
                $name = $file->getRelativePathname();
                $this->writeln($name);

                // Scrumwidget
                $results = $this->em
                    ->getRepository("App:Scrumwidget")
                    ->createQueryBuilder('table')
                    ->where('table.description LIKE :tofind')
                    ->setParameter('tofind', '%'.$name.'%')
                    ->getQuery()->getResult();                
                foreach($results as $result) {
                    // On récupère l'id parent
                    $id=$result->getScrumcolumn()->getScrum()->getId();

                    // On génère les répertoires de destination
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/scrum");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/scrum/$id");
                    
                    // On déplace le fichier
                    $filesource=$this->container->get('kernel')->getProjectDir()."/public/uploads/ckeditor/$name";
                    $filedestination=$this->container->get('kernel')->getProjectDir()."/public/uploads/scrum/$id/$name";
                    $fs->rename($filesource,$filedestination, true);

                    // On remplace le chemin
                    $description=$result->getDescription();
                    $result->setDescription(str_replace("/uploads/ckeditor/$name","/uploads/scrum/$id/$name",$description));
                    $this->em->persist($result);
                    $this->em->flush();   
                }

                // Whiteboardwidget
                $results = $this->em
                    ->getRepository("App:Whiteboardwidget")
                    ->createQueryBuilder('table')
                    ->where('table.description LIKE :tofind')
                    ->setParameter('tofind', '%'.$name.'%')
                    ->getQuery()->getResult();                
                foreach($results as $result) {
                    // On récupère l'id parent
                    $id=$result->getWhiteboard()->getId();

                    // On génère les répertoires de destination
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/whiteboard");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/whiteboard/$id");
                    
                    // On déplace le fichier
                    $filesource=$this->container->get('kernel')->getProjectDir()."/public/uploads/ckeditor/$name";
                    $filedestination=$this->container->get('kernel')->getProjectDir()."/public/uploads/whiteboard/$id/$name";
                    $fs->rename($filesource,$filedestination, true);

                    // On remplace le chemin
                    $description=$result->getDescription();
                    $result->setDescription(str_replace("/uploads/ckeditor/$name","/uploads/whiteboard/$id/$name",$description));
                    $this->em->persist($result);
                    $this->em->flush();  
                }   
                
                // Timelinesegment
                $results = $this->em
                    ->getRepository("App:Timelinesegment")
                    ->createQueryBuilder('table')
                    ->where('table.description LIKE :tofind')
                    ->setParameter('tofind', '%'.$name.'%')
                    ->getQuery()->getResult();                
                foreach($results as $result) {
                    // On récupère l'id parent
                    $id=$result->getTimeline()->getId();

                    // On génère les répertoires de destination
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/timeline");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/timeline/$id");
                    
                    // On déplace le fichier
                    $filesource=$this->container->get('kernel')->getProjectDir()."/public/uploads/ckeditor/$name";
                    $filedestination=$this->container->get('kernel')->getProjectDir()."/public/uploads/timeline/$id/$name";
                    $fs->rename($filesource,$filedestination, true);

                    // On remplace le chemin
                    $description=$result->getDescription();
                    $result->setDescription(str_replace("/uploads/ckeditor/$name","/uploads/timeline/$id/$name",$description));
                    $this->em->persist($result);
                    $this->em->flush();  
                }  
                
                // Timelinedate
                $results = $this->em
                    ->getRepository("App:Timelinedate")
                    ->createQueryBuilder('table')
                    ->where('table.description LIKE :tofind')
                    ->setParameter('tofind', '%'.$name.'%')
                    ->getQuery()->getResult();                
                foreach($results as $result) {
                    // On récupère l'id parent
                    $id=$result->getTimeline()->getId();

                    // On génère les répertoires de destination
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/timeline");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/timeline/$id");
                    
                    // On déplace le fichier
                    $filesource=$this->container->get('kernel')->getProjectDir()."/public/uploads/ckeditor/$name";
                    $filedestination=$this->container->get('kernel')->getProjectDir()."/public/uploads/timeline/$id/$name";
                    $fs->rename($filesource,$filedestination, true);

                    // On remplace le chemin
                    $description=$result->getDescription();
                    $result->setDescription(str_replace("/uploads/ckeditor/$name","/uploads/timeline/$id/$name",$description));
                    $this->em->persist($result);
                    $this->em->flush();  
                }   
                
                
                // Document
                $results = $this->em
                    ->getRepository("App:Document")
                    ->createQueryBuilder('table')
                    ->where('table.description LIKE :tofind')
                    ->setParameter('tofind', '%'.$name.'%')
                    ->getQuery()->getResult();                
                foreach($results as $result) {
                    // On récupère l'id parent
                    $id=null;
                    $type=null;
                    if($result->getWhiteboardwidget()) {
                        $type="whiteboard";
                        $id=$result->getWhiteboardwidget()->getWhiteboard()->getId();
                    }
                    elseif($result->getScrumwidget()) {
                        $type="scrum";
                        $id=$result->getScrumwidget()->getScrumcolumn()->getScrum()->getId();
                    }

                    // On génère les répertoires de destination
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/$type");
                    $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/$type/$id");
                    
                    // On déplace le fichier
                    $filesource=$this->container->get('kernel')->getProjectDir()."/public/uploads/ckeditor/$name";
                    $filedestination=$this->container->get('kernel')->getProjectDir()."/public/uploads/$type/$id/$name";
                    $fs->rename($filesource,$filedestination, true);

                    // On remplace le chemin
                    $description=$result->getDescription();
                    $result->setDescription(str_replace("/uploads/ckeditor/$name","/uploads/$type/$id/$name",$description));
                    $this->em->persist($result);
                    $this->em->flush();  
                } 
                
                // Message
                $results = $this->em
                    ->getRepository("App:Message")
                    ->createQueryBuilder('table')
                    ->where('table.message LIKE :tofind')
                    ->setParameter('tofind', '%'.$name.'%')
                    ->getQuery()->getResult();                
                foreach($results as $result) {
                    // On récupère l'id parent
                    $id=null;
                    $type=null;
                    if($result->getWhiteboardwidget()) {
                        $type="whiteboard";
                        $id=$result->getWhiteboardwidget()->getWhiteboard()->getId();
                    }
                    elseif($result->getScrumwidget()) {
                        $type="scrum";
                        $id=$result->getScrumwidget()->getScrumcolumn()->getScrum()->getId();
                    }

                    if($id) {
                        // On génère les répertoires de destination
                        $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads");
                        $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/$type");
                        $fs->mkdir($this->container->get('kernel')->getProjectDir()."/public/uploads/$type/$id");
                        
                        // On déplace le fichier
                        $filesource=$this->container->get('kernel')->getProjectDir()."/public/uploads/ckeditor/$name";
                        $filedestination=$this->container->get('kernel')->getProjectDir()."/public/uploads/$type/$id/$name";
                        $fs->rename($filesource,$filedestination, true);

                        // On remplace le chemin
                        $description=$result->getMessage();
                        $result->setMessage(str_replace("/uploads/ckeditor/$name","/uploads/$type/$id/$name",$description));
                        $this->em->persist($result);
                        $this->em->flush();  
                    }
                }                 
            }
        }
    }    


    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }     
}
