<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Scrum
 *
 * @ORM\Table(name="scrumwidget")
 * @ORM\Entity(repositoryClass="App\Repository\ScrumwidgetRepository")
 * 
 */
class Scrumwidget
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="colorbody", type="string", nullable=true)
     */
    private $colorbody;

    /**
     * @ORM\Column(name="colorfont", type="string", nullable=true)
     */
    private $colorfont;
    
    /**
     * @ORM\Column(name="filetype", type="string", nullable=true)
     */
    private $filetype;

    /**
     * @ORM\Column(name="file", type="string", nullable=true)
     */
    private $file;

    /**
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @ORM\ManyToOne(targetEntity="Scrumcolumn", inversedBy="scrumwidgets")
     */
    private $scrumcolumn;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="scrumwidgets")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="scrumwidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $scrumwidgetdocuments;

    /**
     * @ORM\OneToMany(targetEntity="Message", mappedBy="scrumwidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $messages;
        
    public function __construct()
    {
        $this->scrumwidgetdocuments = new ArrayCollection();
        $this->messages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getFiletype(): ?string
    {
        return $this->filetype;
    }

    public function setFiletype(?string $filetype): self
    {
        $this->filetype = $filetype;

        return $this;
    }

    public function getFile(): ?string
    {
        return $this->file;
    }

    public function setFile(?string $file): self
    {
        $this->file = $file;

        return $this;
    }

    public function getRoworder(): ?int
    {
        return $this->roworder;
    }

    public function setRoworder(int $roworder): self
    {
        $this->roworder = $roworder;

        return $this;
    }

    public function getScrumcolumn(): ?Scrumcolumn
    {
        return $this->scrumcolumn;
    }

    public function setScrumcolumn(?Scrumcolumn $scrumcolumn): self
    {
        $this->scrumcolumn = $scrumcolumn;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Document[]
     */
    public function getScrumwidgetdocuments(): Collection
    {
        return $this->scrumwidgetdocuments;
    }

    public function addScrumwidgetdocument(Document $scrumwidgetdocument): self
    {
        if (!$this->scrumwidgetdocuments->contains($scrumwidgetdocument)) {
            $this->scrumwidgetdocuments[] = $scrumwidgetdocument;
            $scrumwidgetdocument->setScrumwidget($this);
        }

        return $this;
    }

    public function removeScrumwidgetdocument(Document $scrumwidgetdocument): self
    {
        if ($this->scrumwidgetdocuments->contains($scrumwidgetdocument)) {
            $this->scrumwidgetdocuments->removeElement($scrumwidgetdocument);
            // set the owning side to null (unless already changed)
            if ($scrumwidgetdocument->getScrumwidget() === $this) {
                $scrumwidgetdocument->setScrumwidget(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Message[]
     */
    public function getMessages(): Collection
    {
        return $this->messages;
    }

    public function addMessage(Message $message): self
    {
        if (!$this->messages->contains($message)) {
            $this->messages[] = $message;
            $message->setScrumwidget($this);
        }

        return $this;
    }

    public function removeMessage(Message $message): self
    {
        if ($this->messages->contains($message)) {
            $this->messages->removeElement($message);
            // set the owning side to null (unless already changed)
            if ($message->getScrumwidget() === $this) {
                $message->setScrumwidget(null);
            }
        }

        return $this;
    }

    public function getColorbody(): ?string
    {
        return $this->colorbody;
    }

    public function setColorbody(?string $colorbody): self
    {
        $this->colorbody = $colorbody;

        return $this;
    }

    public function getColorfont(): ?string
    {
        return $this->colorfont;
    }

    public function setColorfont(?string $colorfont): self
    {
        $this->colorfont = $colorfont;

        return $this;
    }
}
