<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

class EthercalcType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('submit', SubmitType::class, [
                    'label'                 => 'Valider',
                    'attr'                  => ['class' => 'btn btn-success']
            ]);

        $builder
            ->add('title', TextType::class, [
                    'label'                 => 'Titre',
                    'disabled'              => ($options["mode"]=="submit"?false:true),
                    'attr'                  => ['class' => 'form-control', 'style' => 'margin-bottom:15px']
            ]);


        $builder
            ->add('groups', Select2EntityType::class, [
                    'label'                 => 'Visible pour les Groupes',
                    'class'                 => 'App:Group',
                    'multiple'              => true,
                    'remote_route'          => 'app_group_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'name',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des groupes',                        
            ]);            

        $builder
            ->add('users', Select2EntityType::class, [
                    'label'                 => 'Visible pour les Utilisateurs',
                    'class'                 => 'App:User',
                    'multiple'              => true,
                    'remote_route'          => 'app_user_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des utilisateurs',                        
            ]); 
        
        if($options["access"]=="admin") {
            $builder
                ->add('user', Select2EntityType::class, [
                        'label'                 => 'Propriétaire',
                        'class'                 => 'App:User',
                        'multiple'              => false,
                        'required'              => true,
                        'remote_route'          => 'app_user_select',
                        'primary_key'           => 'id',
                        'text_property'         => 'displayname',
                        'minimum_input_length'  => 0,
                        'page_limit'            => 100,
                        'allow_clear'           => true,
                        'delay'                 => 250,
                        'cache'                 => false,
                        'cache_timeout'         => 60000,
                        'language'              => 'fr',
                        'placeholder'           => 'Sélectionner un utilisateurs',                        
                ]);            
        }            
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'App\Entity\Ethercalc',
            'mode' => "string",
            'access' => "string",
        ));
    }
}
