<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Doctrine\Persistence\ManagerRegistry;

use App\Service\MessageService;

use App\Entity\Bookmark;
use App\Form\BookmarkType;

class BookmarkController extends AbstractController
{
    private $nameentity  = 'Bookmark';
    private $labelentity = 'App\Entity\Bookmark';
    private $labelroute  = 'app_portal_config_bookmark';
    private $labeldata   = 'bookmark';
    private $labeldatas  = 'bookmarks';
    
    private $wss;
    
    public function __construct(messageService $wss)
    {
        $this->wss = $wss;
    }

    public function submit($idpage,$idwidget,$touser,$access="config",Request $request, ManagerRegistry $em)
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Initialisation de l'enregistrement
        $data = new Bookmark();
        
        // On s'assure que le widget existe
        $pagewidget=null;
        if($touser=="false") {
            $pagewidget = $em->getRepository("App\Entity\Pagewidget")->find($idwidget);
            if (!$pagewidget) throw $this->createNotFoundException('Unable to find entity.');

            // Vérifier que cet enregistrement est modifiable
            if($access=="user") {
                if($usage=="user") {
                    $user=$pagewidget->getPage()->getUser();
                    if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
                }
                elseif($usage=="group") {
                    $groupentity=$em->getRepository("App\Entity\Group")->find($group);
                    $usergroup=$em->getRepository("App\Entity\UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                    if(!$usergroup or $usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
                }
            }
        }

        // Création du formulaire
        $form = $this->createForm(BookmarkType::class,$data,array("mode"=>"submit"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  

            // Bookmark widget ou desktop
            if($touser=="true")
                $data->setUser($this->getUser());
            else 
                $data->setPagewidget($pagewidget);

            // Icon
            $idicon = $form->get('idicon')->getData();
            $icon=$em->getRepository("App\Entity\Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);                

            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            if($pagewidget) {
                foreach($pagewidget->getPage()->getGroups() as $groupchat) {
                    if($groupchat->getFgcanshare()) {
                        $message="Création favoris<br><a href='".$data->getUrl()."' target='_blank'>".$data->getTitle()."</a>";
                        $this->wss->addMessage($this->getUser()->getApikey(),$groupchat->getId(),$message);
                    }
                }
            }

            // Retour à la page
            return $this->redirect($this->generateUrl('app_portal_'.$access.'_page_view',["id"=>$idpage,"usage"=>$usage,"group"=>$group]));
        }
        
        $icons=$em->getRepository("App\Entity\Icon")->findBy(["user"=>null]);
        $iconsuser=null;
        if($access=="user") $iconsuser=$em->getRepository("App\Entity\Icon")->findBy(["user"=>$this->getUser()]);

        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),                
            'entity'            => $data,
            'icons'             => $icons,
            'iconsuser'         => $iconsuser,
            'mode'              => "submit",
            'access'            => $access,   
            'idpage'            => $idpage,         
            'form'              => $form->createView(),
            'usage'             => $usage,
            'group'             => $group
        ]);
    }  

    public function update($idpage,$id,$access="config",Request $request, ManagerRegistry $em)
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');

        // Vérifier que cet enregistrement est modifiable
        $user=$data->getUser();
        if($user) {
            if($usage=="user")
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
        }
        elseif($access=="user") {
            if($usage=="user") {
                $user=$data->getPagewidget()->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            else {
                $groupentity=$em->getRepository("App\Entity\Group")->find($group);
                $usergroup=$em->getRepository("App\Entity\UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup or $usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }

        // Création du formulaire
        $form = $this->createForm(BookmarkType::class,$data,array(
            "mode"      => "update",
            "idicon"    => ($data->getIcon()?$data->getIcon()->getId():null),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            // Icon
            $idicon = $form->get('idicon')->getData();
            $icon=$em->getRepository("App\Entity\Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);  

            // Sauvegarde
            $em->getManager()->flush();

            $pagewidget=$data->getPagewidget();
            if($pagewidget) {
                foreach($pagewidget->getPage()->getGroups() as $groupchat) {
                    if($groupchat->getFgcanshare()) {
                        $message="Modification favoris<br><a href='".$data->getUrl()."' target='_blank'>".$data->getTitle()."</a>";
                        $this->wss->addMessage($this->getUser()->getApikey(),$groupchat->getId(),$message);
                    }
                }
            }

            // Retour à la page
            return $this->redirect($this->generateUrl('app_portal_'.$access.'_page_view',["id"=>$idpage,"usage"=>$usage,"group"=>$group]));
        }
        
        $icons=$em->getRepository("App\Entity\Icon")->findBy(["user"=>null]);
        $iconsuser=null;
        if($access=="user") $iconsuser=$em->getRepository("App\Entity\Icon")->findBy(["user"=>$this->getUser()]);

        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),                
            'entity'            => $data,
            'icons'             => $icons,
            'iconsuser'         => $iconsuser,
            'mode'              => "update",
            'access'            => $access,   
            'idpage'            => $idpage,         
            'form'              => $form->createView(),
            'usage'             => $usage,
            'group'             => $group
        ]);
    }

    public function delete($idpage,$id,$access="config",Request $request, ManagerRegistry $em)
    {
        $usage=$request->query->get('usage');
        $group=$request->query->get('group');

        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');

        // Vérifier que cet enregistrement est supprimable
        $user=$data->getUser();
        if($user) {
            if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
        }
        elseif($access=="user") {
            if($usage=="user") {
                $user=$data->getPagewidget()->getPage()->getUser();
                if($user!=$this->getUser())  throw $this->createNotFoundException('Permission denied');
            }
            else {
                $groupentity=$em->getRepository("App\Entity\Group")->find($group);
                $usergroup=$em->getRepository("App\Entity\UserGroup")->findoneby(["user"=>$this->getUser(),"group"=>$groupentity]);
                if(!$usergroup or $usergroup->getRolegroup()<50) throw $this->createNotFoundException('Permission denied');
            }
        }


        // Supprimer la donnée
        $em->getManager()->remove($data);
        $em->getManager()->flush();
        
        // Retour à la page
        return $this->redirect($this->generateUrl('app_portal_'.$access.'_page_view',["id"=>$idpage,"usage"=>$usage,"group"=>$group]));
    }

    public function heart(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $iditem=$request->request->get('iditem');

        // On s'assure que l'item existe        
        $item = $em->getRepository("App\Entity\Item")->find($iditem);
        if (!$item) throw $this->createNotFoundException('Unable to find entity.');

        // On s'assure que l'item n'existe pas déjà dans les bookmark de l'utilisateur
        $user=$this->getUser();
        $bookmark = $em->getRepository($this->labelentity)->findOneBy(["user"=>$user,"item"=>$item]);
        if(!$bookmark) {
            $bookmark = new Bookmark();
            $bookmark->setTitle($item->getTitle());
            $bookmark->setSubtitle($item->getSubtitle());
            $bookmark->setUrl($item->getUrl());
            $bookmark->setIcon($item->getIcon());
            $bookmark->setColor($item->getColor());
            $bookmark->setTarget($item->getTarget());
            $bookmark->setItem($item);
            $bookmark->setUser($user);

            $em->getManager()->persist($bookmark);
            $em->getManager()->flush();            
        }
        $output=$bookmark->getId();
        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;        
    }

    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($em,$id)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
