<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Calendar
 *
 * @ORM\Entity
 * @ORM\Table(name="calendarevent",indexes={@ORM\Index(name="uid", columns={"uid"})})
 * @ORM\Entity(repositoryClass="App\Repository\CalendareventRepository")
 * @ORM\HasLifecycleCallbacks
 */
class Calendarevent
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
    * @var string
    *
    * @ORM\Column(name="description", type="text")
    */
    private $description;

    /**
     * @ORM\Column(name="start", type="datetime")
     */
    private $start;   

    /**
     * @ORM\Column(name="end", type="datetime")
     */
    private $end;   

    /**
     * @ORM\Column(name="allday", type="boolean")
     */
    private $allday;      

    /**
     * @ORM\Column(name="uid", type="string", nullable=true)
     */
    private $uid;     

    /**
     * @var string
     *
     * @ORM\Column(name="roles", type="array",  nullable=true)
     */
    private $roles;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="calendarevents", cascade={"persist"})
     * @ORM\JoinTable(name="calendareventgroupe",
     *   joinColumns={@ORM\JoinColumn(name="calendarevent", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToOne(targetEntity="Calendar", inversedBy="calendarevents")
     */
    private $calendar;



    /**
     * Constructor
     */
    public function __construct()
    {
        $this->groups = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Calendarevent
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Calendarevent
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set start
     *
     * @param \DateTime $start
     *
     * @return Calendarevent
     */
    public function setStart($start)
    {
        $this->start = $start;

        return $this;
    }

    /**
     * Get start
     *
     * @return \DateTime
     */
    public function getStart()
    {
        return $this->start;
    }

    /**
     * Set end
     *
     * @param \DateTime $end
     *
     * @return Calendarevent
     */
    public function setEnd($end)
    {
        $this->end = $end;

        return $this;
    }

    /**
     * Get end
     *
     * @return \DateTime
     */
    public function getEnd()
    {
        return $this->end;
    }

    /**
     * Set allday
     *
     * @param boolean $allday
     *
     * @return Calendarevent
     */
    public function setAllday($allday)
    {
        $this->allday = $allday;

        return $this;
    }

    /**
     * Get allday
     *
     * @return boolean
     */
    public function getAllday()
    {
        return $this->allday;
    }

    /**
     * Set uid
     *
     * @param string $uid
     *
     * @return Calendarevent
     */
    public function setUid($uid)
    {
        $this->uid = $uid;

        return $this;
    }

    /**
     * Get uid
     *
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Set roles
     *
     * @param array $roles
     *
     * @return Calendarevent
     */
    public function setRoles($roles)
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * Add group
     *
     * @param Group $group
     *
     * @return Calendarevent
     */
    public function addGroup(Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param Group $group
     */
    public function removeGroup(Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Set calendar
     *
     * @param Calendar $calendar
     *
     * @return Calendarevent
     */
    public function setCalendar(Calendar $calendar = null)
    {
        $this->calendar = $calendar;

        return $this;
    }

    /**
     * Get calendar
     *
     * @return Calendar
     */
    public function getCalendar()
    {
        return $this->calendar;
    }
}
