<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="icon")
 * @ORM\HasLifecycleCallbacks
 * @UniqueEntity(fields="label", message="Une Icône existe déjà avec ce label")
 */
class Icon
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=250, unique=true)
     */
    private $label;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $tags;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="icons")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @var ArrayCollection $items
     * @var Item
     *
     * @ORM\OneToMany(targetEntity="Item", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $items;

    /**
     * @var ArrayCollection $itemcategorys
     * @var Itemcategory
     *
     * @ORM\OneToMany(targetEntity="Itemcategory", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $itemcategorys;

    /**
     * @var ArrayCollection $alertcategorys
     * @var Alertcategory
     *
     * @ORM\OneToMany(targetEntity="Alertcategory", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $alertcategorys;

    /**
     * @var ArrayCollection $pagewidgets
     * @var Pagewidget
     *
     * @ORM\OneToMany(targetEntity="Pagewidget", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $pagewidgets;

    /**
     * @var ArrayCollection $widgets
     * @var Widget
     *
     * @ORM\OneToMany(targetEntity="Widget", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $widgets;
    
    /**
     * @var ArrayCollection $bookmarks
     * @var Bookmark
     *
     * @ORM\OneToMany(targetEntity="Bookmark", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $bookmarks;

    /**
     * @var ArrayCollection $groups
     * @var Group
     *
     * @ORM\OneToMany(targetEntity="Group", mappedBy="icon", cascade={"persist"}, orphanRemoval=false)
     */
    private $groups;


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->items = new \Doctrine\Common\Collections\ArrayCollection();
        $this->itemcategorys = new \Doctrine\Common\Collections\ArrayCollection();
        $this->alertcategorys = new \Doctrine\Common\Collections\ArrayCollection();
        $this->pagewidgets = new \Doctrine\Common\Collections\ArrayCollection();
        $this->widgets = new \Doctrine\Common\Collections\ArrayCollection();
        $this->bookmarks = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Icon
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return Icon
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Add item
     *
     * @param Item $item
     *
     * @return Icon
     */
    public function addItem(Item $item)
    {
        $this->items[] = $item;

        return $this;
    }

    /**
     * Remove item
     *
     * @param Item $item
     */
    public function removeItem(Item $item)
    {
        $this->items->removeElement($item);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItems()
    {
        return $this->items;
    }

    /**
     * Add itemcategory
     *
     * @param Itemcategory $itemcategory
     *
     * @return Icon
     */
    public function addItemcategory(Itemcategory $itemcategory)
    {
        $this->itemcategorys[] = $itemcategory;

        return $this;
    }

    /**
     * Remove itemcategory
     *
     * @param Itemcategory $itemcategory
     */
    public function removeItemcategory(Itemcategory $itemcategory)
    {
        $this->itemcategorys->removeElement($itemcategory);
    }

    /**
     * Get itemcategorys
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItemcategorys()
    {
        return $this->itemcategorys;
    }

    /**
     * Add alertcategory
     *
     * @param Alertcategory $alertcategory
     *
     * @return Icon
     */
    public function addAlertcategory(Alertcategory $alertcategory)
    {
        $this->alertcategorys[] = $alertcategory;

        return $this;
    }

    /**
     * Remove alertcategory
     *
     * @param Alertcategory $alertcategory
     */
    public function removeAlertcategory(Alertcategory $alertcategory)
    {
        $this->alertcategorys->removeElement($alertcategory);
    }

    /**
     * Get alertcategorys
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAlertcategorys()
    {
        return $this->alertcategorys;
    }

    /**
     * Add pagewidget
     *
     * @param Pagewidget $pagewidget
     *
     * @return Icon
     */
    public function addPagewidget(Pagewidget $pagewidget)
    {
        $this->pagewidgets[] = $pagewidget;

        return $this;
    }

    /**
     * Remove pagewidget
     *
     * @param Pagewidget $pagewidget
     */
    public function removePagewidget(Pagewidget $pagewidget)
    {
        $this->pagewidgets->removeElement($pagewidget);
    }

    /**
     * Get pagewidgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPagewidgets()
    {
        return $this->pagewidgets;
    }

    /**
     * Add widget
     *
     * @param Widget $widget
     *
     * @return Icon
     */
    public function addWidget(Widget $widget)
    {
        $this->widgets[] = $widget;

        return $this;
    }

    /**
     * Remove widget
     *
     * @param Widget $widget
     */
    public function removeWidget(Widget $widget)
    {
        $this->widgets->removeElement($widget);
    }

    /**
     * Get widgets
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getWidgets()
    {
        return $this->widgets;
    }

    /**
     * Add bookmark
     *
     * @param Bookmark $bookmark
     *
     * @return Icon
     */
    public function addBookmark(Bookmark $bookmark)
    {
        $this->bookmarks[] = $bookmark;

        return $this;
    }

    /**
     * Remove bookmark
     *
     * @param Bookmark $bookmark
     */
    public function removeBookmark(Bookmark $bookmark)
    {
        $this->bookmarks->removeElement($bookmark);
    }

    /**
     * Get bookmarks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBookmarks()
    {
        return $this->bookmarks;
    }

    /**
     * Add group
     *
     * @param Group $group
     *
     * @return Icon
     */
    public function addGroup(Group $group)
    {
        $this->groups[] = $group;

        return $this;
    }

    /**
     * Remove group
     *
     * @param Group $group
     */
    public function removeGroup(Group $group)
    {
        $this->groups->removeElement($group);
    }

    /**
     * Get groups
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getGroups()
    {
        return $this->groups;
    }

    /**
     * Set tags
     *
     * @param string $tags
     *
     * @return Icon
     */
    public function setTags($tags)
    {
        $this->tags = $tags;

        return $this;
    }

    /**
     * Get tags
     *
     * @return string
     */
    public function getTags()
    {
        return $this->tags;
    }
}
