<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Doctrine\ORM\EntityRepository;

class ProjectWriterType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $id=$options['id'];
        $access=$options['access'];

        $builder
            ->add('submit', SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('writers', EntityType::class, [
                'label'         => 'Donner permissions en écritures à',
                'class'         => 'App\Entity\User',
                'query_builder' => function(EntityRepository $er) use ($id,$access) {
                    $qb= $er->createQueryBuilder('user');
                    return $qb->select('user')

                            ->from('App\Entity\Project','project')
                            ->andwhere('project.id=:project')

                            ->from('App\Entity\UserGroup','usergroup')
                            ->andwhere("usergroup.group MEMBER OF project.groups")
                            ->andwhere("usergroup.user=user")

                            ->setParameter('project',$id);
                },
                'choice_label'  => 'username',
                'multiple'      => true,
                'expanded'      => true
            ]);
            
            ;   

    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Project',
            'id' => 'integer',
            'mode' => 'string',
            'access' => 'string',
            'user' => 'App\Entity\User'
        ]);
    }
}
