<?php

namespace App\Service;

class MessageService  {
    private $wssport;

    public function __construct($wssport)
    {
        $this->wssport = $wssport;
    }


    public function addMessage($userkey,$groupid,$message){
        \Ratchet\Client\connect('ws://localhost:'.$this->wssport)->then(function($conn) use ($userkey,$groupid,$message) {
            $msg = ['command' => 'pushsubscribe', 'log'=>'','channel' => 'chat-'.$groupid, 'channeltype' => 'chat',  'channelkey' => $groupid, 'userkey' => $userkey,"subdata"=>["command"=>"addchat","message"=>$message]];
            $msg = json_encode($msg);
            $conn->send($msg);
            $conn->close();
        }, function ($e) {
            die("Could not connect: {$e->getMessage()}");
        });

    }
}
