<?php
namespace App\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;

use Ramsey\Uuid\Uuid;

use App\Entity\Script;

global $bdd01;
global $config;

class ScriptCommand extends Command
{
    private $container;
    private $em;
    private $output;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
    }


    protected function configure()
    {
        $this
            ->setName('app:Script')
            ->setDescription('One shoot Script for App')
            ->setHelp('One shoot Script for App')
        ;
    }
        
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output = $output;

        $script=$this->em->getRepository("App\Entity\Script")->findOneBy(["name"=>"Ninegate V2"]);
        if(!$script) {
            $this->writeln("== SCRIPT = Ninegate V2");
            $users=$this->em->getRepository("App\Entity\User")->findBy(["apikey"=>null]);
            foreach($users as $user) {
                $user->setApikey(Uuid::uuid4());
                $user->setPasswordad("");
            }
            $this->em->flush();

            $pages=$this->em->getRepository("App\Entity\Page")->findBy(["fgpreference"=>null]);
            foreach($pages as $page) {
                $page->setFgpreference(true);
                $this->em->flush();
            }

            $crons=$this->em->getRepository("App\Entity\Cron")->findAll();
            
            foreach($crons as $cron) {
                if(stripos($cron->getCommand(),'app:')===false) {
                    $command=$cron->getCommand();
                    $command=str_replace("Core:","app:",$command);
                    $command=str_replace("Websocket:","app:",$command);
                    $command=str_replace("Cron:","app:",$command);
                    $command=str_replace("Portal:","app:",$command);

                    $command=str_replace("CountMessage","NotifMessage",$command);

                    $cron->setCommand($command);
                    $this->em->flush();
                }

                if($cron->getCommand()=="app:Mail") {
                    $this->em->remove($cron);
                    $this->em->flush();
                }
            }
            $this->script("Ninegate V2");

        }

        return Command::SUCCESS;
    }

    private function script($name) {
        $script=new Script();
        $script->setName($name);
        $this->em->persist($script);
        $this->em->flush();
        $this->writeln("");                  
    }


    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
    }
    private function writeln($string) { 
        $this->output->writeln($string);
    }   

}
