<?php
namespace App\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;

class SetPasswordCommand extends Command
{
    private $container;
    private $em;
    private $output;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
    }
    protected function configure()
    {
        $this
            ->setName('app:SetPassword')
            ->setDescription('Set Password for username')
            ->setHelp('Set Password for username = app:SetPassword username password')
            ->addArgument('username', InputArgument::OPTIONAL, 'username')            
            ->addArgument('password', InputArgument::OPTIONAL, 'password')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {

        $output->writeln('');
        $output->writeln('== app:SetPasword');        
        $output->writeln('==========================================================================================================');

        $username = $input->getArgument('username');
        $output->writeln($username);

        $password = $input->getArgument('password');
        $output->writeln($password);

        $user = $this->em->getRepository('App\Entity\User')->findOneBy(array('username' => $username));
        if($user) {
            $user->setPassword($password);
            $this->em->persist($user);
            $this->em->flush();               
        }

        $output->writeln('');
        return Command::SUCCESS;
    }
}
