<?php

namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;

class ItemType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add("submit", SubmitType::class, [
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add("title", TextType::class, [
                "label"         => "Titre",
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ])

            ->add("subtitle", TextareaType::class, [
                "label"         => 'Sous Titre',
                "required"      => false,
                "disabled"      => ($options["mode"]=="delete"?true:false),
                "attr"          => array("rows" => '4')
            ])            

            ->add("content",CKEditorType::class,[
                "config_name"   => 'full_config',
                "label"         => 'Description',
                "required"      => false,
                "disabled"      => ($options["mode"]=="delete"?true:false),
                "config"        => array("height" => "500px")
            ])

            ->add("itemcategory", EntityType::class, [
                "label"         => 'Catégorie',
                "class"         => 'App\Entity\Itemcategory',
                "choice_label"  => 'label',
                "placeholder"   => '-- Sélectionnez une Catégorie --',
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ])

            ->add('roles', ChoiceType::class, [
                "label"         => 'Visible pour les Rôles',
                "choices" => [
                    "Visiteur"              => 'ROLE_ANONYME',
                    "Utilisateur"           => 'ROLE_USER',
                    "Animateur de Groupe"   => 'ROLE_ANIM',
                    "Modérateur"            => 'ROLE_MODO',
                    "Administateur"         => 'ROLE_ADMIN',
                ],                
                "multiple"      => true,
                "expanded"      => true,
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ])

            ->add('niveau01s', Select2EntityType::class, [
                'label'                 => 'Visible pour les '.$options["labelniveau01"],
                'class'                 => 'App\Entity\Niveau01',
                'text_property'         => 'label',
                'multiple'              => true,
                'remote_route'          => 'app_core_ajax_niveau01_list',
                'primary_key'           => 'id',
                'text_property'         => 'label',
                'minimum_input_length'  => 0,
                'page_limit'            => 100,
                'allow_clear'           => true,
                'delay'                 => 250,
                'cache'                 => false,
                'cache_timeout'         => 60000,
                'language'              => 'fr',
                'placeholder'           => 'Selectionner des '.$options["labelniveau01"],                        
            ])

            ->add('groups', Select2EntityType::class, [
                'label'                 => 'Visible pour les Groupes',
                'class'                 => 'App\Entity\Group',
                'text_property'         => 'label',
                'multiple'              => true,
                'remote_route'          => 'app_core_ajax_group_list',
                'primary_key'           => 'id',
                'text_property'         => 'label',
                'minimum_input_length'  => 0,
                'page_limit'            => 100,
                'allow_clear'           => true,
                'delay'                 => 250,
                'cache'                 => false,
                'cache_timeout'         => 60000,
                'language'              => 'fr',
                'placeholder'           => 'Selectionner des groupes',                        
            ])

            ->add('color', TextType::class, [
                'label'         => "Couleur",
                'required'      => false,
                'attr'          => array("class" => "pick-a-color")              
            ])  

            ->add('url')

            ->add('protected', CheckboxType::class, [
                "label"         => "Force l'authentification de l'utilisateur ?",
                "required"      => false
            ])

            ->add('badgeurl', TextType::class, [
                'label'         => "Badge URL",
                'required'      => false,
            ]) 
            
            ->add('essential', CheckboxType::class, [
                "label"         => "Item essentiel ?",
                "required"      => false
            ])

            ->add('target', ChoiceType::class, [
                "label" => 'Ouvrir le lien dans',
                "choices" => [
                    "Nouvel onglet/fenêtre" => '_blank',
                    "iFrame"                => 'frame',
                    "Onglet courant"        => '_self',
                ]
            ])

            ->add('idicon', HiddenType::class,['mapped'=> false,'data' => $options["idicon"]]);

        if($options["ssosynchroitem"]) {
            $builder->add("ssoitem", TextType::class, [
                "label"         => "Visible si attribut SSO ".$options["user_attr_cas_item"]." égale à",
                "required"      => false,
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ]);            
        }


        if($options["activate_widsonde"]) {
            $builder
            /*
            ->add('clicksonde', CheckboxType::class, [
                "label"         => "Exécuter une sonde statistique sur le clic",
                "required"      => false
            ])
            */   
            
            ->add('clicksondeservice', ChoiceType::class, [
                "label" => 'Type de Service associé à la sonde',
                "label_attr" => array("style" => "display:inline"),
                "placeholder" => 'Sélectionner un service',     
                "required" => false,
                "choices" => [
                    "ACCUEIL" => "ACCUEIL",
                    "ACTUALITES" => "ACTUALITES",
                    "CAHIER TEXTES" => "CAHIER_TEXTES",
                    "CAHIER LIAISON" => "CAHIER_LIAISON",
                    "COURRIER ELECTRONIQUE" => "COURRIER_ELECTRONIQUE",
                    "MESSAGERIE INSTANTANEE" => "MESSAGERIE_INSTANTANEE",
                    "VISIOCONFERENCE" => "VISIOCONFERENCE",
                    "STOCKAGE PARTAGE" => "STOCKAGE_PARTAGE",
                    "PRODUCTION COLLABORATIVE" => "PRODUCTION_COLLABORATIVE",
                    "DOCUMENTATION CDI" => "DOCUMENTATION_CDI",
                    "PARCOURS PEDAGOGIQUE" => "PARCOURS_PEDAGOGIQUE",
                    "RESERVATION SALLES MATERIELS" => "RESERVATION_SALLES_MATERIELS",
                    "SERVICE COLLECTIVITE" => "SERVICE_COLLECTIVITE",
                    "SERVICES VIE SCOLAIRE" => "SERVICES_VIE_SCOLAIRE",
                    "GESTION TEMPS" => "GESTION_TEMPS",
                    "ABSENCES" => "ABSENCES",
                    "GESTION COMPETENCES" => "GESTION_COMPETENCES",
                    "NOTES" => "NOTES",
                    "MANUEL NUMERIQUE" => "MANUEL_NUMERIQUE",
                    "RESSOURCE MULTIMEDIA" => "RESSOURCE_MULTIMEDIA",
                    "RESSOURCE ORIENTATION" => "RESSOURCE_ORIENTATION",
                    "RESSOURCE PRODUCTION" => "RESSOURCE_PRODUCTION",
                    "RESSOURCE ACCOMPAGNEMENT ENTRAINEMENT" => "RESSOURCE_ACCOMPAGNEMENT_ENTRAINEMENT",
                    "RESSOURCE REFERENCE DICTIONNAIRE" => "RESSOURCE_REFERENCE_DICTIONNAIRE",
                    "RESSOURCE DOCUMENTAIRE" => "RESSOURCE_DOCUMENTAIRE",
                    "PAGE ENT" => "PAGE_ENT",
                ],                
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ]);
            
        }        
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'App\Entity\Item',
            'mode' => "string",
            'idicon' => "string",
            'labelniveau01' => "string",
            'ssosynchroitem' => "string",
            'user_attr_cas_item' => "string",
            "activate_widsonde" => "string",
        ]);
    }
}
