<?php
namespace App\Validator;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * @Annotation
 */
class PasswordValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint)
    {
        if(!empty($value)) {
            if (strlen($value) < '8') {
                $this->context->addViolation($constraint->message);
            }
            elseif(!preg_match("#[0-9]+#",$value)) {
                $this->context->addViolation($constraint->message);
            }
            elseif(!preg_match("#[a-zA-Z]+#",$value)) {
                $this->context->addViolation($constraint->message);
            }
            elseif(!preg_match("/[|!@#$%&*\/=?,;.:\-_+~^\\\]/",$value)) {
                $this->context->addViolation($constraint->message);
            }
        }        
    }
}