<?php

namespace Cadoles\CoreBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Form\FormError;

use Cadoles\CoreBundle\Entity\Config;
use Cadoles\CoreBundle\Form\ConfigType;
use Cadoles\CoreBundle\Form\DatauserType;

class ConfigController extends Controller
{
    public function homeAction(Request $request)
    {
      	return $this->render('CadolesCoreBundle:Core:config.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
        ]);
    }

    public function listAction()
    {
        $em = $this->getDoctrine()->getManager();

        $configs = $em->createQueryBuilder()
                      ->select('b')
                      ->from('CadolesCoreBundle:Config',  'b')
                      ->where('b.visible = :visible')
                      ->setParameter('visible', 1)
                      ->addOrderBy('b.order')
                      ->getQuery()
                      ->getResult();

        return $this->render('CadolesCoreBundle:Config:list.html.twig', [
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
            'configs'       => $configs
        ]);
    }

    public function updateAction($id,Request $request)
    {
        // Récupération de l'enregistrement courant
        $config=$this->getConfig($id);

        // Vérifier que cet enregistrement est modifiable
        $type=$config->getType();
        $required=$config->getRequired();
        $visible=$config->getVisible();
        $changeable=$config->getChangeable();
        if(!$visible||!$changeable) {
            return $this->redirectToRoute('cadoles_core_config_commun');
        }

        // Création du formulaire
        $form = $this->createForm(ConfigType::class,$config,array("key" => $id, "type" => $type, "required" => $required));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm($form,$request,$config);

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $config = $form->getData();
            $em->persist($config);
            $em->flush();

            // Sur type boolean
            if($type=="boolean") {
                $qb = $em->createQueryBuilder();
                $q = $qb->update('CadolesCoreBundle:Config', 'c')
                    ->set('c.visible', ':visible')
                    ->where('c.grouped = :key')
                    ->setParameter('visible', $config->getValue())
                    ->setParameter('key', $id)
                    ->getQuery();
                $q->execute();                
            }
            return $this->redirectToRoute('cadoles_core_config_commun');
        }

        // Affichage du formulaire
        return $this->render('CadolesCoreBundle:Config:update.html.twig', [
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
            'config'        => $config,
            'type'          => $type,
            'form'          => $form->createView()
        ]);
    }

    public function deleteAction($id,Request $request)
    {
        // Récupération de l'enregistrement courant
        $config=$this->getConfig($id);
        if(!$config->getRequired()) {
            $config->setValue("");
            $em = $this->getDoctrine()->getManager();
            $em->persist($config);
            $em->flush();            
        }
        return $this->redirectToRoute('cadoles_core_config_commun',['usesidebar'=>true]);
    }

    public function logoAction()
    {
        return $this->render('CadolesCoreBundle:Config:logo.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    public function headerAction()
    {
        return $this->render('CadolesCoreBundle:Config:header.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
        ]);
    }

    protected function getConfig($id)
    {
        $em = $this->getDoctrine()->getManager();
        $config = $em->getRepository('CadolesCoreBundle:Config')->find($id);

        if (!$config) {
            throw $this->createNotFoundException('Unable to find config.');
        }

        return $config;
    }

    public function datauserdefaultAction(Request $request)
    {   
        $em = $this->getDoctrine()->getManager();	
        $config=$em->getRepository('CadolesCoreBundle:Config')->find("datauser");
        $config->setValue("");
        $em->persist($config);
        $em->flush();     
        
        return $this->redirectToRoute('cadoles_core_config_datauser');      
    }

    public function datauserAction(Request $request)
    {      
        $em = $this->getDoctrine()->getManager();	
        $session=$this->get('session');
        $config=$em->getRepository('CadolesCoreBundle:Config')->find("datauser");
        $fields=$config->getValue();
        $fields=json_decode($fields,true);
        if(!is_array($fields)) $fields=[];

        // Valeur par défaut 0=caché / 1=falcultatif / 2=obligatoire
        if(!array_key_exists("firstname",$fields)) {
            $fields["firstname"]["perm"]=1;
            $fields["firstname"]["label"]="Prénom";
        }            

        if(!array_key_exists("visible",$fields)) {
            $fields["visible"]["perm"]=2;
            $fields["visible"]["label"]="Visible";
        }   

        if(!array_key_exists("authlevel",$fields)) {
            $fields["authlevel"]["perm"]=2;
            $fields["authlevel"]["label"]="Niveau d'authentification";
        }   

        if(!array_key_exists("belongingpopulation",$fields)) {
            $fields["belongingpopulation"]["perm"]=2;
            $fields["belongingpopulation"]["label"]="Population d'appartenance";
        }   

        if(!array_key_exists("job",$fields)) {
            $fields["job"]["perm"]=1;
            $fields["job"]["label"]="Métier";
        }   

        if(!array_key_exists("position",$fields)) {
            $fields["position"]["perm"]=1;
            $fields["position"]["label"]="Fonction";
        }   

        if(!array_key_exists("niveau02",$fields)) {
            $fields["niveau02"]["perm"]=1;
            $fields["niveau02"]["label"]=$session->get('labelniveau02');
        }   

        if(!array_key_exists("usualname",$fields)) {
            $fields["usualname"]["perm"]=1;
            $fields["usualname"]["label"]="Nom d'Usage";
        }   

        if(!array_key_exists("gender",$fields)) {
            $fields["gender"]["perm"]=1;
            $fields["gender"]["label"]="Sexe";
        }   

        if(!array_key_exists("givensname",$fields)) {
            $fields["givensname"]["perm"]=1;
            $fields["givensname"]["label"]="Autre Prénom";
        }   

        if(!array_key_exists("telephonenumber",$fields)) {
            $fields["telephonenumber"]["perm"]=1;
            $fields["telephonenumber"]["label"]="Téléphone";
        }   

        if(!array_key_exists("postaladress",$fields)) {
            $fields["postaladress"]["perm"]=1;
            $fields["postaladress"]["label"]="Adresse";
        }   

        if(!array_key_exists("birthdate",$fields)) {
            $fields["birthdate"]["perm"]=1;
            $fields["birthdate"]["label"]="Date de Naissance";
        }   

        if(!array_key_exists("birthcountry",$fields)) {
            $fields["birthcountry"]["perm"]=1;
            $fields["birthcountry"]["label"]="Pays de Naissance";
        }   

        if(!array_key_exists("birthplace",$fields)) {
            $fields["birthplace"]["perm"]=1;
            $fields["birthplace"]["label"]="Ville de Naissance";
        }   
        
        if(!array_key_exists("visite",$fields)) {
            $fields["visite"]["perm"]=1;
            $fields["visite"]["label"]="Visite";
        }   

        if(!$session->get('viewniveau02'))
            unset($fields["niveau02"]);

       

        
        $form = $this->createForm(DatauserType::class,$config,array("mode"=>"datauser","fields" => $fields));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        if ($form->get('submit')->isClicked() && $form->isValid()) {
          
            foreach($fields as $key => $value) {
                $perm = $form->get($key)->getData();
                $fields[$key]["perm"]=$perm;
            }
            
            $json=json_encode($fields);
            $config->setValue($json);
            $em->persist($config);
            $em->flush();     
        }


        return $this->render('CadolesCoreBundle:Config:datauser.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
            'form'          => $form->createView(),
            'mode'          => "datauser"
        ]);
    }

    public function datausersdefaultAction(Request $request)
    {   
        $em = $this->getDoctrine()->getManager();	
        $config=$em->getRepository('CadolesCoreBundle:Config')->find("datausers");
        $config->setValue("");
        $em->persist($config);
        $em->flush();     
        
        return $this->redirectToRoute('cadoles_core_config_datausers');      
    }

    public function datausersAction(Request $request)
    {      
        $em = $this->getDoctrine()->getManager();	
        $session=$this->get('session');
        $config=$em->getRepository('CadolesCoreBundle:Config')->find("datausers");
        $fields=$config->getValue();

        $fields=json_decode($fields, true);
        if(!is_array($fields)) $fields=[];
        
        // Valeur par défaut 0=caché / 3=visible
        if(!array_key_exists("avatar",$fields)) {
            $fields["avatar"]["perm"]=1;
            $fields["avatar"]["label"]="Avatar";
        }
        if(!array_key_exists("login",$fields)) {
            $fields["login"]["perm"]=1;
            $fields["login"]["label"]="Login";
        }
        if(!array_key_exists("lastname",$fields)) {
            $fields["lastname"]["perm"]=1;
            $fields["lastname"]["label"]="Nom";
        }
        if(!array_key_exists("firstname",$fields)) {
            $fields["firstname"]["perm"]=1;
            $fields["firstname"]["label"]="Prenom";
        }
        if(!array_key_exists("email",$fields)) {
            $fields["email"]["perm"]=1;
            $fields["email"]["label"]="Email";
        }
        if(!array_key_exists("niveau01",$fields)) {
            $fields["niveau01"]["perm"]=1;
            $fields["niveau01"]["label"]=$session->get('labelniveau01');
        }   
        if(!array_key_exists("niveau02",$fields)) {
            $fields["niveau02"]["perm"]=1;
            $fields["niveau02"]["label"]=$session->get('labelniveau02');
        }
        if(!array_key_exists("group",$fields)) $fields["group"]["perm"]=1;
        $fields["group"]["label"]="Groupes (caché uniquement pour le rôle Utilisateur) ";

        if(!array_key_exists("job",$fields)) {
            $fields["job"]["perm"]=1;
            $fields["job"]["label"]="Métier";
        }
        if(!array_key_exists("position",$fields)) {
            $fields["position"]["perm"]=1;
            $fields["position"]["label"]="Fonction";
        }   
        if(!array_key_exists("role",$fields)) {
            $fields["role"]["perm"]=1;
            $fields["role"]["label"]="Rôles";
        }
        if(!array_key_exists("telephonenumber",$fields)) {
            $fields["telephonenumber"]["perm"]=1;
            $fields["telephonenumber"]["label"]="Téléphone";            
        }
        if(!array_key_exists("visitedate",$fields)) $fields["visitedate"]["perm"]=1;
        $fields["visitedate"]["label"]="Visite (caché uniquement pour les rôles Animateur et Utilisateur) ";

        if(!$session->get('viewniveau02'))
            unset($fields["niveau02"]);

        $form = $this->createForm(DatauserType::class,$config,array("mode"=>"datausers","fields" => $fields));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        if ($form->get('submit')->isClicked()) {
            $onevisible=false;
            foreach($fields as $key => $value) {
                $perm = $form->get($key)->getData();
                $fields[$key]["perm"]=$perm;
                if($perm==1) $onevisible=true;
            }
            
            if(!$onevisible)
                $form->addError(new FormError('Au moins une colonne doit être visible'));

            if ($form->get('submit')->isClicked() && !$form->isValid()) {
                $this->get('session')->getFlashBag()->clear();
                $validator = $this->get('validator');
                $errors = $validator->validate($config);
                foreach( $errors as $error ) {
                    $request->getSession()->getFlashBag()->add("error", $error->getMessage());
                }
    
                $errors = $form->getErrors();
                foreach( $errors as $error ) {
                    $request->getSession()->getFlashBag()->add("error", $error->getMessage());
                }
            }                
        }

        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $json=json_encode($fields);
            $config->setValue($json);
            $em->persist($config);
            $em->flush();     
        }


        return $this->render('CadolesCoreBundle:Config:datauser.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
            'form'          => $form->createView(),
            'mode'          => "datausers"
        ]);
    }

    protected function getErrorForm($form,$request,$data) {
        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();
            $validator = $this->get('validator');
            $errors = $validator->validate($data);
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }
}
