<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\Persistence\ManagerRegistry;

use App\Entity\Icon;
use App\Form\IconType;

class IconController extends AbstractController
{
    private $nameentity  = 'Icon';
    private $labelentity = 'App\Entity\Icon';
    private $labelroute  = 'app_portal_config_icon';
    private $labeldata   = 'icon';
    private $labeldatas  = 'icons';

    public function list($access="config",Request $request, ManagerRegistry $em)
    {
        $inframe=$request->get("inframe");

        if($access=="config")
            $icons=$em->getRepository("App\Entity\Icon")->findBy(["user"=>null]);
        else
            $icons=$em->getRepository("App\Entity\Icon")->findBy(["user"=>$this->getUser()]);

      	return $this->render($this->nameentity.'\list.html.twig',[
            'useheader'         => !($inframe),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"&&!$inframe),   
            'access'            => $access,
            $this->labeldatas   => $icons,
            'inframe'           => $inframe
        ]);
    }

    public function submit($access="config",Request $request, ManagerRegistry $em)
    {
        $inframe=$request->get("inframe");

        // Initialisation de l'enregistrement
        $data = new Icon();
        
        // Création du formulaire
        $form = $this->createForm(IconType::class,$data,array("mode"=>"submit"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            if($access=="user") $data->setUser($this->getUser());
           
            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute('app_portal_'.$access.'_icon',['inframe'=>$inframe]);
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => !($inframe),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"&&!$inframe),   
            'access'            => $access,
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'form'              => $form->createView(),
            'inframe'           => $inframe,
        ]);
    }  

    public function update($id,$access="config",Request $request, ManagerRegistry $em)
    {
        $inframe=$request->get("inframe");

        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);
        
        // Vérifier que cet enregistrement est modifiable
                                    
        // Création du formulaire
        $form = $this->createForm(IconType::class,$data,array("mode"=>"update"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();
            
            // Sauvegarde
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute('app_portal_'.$access.'_icon',['inframe'=>$inframe]);
        }
        
       
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => !($inframe),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"&&!$inframe),   
            'access'            => $access,         
            $this->labeldata    => $data,
            'mode'              => 'update',
            'form'              => $form->createView(),
            'refresh'           => false,
            'inframe'           => $inframe
        ]);
    }

    public function delete($id,$access="config",Request $request, ManagerRegistry $em)
    {
        $inframe=$request->get("inframe");

        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);

        // Vérifier que cet enregistrement est supprimable

        // Supprimer la donnée
        $em->getManager()->remove($data);
        $em->getManager()->flush();
            
        return $this->redirectToRoute('app_portal_'.$access.'_icon',['inframe'=>$inframe]);
    }

    public function select($access="config", ManagerRegistry $em) {
        // Affichage du formulaire
        $icons=$em->getRepository("App\Entity\Icon")->findBy(["user"=>null]);
        $iconsuser=null;
        if($access=="user") $iconsuser=$em->getRepository("App\Entity\Icon")->findBy(["user"=>$this->getUser()]);

        return $this->render($this->nameentity.'\select.html.twig',[
            'useheader'           => false,
            'usemenu'           => false,
            'usesidebar'        => false,   
            'access'            => $access,
            $this->labeldatas   => $icons,
            'iconsuser'         => $iconsuser
        ]);

    }

    public function icon()
    {
        return $this->render($this->nameentity.'\icon.html.twig',[
            'useheader'         => false,
            'usemenu'           => false,
            'usesidebar'        => false,            
        ]);
    }

    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($em,$id)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
