<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Doctrine\Persistence\ManagerRegistry;

use App\Entity\PermModoProfil;
use App\Entity\PermModo;
use App\Form\PermmodoprofilType;

class PermmodoprofilController extends AbstractController
{
    private $labelroute  = 'app_core_config_permmodoprofil';
    private $labelentity = 'App\Entity\PermModoProfil';
    private $labeldata   = 'permmodoprofil';
    private $labeldatas  = 'permmodoprofils';

    public function list()
    {
      	return $this->render('Permmodoprofil\list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
        ]);
    }

    public function ajaxlist(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
               
        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');
      
        // Nombre total d'enregistrement
        $total = $em->getManager()->createQueryBuilder()->select('COUNT(table)')->from($this->labelentity,'table')->getQuery()->getSingleScalarResult();

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else {
            $qb = $em->getManager()->createQueryBuilder()
                        ->select('COUNT(table)')
                        ->from($this->labelentity,'table')
                        ->where('table.name LIKE :value')
                        ->setParameter("value", "%".$search["value"]."%");
            $totalf = $qb->getQuery()->getSingleScalarResult();
        }

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );

        // Parcours des Enregistrement
        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('table')->from($this->labelentity,'table');
       
        if($search["value"]!="") {
            $qb ->andwhere('table.name LIKE :value')
                ->setParameter("value", "%".$search["value"]."%");
        }
        switch($order[0]["column"]) {
            case 1 : 
            $qb->orderBy('table.name',$order[0]["dir"]);
            break;
        }

        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        foreach($datas as $data) {
            $action ="<a href='".$this->generateUrl('app_core_config_permmodoprofil_update', array('id'=>$data->getId()))."'><i class='fa fa-file fa-fw fa-2x' title='Modifier'></i></a>";
            if($data->getId()>0) $action.="<a href='".$this->generateUrl('app_core_config_permmodoprofil_delete', array('id'=>$data->getId()))."' title='Supprimer'><i class='fa fa-trash fa-fw fa-2x'></i></a>";
            
            array_push($output["data"],array($action,$data->getName()));
        }

        // Retour
        return new Response(json_encode($output), 200);
    }    

    public function submit(Request $request, ManagerRegistry $em)
    {
        // Initialisation de l'enregistrement
        $data = new PermModoProfil();
        
        // Création du formulaire
        $form = $this->createForm(PermmodoprofilType::class,$data,array(
            "mode"              => "submit",
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            
            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // Init permission
            $this->initPermModo($em,$data);

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute.'_update',["id"=>$data->getId()]);
        }
        
        // Affichage du formulaire
        return $this->render('Permmodoprofil\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'form'              => $form->createView()
        ]);
    }  

    public function update($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);

        // Récupération des permission sur la side
        $sidebars=$request->getSession()->get('sidebar');
        $perms=[];
        foreach($sidebars as $sidebar) {
            foreach($sidebar["childs"] as $child) {
                $permmod=$em->getRepository("App\Entity\PermModo")->findOneBy(["route"=>$child["path"],"permmodoprofil"=>$id]);
                if($permmod) {
                    array_push($perms,[
                        'id' => $permmod->getId(),
                        'route' =>  $permmod->getRoute(),
                        'label'=>$sidebar['label'].' >> '.$child['label'],
                        'visible'=>$permmod->getVisible()
                    ]);
                }
            }
        }

        // Création du formulaire
        $form = $this->createForm(PermmodoprofilType::class,$data,array(
            "mode"              => "update"
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();
            
            // Sauvegarde
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute($this->labelroute);
        }
        
       
        // Affichage du formulaire
        return $this->render('Permmodoprofil\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,               
            $this->labeldata    => $data,
            'mode'              => 'update',
            'form'              => $form->createView(),
            'permmodos'         => $perms
        ]);
    }

    public function delete($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($em,$id);

        // Création du formulaire
        $form = $this->createForm(PermmodoprofilType::class,$data,array(
            "mode"              =>"delete",
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);        

        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"delete");
                
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em->getManager()->remove($data);
            $em->getManager()->flush();
            
            return $this->redirectToRoute($this->labelroute);
        }
        
        // Affichage du formulaire
        return $this->render('Permmodoprofil\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,   
            $this->labeldata    => $data,
            'mode'              => 'delete',
            'form'              => $form->createView()
        ]);                    
    }

    public function permmodo($id, Request $request, ManagerRegistry $em)
    {
        $sidebars=$request->getSession()->get('sidebar');
        
        $perms=[];
        foreach($sidebars as $sidebar) {
            foreach($sidebar["childs"] as $child) {
                $permmod=$em->getRepository("App\Entity\PermModo")->findOneBy(["route"=>$child["path"],"permmodoprofil"=>$id]);
                if($permmod) {
                    array_push($perms,['id' => $permmod->getId(), 'label'=>$sidebar['label'].' >> '.$child['label'],'visible'=>$permmod->getVisible()]);
                }
            }
        }

        return $this->render('Permmodoprofil\permmodo.html.twig', [
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => true,
            'profil'        => $this->getData($em,$id),
            'permmodos'     => $perms
        ]);
    }

    public function permmodoupdate(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) return new JsonResponse(array('message' => 'Interdit'), 400);

        $output=array();
        $id = $request->request->get('id');

        $permmodo = $em->getRepository("App\Entity\PermModo")->find($id);
        if (!$permmodo) throw $this->createNotFoundException('Unable to find entity.');

        $permmodo->setVisible(!$permmodo->getVisible());
        $em->getManager()->flush();        

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response; 
    }

    protected function getDatas(ManagerRegistry $em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData(ManagerRegistry $em,$id)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
            // On s'assure que le profil n'est pas rattaché à des utilisateurs
            if($data->getUsers()->count() > 0) {
                $form->addError(new FormError('Un utilisateur utilise ce profil de modération : suppression impossible'));
            }
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    

    private function initPermModo($em,$profil) {
        $this->addModeration($em,$profil,'app_core_config_commun',0);
        $this->addModeration($em,$profil,'app_core_config_theme',0);
        $this->addModeration($em,$profil,'app_core_config_datauser',0);
        $this->addModeration($em,$profil,'app_core_config_datausers',0);
        $this->addModeration($em,$profil,'app_core_config_whitelist',0);
        $this->addModeration($em,$profil,'app_core_config_niveau01',1);
        $this->addModeration($em,$profil,'app_core_config_niveau02',1);
        $this->addModeration($em,$profil,'app_core_config_group',1);
        $this->addModeration($em,$profil,'app_core_config_registration',1);
        $this->addModeration($em,$profil,'app_core_config_user',1);
        $this->addModeration($em,$profil,'app_portal_config_pagetemplate',1);
        $this->addModeration($em,$profil,'app_portal_config_page',1);
        $this->addModeration($em,$profil,'app_portal_config_item',1);
        $this->addModeration($em,$profil,'app_portal_config_alert',1);
        $this->addModeration($em,$profil,'app_portal_config_calendar',1);
        $this->addModeration($em,$profil,'app_portal_config_blog',1);
        $this->addModeration($em,$profil,'app_portal_config_project',1);
        $this->addModeration($em,$profil,'app_portal_config_flux',1);
        $this->addModeration($em,$profil,'app_portal_config_notice',1);
        $this->addModeration($em,$profil,'app_portal_config_icon',1);
        $this->addModeration($em,$profil,'app_portal_config_syncbalado',0);
        $this->addModeration($em,$profil,'app_portal_config_synccdt',0);
        $this->addModeration($em,$profil,'app_portal_config_syncgepiannu',0);
        $this->addModeration($em,$profil,'app_portal_config_syncgepisiecle',0);
        $this->addModeration($em,$profil,'app_portal_config_synclimesurvey',0);
        $this->addModeration($em,$profil,'app_portal_config_syncmoodle',0);
        $this->addModeration($em,$profil,'app_portal_config_syncnextcloud',0);
        $this->addModeration($em,$profil,'app_portal_config_syncsacoche',0);
        $this->addModeration($em,$profil,'app_portal_config_syncpiwik',0);
        $this->addModeration($em,$profil,'app_portal_config_syncwordpress',0);
        $this->addModeration($em,$profil,'app_core_config_statistic',1);
        $this->addModeration($em,$profil,'app_core_config_mailing',1);
        $this->addModeration($em,$profil,'app_core_config_importuser',0);
        $this->addModeration($em,$profil,'app_cron_config',0);
        $this->addModeration($em,$profil,'app_cron_config_log',0);
    }

    private function addModeration($em,$profil,$route,$visible) {
        $entity=$em->getRepository('App\Entity\PermModo')->findOneBy(["route"=>$route,"permmodoprofil"=>$profil]);
        if(!$entity) {
            $entity=new PermModo();
            $entity->setRoute($route);
            $entity->setVisible($visible);
            $entity->setPermmodoprofil($profil);
            $em->getManager()->persist($entity);
            $em->getManager()->flush();            
        }
    }

}
