<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Pagewidget
 *
 * @ORM\Entity
 * @ORM\Table(name="pagewidget")
 * @ORM\HasLifecycleCallbacks
 */
class Pagewidget
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
  
    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="loc", type="string")
     */
    private $loc;

    /**
     * @var string
     *
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @var integer
     *
     * @ORM\Column(name="height", type="integer")
     */
    private $height;

    /**
     * @var boolean
     *
     * @ORM\Column(name="autoajust", type="boolean", options={"default":false})
     */
    protected $autoajust;

    /**
     * @var boolean
     *
     * @ORM\Column(name="border", type="boolean", options={"default":true})
     */
    protected $border;

    /**
     * @var boolean
     *
     * @ORM\Column(name="opened", type="boolean", options={"default":true})
     */
    protected $opened;
        
    /**
     * @var string
     *
     * @ORM\Column(name="colorheaderback", type="string", nullable=true)
     */
    protected $colorheaderback;

    /**
     * @var string
     *
     * @ORM\Column(name="colorheaderfont", type="string", nullable=true)
     */
    protected $colorheaderfont;

    /**
     * @var string
     *
     * @ORM\Column(name="colorbodyback", type="string", nullable=true)
     */
    protected $colorbodyback;

    /**
     * @var string
     *
     * @ORM\Column(name="colorbodyfont", type="string", nullable=true)
     */
    protected $colorbodyfont;

    /**
     * @var string
     *
     * @ORM\Column(name="parameter", type="array", nullable=true)
     */
    private $parameter;
    
    /**
     * @ORM\ManyToOne(targetEntity="Page", inversedBy="pagewidgets")
     */
    private $page;

    /**
     * @ORM\ManyToOne(targetEntity="Widget", inversedBy="pagewidgets")
     */
    private $widget;

    /**
     * @ORM\ManyToOne(targetEntity="Icon", inversedBy="pagewidgets")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $icon;

    /**
     * @var ArrayCollection $bookmark
     * @var Bookmark
     *
     * @ORM\OneToMany(targetEntity="Bookmark", mappedBy="pagewidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $bookmarks;    

    /**
     * @var ArrayCollection $slide
     * @var Slide
     *
     * @ORM\OneToMany(targetEntity="Slide", mappedBy="pagewidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $slides;    


    // A garder pour forcer l'id en init
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    } 
        
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->bookmarks = new \Doctrine\Common\Collections\ArrayCollection();
        $this->slides = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Pagewidget
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set loc
     *
     * @param string $loc
     *
     * @return Pagewidget
     */
    public function setLoc($loc)
    {
        $this->loc = $loc;

        return $this;
    }

    /**
     * Get loc
     *
     * @return string
     */
    public function getLoc()
    {
        return $this->loc;
    }

    /**
     * Set roworder
     *
     * @param integer $roworder
     *
     * @return Pagewidget
     */
    public function setRoworder($roworder)
    {
        $this->roworder = $roworder;

        return $this;
    }

    /**
     * Get roworder
     *
     * @return integer
     */
    public function getRoworder()
    {
        return $this->roworder;
    }

    /**
     * Set height
     *
     * @param integer $height
     *
     * @return Pagewidget
     */
    public function setHeight($height)
    {
        $this->height = $height;

        return $this;
    }

    /**
     * Get height
     *
     * @return integer
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * Set autoajust
     *
     * @param boolean $autoajust
     *
     * @return Pagewidget
     */
    public function setAutoajust($autoajust)
    {
        $this->autoajust = $autoajust;

        return $this;
    }

    /**
     * Get autoajust
     *
     * @return boolean
     */
    public function getAutoajust()
    {
        return $this->autoajust;
    }

    /**
     * Set border
     *
     * @param boolean $border
     *
     * @return Pagewidget
     */
    public function setBorder($border)
    {
        $this->border = $border;

        return $this;
    }

    /**
     * Get border
     *
     * @return boolean
     */
    public function getBorder()
    {
        return $this->border;
    }

    /**
     * Set opened
     *
     * @param boolean $opened
     *
     * @return Pagewidget
     */
    public function setOpened($opened)
    {
        $this->opened = $opened;

        return $this;
    }

    /**
     * Get opened
     *
     * @return boolean
     */
    public function getOpened()
    {
        return $this->opened;
    }

    /**
     * Set colorheaderback
     *
     * @param string $colorheaderback
     *
     * @return Pagewidget
     */
    public function setColorheaderback($colorheaderback)
    {
        $this->colorheaderback = $colorheaderback;

        return $this;
    }

    /**
     * Get colorheaderback
     *
     * @return string
     */
    public function getColorheaderback()
    {
        return $this->colorheaderback;
    }

    /**
     * Set colorheaderfont
     *
     * @param string $colorheaderfont
     *
     * @return Pagewidget
     */
    public function setColorheaderfont($colorheaderfont)
    {
        $this->colorheaderfont = $colorheaderfont;

        return $this;
    }

    /**
     * Get colorheaderfont
     *
     * @return string
     */
    public function getColorheaderfont()
    {
        return $this->colorheaderfont;
    }

    /**
     * Set colorbodyback
     *
     * @param string $colorbodyback
     *
     * @return Pagewidget
     */
    public function setColorbodyback($colorbodyback)
    {
        $this->colorbodyback = $colorbodyback;

        return $this;
    }

    /**
     * Get colorbodyback
     *
     * @return string
     */
    public function getColorbodyback()
    {
        return $this->colorbodyback;
    }

    /**
     * Set colorbodyfont
     *
     * @param string $colorbodyfont
     *
     * @return Pagewidget
     */
    public function setColorbodyfont($colorbodyfont)
    {
        $this->colorbodyfont = $colorbodyfont;

        return $this;
    }

    /**
     * Get colorbodyfont
     *
     * @return string
     */
    public function getColorbodyfont()
    {
        return $this->colorbodyfont;
    }

    /**
     * Set parameter
     *
     * @param array $parameter
     *
     * @return Pagewidget
     */
    public function setParameter($parameter)
    {
        $this->parameter = $parameter;

        return $this;
    }

    /**
     * Get parameter
     *
     * @return array
     */
    public function getParameter()
    {
        return $this->parameter;
    }

    /**
     * Set page
     *
     * @param Page $page
     *
     * @return Pagewidget
     */
    public function setPage(Page $page = null)
    {
        $this->page = $page;

        return $this;
    }

    /**
     * Get page
     *
     * @return Page
     */
    public function getPage()
    {
        return $this->page;
    }

    /**
     * Set widget
     *
     * @param Widget $widget
     *
     * @return Pagewidget
     */
    public function setWidget(Widget $widget = null)
    {
        $this->widget = $widget;

        return $this;
    }

    /**
     * Get widget
     *
     * @return Widget
     */
    public function getWidget()
    {
        return $this->widget;
    }

    /**
     * Set icon
     *
     * @param Icon $icon
     *
     * @return Pagewidget
     */
    public function setIcon(Icon $icon = null)
    {
        $this->icon = $icon;

        return $this;
    }

    /**
     * Get icon
     *
     * @return Icon
     */
    public function getIcon()
    {
        return $this->icon;
    }

    /**
     * Add bookmark
     *
     * @param Bookmark $bookmark
     *
     * @return Pagewidget
     */
    public function addBookmark(Bookmark $bookmark)
    {
        $this->bookmarks[] = $bookmark;

        return $this;
    }

    /**
     * Remove bookmark
     *
     * @param Bookmark $bookmark
     */
    public function removeBookmark(Bookmark $bookmark)
    {
        $this->bookmarks->removeElement($bookmark);
    }

    /**
     * Get bookmarks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBookmarks()
    {
        return $this->bookmarks;
    }

    /**
     * Add slide
     *
     * @param Slide $slide
     *
     * @return Pagewidget
     */
    public function addSlide(Slide $slide)
    {
        $this->slides[] = $slide;

        return $this;
    }

    /**
     * Remove slide
     *
     * @param Slide $slide
     */
    public function removeSlide(Slide $slide)
    {
        $this->slides->removeElement($slide);
    }

    /**
     * Get slides
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSlides()
    {
        return $this->slides;
    }
}
