<?php
namespace App\Websocket;
 
use Exception;
use Ratchet\ConnectionInterface;
use Ratchet\MessageComponentInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;
use SplObjectStorage;

use App\Entity\Scrum;
use App\Entity\Scrumcolumn;
use App\Entity\Scrumwidget;

class MessageHandler implements MessageComponentInterface
{
    protected $container;
    protected $em;

    protected $clients;
    private $channels;
    private $channeltypes;
    private $channelkeys;
    private $userconns;
    private $userkeys;
 
    public function __construct(ContainerInterface $container, EntityManagerInterface $em)
    {
        $this->container = $container;
        $this->em = $em;

        $this->clients          = new SplObjectStorage;
        $this->channels         = [];
        $this->channeltypes     = [];
        $this->channelkeys      = [];
        $this->userconns        = [];
        $this->userkeys         = [];
    }
 
    public function onOpen(ConnectionInterface $conn)
    {
        $this->clients->attach($conn);
        $this->userconns[$conn->resourceId] = $conn;
    }

    public function onClose(ConnectionInterface $conn)
    {
        $data= new \stdClass;
        $data->command = "adead";

        // Envoyer le message de deconnection
        if (isset($this->channels[$conn->resourceId])) {
            $this->sendMessage($conn,$data,"other");
        }        
        
        // Détacher
        $this->clients->detach($conn);
        unset($this->userconns[$conn->resourceId]);
        unset($this->userkeys[$conn->resourceId]);
        unset($this->channels[$conn->resourceId]);
    }

    public function onError(ConnectionInterface $conn, Exception $e)
    {
        $conn->close();
    }

    public function onMessage(ConnectionInterface $conn, $msg)
    {
        $data = json_decode($msg);

        switch ($data->command) {
            case "subscribe":
                $this->channels[$conn->resourceId] = $data->channel;
                $this->channeltypes[$conn->resourceId] = $data->channeltype;
                $this->channelkeys[$conn->resourceId] = $data->channelkey;
                $this->userkeys[$conn->resourceId] = $data->userkey;
            break;

            case "meto":
                if (isset($this->channels[$conn->resourceId])) {
                    $this->sendMessage($conn,$data,"other");
                }
            break;

            case "alive":
                if (isset($this->channels[$conn->resourceId])) {
                    $this->sendMessage($conn,$data);
                }
            break;

            default:
                if (isset($this->channels[$conn->resourceId])) {
                    switch ($this->channeltypes[$conn->resourceId]) {
                        //case "type": $this->onMessageYype($conn,$data); break;
                        default: $this->sendMessage($conn,$data);
                    }
                }
            break;
        }
    } 

    private function sendMessage(ConnectionInterface $conn, $data, $dest="all") {
        $target = $this->channels[$conn->resourceId];
        foreach ($this->channels as $id=>$channel) {
            if ($channel == $target) {
                // dest = all - tout le monde meme l'expediteur
                // dest = other - tout le monde sauf l'expedituer
                // dest = me - seumlement l'expediteur
                if($dest=="all"||($dest=="other"&&$id!=$conn->resourceId)||($dest=="me"&&$id==$conn->resourceId)) {
                    // From
                    $key= $this->userkeys[$conn->resourceId];
                    $from=$this->em->getRepository("App:User")->findOneBy(["apikey"=>$key]);

                    // To
                    $key= $this->userkeys[$id];
                    $to=$this->em->getRepository("App:User")->findOneBy(["apikey"=>$key]);

                    // Send
                    if($from && $to) {
                        $data->from= new \stdClass;
                        $data->from->id             = $from->getId();
                        $data->from->username       = $from->getUsername();
                        $data->from->displayname    = $from->getDisplayname();
                        $data->from->avatar         = $this->getAvatar($from->getAvatar());
                        
                        $data->log="== GET MSG from ".$data->from->username." to ".$to->getUsername()." = ".$data->command;
                        $this->userconns[$id]->send(json_encode($data));
                    }
                }
            }
        }
    }

    private function getAvatar($avatar) {
        if(stripos($avatar,"http")===0)
            return $avatar;
        else
            return "/".$this->container->getParameter("appAlias")."/uploads/avatar/".$avatar;        
    }
}