<?php
/**
 * PHP 5
 * 
 * Model pour la table sondages
 */
class Sondage extends Model {

	/**
	 * Permet de récupérer tous les sondages d'un utilisateur
	 * 			
	 * @param  string $user_mail Adresse email de l'utilisateur
	 * @return stdClass          Résultat de la requête
	 */
	public function get_sondage_user( $user_mail = "" ) {
		if (empty($user_mail))
			return false;

		$polls = $this->find(array(
			'conditions' => array(
				'mail_admin' => $user_mail
				)
			));

		return $polls;
	}

	/**
	 * Permet de générer le token d'un sondage
	 * @return string Token
	 */
	public function genere_ID() {
		return uniqid('quid_');
	}

	/**
	 * Test si un enregistrement existe en base
	 * @param  string $token Token du sondage à trouver
	 * @return boolean        
	 */
	public function exists( $token ) {
		return $this->findCount(array('token' => $token));
	}

	/**
	 * Permet de tester la validité des heures proposé,
	 * puis de préparer les données à être enregistrées en session
	 * @param  array $data Tableau contenant tous les horaires
	 * @return boolean
	 */
	public function cleanHours( $data ) {
		$match = false;
		foreach ($data as $k => $v) {
			foreach ($v as $l => $m) {
				if (!empty($m)) {
					// Si le format de l'heure ne correspond pas à au moins un de ceux attendu
					// on retourne false
					// 
					if (preg_match("/^((?(?=2)2[0-3]?|[0-1]?\d)[:hH][0-5]\d)(?(?=-)-(?1))$/i", $m)) {
						// On réécrit le choix de l'option pour le préparer à entrer en BDD
						// format de sortie : timestamp@horaire
						// 
						if (is_object($data))
							array_push($data->$k,  $k.'@'.$m);
						else
							array_push($data[$k],  $k.'@'.$m);
					} else {
						return;
					}
					$match = true;
				}

				$table = $data->$k;
				if (is_object($data))
					$key = array_search($m, $data->$k);
				else
					$key = array_search($m, $data[$k]);
				unset($table[$key]);
				if (!empty($table))
					$data->$k = $table;
				else
					unset($data->$k);
			}

		}
		
		return $match;
	}

	/**
	 * Permet de checker la validité des options textes renseignée
	 * @param  string $data chaine a tester
	 * @return boolean       
	 */
	public function cleanText( $data ) {
		if (empty($data))
			return false;

		return true;
	}

	/**
	 * Test toutes les adresses emails proposées
	 * @param  array $data Tableau contenant les adresses email
	 * @return mixed FALSE si erreur - Tableau nettoyé sinon       
	 */
	public function cleanDest( $data ) {
		foreach ($data as $k => $v) {
			if (empty($v)) {
				unset($data[$k]);
			} else {
				if (!filter_var($v, FILTER_VALIDATE_EMAIL))
					return false;
			}
		}
		return $data;
	}
}