<?php $all_days = $calendar->get_all_days(date('Y'), date('Y') + 5); ?>

<!-- Controls -->
<div class="row">
	<div class="col-md-3">
		<div class="form-group">
			<select class="list-years form-control" id="listYear" name="year">
				<?php foreach ($all_days as $year => $months) : ?>
					<option value="<?php echo $year; ?>" <?php echo ($year == date('Y')) ?  'selected' : ''; ?>><?php echo $year; ?></option>
				<?php endforeach; ?>
			</select>
		</div>
	</div>
	<div class="col-md-3">
		<div class="form-group">
			<select class="list-months form-control" id="listMonths" name="year">
				<?php foreach ($calendar->months as $i => $month) : ?>
					<option value="<?php echo $i+1; ?>" <?php echo ($i+1 == date('m')) ?  'selected' : ''; ?>><?php echo ucfirst($month); ?></option>
				<?php endforeach; ?>
			</select>
		</div>
	</div>
</div>
<!-- /end controls -->

<div class="row">
	<div class="col-md-12">
		<div class="table-responsive">
			<div id="showCalendar">
				<?php $jours_feries = $calendar->getHolidays(); ?>
				<?php foreach ($all_days as $year => $months) : ?>
					<?php foreach ($months as $month => $days) : ?>
						<div id="year-<?php echo $year; ?>-month-<?php echo $month; ?>" class="table-month">
							<table class="table table-bordered">
								<thead>
									<tr>
										<?php foreach ($calendar->days as $i => $day) : ?>
											<th class="day pa1"><?php echo ucfirst($day); ?></th>
										<?php endforeach; ?>
									</tr>
								</thead>
								<tr>
								<?php $end = end($days); foreach ($days as $i => $day) : ?>
									<?php if ($i == 1 AND $day != 1) : ?>
										<td colspan="<?php echo $day-1; ?>" class="empty"></td>
									<?php endif; ?>
									<?php if (isset($s_sondage['options'])) : ?>
										<td class="day pa1 <?php echo in_array(strtotime($year.'-'.$month.'-'.$i), $jours_feries) ? 'ferie' : '' ; ?> <?php echo ($day==6 || $day==7) ? 'we' : '' ; ?> <?php echo (in_array(strtotime($year.'-'.$month.'-'.$i), $s_sondage['options'])) ? 'selected' : ''; ?>" data-target="<?php echo URL.'/saveDate'.'/'.$sondage->token.'/'.strtotime($year.'-'.$month.'-'.$i).'/'.(in_array(strtotime($year.'-'.$month.'-'.$i), $s_sondage['options']) ? 'remove' : 'add'); ?>">
									<?php else : ?>
										<td class="day pa1 <?php echo in_array(strtotime($year.'-'.$month.'-'.$i), $jours_feries) ? 'ferie' : '' ; ?> <?php echo ($day==6 || $day==7) ? 'we' : '' ; ?> <?php echo (in_array(strtotime($year.'-'.$month.'-'.$i), array())) ? 'selected' : ''; ?>" data-target="<?php echo URL.'/saveDate'.'/'.$sondage->token.'/'.strtotime($year.'-'.$month.'-'.$i).'/'.(in_array(strtotime($year.'-'.$month.'-'.$i), array()) ? 'remove' : 'add'); ?>">
									<?php endif; ?>
										<?= (strtotime($year.'-'.$month.'-'.$i) == strtotime(date('Y-m-d'))) ? '<span class="label-alert label label-info"><i class="fa fa-map-marker"></i></span>' : '' ; ?>
										<span class="numDay"><?php echo $i; ?></span>
										<?= ($day==6 || $day==7) ? '<span class="label-alert label label-default">we</span>' : '' ; ?>
										<?= in_array(strtotime($year.'-'.$month.'-'.$i), $jours_feries) ? '<span class="label-alert label label-warning">férié</span>' : '' ; ?>
										<input type="hidden" name="dates[<?php echo strtotime($year.'-'.$month.'-'.$i); ?>]" value="">
									</td>
									<?php if ($day==7) : ?>
										</tr><tr>
									<?php endif; ?>
								<?php endforeach; ?>
								<?php if ($end != 7) : ?>
									<td colspan="<?php echo 7-$end; ?>" class="empty"></td>
								<?php endif; ?>
								</tr>
							</table>
						</div>
					<?php endforeach; ?>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</div>