<?php
/**
 * Piwik - free/libre analytics platform
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 */
namespace Piwik\Plugins\ProfiledVisits\Reports;

use Piwik\Piwik;
use Piwik\Plugin\Report;
use Piwik\Plugin\ViewDataTable;

use Piwik\View;

class GetApplicationsEnseignants extends Base
{
    protected function init()
    {
        parent::init();

        $this->name             = 'Applications utilisées par les enseignants';
        $this->dimension        = null;
        $this->documentation    = Piwik::translate('');
        $this->order            = 1;
        $this->metrics          = array('nb_visits', 'nb_hits');
    }

    public function configureView(ViewDataTable $view)
    {
        $view->config->addTranslations(array('label' => 'Application'));

        $view->config->show_search                  = false;
        $view->requestConfig->filter_sort_column    = 'nb_visits';
        $view->config->show_pie_chart               = true;
        $view->config->show_table_all_columns       = false;
        $view->config->disable_row_evolution        = true;
        $view->config->filter_limit                 = 10;
        $view->config->columns_to_display           = array_merge(array('label'), $this->metrics);
    }

    public function getRelatedReports()
    {
         return array(new GetApplicationsutilisees(), new GetApplicationsEleves()); // eg return array(new XyzReport());
    }
}
