(function () {
    // Récupérer les paramètres passés dans le src du script
    function getScriptParams() {
        let currentScript = document.currentScript;

        if (!currentScript) {
            const scripts = document.getElementsByTagName('script');
            currentScript = scripts[scripts.length - 1];
        }

        if (currentScript && currentScript.src) {
            // 1. On récupère l'URL complète (votre 'src')
            const src = currentScript.src;

            // 2. Utiliser l'API URLSearchParams pour une analyse fiable et facile
            const url = new URL(src);
            const params = url.searchParams;

            // 3. Convertir l'objet URLSearchParams en un simple objet JavaScript (Map)
            const paramsObject = {};
            params.forEach((value, key) => {
                paramsObject[key] = value;
            });

            return paramsObject;
        }

        return {};
    }

    var params = getScriptParams();
    params.route = window.location.href;

    // Construire l'URL relative du PHP (même dossier que le script JS)
    var phpUrl = '/sondepiwik/sonde.php';

    // Ajout des paramètres passés au script
    var urlParams = new URLSearchParams(params).toString();
    if (urlParams.length > 0) {
        phpUrl += '?' + urlParams;
    }

    // Faire la requête AJAX vers le PHP
    fetch(phpUrl, {
        method: 'GET',
        credentials: 'include'  // pour envoyer les cookies (ex : session PHP)
    })
        .then(function (response) {
            if (!response.ok) throw new Error('Network response was not ok');
            return response.text();
        })
        .then(function (text) {
            console.log(text);

            // Optionnel : si tu veux appeler une fonction globale callback passée en paramètre
            if (params.callback && typeof window[params.callback] === 'function') {
                window[params.callback](text);
            }
        })
        .catch(function (err) {
            console.error('Erreur sonde:', err);
        });

})();
