<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'fr', version '3.10'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Des sessions BigBlueButtonBN sont prévues';
$string['bbbduetimeoverstartingtime'] = 'La date de fin doit être supérieure à la date de début.';
$string['bbbdurationwarning'] = 'La durée maximale de cette session est de %duration% minutes.';
$string['bbbrecordallfromstartwarning'] = 'Cette session est enregistrée depuis le début.';
$string['bbbrecordwarning'] = 'Cette session peut être enregistrée.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Ajouter une nouvelle salle/activité BigBlueButtonBN';
$string['bigbluebuttonbn:join'] = 'Rejoindre une conférence BigBlueButtonBN';
$string['bigbluebuttonbn:managerecordings'] = 'Gérer les enregistrements BigBlueButtonBN';
$string['bigbluebuttonbn:meeting'] = 'Créer des instances avec des possibilités de réunion en direct';
$string['bigbluebuttonbn:recording'] = 'Créer des instances avec des possibilités d\'enregistrement';
$string['bigbluebuttonbn:view'] = 'Voir une conférence';
$string['calendarstarts'] = '{$a} est planifié pour';
$string['completionattendance'] = 'L\'étudiant doit assister à la réunion pour :';
$string['completionattendancedesc'] = 'L\'étudiant doit assister à la réunion et rester dans la session pendant au moins {$a} minute(s).';
$string['completionattendancegroup'] = 'Exiger la présence';
$string['completionattendancegroup_help'] = 'La participation à la réunion pendant (n) minutes est requise pour achever l\'activité';
$string['completionengagementchats'] = 'Événements de chat';
$string['completionengagementdesc'] = 'L\'étudiant doit participer à des activités pendant la réunion';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementgroup'] = 'Exiger la participation';
$string['completionengagementgroup_help'] = 'Une participation active lors la session est requise pour l\'achèvement';
$string['completionengagementpollvotes'] = 'Votes du sondage';
$string['completionengagementraisehand'] = 'Événements de levée de main';
$string['completionengagementtalks'] = 'Événements de discussion';
$string['completionengagementtalktime'] = 'Durée de la discussion';
$string['completionupdatestate'] = 'État de la mise à jour de l\'achèvement';
$string['completionvalidatestate'] = 'Validation de l\'achèvement';
$string['completionvalidatestatetriggered'] = 'La validation de l\'achèvement a été déclenchée.';
$string['config_clienttype'] = 'Configuration du type de « client web »';
$string['config_clienttype_default'] = 'Type de client web par défaut';
$string['config_clienttype_default_description'] = 'Choisissez entre le client Adobe Flash classique ou le nouveau HTML5.';
$string['config_clienttype_description'] = 'Ce paramètre autorise/empêche le choix du client web pour chaque conférence.';
$string['config_clienttype_editable'] = 'Le choix du client web peut être modifié';
$string['config_clienttype_editable_description'] = 'Cette option permet de choisir le client Web (AdobeFlash/HTML5) à partir du formulaire d\'édition de la salle.';
$string['config_default_messages'] = 'Messages par défaut';
$string['config_default_messages_description'] = 'Définir les messages par défaut pour l\'activité BBB';
$string['config_disablecam_default'] = 'Le réglage « Désactiver les caméras » est activée par défaut';
$string['config_disablecam_default_description'] = 'Si activé, les caméras seront désactivées.';
$string['config_disablecam_editable'] = 'Le réglage « Désactiver les caméras » peut être modifiée';
$string['config_disablecam_editable_description'] = 'Le réglage « Désactiver les caméras » peut être modifiée quand la conférence est ajoutée ou mise à jour.';
$string['config_disablemic_default'] = 'Le réglage « Désactiver les micros » est activée par défaut';
$string['config_disablemic_default_description'] = 'Si activé, les micros seront désactivés.';
$string['config_disablemic_editable'] = 'Le réglage « Désactiver les micros » peut être modifiée';
$string['config_disablemic_editable_description'] = 'Le réglage « Désactiver les micros » peut être modifiée quand la conférence est ajoutée ou mise à jour.';
$string['config_disablenote_default'] = 'Le réglage « Désactiver les notes partagées » est activée par défaut';
$string['config_disablenote_default_description'] = 'Si activé, les notes partagées seront désactivées.';
$string['config_disablenote_editable'] = 'Le réglage « Désactiver les notes partagées » peut être modifiée';
$string['config_disablenote_editable_description'] = 'Le réglage « Désactiver les notes partagées » peut être modifiée quand la conférence est ajoutée ou mise à jour.';
$string['config_disableprivatechat_default'] = 'Le réglage «Désactiver les chats privés» est activé par défaut';
$string['config_disableprivatechat_default_description'] = 'Si activé, les chats privés seront désactivés.';
$string['config_disableprivatechat_editable'] = 'Le réglage « Désactiver les chats privés » peut être modifié';
$string['config_disableprivatechat_editable_description'] = 'Le réglage « Désactiver les chats privés » peut être modifié quand la conférence est ajoutée ou mise à jour.';
$string['config_disablepublicchat_default'] = 'Le réglage «Désactiver les chats publics» est activé par défaut';
$string['config_disablepublicchat_default_description'] = 'Si activé, les chats publics seront désactivés.';
$string['config_disablepublicchat_editable'] = 'Le réglage « Désactiver les chats publics » peut être modifié';
$string['config_disablepublicchat_editable_description'] = 'Le réglage « Désactiver les chats publics » peut être modifié quand la conférence est ajoutée ou mise à jour.';
$string['config_experimental_features'] = 'Configuration pour les fonctionnalités expérimentales';
$string['config_experimental_features_description'] = 'Configuration pour les fonctionnalités expérimentales.';
$string['config_extended_capabilities'] = 'Paramétrages pour capacités étendues';
$string['config_extended_capabilities_description'] = 'Configuration pour des capacités étendues lorsque le serveur BigBlueButton le permet.';
$string['config_general'] = 'Configuration générale';
$string['config_general_description'] = 'Ces paramètres sont <b> toujours </b> utilisés';
$string['config_hideuserlist_default'] = 'Le réglage « Cacher la liste des utilisateurs » est activé par défaut';
$string['config_hideuserlist_default_description'] = 'Si activé, la liste des utilisateurs de la session sera masquée.';
$string['config_hideuserlist_editable'] = 'Le réglage « Cacher la liste des utilisateurs » peut être modifié';
$string['config_hideuserlist_editable_description'] = 'Le réglage « Cacher la liste des utilisateurs » peut être modifié quand la conférence est ajoutée ou mise à jour.';
$string['config_importrecordings'] = 'Configuration de l\'option « Importer des enregistrements »';
$string['config_importrecordings_description'] = 'Ces réglages sont spécifiques à cette fonctionnalité';
$string['config_importrecordings_enabled'] = 'Importer des enregistrements activé';
$string['config_importrecordings_enabled_description'] = 'Quand ce paramètre et l\'option enregistrement sont autorisés, il est possible d\'importer des enregistrements de différents cours dans une activité.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importer des enregistrements d\'activités supprimées autorisé';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Si ce réglage et la fonction d\'importation d\'enregistrements sont activées, il est possible d\'importer des enregistrements d\'activités qui ne sont plus dans le cours.';
$string['config_lockedlayout_default'] = 'Interface verrouillée par défaut';
$string['config_lockedlayout_default_description'] = 'Si activé, l\'interface de la session sera verrouillée';
$string['config_lockedlayout_editable'] = 'Le réglage « Interface verrouillée » peut être modifié';
$string['config_lockedlayout_editable_description'] = 'Le réglage « Interface verrouillée » peut être modifié lors de l\'ajout de la modification de l\'activité';
$string['config_lockonjoin_default'] = 'Ignorer le verrouillage lors de l\'accès activé par défaut';
$string['config_lockonjoin_default_description'] = 'Si activé, les réglages de verrouillage seront ignorés. La configuration de verrouillage doit être activée pour que cela s\'applique.';
$string['config_lockonjoin_editable'] = '« Ignorer le verrouillage lors de l\'accès » peut être modifié';
$string['config_lockonjoin_editable_description'] = '« Ignorer le verrouillage lors de l\'accès » peut être modifié lors de l\'ajout de la modification de l\'activité';
$string['config_lockonjoinconfigurable_default'] = 'Réglages de verrouillage activés par défauts';
$string['config_lockonjoinconfigurable_default_description'] = 'Si activé, les réglages de verrouillage de session peuvent être activés ou désactivés à partir du réglage ci-dessus.';
$string['config_lockonjoinconfigurable_editable'] = 'Les réglages de verrouillage peuvent être modifiés';
$string['config_lockonjoinconfigurable_editable_description'] = 'Les réglages de verrouillage peuvent être modifié lors de l\'ajout ou la modification de l\'activité';
$string['config_locksettings'] = 'Configuration pour les réglages de verrouillage';
$string['config_locksettings_description'] = 'Ces réglages activent ou désactivent les options de l\'interface utilisateur pour les réglages de verrouillage et définissent également les valeurs par défaut de ces options.';
$string['config_meetingevents_enabled'] = 'S\'inscrire à des événements';
$string['config_meetingevents_enabled_description'] = 'Activez le plugin pour accepter et traiter les événements en direct après la fin de la session. (Il doit être activé pour «Achèvement de l\'activité» et ne fonctionnera que si le serveur BigBlueButton est capable de traiter les scripts post_events).';
$string['config_muteonstart'] = 'Configuration du réglage « Muet au démarrage »';
$string['config_muteonstart_default'] = '« Muet au démarrage » activé par défaut';
$string['config_muteonstart_default_description'] = 'Si activé, la session sera muette au démarrage.';
$string['config_muteonstart_description'] = 'Ces paramètres activent ou désactivent les réglages dans l\'interface utilisateur et définissent également les valeurs par défaut de ces options.';
$string['config_muteonstart_editable'] = 'Le réglage « Muet au démarrage » peut être modifié';
$string['config_muteonstart_editable_description'] = 'Le réglage « Muet au démarrage » par défaut peut être modifié lorsque l\'activité est ajoutée ou modifiée.';
$string['config_participant'] = 'Configuration des participants';
$string['config_participant_description'] = 'Ces paramètres définissent le rôle par défaut des participants dans une conférence.';
$string['config_participant_moderator_default'] = 'Modérateur par défaut';
$string['config_participant_moderator_default_description'] = 'Cette règle est utilisée par défaut quand une nouvelle salle est ajoutée.';
$string['config_presentation_default'] = 'Fichier par défaut pour le réglage « Pré-déposer la présentation »';
$string['config_presentation_default_description'] = 'Ce paramètre permet de sélectionner un fichier à utiliser par défaut dans toutes les instances BBB si  « Pré-déposer la présentation » est activé.';
$string['config_preuploadpresentation'] = 'Configuration de l\'option « Pré-déposer la présentation »';
$string['config_preuploadpresentation_description'] = 'Ces paramètres activent ou désactivent les options dans l\'interface utilisateur et définissent également les valeurs par défaut de ces options. Cette fonctionnalité ne fonctionne que si le serveur MOODLE est accessible par le serveur BigBlueButton';
$string['config_preuploadpresentation_editable'] = 'Le « pré-déposer » de la présentation est modifiable.';
$string['config_recording'] = 'Configuration de l\'option « Enregistrement de la conférence »';
$string['config_recording_all_from_start_default'] = 'Enregistrer toutes les réunions dès leur ouverture';
$string['config_recording_all_from_start_default_description'] = 'Si activé, la réunion est automatiquement enregistrée';
$string['config_recording_all_from_start_editable'] = '« Enregistrer toutes les réunions dès leur ouverture » peut-être modifié';
$string['config_recording_all_from_start_editable_description'] = 'Si coché, l\'interface comprend une option pour activer et désactiver les enregistrements des réunions dès leur ouverture';
$string['config_recording_default'] = 'L\'option « Enregistrement » est activée par défaut';
$string['config_recording_default_description'] = 'Si activé, les sessions créées dans BigBlueButton pourront être enregistrées.';
$string['config_recording_description'] = 'Ces réglages sont spécifiques à cette fonctionnalité';
$string['config_recording_editable'] = 'L\'option « Enregistrement » peut être éditée';
$string['config_recording_editable_description'] = 'Si ce réglage est activé, l\'interface propose une option pour activer/désactiver la fonctionnalité d\'enregistrement.';
$string['config_recording_hide_button_default'] = 'Cacher le bouton d\'enregistrement';
$string['config_recording_hide_button_default_description'] = 'Si coché, le bouton d\'enregistrement sera caché';
$string['config_recording_hide_button_editable'] = 'Le réglage « Cacher le bouton d\'enregistrement » peut être modifié';
$string['config_recording_hide_button_editable_description'] = 'Si coché, l\'interface comprend une option permettant d\'activer et de désactiver permettant d\'activer et de désactiver la fonctionnalité « Cacher le bouton d\'enregistrement »';
$string['config_recording_icons_enabled'] = 'Icônes pour la gestion des enregistrements';
$string['config_recording_icons_enabled_description'] = 'Lorsqu\'il est activé, le panneau de gestion des enregistrements affiche des icônes pour les actions de publication/dépublication et de suppression.';
$string['config_recordingready_enabled'] = 'Envoyer des notifications lorsqu\'un enregistrement est disponible';
$string['config_recordingready_enabled_description'] = 'Activer le plugin pour envoyer des notifications lorsque l\'enregistrement est prêt (cela ne fonctionnera que si le script post_publish_recording_ready_callback est activé sur le serveur BigBlueButton).';
$string['config_recordings'] = 'Configuration pour l\'option « Montrer les enregistrements »';
$string['config_recordings_deleted_default'] = 'Inclure les enregistrements des activités supprimées activé par défaut';
$string['config_recordings_deleted_default_description'] = 'Si activé, la table d\'enregistrements inclura les enregistrements des activités supprimées, s\'il y en a.';
$string['config_recordings_deleted_editable'] = 'L\'option « Inclure les enregistrements des activités supprimées » peut être éditée';
$string['config_recordings_deleted_editable_description'] = 'Inclure les enregistrements des activités supprimées activé par défaut peut être édité quand la conférence est ajoutée ou mise à jour.';
$string['config_recordings_description'] = 'Ces réglages sont spécifiques à cette fonctionnalité';
$string['config_recordings_general'] = 'Afficher les paramètres d\'enregistrement';
$string['config_recordings_general_description'] = 'Ces paramètres sont utilisés uniquement si les enregistrements sont affichés';
$string['config_recordings_html_default'] = 'La table d\'enregistrements est affichée en HTML par défaut';
$string['config_recordings_html_default_description'] = 'Si activé, la table d\'enregistrements est affichée en HTML par défaut.';
$string['config_recordings_html_editable'] = 'La table d\'enregistrements affichée en HTML  peut être éditée';
$string['config_recordings_html_editable_description'] = 'La table d\'enregistrements affichée en HTML  peut être éditée  lors de l\'ajout ou la modification d\'une instance';
$string['config_recordings_imported_default'] = 'Afficher uniquement les liens importés activé par défaut';
$string['config_recordings_imported_default_description'] = 'Si activé, la table des enregistrements ne contiendra que les liens importés d\'autre enregistrements';
$string['config_recordings_imported_editable'] = 'L\'option « Afficher uniquement les liens importés » peut être éditée';
$string['config_recordings_imported_editable_description'] = 'Afficher uniquement les liens importés par défaut peut être édité quand la conférence ajoutée ou mise à jour.';
$string['config_recordings_preview_default'] = 'L\'aperçu est activé par défaut';
$string['config_recordings_preview_default_description'] = 'Si activé, la table inclut un aperçu de la présentation.';
$string['config_recordings_preview_editable'] = 'L\'option « Aperçu » peut être éditée';
$string['config_recordings_preview_editable_description'] = 'L\'option « Aperçu » peut être éditée quand la conférence est ajoutée ou mise à jour.';
$string['config_recordings_sortorder'] = 'Trier les enregistrements par ordre croissant.';
$string['config_recordings_sortorder_description'] = 'Par défaut, les enregistrements sont affichés dans l\'ordre décroissant. Une fois cochés, ils seront triés par ordre croissant.';
$string['config_recordings_validate_url'] = 'Valider l\'URL';
$string['config_recordings_validate_url_description'] = 'Si coché, l\'URL de l\'enregistrement devra être validée avant qu\'un utilisateur puisse y accéder';
$string['config_scheduled'] = 'Configuration de « sessions planifiées »';
$string['config_scheduled_description'] = 'Ces paramètres définissent certains comportements par défaut pour les sessions planifiées.';
$string['config_scheduled_duration_compensation'] = 'Temps complémentaire (minutes)';
$string['config_scheduled_duration_compensation_description'] = 'Minutes ajoutées à la clôture prévue lors du calcul de la durée.';
$string['config_scheduled_duration_enabled'] = 'Calcul de la durée activé';
$string['config_scheduled_duration_enabled_description'] = 'La durée d\'une séance planifiée est calculée sur la base des horaires d\'ouverture et de fermeture.';
$string['config_scheduled_pre_opening'] = 'Accessible avant l\'heure d\'ouverture (minutes)';
$string['config_scheduled_pre_opening_description'] = 'Le temps en minutes pour accéder à la session avant les horaires d\'ouverture de temps.';
$string['config_sendnotifications'] = 'Configuration de l\'option « Envoyer des notifications »';
$string['config_sendnotifications_description'] = 'Ces paramètres activent ou désactivent les options dans l\'interface utilisateur et définissent également les valeurs par défaut de ces options.';
$string['config_sendnotifications_enabled'] = 'Envoyer des notifications activé';
$string['config_sendnotifications_enabled_description'] = 'Si elle est activée, l\'interface permettant de modifier l\'activité comprend une option permettant d\'envoyer une notification à l\'utilisateur inscrit lorsque l\'activité est ajoutée ou mise à jour.';
$string['config_server_url'] = 'URL du serveur BigBlueButton';
$string['config_server_url_description'] = 'L\'URL de votre serveur BigBlueButton doit se terminer par /bigbluebutton/. (Cette URL par défaut est celle pour un serveur BigBlueButton fourni par Blindside Networks à utiliser pour les tests.)';
$string['config_shared_secret'] = 'Secret partagé BigBlueButton';
$string['config_shared_secret_description'] = 'Le sel de sécurité de votre serveur BigBlueButton. (Ce sel par défaut est pour un serveur BigBlueButton fourni par Blindside Networks que vous pouvez utiliser pour les tests.)';
$string['config_uidelegation_enabled'] = 'La délégation de l\'interface utilisateur est activée';
$string['config_uidelegation_enabled_description'] = 'Ces paramètres activent ou désactivent la délégation d\'interface utilisateur au serveur BigBlueButton.';
$string['config_userlimit'] = 'Configuration de l\'option « Limite d\'utilisateurs »';
$string['config_userlimit_default'] = 'Limite d\'utilisateurs activé par défaut';
$string['config_userlimit_default_description'] = 'Le nombre d\'utilisateurs autorisés par défaut dans une session quand une nouvelle salle ou conférence est ajoutée. Si le nombre est 0, il n\'y a pas de limite.';
$string['config_userlimit_description'] = 'Ces paramètres activent ou désactivent les options dans l\'interface utilisateur et définissent également les valeurs par défaut de ces options.';
$string['config_userlimit_editable'] = 'L\'option « Limite d\'utilisateurs » peut être éditée';
$string['config_userlimit_editable_description'] = 'Le nombre limite d\'utilisateurs par défaut peut être édité quand la salle ou la conférence est ajoutée ou mise à jour.';
$string['config_voicebridge'] = 'Configuration de la fonction « Connexion orale » .';
$string['config_voicebridge_description'] = 'Ces paramètres activent ou désactivent les options dans l\'interface utilisateur et définissent également les valeurs par défaut de ces options.';
$string['config_waitformoderator'] = 'Configuration de l\'option « Attendre un modérateur »';
$string['config_waitformoderator_cache_ttl'] = 'Cache TTL de la fonction "attendre un modérateur"';
$string['config_waitformoderator_cache_ttl_description'] = 'Pour supporter une charge importante de clients, ce plugin utilise un cache. Ce paramètre définit la durée pendant laquelle le cache sera conservé avant que la prochaine requête soit envoyée au serveur BigBlueButton.';
$string['config_waitformoderator_default'] = 'Attendre un modérateur activé par défaut';
$string['config_waitformoderator_default_description'] = 'L\'option « Attendre un modérateur » est activée par défaut quand une nouvelle salle ou conférence est ajoutée.';
$string['config_waitformoderator_description'] = 'Ces réglages sont spécifiques à cette fonctionnalité';
$string['config_waitformoderator_editable'] = 'L\'option « Attendre un modérateur » peut être éditée';
$string['config_waitformoderator_editable_description'] = 'La valeur par défaut de l\'option « Enregistrement » peut être éditée quand la salle ou la conférence est ajoutée ou mise à jour.';
$string['config_waitformoderator_ping_interval'] = 'Signal serveur (ping) de la fonction "attendre un modérateur"';
$string['config_waitformoderator_ping_interval_description'] = 'Quand la fonction"attendre un modérateur" est activée , le "client" envoie une requête (ping)  sur le status de la session toutes les [nombre] secondes. Ce paramètre défini cet intervalle de requêtes faites par le serveur Moodle.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton utilise le fichier config.php avec une variable globale qui a été dépréciée. Veuillez convertir le fichier car il ne sera pas supporté dans les futures versions.';
$string['config_warning_curl_not_installed'] = 'Cette fonctionnalité nécessite que l\'extension CURL pour PHP soit installée et activée. Le paramétrage ne sera accessible que si cette condition est remplie';
$string['config_welcome_default'] = 'Message d\'accueil par défaut';
$string['config_welcome_default_description'] = 'Remplace le message par défaut mis en place pour le serveur BigBlueButton. Le message peut inclure des mots-clés (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) qui seront substitués automatiquement, ainsi que des balises html comme <b>...</b> ou <i></i>.';
$string['config_welcome_editable'] = 'Le message de bienvenue par défaut est modifiable par les enseignants.';
$string['config_welcome_editable_description'] = 'Le message de bienvenue peut être modifié lorsque l\'instance est ajoutée ou mise à jour.';
$string['email_body_notification_meeting_by'] = 'par';
$string['email_body_notification_meeting_description'] = 'Description';
$string['email_body_notification_meeting_details'] = 'Détails';
$string['email_body_notification_meeting_end_date'] = 'Date de fin';
$string['email_body_notification_meeting_has_been'] = 'a été';
$string['email_body_notification_meeting_start_date'] = 'Date de début';
$string['email_body_notification_meeting_title'] = 'Titre';
$string['email_body_recording_ready_for'] = 'Enregistrement pour';
$string['email_body_recording_ready_is_ready'] = 'est prêt';
$string['email_footer_sent_by'] = 'Ce message de notification automatique a été envoyé par';
$string['email_footer_sent_from'] = 'du cours';
$string['ends_at'] = 'Termine';
$string['event_activity_created'] = 'Activité créée';
$string['event_activity_deleted'] = 'Activité supprimée';
$string['event_activity_updated'] = 'Activité mise à jour';
$string['event_activity_viewed'] = 'Activité consultée';
$string['event_live_session'] = 'Événement de session en direct';
$string['event_meeting_created'] = 'Conférence créée';
$string['event_meeting_ended'] = 'Conférence fermée (de force)';
$string['event_meeting_joined'] = 'Conférence rejointe';
$string['event_meeting_left'] = 'Conférence quittée';
$string['event_recording_deleted'] = 'Enregistrement supprimé';
$string['event_recording_edited'] = 'Enregistrement édité';
$string['event_recording_imported'] = 'Enregistrement importé';
$string['event_recording_protected'] = 'Enregistrement protégé';
$string['event_recording_published'] = 'Enregistrement publié';
$string['event_recording_unprotected'] = 'Enregistrement déprotégé';
$string['event_recording_unpublished'] = 'Enregistrement non publié';
$string['event_recording_viewed'] = 'Enregistrement visionné';
$string['general_error_not_allowed_to_create_instances'] = 'L\'utilisateur n\'est autorisé à créer aucun type d\'instance.';
$string['general_error_unable_connect'] = 'Impossible de se connecter. Vérifiez l\'URL du serveur BigBlueButton ET vérifiez que le serveur est actif.';
$string['index_confirm_end'] = 'Souhaitez-vous terminer la conférence ?';
$string['index_disabled'] = 'désactivé';
$string['index_enabled'] = 'activé';
$string['index_ending'] = 'Fermeture de la conférence… merci de patienter';
$string['index_error_bbtn'] = 'L\'ID BigBlueButton {$a} est incorrect';
$string['index_error_checksum'] = 'Une erreur de vérification est apparue. Vérifiez votre sel de sécurité.';
$string['index_error_forciblyended'] = 'Impossible de joindre cette conférence, car elle a été manuellement fermée.';
$string['index_error_noinstances'] = 'Il n\'y a pas d\'instances de BigBlueButtonBN';
$string['index_error_unable_display'] = 'Impossible d\'afficher les conférences. Vérifiez l\'URL du serveur BigBlueButton ET vérifiez que le serveur est actif.';
$string['index_heading'] = 'Salons BigBlueButton';
$string['index_heading_actions'] = 'Actions';
$string['index_heading_group'] = 'Groupe';
$string['index_heading_moderator'] = 'Modérateurs';
$string['index_heading_name'] = 'Salon';
$string['index_heading_recording'] = 'Enregistrement';
$string['index_heading_users'] = 'Utilisateurs';
$string['index_heading_viewer'] = 'Participants';
$string['indicator:cognitivedepth'] = 'BigBlueButton cognitive';
$string['indicator:cognitivedepth_help'] = 'Cet indicateur est basé sur la profondeur cognitive atteinte par l\'étudiant dans une activité BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButton social';
$string['indicator:socialbreadth_help'] = 'Cet indicateur est basé sur l\'étendue sociale atteinte par l\'étudiant dans une activité BigBlueButton.';
$string['instance_type_default'] = 'Salle/Activité avec enregistrements';
$string['instance_type_recording_only'] = 'Enregistrements uniquement';
$string['instance_type_room_only'] = 'Salle/Activité uniquement';
$string['minute'] = 'minute';
$string['minutes'] = 'minutes';
$string['mod_form_block_clienttype'] = 'Technologie client web';
$string['mod_form_block_clienttype_flash'] = 'Client basé sur la technologie Adobe Flash';
$string['mod_form_block_clienttype_html5'] = 'Client basé sur la technologie HTML5';
$string['mod_form_block_general'] = 'Paramètres généraux';
$string['mod_form_block_participants'] = 'Rôle attribué pendant la session en direct';
$string['mod_form_block_presentation'] = 'Contenu de présentation';
$string['mod_form_block_presentation_default'] = 'Contenu par défaut de la présentation';
$string['mod_form_block_record'] = 'Paramètres d\'enregistrement';
$string['mod_form_block_recordings'] = 'Vue pour l\'enregistrement';
$string['mod_form_block_room'] = 'Paramètres de l\'activité/salle';
$string['mod_form_block_schedule'] = 'Horaire de la session';
$string['mod_form_field_block_clienttype'] = 'Technologie client web';
$string['mod_form_field_closingtime'] = 'Accès clos';
$string['mod_form_field_conference_name'] = 'Nom de la conférence';
$string['mod_form_field_disablecam'] = 'Désactiver les webcams';
$string['mod_form_field_disablemic'] = 'Désactiver les microphones';
$string['mod_form_field_disablenote'] = 'Désactiver les notes partagées';
$string['mod_form_field_disableprivatechat'] = 'Désactiver la discussion privée';
$string['mod_form_field_disablepublicchat'] = 'Désactiver la discussion publique';
$string['mod_form_field_duration'] = 'Durée';
$string['mod_form_field_duration_help'] = 'Définir la durée d\'une conférence établira la durée maximale d\'une conférence, avant que l\'enregistrement ne se termine.';
$string['mod_form_field_hideuserlist'] = 'Cacher la liste des participants';
$string['mod_form_field_instanceprofiles'] = 'Type de conférence';
$string['mod_form_field_instanceprofiles_help'] = 'Choisissez le type de cette conférence BigBlueButton.';
$string['mod_form_field_intro'] = 'Description';
$string['mod_form_field_intro_help'] = 'Une courte description pour la classe ou conférence.';
$string['mod_form_field_lockedlayout'] = 'Verrouiller la disposition de la salle';
$string['mod_form_field_lockonjoin'] = 'Ignorer les paramètres de verrouillage';
$string['mod_form_field_lockonjoinconfigurable'] = 'Autoriser à ignorer les paramètres de verrouillage';
$string['mod_form_field_muteonstart'] = 'Muet au début';
$string['mod_form_field_name'] = 'Nom de la conférence';
$string['mod_form_field_nosettings'] = 'Aucun paramètre ne peut être modifié';
$string['mod_form_field_notification'] = 'Notifier ce changement aux utilisateurs inscrits';
$string['mod_form_field_notification_created_help'] = 'Envoyer une notification à tous les utilisateurs inscrits pour leur faire savoir que cette activité a été créée.';
$string['mod_form_field_notification_help'] = 'Envoyer une notification à tous les utilisateurs inscrits pour leur faire savoir que cette activité a été ajoutée ou mise à jour.';
$string['mod_form_field_notification_modified_help'] = 'Envoyer une notification à tous les utilisateurs inscrits pour leur faire savoir que cette activité a été mise à jour.';
$string['mod_form_field_notification_msg_at'] = 'à';
$string['mod_form_field_notification_msg_created'] = 'ajouté';
$string['mod_form_field_notification_msg_modified'] = 'mis à jour';
$string['mod_form_field_openingtime'] = 'Accès ouvert';
$string['mod_form_field_participant_add'] = 'Ajouter une affectation';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Modérateur';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Participant';
$string['mod_form_field_participant_list'] = 'Liste des affectations';
$string['mod_form_field_participant_list_action_add'] = 'Ajouter';
$string['mod_form_field_participant_list_action_remove'] = 'Supprimer';
$string['mod_form_field_participant_list_text_as'] = 'rejoins la session en tant que';
$string['mod_form_field_participant_list_type_all'] = 'Tous les utilisateurs inscrits';
$string['mod_form_field_participant_list_type_owner'] = 'Propriétaire';
$string['mod_form_field_participant_list_type_role'] = 'Rôle';
$string['mod_form_field_participant_list_type_user'] = 'Utilisateur';
$string['mod_form_field_record'] = 'La session peut être enregistrée';
$string['mod_form_field_recordallfromstart'] = 'Tout enregistrer du début';
$string['mod_form_field_recordhidebutton'] = 'Masquer le bouton d\'enregistrement';
$string['mod_form_field_recordings_deleted'] = 'Inclure les enregistrements des activités supprimées';
$string['mod_form_field_recordings_html'] = 'Afficher la table en HTML';
$string['mod_form_field_recordings_imported'] = 'Afficher uniquement les liens importés';
$string['mod_form_field_recordings_preview'] = 'Afficher l\'aperçu de l\'enregistrement';
$string['mod_form_field_room_name'] = 'Nom de la conférence';
$string['mod_form_field_userlimit'] = 'Limite utilisateurs';
$string['mod_form_field_userlimit_help'] = 'Limite maximum d\'utilisateurs dans une conférence. Si la limite indiquée est 0, le nombre d\'utilisateurs sera illimité.';
$string['mod_form_field_voicebridge'] = 'Connexion orale [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Erreur de format. Vous devez saisir un nombre entre 1 et 9999.';
$string['mod_form_field_voicebridge_help'] = 'Numéro de conférence vocale que les participants entrent pour rejoindre la conférence vocale. Un nombre entre 1 et 9999 doit être saisi. Si la valeur est 0, un nombre aléatoire sera généré par BigBlueButton. Un nombre 7 sera placé avant les 4 chiffres saisis.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Valeur non unique. Ce numéro est utilisé par une autre salle ou une conférence.';
$string['mod_form_field_wait'] = 'Attendez le modérateur';
$string['mod_form_field_wait_help'] = 'Les participants doivent attendre qu\'un modérateur entre dans la session avant de pouvoir le faire';
$string['mod_form_field_welcome'] = 'Message d\'accueil';
$string['mod_form_field_welcome_default'] = '<br>Bienvenue à <b>%%CONFNAME%%</b> !<br><br>Pour obtenir de l\'aide sur l\'utilisation de BigBlueButton, consultez ces (courtes) <a href="event:http://www.bigbluebutton.org/content/videos"><u>vidéos tutorielles</u></a>.<br><br>Pour rejoindre l\'audio, cliquez sur l\'icône du téléphone (en haut au centre). <b>Veuillez utiliser un casque pour ne pas causer de bruit de fond aux autres.</b>';
$string['mod_form_field_welcome_help'] = 'Remplace le message de bienvenue par défaut défini pour le serveur BigBlueButton. Le message peut inclure des mots clés (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) qui seront substitués automatiquement, ainsi que des balises HTML comme <b>…</b> ou <i></i>';
$string['mod_form_locksettings'] = 'Paramètres de verrouillage';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton vous permet de créer à partir de Moodle des liens vers des classes en ligne en temps réel en utilisant BigBlueButton, un système de conférence web open source pour l\'enseignement à distance.

En utilisant BigBlueButton, vous pouvez indiquer le titre, la description, l\'agenda (ce qui donne une plage de dates pour rejoindre la session), des groupes et des détails sur l\'enregistrement de la session en ligne.';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'Administration BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Afin de créer et de rejoindre des sessions BigBlueButton, les données utilisateur doivent être échangées avec le serveur.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Le nom complet de l\'utilisateur qui accède au serveur BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'L\'identifiant de l\'utilisateur qui accède au serveur BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Stocke la configuration de la salle ou de l\'activité qui définit les fonctionnalités et le comportement général de la session BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Une liste de règles qui définissent le rôle des utilisateurs dans la réunion en direct. Un identifiant d\'utilisateur peut être enregistré car les autorisations peuvent être accordées par rôle ou par utilisateur.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Stocke les événements déclenchés lors de l\'utilisation du plugin.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Le type d\'événement déclenché par l\'utilisateur.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'L\'identifiant de la réunion à laquelle l\'utilisateur a eu accès.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Peut inclure des informations supplémentaires relatives à la réunion ou à l\'enregistrement affecté par l\'événement.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'L\'heure à laquelle le journal a été créé.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'L\'identifiant de l\'utilisateur qui a déclenché l\'événement.';
$string['removedevents'] = 'Événements supprimés';
$string['removedlogs'] = 'Journaux personnalisés supprimés';
$string['removedrecordings'] = 'Enregistrements supprimés';
$string['removedtags'] = 'Mots clés supprimés';
$string['resetevents'] = 'Supprimer les événements';
$string['resetlogs'] = 'Supprimer les journaux personnalisés';
$string['resetlogs_help'] = 'Supprimer les journaux personnalisés causera la perte des références vers les enregistrements';
$string['resetrecordings'] = 'Supprimer les enregistrements';
$string['resetrecordings_help'] = 'La suppression des enregistrements les rendra inaccessibles de partout et ne pourra pas être annulée.';
$string['resettags'] = 'Supprimer les mots clés';
$string['search:activity'] = 'BigBlueButton - informations sur l\'activité';
$string['search:tags'] = 'BigBlueButton - informations sur les mots clés';
$string['sendnotification'] = 'Envoyer une notification';
$string['started_at'] = 'Débute';
$string['starts_at'] = 'A débuté';
$string['view_conference_action_end'] = 'Terminer la session';
$string['view_conference_action_join'] = 'Entrer dans la session';
$string['view_error_action_not_completed'] = 'L\'action n\'a pas pu être complétée';
$string['view_error_bigbluebutton'] = 'Une erreur est survenue dans BigBlueButton. {$a}';
$string['view_error_create'] = 'Le serveur BigBlueButton a renvoyé un message d\'erreur, la conférence n\'a pas pu être créée.';
$string['view_error_current_state_not_found'] = 'L\'état actuel n\'a pas été trouvé. L\'enregistrement a peut-être été supprimé ou le serveur BigBlueButton n\'est pas compatible avec l\'action effectuée.';
$string['view_error_import_no_courses'] = 'Aucun cours où chercher des enregistrements';
$string['view_error_import_no_recordings'] = 'Aucun enregistrement à importer dans ce cours';
$string['view_error_invalid_session'] = 'La session est échue. Retournez sur la page d\'accueil de l\'activité.';
$string['view_error_max_concurrent'] = 'Le nombre de sessions simultanées autorisé a été atteint.';
$string['view_error_meeting_not_running'] = 'Quelque chose ne va pas, la conférence n\'a pas lieu.';
$string['view_error_no_group'] = 'Il n\'y a pas de groupe configuré actuellement. Veuillez créer des groupes avant d\'essayer de vous connecter à la conférence.';
$string['view_error_no_group_student'] = 'Vous n\'avez pas été inscrit dans un groupe. Veuillez contacter votre enseignant, ou l\'administrateur.';
$string['view_error_no_group_teacher'] = 'Il n\'y a pas de groupe configuré actuellement. Veuillez créer des groupes, ou contacter l\'administrateur.';
$string['view_error_unable_join'] = 'Impossible de rejoindre la conférence. Vérifiez l\'URL du serveur BigBlueButton ET vérifiez que le serveur est actif.';
$string['view_error_unable_join_student'] = 'Impossible de se connecter au serveur BigBlueButton. Veuillez contacter votre enseignant ou l\'administrateur.';
$string['view_error_unable_join_teacher'] = 'Impossible de se connecter au serveur BigBlueButton. Veuillez contacter l\'administrateur.';
$string['view_error_url_missing_parameters'] = 'Des paramètres manquent dans cet URL';
$string['view_error_userlimit_reached'] = 'Le nombre d\'utilisateurs autorisés dans une conférence a été atteint.';
$string['view_groups_nogroups_warning'] = 'La salle a été configurée pour utiliser les groupes mais il n\'y aucun groupe défini dans le cours.';
$string['view_groups_notenrolled_warning'] = 'La salle a été configurée pour utiliser les groupes mais vous n\'êtes inscrit.e dans aucun.';
$string['view_groups_selection'] = 'Sélectionnez le groupe que vous souhaitez joindre, et confirmez l\'action';
$string['view_groups_selection_join'] = 'Joindre';
$string['view_groups_selection_warning'] = 'Il y a une salle de conférence pour chaque groupe. Si vous avez accès à plus d\'une, assurez-vous de choisir la bonne.';
$string['view_login_moderator'] = 'Connexion comme modérateur…';
$string['view_login_viewer'] = 'Connexion comme participant…';
$string['view_message_and'] = 'et';
$string['view_message_conference_has_ended'] = 'Cette conférence est terminée.';
$string['view_message_conference_in_progress'] = 'Cette conférence est en cours.';
$string['view_message_conference_not_started'] = 'Cette conférence n\'a pas encore démarré.';
$string['view_message_conference_room_ready'] = 'Cette salle de conférence est prête. Vous pouvez rejoindre la session maintenant.';
$string['view_message_conference_wait_for_moderator'] = 'En attente d\'un modérateur pour pouvoir joindre la session.';
$string['view_message_finished'] = 'Cette activité est terminée.';
$string['view_message_has_joined'] = 'a rejoint';
$string['view_message_have_joined'] = 'ont rejoint';
$string['view_message_hour'] = 'heure';
$string['view_message_hours'] = 'heures';
$string['view_message_importrecordings_disabled'] = 'L\'option pour importer les liens d\'enregistrement n\'est pas activée sur ce serveur.';
$string['view_message_minute'] = 'minute';
$string['view_message_minutes'] = 'minutes';
$string['view_message_moderator'] = 'modérateur';
$string['view_message_moderators'] = 'modérateurs';
$string['view_message_norecordings'] = 'Aucun enregistrement encore disponible pour cette conférence.';
$string['view_message_notavailableyet'] = 'Cette session n\'est pas encore disponible.';
$string['view_message_recordings_disabled'] = 'Les enregistrements ont été désactivés de ce serveur. Les instances de BigBlueButton pour l\'enregistrements uniquement ne peuvent pas être utilisées.';
$string['view_message_room_closed'] = 'Cette salle est fermée.';
$string['view_message_room_open'] = 'Cette salle est ouverte.';
$string['view_message_room_ready'] = 'Cette salle est prête.';
$string['view_message_session_for'] = 'la session pour';
$string['view_message_session_has_user'] = 'Il y a';
$string['view_message_session_has_users'] = 'Il y a';
$string['view_message_session_no_users'] = 'Il n\'y a pas d\'utilisateur dans cette session';
$string['view_message_session_running_for'] = 'Cette session a duré';
$string['view_message_session_started_at'] = 'Cette session a démarré à';
$string['view_message_tab_close'] = 'Cet onglet (ou fenêtre) doit être fermé(e) manuellement';
$string['view_message_times'] = 'temps';
$string['view_message_user'] = 'utilisateur';
$string['view_message_users'] = 'utilisateurs';
$string['view_message_viewer'] = 'spectateur';
$string['view_message_viewers'] = 'spectateurs';
$string['view_mobile_message_groups_not_supported'] = 'Cette instance permet de travailler avec des groupes, mais l\'application mobile ne prend pas en charge cette fonction. Veuillez ouvrir l\'application sur le bureau si vous voulez utiliser le support de groupe.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Vous avez dépassé les 45 secondes sur cette page, veuillez recharger la page pour rejoindre correctement la réunion.';
$string['view_noguests'] = 'BigBlueButton n\'est pas ouvert aux visiteurs anonymes';
$string['view_nojoin'] = 'Votre rôle ne vous permet pas de joindre cette session.';
$string['view_recording'] = 'enregistrement';
$string['view_recording_actionbar'] = 'Barre d\'outils';
$string['view_recording_activity'] = 'Activité';
$string['view_recording_button_import'] = 'Import de liens d\'enregistrement';
$string['view_recording_button_return'] = 'Retour';
$string['view_recording_course'] = 'Cours';
$string['view_recording_date'] = 'Date';
$string['view_recording_delete_confirmation'] = 'Voulez vous vraiment supprimer cet {$a} ?';
$string['view_recording_delete_confirmation_warning_p'] = 'Cet enregistrement a {$a} liens associés qui ont été importés dans différents cours ou activités. Si l\'enregistrement est supprimé, ces liens le seront également';
$string['view_recording_delete_confirmation_warning_s'] = 'Cet enregistrement a {$a} lien associé qui a été importé dans une activité ou un cours différent. Si l\'enregistrement est supprimé, ce lien le sera également';
$string['view_recording_description'] = 'Description';
$string['view_recording_duration'] = 'Durée';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'L\'URL de ce format d\'enregistrement est inaccessible.';
$string['view_recording_format_notes'] = 'Notes';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Présentation';
$string['view_recording_format_screenshare'] = 'Partage d\'écran';
$string['view_recording_format_statistics'] = 'Statistiques';
$string['view_recording_format_video'] = 'Vidéo';
$string['view_recording_import_confirmation'] = 'Voulez-vous vraiment importer cet enregistrement ?';
$string['view_recording_length'] = 'Durée';
$string['view_recording_link_warning'] = 'Ce lien mène à un enregistrement crée dans une activité ou un cours différent';
$string['view_recording_list_action_delete'] = 'Suppression';
$string['view_recording_list_action_edit'] = 'Mise à jour';
$string['view_recording_list_action_play'] = 'Jouer';
$string['view_recording_list_action_process'] = 'En traitement';
$string['view_recording_list_action_protect'] = 'Protéger';
$string['view_recording_list_action_publish'] = 'Publication';
$string['view_recording_list_action_unprotect'] = 'Déprotéger';
$string['view_recording_list_action_unpublish'] = 'Unpublishing';
$string['view_recording_list_action_update'] = 'Mise à jour';
$string['view_recording_list_actionbar'] = 'Outils';
$string['view_recording_list_actionbar_delete'] = 'Supprimer';
$string['view_recording_list_actionbar_edit'] = 'Modifier';
$string['view_recording_list_actionbar_hide'] = 'Cacher';
$string['view_recording_list_actionbar_import'] = 'Importer';
$string['view_recording_list_actionbar_protect'] = 'Rendre privé';
$string['view_recording_list_actionbar_publish'] = 'Publier';
$string['view_recording_list_actionbar_show'] = 'Montrer';
$string['view_recording_list_actionbar_unprotect'] = 'Rendre public';
$string['view_recording_list_actionbar_unpublish'] = 'Annuler la publication';
$string['view_recording_list_activity'] = 'Activité';
$string['view_recording_list_course'] = 'Cours';
$string['view_recording_list_date'] = 'Date';
$string['view_recording_list_description'] = 'Description';
$string['view_recording_list_duration'] = 'Durée';
$string['view_recording_list_recording'] = 'Enregistrement';
$string['view_recording_meeting'] = 'Réunion';
$string['view_recording_modal_button'] = 'Appliquer';
$string['view_recording_modal_title'] = 'Définir les valeurs pour l\'enregistrement';
$string['view_recording_name'] = 'Nom';
$string['view_recording_playback'] = 'Lecture';
$string['view_recording_preview'] = 'Aperçu';
$string['view_recording_preview_help'] = 'Survolez une image pour la voir en taille réelle';
$string['view_recording_publish_link_deleted'] = 'Ce lien ne peut pas être re-publié car cet enregistrement n\'existe pas sur le serveur BigBlueButton. Ce lien devrait être supprimé.';
$string['view_recording_publish_link_not_published'] = 'Ce lien ne peut pas être re-publié car cet enregistrement n\'est pas publié';
$string['view_recording_recording'] = 'Enregistrement';
$string['view_recording_tags'] = 'Mots clés';
$string['view_recording_unprotect_link_deleted'] = 'La protection de ce lien ne peut être supprimée car l\'enregistrement n\'existe pas sur le serveur actuel de BigBlueButton. Le lien doit être supprimé.';
$string['view_recording_unprotect_link_not_unprotected'] = 'La protection de ce lien ne peut être supprimée car cet enregistrement est protégé';
$string['view_recording_unpublish_confirmation'] = 'Voulez-vous vraiment supprimer la publication de cet {$a} ?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Cet enregistrement a {$a} liens associés qui ont été importés dans différents cours ou activités. Si la publication de l\'enregistrement est supprimée, celles des liens le seront également';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Cet enregistrement a {$a} lien associé qui a été importé dans une activité ou un cours différent. Si la publication de l\'enregistrement est supprimée, celle du lien le sera également';
$string['view_recording_yui_first'] = 'Premier';
$string['view_recording_yui_go'] = 'Go';
$string['view_recording_yui_last'] = 'Dernier';
$string['view_recording_yui_next'] = 'Suivant';
$string['view_recording_yui_page'] = 'Page';
$string['view_recording_yui_prev'] = 'Précédent';
$string['view_recording_yui_rows'] = 'Lignes';
$string['view_recording_yui_show_all'] = 'Afficher tout';
$string['view_room'] = 'Voir une salle';
$string['view_section_title_presentation'] = 'Fichier de présentation';
$string['view_section_title_recordings'] = 'Enregistrements';
$string['view_warning_default_server'] = 'Ce serveur Moodle utilise le serveur BigBlueButton de test pré-configuré par défaut. Il devrait être remplacé par un autre pour la production.';
