<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'pdfannotator', language 'fr', version '3.10'.
 *
 * @package     pdfannotator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actiondropdown'] = 'Options';
$string['activities'] = 'Activités';
$string['addAComment'] = 'Ajouter un commentaire';
$string['all'] = 'tous';
$string['allanswers'] = 'tous';
$string['allquestions'] = 'tous';
$string['allquestionsimgtitle'] = 'Afficher toutes les questions de ce document';
$string['allquestionstitle'] = 'Toutes les questions dans';
$string['allreports'] = 'tous les rapports';
$string['annotationDeleted'] = 'L\'annotation a été supprimée';
$string['anonymous'] = 'Anonyme';
$string['answer'] = 'Réponse';
$string['answerButton'] = 'Réponse';
$string['answerSolved'] = 'Cette réponse a été marquée comme correcte par un enseignant.';
$string['answercounthelpicon'] = 'Nombre de réponses';
$string['answercounthelpicon_help'] = 'Cette colonne affiche le nombre de réponses pour chaque chaque question.';
$string['answers'] = 'réponses';
$string['answerstab'] = 'Réponses';
$string['answerstabicon'] = 'Réponses';
$string['author'] = 'Auteur';
$string['average'] = 'moyenne';
$string['average_help'] = 'Seuls les utilisateurs ayant rédigé au moins un commentaires sont inclus dans le calcul de la moyenne (arithmétique)';
$string['by'] = 'par';
$string['by_other_users'] = 'par d\'autres utilisateurs';
$string['bynameondate'] = 'par {$a->name} - {$a->date}';
$string['cancelButton'] = 'Annuler';
$string['colorPicker'] = 'Choisir une couleur';
$string['comment'] = 'Commentaire';
$string['commentDeleted'] = 'Commentaire supprimé';
$string['comments'] = 'Commentaires';
$string['correct'] = 'correct';
$string['count'] = 'nombre';
$string['createAnnotation'] = 'Ajouter une annotation';
$string['currentPage'] = 'numéro de page courant';
$string['day'] = 'jour';
$string['days'] = 'jours';
$string['delete'] = 'Supprimer';
$string['deleteComment'] = 'Supprimer le commentaire';
$string['deletedComment'] = 'commentaire supprimé';
$string['deletedQuestion'] = 'question supprimée';
$string['deletingAnnotation_manager'] = 'L\'annotation et tous les commentaires correspondants seront supprimés.';
$string['deletingAnnotation_student'] = 'L\'annotation et tous les commentaires correspondants seront supprimés. <br> Vous pouvez supprimer vos propres annotations tant qu\'elles n\'ont pas été commentées par d\'autres utilisateurs.';
$string['deletingComment'] = 'Le commentaire sera supprimé. Il sera affiché comme supprimé sauf s\'il s\'agit du dernier commentaire de son sujet.';
$string['deletingCommentTitle'] = 'Êtes-vous sûr ?';
$string['deletingQuestion_manager'] = 'Le commentaire sera supprimé. <br> Conseil : Si vous souhaitez également supprimer toutes les réponses, supprimez l\'annotation du document.';
$string['deletionForbidden'] = 'Suppression non autorisée';
$string['didyouknow'] = 'Le saviez-vous ?';
$string['dnduploadpdfannotator'] = 'Créer un fichier pour l\'annotation PDF';
$string['document'] = 'Document';
$string['drawing'] = 'Dessinez dans le document avec le stylo.';
$string['edit'] = 'Modifier';
$string['editAnnotationTitle'] = 'Êtes-vous sûr ?';
$string['editButton'] = 'Enregistrer';
$string['editedComment'] = 'dernière édition';
$string['enterText'] = 'Saisir le texte';
$string['entity_helptitle'] = 'Aide pour';
$string['error'] = 'Erreur !';
$string['error:addAnnotation'] = 'Une erreur s\'est produite lors de l\'ajout d\'une annotation.';
$string['error:addComment'] = 'Une erreur s\'est produite lors de l\'ajout du commentaire.';
$string['error:closequestion'] = 'Une erreur s\'est produite lors de la fermeture / ouverture de la question.';
$string['error:deleteAnnotation'] = 'Une erreur s\'est produite lors de la suppression d\'une annotation.';
$string['error:editAnnotation'] = 'Une erreur s\'est produite lors de la modification d\'une annotation.';
$string['error:editcomment'] = 'Une erreur s\'est produite lors de la tentative de modification d\'un commentaire.';
$string['error:getAllQuestions'] = 'Une erreur s\'est produite lors de la récupération des questions de ce document.';
$string['error:getAnnotation'] = 'Une erreur s\'est produite lors de la récupération de l\'annotation.';
$string['error:getAnnotations'] = 'Une erreur s\'est produite lors de la récupération de toutes les annotations.';
$string['error:getComments'] = 'Une erreur s\'est produite lors de la récupération des commentaires.';
$string['error:getQuestions'] = 'Une erreur s\'est produite lors de la récupération des questions de cette page.';
$string['error:markasread'] = 'L\'élément n\'a pas pu être marqué comme lu.';
$string['error:markasunread'] = 'L\'élément n\'a pas pu être marqué comme non lu.';
$string['error:openingPDF'] = 'Une erreur s\'est produite lors de l\'ouverture du fichier PDF.';
$string['error:openprintview'] = 'Une erreur s\'est produite lors de la tentative d\'ouverture du fichier PDF dans Acrobat Reader.';
$string['error:printcomments'] = 'Une erreur s\'est produite lors de l\'ouverture des commentaires dans un fichier PDF.';
$string['error:redihideCommentsplayComment'] = 'Une erreur s\'est produite lors de la réinsertion du commentaire pour les participants.';
$string['error:renderPage'] = 'Une erreur s\'est produite lors de l\'affichage de la page.';
$string['error:reportComment'] = 'Une erreur s\'est produite lors de l\'enregistrement du rapport.';
$string['error:subscribe'] = 'Une erreur s\'est produite lors de l\'abonnement à la question.';
$string['error:unsubscribe'] = 'Une erreur s\'est produite lors du désabonnement à la question.';
$string['error:voteComment'] = 'Une erreur s\'est produite lors de l\'enregistrement du vote.';
$string['eventreport_added'] = 'Un commentaire a été signalé';
$string['filenotfound'] = 'Fichier non trouvé.';
$string['forward'] = 'Transmettre';
$string['forwardedquestionhtml'] = '{$a->sender} vous a transmis la question suivante : <br /> <br />
        "{$a->questioncontent}" <br /> <br />
        Avec le message : <br /> <br />
        "{$a->message}" <br /> <br />
        La question est disponible <a href="{$a->urltoquestion}">ici</a>.';
$string['forwardedquestiontext'] = '{$a->sender} vous a transmis la question suivante :

        "{$a->questioncontent}"

        avec le message :

        "{$a->message}

         la question est disponible à : {$a->urltoquestion}';
$string['fullscreen'] = 'Plein écran';
$string['fullscreenBack'] = 'Quitter le mode plein écran';
$string['global_setting_anonymous'] = 'Autoriser les posts anonymes ?';
$string['global_setting_anonymous_desc'] = 'Avec cette option, vous autorisez vos utilisateurs à poster des commentaires anonymement. Cette option active les publication anonyme globalement';
$string['global_setting_latexapisetting'] = 'API LaTeX vers PNG';
$string['global_setting_latexapisetting_desc'] = 'API pour convertir Latex en PNG pour les téléchargements PDF. <br>
        Remarque : Si vous utilisez l\'API Google Chart, Google obtiendra toutes les formules incluses dans le document si quelqu\'un choisit d\'utiliser LaTeX<br>
        Si vous utilisez l\'API Moodle, vous avez besoin qu\'un latex, dvips et convertisseur binaire soit installé sur votre serveur.
        (Voir <a href="https://docs.moodle.org/38/en/TeX_notation_filter">la Documentation Moodle</a>)';
$string['global_setting_latexusegoogle'] = 'API Google Chart';
$string['global_setting_latexusemoodle'] = 'API interne de Moodle';
$string['global_setting_use_private_comments'] = 'Autoriser les notes personnelles ?';
$string['global_setting_use_private_comments_desc'] = 'Autorise les participants à rédiger des annotations personnelles et des notes personnelles';
$string['global_setting_use_protected_comments'] = 'Autoriser les commentaires privés ?';
$string['global_setting_use_protected_comments_desc'] = 'Autorise les participants à rédiger des annotation privées et des commentaires privés. Seul l\'auteur et l\'administrateur peuvent voir ce commentaire.';
$string['global_setting_use_studentdrawing'] = 'Autoriser les dessins pour les participants ?';
$string['global_setting_use_studentdrawing_desc'] = 'Veuillez noter que les dessins sont anonymes et ne peuvent être ni commentés, ni rapportés.';
$string['global_setting_use_studenttextbox'] = 'Autoriser les zones de texte pour les participants ?';
$string['global_setting_use_studenttextbox_desc'] = 'Veuillez noter que les annotations de zone de texte sont anonymes et ne peuvent être ni commentées ni rapportées.';
$string['global_setting_useprint'] = 'Autoriser l\'enregistrement et l\'impression ?';
$string['global_setting_useprint_comments'] = 'Autoriser l\'enregistrement / l\'impression des commentaires ?';
$string['global_setting_useprint_comments_desc'] = 'Autoriser les participants à enregistrer et imprimer les annotations et les commentaires';
$string['global_setting_useprint_desc'] = 'Permettre aux participants de sauvegarder et d’imprimer le document pdf et ses commentaires';
$string['global_setting_useprint_document'] = 'Autoriser l\'enregistrement / l\'impression du document ?';
$string['global_setting_useprint_document_desc'] = 'Permettre aux participants de sauvegarder et d’imprimer le document pdf';
$string['global_setting_usevotes'] = 'Autoriser les liens vers les commentaires ?';
$string['global_setting_usevotes_desc'] = 'Avec cette option, les utilisateurs peuvent aimer / voter pour les postes autres que les leurs.';
$string['hiddenComment'] = 'Commentaire masqué';
$string['hiddenforparticipants'] = 'Masqué aux étudiants';
$string['hideAnnotations'] = 'Masquer les annotations';
$string['highlight'] = 'Surligner le texte et ajouter un commentaire.';
$string['hour'] = 'heure';
$string['hours'] = 'heures';
$string['in_course'] = 'dans ce cours';
$string['in_document'] = 'dans ce document';
$string['infonocomments'] = 'Ce document ne contient aucun commentaire pour le moment.';
$string['iscorrecthelpicon'] = 'Correct';
$string['iscorrecthelpicon_help'] = 'Lorsqu\'un enseignant ou un responsable a marqué une réponse comme correcte, une coche verte apparaît à côté.';
$string['itemsperpage'] = 'Éléments par page';
$string['justnow'] = 'juste maintenant';
$string['lastanswered'] = 'Dernière réponse';
$string['lastedited'] = 'Dernière édition';
$string['legacyfiles'] = 'Migration de l\'ancien fichier de cours';
$string['legacyfilesactive'] = 'Actif';
$string['legacyfilesdone'] = 'Terminé';
$string['like'] = 'aimer';
$string['likeAnswer'] = 'utile';
$string['likeAnswerForbidden'] = 'déjà marqué utile';
$string['likeCountAnswer'] = 'des participants considèrent cette réponse utile';
$string['likeCountQuestion'] = 'Des participants sont égalements intéressés par cette question';
$string['likeForbidden'] = 'Vous n\'êtes pas autoriser à aimer ce commentaire';
$string['likeOwnComment'] = 'propre commentaire';
$string['likeQuestion'] = 'question intéressante';
$string['likeQuestionForbidden'] = 'déjà marqué comme utile';
$string['loading'] = 'Chargement !';
$string['markCorrect'] = 'Marqué comme correct';
$string['markSolved'] = 'Fermer la question';
$string['markUnsolved'] = 'Réouvrir la question';
$string['markasread'] = 'Marqué comme lu';
$string['markasunread'] = 'Marqué comme non lu';
$string['markhidden'] = 'Cacher';
$string['me'] = 'moi';
$string['messageforwardform'] = 'Votre message au(x) destinataire(s)';
$string['messageprovider:forwardedquestion'] = 'Lorsqu\'une question vous a été transmise';
$string['messageprovider:newanswer'] = 'Lorsque l\'on répond à une question à laquelle vous êtes abonné·e';
$string['messageprovider:newquestion'] = 'Lorsqu\'une nouvelle question est posée';
$string['messageprovider:newreport'] = 'Lorsqu\'un commentaire a été signalé';
$string['min2Chars'] = 'Une question ou un commentaire avec moins de 2 caractères n\'est pas autorisé.';
$string['minute'] = 'minute';
$string['minutes'] = 'minutes';
$string['missingAnnotation'] = 'L\'annotation correspondante ne peut pas être trouvée·!';
$string['modifiedby'] = 'par';
$string['modulename_help'] = 'Cette activité permet de collaborer sur un document PDF. Les participants peuvent annoter des parties spécifiques du PDF et en discuter avec les autres.';
$string['month'] = 'mois';
$string['months'] = 'mois';
$string['myanswers'] = 'mes réponses';
$string['mypost'] = 'Mon poste';
$string['myprivate'] = 'Mes notes personnelles';
$string['myprotectedanswers'] = 'Mes réponses privées';
$string['myprotectedquestions'] = 'Mes questions privées';
$string['mypublicanswers'] = 'Mes réponses publiques';
$string['mypublicquestions'] = 'Mes questions publiques';
$string['myquestion'] = 'Question';
$string['myquestions'] = 'mes questions';
$string['newanswerhtml'] = 'Vous vous êtes abonné à la question "{$a->question}" à laquelle {$a->answeruser} a répondu par le commentaire suivant : <br /> <br /> "{$a->content}"<br /><br />
La réponse est disponible <a href="{$a->urltoanswer}">ici</a>.';
$string['newanswertext'] = 'Vous vous êtes abonné à la question "{$a->question}"à laquelle {$a->answeruser} a répondu par le commentaire suivant :

    "{$a->content}"

La réponse est disponible à l\'adresse suivante : {$a->urltoanswer}';
$string['newquestionhtml'] = 'Une nouvelle question a été ajoutée par {$a->answeruser} avec le contenu suivant : <br /> <br /> "{$a->content}"<br /><br />
La question est disponible <a href="{$a->urltoanswer}">ici</a>.';
$string['newquestions'] = 'Demandé récemment';
$string['newquestiontext'] = 'Une nouvelle question a été ajoutée par {$a->answeruser} avec le contenu suivant :

    "{$a->content}"

La question est disponible à l\'adresse suivante : {$a->urltoanswer}';
$string['nextPage'] = 'Page suivante';
$string['noCommentsupported'] = 'Ce type d\'annotation ne prend par en charge les commentaires.';
$string['noanswers'] = 'Il n\'y a pas de réponse dans ce cours actuellement.';
$string['noanswerssubscribed'] = 'Il n\'y a aucune réponse aux questions auxquelles vous êtes abonné pour le moment.';
$string['nomyposts'] = 'Vous n\'avez pas posté de question ni de réponse dans ce cours pour le moment.';
$string['noquestions'] = 'Aucune question dans cette page !';
$string['noquestions_overview'] = 'Il n\'y a pas de question dans ce cours actuellement.';
$string['noquestions_view'] = 'Il n\'y a pas de question dans ce document actuellement.';
$string['noquestionsclosed_overview'] = 'Il n\'y a pas de question fermée dans ce cours actuellement.';
$string['noquestionsopen_overview'] = 'Il n\'y a pas de question ouverte dans ce cours actuellement.';
$string['noreadreports'] = 'Il n\'y a pas de rapport lu dans ce cours actuellement.';
$string['noreports'] = 'Il n\'y a pas de rapport dans ce cours actuellement.';
$string['nosearchresults'] = 'Aucun résultat trouvé.';
$string['notificationsubject:forwardedquestion'] = 'Question transférée dans {$a}';
$string['notificationsubject:newanswer'] = 'Nouvelle réponse à une question à laquelle vous êtes abonné dans {$a}';
$string['notificationsubject:newquestion'] = 'Nouvelle question dans {$a}';
$string['notificationsubject:newreport'] = 'Un commentaire a été signalé dans {$a}';
$string['nounreadreports'] = 'Il n\'y a pas de rapport non lu dans ce cours actuellement.';
$string['on'] = 'le';
$string['onlyDeleteOwnAnnotations'] = ', parce qu\'elle appartient à un autre utilisateur.';
$string['onlyDeleteUncommentedPosts'] = ', parce que les commentaires des autres utilisateurs seraient également supprimés.';
$string['openquestions'] = 'non résolu';
$string['overview'] = 'Vue d\'ensemble';
$string['overviewactioncolumn'] = 'Gérer';
$string['ownpoststab'] = 'Mes publications';
$string['ownpoststabicon'] = 'Mes publications';
$string['ownpoststabicon_help'] = 'Cette page affiche tous les commentaires que vous avez publiés dans ce cours.';
$string['page'] = 'page';
$string['pdfButton'] = 'Document';
$string['pdfannotator'] = 'Document';
$string['pdfannotator:addinstance'] = 'Ajouter une instance';
$string['pdfannotator:administrateuserinput'] = 'Administrer les commentaires';
$string['pdfannotator:closeanyquestion'] = 'Fermer toute question';
$string['pdfannotator:closequestion'] = 'Fermer ses propres questions';
$string['pdfannotator:create'] = 'Créer des annotations et des commentaires';
$string['pdfannotator:deleteany'] = 'Supprimer toute annotation et commentaire';
$string['pdfannotator:deleteown'] = 'Supprimer vos propres annotations et commentaires';
$string['pdfannotator:edit'] = 'Modifier vos propres annotations et commentaires';
$string['pdfannotator:editanypost'] = 'Modifier toutes annotations et tous les commentaires';
$string['pdfannotator:forwardquestions'] = 'Questions transférées';
$string['pdfannotator:getforwardedquestions'] = 'Recevoir les questions transférées';
$string['pdfannotator:hidecomments'] = 'Masquer les commentaires pour les participants';
$string['pdfannotator:markcorrectanswer'] = 'Marquer les réponses comme correctes';
$string['pdfannotator:printcomments'] = 'Télécharger les commentaires';
$string['pdfannotator:printdocument'] = 'Télécharger le document';
$string['pdfannotator:recievenewquestionnotifications'] = 'Recevoir des notifications sur les nouvelles questions';
$string['pdfannotator:report'] = 'Signaler des commentaires inappropriés au responsable du cours';
$string['pdfannotator:seehiddencomments'] = 'Voir les commentaires cachés';
$string['pdfannotator:subscribe'] = 'S\'abonner à la question';
$string['pdfannotator:usedrawing'] = 'Utiliser le dessin (même si l\'option est désactivée pour un PDF Annotation)-';
$string['pdfannotator:usetextbox'] = 'Utiliser la zone de texte (même si l\'option est désactivée pour un PDF-Annotation)';
$string['pdfannotator:view'] = 'Voir PDF Annotation';
$string['pdfannotator:viewanswers'] = 'Afficher les réponses aux questions auxquelles vous êtes abonné (page d\'aperçu)';
$string['pdfannotator:viewposts'] = 'Afficher ses propres commentaires (page d\'aperçu)';
$string['pdfannotator:viewprotectedcomments'] = 'Voir les commentaires privés';
$string['pdfannotator:viewquestions'] = 'Voir les questions ouvertes (page d\'aperçu)';
$string['pdfannotator:viewreports'] = 'Voir les commentaires signalés (overview page)';
$string['pdfannotator:viewstatistics'] = 'Voir la page des statistiques';
$string['pdfannotator:viewteacherstatistics'] = 'Voir des informations supplémentaires sur la page des statistiques';
$string['pdfannotator:vote'] = 'Voter pour une question intéressante ou un commentaire utile';
$string['pdfannotator:writeprivatecomments'] = 'Prendre des notes personnelles';
$string['pdfannotator:writeprotectedcomments'] = 'Ecrire des commentaires privés';
$string['pdfannotatorcolumn'] = 'Document';
$string['pdfannotatorcontent'] = 'Fichiers et sous-dossiers';
$string['pdfannotatorname'] = 'Outil d\'annotation PDF';
$string['pluginadministration'] = 'Administration de PDF Annotation';
$string['pluginname'] = 'PDF Annotation';
$string['point'] = 'Ajoutez une épingle dans le document et écrivez un commentaire.';
$string['prevPage'] = 'Page précédente';
$string['print'] = 'télécharger le document';
$string['printButton'] = 'Télécharger';
$string['printviewtitle'] = 'Commentaires';
$string['printwithannotations'] = 'télécharger les commentaires';
$string['privacy:metadata:core_files'] = 'PDFannotator stocke les fichiers téléchargés par l’utilisateur comme base d’annotation et de discussion.';
$string['privacy:metadata:pdfannotator_annotations'] = 'Le PDF Annotation est toujours en cours de développement. Vous pouvez nous aider à l\'adapter à vos besoins en nous faisant part de vos commentaires. Merci d\'avance';
$string['privacy:metadata:pdfannotator_annotations:annotationid'] = 'L\'ID de l\'annotation qui a été créée. Celui-ci fait référence aux données listées ci-dessus.';
$string['privacy:metadata:pdfannotator_annotations:userid'] = 'L\'ID de l\'utilisateur qui a créé cette annotation.';
$string['privacy:metadata:pdfannotator_comments'] = 'Informations sur les annotations faites par un utilisateur. Cela inclut le type d\'annotation (par exemple surbrillance ou dessin), sa position dans un fichier spécifique, ainsi que l\'heure de création.';
$string['privacy:metadata:pdfannotator_comments:annotationid'] = 'L\'ID de l\'annotation sous-jacente.';
$string['privacy:metadata:pdfannotator_comments:content'] = 'Le commentaire littéral.';
$string['privacy:metadata:pdfannotator_comments:userid'] = 'L\'ID de l\'auteur du commentaire';
$string['privacy:metadata:pdfannotator_reports'] = 'Les utilisateurs peuvent signaler les commentaires des autres utilisateurs comme étant inappropriés. Cela inclut l\'ID du commentaire reporté ainsi que celui de son auteur, le contenu et la date du signalement.';
$string['privacy:metadata:pdfannotator_reports:commentid'] = 'L\'ID du commentaire signalé.';
$string['privacy:metadata:pdfannotator_reports:message'] = 'Le contenu du rapport.';
$string['privacy:metadata:pdfannotator_reports:userid'] = 'L\'auteur du rapport.';
$string['privacy:metadata:pdfannotator_subscriptions'] = 'Informations sur les abonnements aux questions / discussions individuelles.';
$string['privacy:metadata:pdfannotator_subscriptions:annotationid'] = 'L\'ID de la question/discussion à laquelle vous vous êtes abonné.';
$string['privacy:metadata:pdfannotator_subscriptions:userid'] = 'L\'ID de l\'utilisateur avec cet abonnement.';
$string['privacy:metadata:pdfannotator_votes'] = 'Information à propos des questions et commentaires qui ont été marquées comme iintéressants ou utiles.';
$string['privacy:metadata:pdfannotator_votes:commentid'] = 'L\'ID du commentaire.';
$string['privacy:metadata:pdfannotator_votes:userid'] = 'L\'ID de l\'utilisateur qui a marqué le commentaire comme étant intéressant ou utile. Il est enregistré afin d\'empêcher les utilisateurs de voter pour le même commentaire à plusieurs reprises.';
$string['private_comments'] = 'Notes personnelles';
$string['private_comments_help'] = 'Visible uniquement par vous.';
$string['protected_answers'] = 'Réponses privées';
$string['protected_comments'] = 'Commentaires privés';
$string['protected_comments_help'] = 'Visible uniquement par vous et l\'enseignant.';
$string['protected_questions'] = 'Questions privées';
$string['public_comments'] = 'Commentaires publics';
$string['publicanswers'] = 'Réponses publiques';
$string['publicquestions'] = 'Questions publiques';
$string['question'] = 'question';
$string['questionSolved'] = 'La question est close. Cependant, vous pouvez toujours créer de nouveaux commentaires.';
$string['questionsimgtitle'] = 'Montrer toutes les questions sur cette page';
$string['questionstab'] = 'Questions non résolues';
$string['questionstabicon'] = 'Questions';
$string['questionstabicon_help'] = 'Cette page affiche toutes les questions non résolues qui ont été posées dans ce cours. Vous pouvez également choisir de voir toutes les questions résolues dans ce cours.';
$string['questionstitle'] = 'Questions sur la page';
$string['read'] = 'Lu';
$string['reason'] = 'Explication';
$string['recievenewquestionnotifications'] = 'Notifier de nouvelles questions';
$string['recipient'] = 'Destinataire(s)';
$string['recipient_help'] = 'Pour sélectectionner plusieurs personnes, maintenez la touche "Ctrl" enfoncée';
$string['recipientforwardform'] = 'Transférer à';
$string['recipientrequired'] = 'Veuillez sélectionner le(s) destinataire(s)';
$string['rectangle'] = 'Ajoutez un rectangle dans le document et écrivez un commentaire.';
$string['removeCorrect'] = 'Supprimer les marqueurs "correct"';
$string['removehidden'] = 'Montrer';
$string['report'] = 'Rapport';
$string['reportaddedhtml'] = '{$a->reportinguser} a signalé un commentaire avec le message suivant : <br /><br /> "{$a->introduction}"<br /><br />
Il est <a href="{$a->urltoreport}">disponible sur le site internet</a>.';
$string['reportaddedtext'] = '{$a->reportinguser} a signalé un commentaire avec le message suivant :

« {$a->introduction} »

Il est disponible sous : {$a->urltoreport}';
$string['reportedby'] = 'par / le';
$string['reportedcomment'] = 'Commentaire signalé';
$string['reports'] = 'commentaires signalés';
$string['reportsendbutton'] = 'Envoyer';
$string['reportstab'] = 'Commentaires signalés';
$string['reportstabicon'] = 'Commentaires signalés';
$string['reportstabicon_help'] = 'Cette page affiche les commentaires qui ont été signalés comme étant inappropriés dans ce cours. Vous pouvez choisir de n\'afficher que le rapports non lu/lu* ou tous les rapports.<br>* Tout responsable de ce cours peut marquer un signament comme lu.';
$string['reportwassentoff'] = 'Le commentaire a été signalé.';
$string['search'] = 'Recherche';
$string['searchresults'] = 'Résultats de la recherche';
$string['second'] = 'seconde';
$string['seconds'] = 'secondes';
$string['seenreports'] = 'lecture seule';
$string['send'] = 'Envoyer';
$string['sendAnonymous'] = 'poster anonymement';
$string['sendPrivate'] = 'poster une note personnelle';
$string['sendProtected'] = 'poster un commentaire privé';
$string['setting_alternative_name'] = 'Nom';
$string['setting_alternative_name_desc'] = 'Fournissez un autre nom pour le PDF. Si vide, le nom du pdf sera utilisé comme nom représentatif';
$string['setting_alternative_name_help'] = 'Si le nom fait plus de 20 caractères de long, les caractères restants seront remplacés par "..." dans l\'onglet de navigation interne de l\'annotateur.';
$string['setting_anonymous'] = 'Autoriser la publication anonyme ?';
$string['setting_fileupload'] = 'Sélectionnez un fichier pdf';
$string['setting_fileupload_help'] = 'Vous ne pouvez plus modifier le fichier sélectionné après que l\'annotateur ait été créé par un clic sur"Enregistrer".';
$string['setting_use_private_comments'] = 'Autoriser les notes personnelles';
$string['setting_use_private_comments_help'] = 'Autorise les participants à rédiger des notes personnelles. Les autres utilisateurs ne peuvent pas voir ces commentaires.';
$string['setting_use_protected_comments'] = 'Autoriser les commentaires privés';
$string['setting_use_protected_comments_help'] = 'Autorise les participants à rédiger des commentaires privés. Seul l\'auteur et les enseignants peuvent voir ce commentaire.';
$string['setting_use_studentdrawing'] = 'Dessin';
$string['setting_use_studentdrawing_help'] = 'Permettre aux participants de sauvegarder et imprimer le document PDF sans les annotations et commentaires';
$string['setting_use_studenttextbox'] = 'Zone de texte';
$string['setting_use_studenttextbox_help'] = 'Veuillez noter que les annotations par zone de texte ne sont pas anonymes et ne peuvent pas être commentées ni signalées.';
$string['setting_useprint'] = 'enregistrer et imprimer';
$string['setting_useprint_comments'] = 'enregistrer et imprimer les commentaires';
$string['setting_useprint_comments_help'] = 'Permettre aux participants de sauvegarder et imprimer les annotations et commentaires';
$string['setting_useprint_document'] = 'Sauvegarder et imprimer le document PDF';
$string['setting_useprint_document_help'] = 'Permettre aux participants de sauvegarder et imprimer le document PDF';
$string['setting_useprint_help'] = 'Veuillez noter que les annotations par dessin ne sont pas anonymes et ne peuvent pas être commentées ni signalées.';
$string['setting_usevotes'] = 'Voter/Aimer';
$string['setting_usevotes_help'] = 'En activant cette option, les utilisateurs peuvent aimer / voter pour des publications autres que les leurs.';
$string['show'] = 'Montrer';
$string['showAnnotations'] = 'Montrer les annotations';
$string['showless'] = 'moins';
$string['showmore'] = 'plus';
$string['slotdatetimelabel'] = 'Date et heure';
$string['startDiscussion'] = 'Démarrer une discussion';
$string['statistic'] = 'Statistiques';
$string['strftimedatetime'] = '%d %b %Y, %k:%M';
$string['strikeout'] = 'Barrer le texte et ajouter un commentaire.';
$string['studentdrawingforbidden'] = 'Cet annotateur ne prend pas en charge les dessins pour votre rôle d\'utilisateur.';
$string['studenttextboxforbidden'] = 'Cet annotateur ne prend pas en charge les zones de texte pour votre rôle d\'utilisateur.';
$string['subscribe'] = 'S\'abonner à ces Annotations';
$string['subscribeQuestion'] = 'S\'abonner';
$string['subscribed'] = 'Abonné';
$string['subscribedanswers'] = 'aux questions auxquelles je suis abonné·e';
$string['subtitleforreportcommentform'] = 'Votre message pour le responsable du cours';
$string['successfullyEdited'] = 'Modifications enregistrées';
$string['successfullyHidden'] = 'Les participants voient maintenant ce commentaire comme caché.';
$string['successfullyRedisplayed'] = 'Le commentaire est à nouveau visible pour les participants';
$string['successfullySubscribed'] = 'Votre abonnement à la question a été enregistré.';
$string['successfullyUnsubscribed'] = 'Votre abonnement a été annulé.';
$string['successfullyUnsubscribedPlural'] = 'Votre abonnement a été annulé. Toutes les {$a} réponses à la question ont été supprimées de ce tableau.';
$string['successfullyUnsubscribedSingular'] = 'Votre abonnement à la question a été annulé et la seul réponse a été supprimée de ce tableau.';
$string['successfullyUnsubscribedTwo'] = 'Votre abonnement a été annulé. Les deux réponses à cette questions ont été supprimées de ce tableau.';
$string['successfullymarkedasread'] = 'Le rapport a été marqué comme lu.';
$string['successfullymarkedasreadandnolongerdisplayed'] = 'Le rapport a été marqué comme lu et retiré du tableau.';
$string['successfullymarkedasunread'] = 'Le rapport a été marqué comme non lu.';
$string['successfullymarkedasunreadandnolongerdisplayed'] = 'Le rapport a été marqué comme non lu et retiré du tableau.';
$string['sumPages'] = 'Nombre de pages';
$string['text'] = 'Ajouter un texte dans le document.';
$string['titleforreportcommentform'] = 'Signaler un commentaire';
$string['titleforwardform'] = 'Tranférer la question';
$string['toreport'] = 'Rapport';
$string['unseenreports'] = 'non lu seulement';
$string['unsolvedquestionstitle'] = 'Questions non résolues';
$string['unsolvedquestionstitle_help'] = 'Toutes les questions non résolues de ce cours sont listées.';
$string['unsubscribe'] = 'Se désinscrire de ces Annotations';
$string['unsubscribeQuestion'] = 'Se désabonner';
$string['unsubscribe_notification'] = 'Pour se désabonner des notifications, veuillez cliquer <a href="{$a}">ici</a>.';
$string['unsubscribingDidNotWork'] = 'Les abonnements ne peuvent pas être annulés.';
$string['use_private_comments'] = 'Autoriser les participants à rédiger des notes personnelles ?';
$string['use_protected_comments'] = 'Autoriser les participants à rédiger des commentaires privés ?';
$string['use_studentdrawing'] = 'Activer le dessin pour les participants ?';
$string['use_studenttextbox'] = 'Activer l\'outil zone de texte pour les participants ?';
$string['useprint'] = 'Donner l’accès au PDF aux participants ?';
$string['useprint_comments'] = 'Donner l’accès au PDF et à ses commentaires aux participants ?';
$string['useprint_document'] = 'Donner l’accès au PDF aux participants ?';
$string['usevotes'] = 'Autorise les utilisateurs à aimer les commentaires.';
$string['view'] = 'Document';
$string['votes'] = 'Aimer';
$string['voteshelpicon'] = 'Aimer';
$string['voteshelpicon_help'] = 'Cette colonne vous indique combien d\'autres personnes s\'intéressent à la question';
$string['voteshelpicontwo'] = 'Aimer';
$string['voteshelpicontwo_help'] = 'Cette colonne vous indique combien de fois votre poste à été <em>aimé</em>';
$string['week'] = 'semaine';
$string['weeks'] = 'semaines';
$string['year'] = 'année';
$string['years'] = 'années';
$string['yesButton'] = 'Oui';
$string['zoom'] = 'zoom';
$string['zoomin'] = 'zoomer';
$string['zoomout'] = 'dé-zoomer';
