import datetime
import autopath
from os.path import join
import subprocess
from eoleaaf.util import db
from eoleaaf.parseaaf import main
from eoleaaf.parsedelta import main as main_delta

data = join(autopath.HERE, 'data')

keys = set(['ENTPersonFonctions', 'uid', 'personalTitle', 'ENTPersonNomPatro', 'FieldFromXMLImportActionDate', 'ENTAuxEnsMEF', 'FieldModifiedStatus', 'ENTPersonJointure', 'ENTAuxEnsClassesMatieres', 'PersEducNatPresenceDevantEleves', 'ENTAuxEnsMatiereEnseignEtab', 'sn', 'ENTPersonStructRattach', 'mail', 'id', 'ENTPersonDateNaissance', 'givenName', 'FieldToLDIFFExportActionDate', 'userPassword', 'ENTAuxEnsClasses', 'FieldActionType'])

expected = {'ENTPersonFonctions': '2729$ORI$ORIENTATION$O0040$ORIENTATION', 'uid': 'AUL14655', 'ENTAuxEnsClassesMatieres': None, 'FieldFromXMLImportActionDate': datetime.datetime(2014, 5, 27, 10, 39, 50), 'userPassword': 'OTVOHUGI', 'ENTAuxEnsMEF': None, 'FieldModifiedStatus': 1, 'ENTPersonJointure': '111111', 'ENTPersonNomPatro': 'MAUF', 'PersEducNatPresenceDevantEleves': 'N', 'givenName': 'ALBERTINE', 'ENTAuxEnsMatiereEnseignEtab': None, 'sn': 'MAUF', 'ENTPersonStructRattach': None, 'ENTPersonDateNaissance': '11/11/1911', 'mail': 'albertine.MAUF@ac-dijon.fr', 'personalTitle': 'Mme', 'FieldToLDIFFExportActionDate': None, 'id': '111111', 'ENTAuxEnsClasses': None, 'FieldActionType': 'CREATE'}

def test_20140130():
    path_aaf_complet = join(data, '20140130', 'aaf-complet')
    main(path_aaf_complet, reset_db=True, close=False)

    sql = 'select * from enseignant;'
    before = db.fetchone(sql)
    path_aaf_delta = join(data, '20140130', 'aaf-delta')
    main_delta(path_aaf_delta, close=False)

    sql = 'select * from enseignant;'
    after = db.fetchone(sql)

    keys_before = set(before.keys())
    keys_after = set(after.keys())
    #db.close()
    assert keys_before == keys_after

    for key in keys_before:
        if key == 'mail':
            assert before[key] == expected[key] #'albertine.MAUF@ac-dijon.fr'
            assert after[key] == 'AM@ac-dijon.fr'
        elif key == 'ENTPersonDateNaissance':
            assert before[key] == expected[key] #'11/11/1911'
            assert after[key] == '12/12/1912'
        elif key == 'FieldActionType':
            assert before[key] == 'CREATE'
            assert after[key] == 'DELTAUPDATE'
        else:
            assert before[key] == after[key]

