# Utilisation des couleurs et autres
. /usr/lib/eole/ihm.sh

Domaine=$(CreoleGet ad_domain)
Racine="OU=Services,"$(ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit))'|grep dn|grep Control|cut -d, -f2-)
Niveau=$1
Suffixe="OU="$Niveau","$Racine

if [ -f $Domaine.ldif ]
then
    rm -f $Domaine.ldif
fi

if [ $2 == "-i" ]
then
	# INITIALISATION DE LA FORET
	# Création du 1er niveau OU=Services,OU=$Niveau avec la sous OU Defaut
    test=`ldbsearch -H /var/lib/samba/private/sam.ldb '(&(objectclass=OrganizationalUnit))'|grep "dn: OU=Services"`
    if [ -z "$test" ]
    then
        echo "dn: "$Racine >> $Domaine.ldif
    	echo "objectClass: organizationalUnit" >> $Domaine.ldif
    	echo "" >> $Domaine.ldif
    fi
	echo "dn: "$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	echo "dn: OU=Defaut,"$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	echo "dn: OU=Amande,OU=Defaut,"$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	echo "dn: OU=Hors Amande,OU=Defaut,"$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	echo "dn: OU=Machines,OU=Defaut,"$Suffixe >> $Domaine.ldif
	echo "objectClass: organizationalUnit" >> $Domaine.ldif
	echo "" >> $Domaine.ldif
	#
	shift 2	# Pour ne pas prendre en compte dans les parametres l'option "-i" ou "-a" et la variable de 1er niveau $1
	#
	for unite in "$@"
		# Boucle pour créer les sous-OU sur le même principe que le 1er niveau Defaut
	do
	   echo "dn: OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Amande,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Hors Amande,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Machines,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	done
	# Application du fichier ldif cree precedemment
	ldbmodify -H /var/lib/samba/private/sam.ldb $Domaine.ldif
	#
	# Creation des groupes de 1er niveau
	samba-tool group add $Niveau"-Defaut-OUADM" --groupou="OU=Defaut,OU="$Niveau",OU=Services"
	samba-tool group add $Niveau"-Defaut-PCADM" --groupou="OU=Defaut,OU="$Niveau",OU=Services"
	samba-tool group add $Niveau"-Defaut-SRVADM" --groupou="OU=Defaut,OU="$Niveau",OU=Services"
	# Création du groupe integrateurs
	samba-tool group add integrateurs
	# Ajout du groupe "Services-Defaut-PCADM" comme membre du groupe integrateurs
	samba-tool group addmembers integrateurs $Niveau"-Defaut-PCADM"
	# Creation des groupes de sous-niveau
	for unite in "$@"
	do
		samba-tool group add $Niveau"-"$unite"-OUADM" --groupou="OU="$unite",OU="$Niveau",OU=Services"
		samba-tool group add $Niveau"-"$unite"-PCADM" --groupou="OU="$unite",OU="$Niveau",OU=Services"
		samba-tool group add $Niveau"-"$unite"-SRVADM" --groupou="OU="$unite",OU="$Niveau",OU=Services"
		# Ajout du groupes "Services-"$unite"-PCADM" comme membre du groupe integrateurs
		samba-tool group addmembers integrateurs $Niveau"-"$unite"-PCADM"
	done
elif [ $2 == "-a" ]
then
	# AJOUT D'UNITE(S) ET DES GROUPES CORRESPONDANTS A LA FORET EXISTANTE
	#
	shift 2	# pour ne pas prendre en compte dans les parametres l'option "-i" ou "-a" et la variable de 1er niveau $1
	#
	# Gestion des fichiers ldif
	if [ -f $Domaine.ldif ]
	then
		if [ -f $Domaine-bak.ldif ]
		then
			# Si le fichier $Domaine-bak.ldif existe
			# on concatene les fichiers $Domaine.ldif et $Domaine-bak.ldif dans le fichier $Domaine-bak.ldif
			# et on supprime le fichier $Domaine.ldif qui va être cree par la suite du script
			cat $Domaine-bak.ldif $Domaine.ldif >> $Domaine-bak2.ldif
			rm -f $Domaine.ldif $Domaine-bak.ldif
			mv $Domaine-bak2.ldif $Domaine-bak.ldif
		else
			# On renomme $Domaine.ldif en $Domaine-back.ldif
			# le fichier $Domaine.ldif va être cree par la suite du script
			mv $Domaine.ldif $Domaine-bak.ldif
		fi
	fi
	# Fin de gestion des fichiers ldif
	#
	for unite in "$@"
		# Boucle pour créer les sous-OU sur le même principe que le 1er niveau Defaut
	do
	   echo "dn: OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Amande,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Hors Amande,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	   echo "dn: OU=Machines,OU=$unite,"$Suffixe >> $Domaine.ldif
	   echo "objectClass: organizationalUnit" >> $Domaine.ldif
	   echo "" >> $Domaine.ldif
	done
	# Application du fichier ldif cree precedemment
	# Remarque : si aucune OU n'a été précisée dans la commande, soit ./add_unite.sh -a ,
	#            alors le fichier $Domaine.ldif n'existe pas et il n'y a donc rien à faire => d'où le test ci-dessous
	if [ -f $Domaine.ldif ] ; then ldbmodify -H /var/lib/samba/private/sam.ldb $Domaine.ldif ; fi
	#
	# Creation des groupes de sous-niveau
	for unite in "$@"
	do
		samba-tool group add $Niveau"-"$unite"-OUADM" --groupou="OU="$unite",OU="$Niveau",OU=Services"
		samba-tool group add $Niveau"-"$unite"-PCADM" --groupou="OU="$unite",OU="$Niveau",OU=Services"
		samba-tool group add $Niveau"-"$unite"-SRVADM" --groupou="OU="$unite",OU="$Niveau",OU=Services"
		# Ajout du groupes "Services-"$unite"-PCADM" comme membre du groupe integrateurs
		samba-tool group addmembers integrateurs $Niveau"-"$unite"-PCADM"
	done
else
	# Aide a la syntaxe du script
	# Se lance quand on execute le script sans les options -i ou -a (mauvaise syntaxe)
	Clear
	EchoRouge ".  !!! Attention a la syntaxe de la commande !!!"
	echo
	printf ".  %${len_pf}s => " "Ne pas utiliser la commande de cette façon"
	EchoOrange "$0 $1 $2 $3 $4 $5 $6 $7 $8 $9"
	echo
	EchoGras "Syntaxe de la commande : l'option -i ou -a est obligatoire"
	printf ".  %${len_pf}s => " "soit "
	EchoVert "$0 [niveau] (-i ou -a) [parametre1] [parametre2] ...   avec niveau = Unite d'Organisation sous Services et parametreX = Unite d'Organisation X"
	printf ".  %${len_pf}s => " "     "
	EchoVert "                                                     - il n'y a pas lieu de preciser l'OU Defaut, seules les autres OU sont a preciser"
	printf ".  %${len_pf}s => " "     "
	EchoVert "                                                     - si pas de parametre (avec option -i), seule l'OU Defaut sera cree"
	echo
	printf ".  %${len_pf}s => " "Si initialisation de la foret"
	if [ $# = 0 ] ;	then EchoVert "$0 -i [parametre1] [parametre2] ..."; else EchoVert "$0 $1 -i $2 $3 $4 $5 $6 $7 $8 $9"; fi
	printf ".  %${len_pf}s => " "Si ajout d'unite a la foret existante"
	if [ $# = 0 ] ;	then EchoVert "$0 -i [parametre1] [parametre2] ..."; else EchoVert "$0 $1 -a $2 $3 $4 $5 $6 $7 $8 $9"; fi
	echo -e "\n"
fi
