#!/bin/bash
#
# Enregistrement Zéphir automatique
# Montages de deux fichier de log. l'utilisation de BOOT_LOG_FILE_STATUS ce fait dans _wait_for_poff_or_error du script deploy-auto

# shellcheck disable=SC1091
source ./context.sh
source ./00_logging.sh

ZCREDS="zcreds.sc"
ZCA="zephir-ca.crt"
export HTTP_PROXY="${PROXY}"
export HTTPS_PROXY="${PROXY}"
export http_proxy="${PROXY}"
export https_proxy="${PROXY}"

function enr_zeph(){
    # shellcheck disable=SC2207
    creds=($(< "${ZCREDS}"))
    addr="${creds[0]}"
    user="${creds[1]}"
    pass="${creds[2]}"
    lgmsg "ENREGISTREMENT_ZEPHIR:RUNNING:Start"
    export LANG=fr_FR.UTF-8 
    export LC_ADDRESS=fr_FR.UTF-8
    export LC_NAME=fr_FR.UTF-8
    export LC_MONETARY=fr_FR.UTF-8
    export LC_PAPER=fr_FR.UTF-8
    export LC_IDENTIFICATION=fr_FR.UTF-8
    export LC_TELEPHONE=fr_FR.UTF-8
    export LC_MESSAGES=fr_FR.UTF-8
    export LC_MEASUREMENT=fr_FR.UTF-8
    export LC_CTYPE=fr_FR.UTF-8
    export LC_TIME=fr_FR.UTF-8
    export LC_ALL=fr_FR.UTF-8
    export LC_COLLATE=fr_FR.UTF-8
    export LC_NUMERIC=fr_FR.UTF-8

    http_proxy="${HTTP_PROXY}" https_proxy="${HTTPS_PROXY}" apt-eole install expect
    /usr/bin/expect << __EOF__
spawn enregistrement_zephir
set timeout 300
expect {
  "*Voulez-vous établir une configuration réseau minimale*" { send -- N\n; exp_continue }
  "*Entrez l'adresse*" { send -- ${addr}\r; exp_continue; }
  "*Entrez votre login pour l'application Zéphir*" { send -- ${user}\r; exp_continue; }
  "*Mot de passe pour l'application Zéphir pour*" { send -- ${pass}\r; exp_continue; }
  "*continuer l'enregistrement (O/N) ?*" { send -- O\n; exp_continue; }
  "*créer le serveur dans la base du serveur Zéphir*" { send -- N\r; exp_continue; }
  "*rien pour saisir directement un n*" { send -- \r; exp_continue; }
  "*entrez le n° identifiant le serveur l'application*" { send -- ${ZEPHIR_ID}\n; exp_continue; }
  "*Voulez vous migrer le serveur vers le module*" { send -- O\n; exp_continue; }
  "*matériel*" { send -- \n; exp_continue; }
  "*processeur*" { send -- \n; exp_continue; }
  "*disque dur*" { send -- \n; exp_continue; }
  "*exp_continuer*" { send -- O\r; exp_continue; }
  "*Entrez le numéro de votre choix*" { send -- 2\r; exp_continue; }
  "*le numéro attribué à ce serveur sur le serveur Zéphir est : ${ZEPHIR_ID}*" { exp_continue; }
  timeout { exit }
  eof { exit }
}
__EOF__
    return $?
}


function is_registred(){
  # seul le compte rendu nous interesse --> /dev/null
  enregistrement_zephir -c >/dev/null
  return $?
}

function is_zephir_available(){

  # shellcheck disable=SC2207
  creds=($(< "${ZCREDS}"))
  addr="${creds[0]}"

  cnt=0
  timeout=900
  while [[ "${cnt}" -ne "${timeout}" ]]
  do
    nc -z -w2 "${addr}" 7080
    res=${?}
    if [[ ${res} -eq 0 ]]
    then
      return 0
      break
    fi
    cnt=$((cnt+1))
    sleep 1
    lgmsg "ENREGISTREMENT_ZEPHIR:RUNNING:Waiting for ${addr} port 7080 [${cnt}]"
    if [[ "${timeout}" -eq "${cnt}" ]]
    then
      return "${timeout}"
    fi
  done
}

[[ ! -e "${BOOT_LOG_FILE}" ]] && touch "${BOOT_LOG_FILE}"

if [[ -e "${ZCREDS}" ]]
then
    lgmsg "ENREGISTREMENT_ZEPHIR:STARTING:"
    if [[ -e "${ZCA}" ]]
    then
        cp -v "${ZCA}" /usr/local/share/ca-certificates/ | tee -a "${BOOT_LOG_FILE}"
        update-ca-certificates | tee -a "${BOOT_LOG_FILE}"
    fi

    is_registred
    res="${?}"
    if [[ "${res}" -eq 0 ]]
    then
      lgmsg "ENREGISTREMENT_ZEPHIR:DONE:"
      exit 0
    fi

    sleep 5
    is_zephir_available
    res=${?}
    if [[ ${res} -ne 0 ]]
    then
      lgmsg "ENREGISTREMENT_ZEPHIR:ERROR:Zephir server is not responding"
      exit 4
    fi

    enr_zeph | tee -a "${BOOT_LOG_FILE}"
    res="${?}"
    if [[ "${res}" -eq 0 ]]
    then
      lgmsg "ENREGISTREMENT_ZEPHIR:DONE:registered server"
      sleep 5 # cool down things
      exit 0
    else
      exit "${res}"
    fi
else
   lgmsg "ENREGISTREMENT_ZEPHIR:ERROR:${ZCREDS} file is missing !"
   exit 10
fi
