#! /usr/bin/env python3
# -*- coding: utf-8 -*-

###########################################################################
#
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# update_etabs.py
#
# procédure de récupération d'informations
# (type, libellé) sur les établissements via Zéphir
#
###########################################################################
import xmlrpc.client, sys, os, getpass, base64
# Attention egalement dans eolesso/util.py
repl_dir = '/etc/ldap/replication'
info_etabs = os.path.join(repl_dir, 'zephir', 'etabs.ini')

def exit(msg):
    sys.exit('\n%s\n' % msg)

try:
    from zephir.zephir_conf.zephir_conf import adresse_zephir, id_serveur
    from zephir.lib_zephir import TransportEole
except:
    exit("Ce serveur n'est pas enregistré sur Zéphir")

print("")
print("Procédure de mise à jour des informations sur les établissements répliqués")
print("La configuration de réplication sera mise à jour depuis Zéphir")
print("")

login = input('Entrez votre login Zéphir :')

con_ok = False
while not con_ok:
    passwd = getpass.getpass('Mot de passe (rien pour sortir):')
    if passwd == "":
        exit('Abandon')
    z_prox = xmlrpc.client.ServerProxy('https://%s:%s@%s:7080' % (login, passwd, adresse_zephir), transport=TransportEole())
    try:
        req_ok, data_etab = z_prox.uucp.get_replication_info(id_serveur)
        con_ok = True
    except:
        print("! Erreur d'authentification ou droits insuffisants sur Zéphir.")
        print(" L'accès au groupe de droits 'Gestion de la synchronisation AAF' est requis.")

# mise à jour des données du fichier etabs.ini
if not os.path.isdir(os.path.dirname(info_etabs)):
    exit('\nErreur, aucune configuration de réplication détectée')
ini_data = base64.decodestring(data_etab)
fic_etab = open(info_etabs, 'w')
fic_etab.write(ini_data)
fic_etab.close()

print("\n\nLe fichier d'information établissements à été récupéré depuis Zéphir (%s)" % info_etabs)
print("")
print("Vous pouvez ajouter/redéfinir des informations en créant un(des) fichier(s) personnalisé(s) : ")
print("\n  %s/etabs_<XXX>.ini\n" %  repl_dir)
print("Les champs reconnus sont : libelle_etab, type_etab, portail_etab\n")
print("")
print("Les données seront prises en compte au prochain démarrage du service eole-sso.")
