# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- from tplroot ~ '/map.jinja' import mapdata as ews with context %}
{%- from tplroot ~ "/libkwargs.jinja" import format_kwargs with context %}

{%- set saltstack = ews.salt %}

{%- set sls_repo_install = tplroot ~ ".salt.repo.install" %}

{%- if saltstack.pkg.use_upstream_repo %}
{%-   set requires = [{"sls": sls_repo_install}] %}
{%- else %}
{%-   set requires = [] %}
{%- endif %}

{#- serialize as YAML to avoid encoding errors on Python2 #}
include: {{ requires | map(attribute="sls") | list | yaml }}

eole-workstation/salt/minion/package/install/pkg.installed:
  pkg.installed:
    - name: {{ saltstack.minion.pkg.name }}
    - require: {{ requires | yaml }}
