# -*- coding: UTF-8 -*-
###########################################################################
#
# Eole NG
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
# eole@ac-dijon.fr
#
###########################################################################

"""
Module définissant les interfaces liées aux patrons de conception

    - Observer / Observable
    - Singleton
"""

class Singleton(object):
    """ Le DP Singleton
    """
    def __new__(cls, *args, **kwds):
        it = cls.__dict__.get("__it__")
        if it is not None:
            return it
        cls.__it__ = it = object.__new__(cls)
        return it

class Observer:
    """ Interface pour utiliser le patron de conception 'Observer'
    """

    def update(self):
        """

        """
        raise NotImplementedError("L'observateur doit implanter la méthode update")

class Observable:
    """ Classe de base pour utiliser le patron de conception 'Observable'
    """

    def __init__(self):
        self.observers = []

    def register_observer(self, observer):
        # assert observer not in self.observers
        self.observers.append(observer)

    def unregister_observer(self, observer):
        try:
            self.observers.remove(observer)
        except ValueError:
            print("%r n'était pas enregsitré en tant qu'observateur"%observer)


    def notify_observers(self):
        for o in self.observers:
            o.update()

## XXX FIXME : Si FluxListener reste dans cet état, autant utiliser Observer !
class FluxListener:

    def flux_changed(self):
        pass


class ZoneListener:

    def zone_changed(self):
        pass
