# -*- coding: UTF-8 -*-
"""Module de tests unitaires pour la gestion des directives ERA
"""

import autopath

from era.backend.processors import *
import sys


class FakeDirective(object):
    """Emule la classe directive (pour les actions)
    """
    ACTION_DENY = 1
    ACTION_ALLOW = 2
    ACTION_FORWARD = 32
    ACTION_DNAT = 8
    ACTION_MASK = 16
    ACTION_REDIRECT = 4
    
    def __init__(self, action):
        self.action = action

    def get_dest_zone(self):
        class Zone:
            pass
        z = Zone()
        z.name = 'exterieur'
        return  z

def test_processor_factory():
    """
    L{era.backend.processors.get_processor}
    Teste la fabrique de processeurs
    """
    # deny
    d = FakeDirective(FakeDirective.ACTION_DENY)
    proc = get_processor(d)
    assert (isinstance(proc, BasicDirectiveProcessor))
    # accept
    d = FakeDirective(FakeDirective.ACTION_ALLOW)
    proc = get_processor(d)
    assert (isinstance(proc, BasicDirectiveProcessor))
    # forward
    d = FakeDirective(FakeDirective.ACTION_FORWARD)
    proc = get_processor(d)
    assert (isinstance(proc, ForwardDirectiveProcessor))
    # redirect
    d = FakeDirective(FakeDirective.ACTION_REDIRECT)
    proc = get_processor(d)
    assert (isinstance(proc, RedirectDirectiveProcessor))
    # dnat
    d = FakeDirective(FakeDirective.ACTION_DNAT)
    proc = get_processor(d)
    assert (isinstance(proc, DNATDirectiveProcessor))
    # snat
    d = FakeDirective(FakeDirective.ACTION_MASK)
    proc = get_processor(d)
    assert (isinstance(proc, SNATDirectiveProcessor))
    
    
