## -*- coding: UTF-8 -*-
#"""Module de tests unitaires pour l'authentification par groupes 
#"""
#import autopath

#from os.path import join 
#from era.tests.hlcompile import high_level_compile as compiler
#from era.tests.utils import TempFile
#from era.backend.nufw_acl_plaintext import gen_acls

#def test_compile():
#    """
#        permet de savoir si des règles en -j NFQUEUE sont bien là
#    """
#    
#    tp = TempFile()
#    model_file = join(autopath.HERE, "data", "nufw_authenticated.xml")
#    compiler(model_file, tp.tmpfname)
#    assert "-j NFQUEUE" in tp.read()
#    tp.clean()

#def test_acl_plaintext():
#    """
#        verifie le fichier de sortie de nufwaclplaintext pour une directive standard
#    """
#    
#    acl_file = TempFile()
#    model_file = join(autopath.HERE, "data", "nufw_authenticated.xml")
#    gen_acls(acl_file.tmpfname, model_file)
#    expected = """[test de directive authentifiee0]
#DstPort = 80-80 
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 0 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 10001 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#outdev = eth0 

#[test de directive authentifiee1]
#DstPort = 443-443 
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 0 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 10001 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#outdev = eth0 

#[test de directive authentifiee2]
#DstPort = 3128-3128 
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 0 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 10001 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#outdev = eth0 

#[test de directive authentifiee3]
#DstPort = 8080-8080 
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 0 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 10001 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#outdev = eth0"""
#    assert expected in acl_file.read()
#    acl_file.clean()
#    
#def test_acl_plaintext_redirect():
#    """
#        verifie le fichier de sortie de nufwaclplaintext pour une directive de redirection
#    """
#    
#    acl_file = TempFile()
#    model_file = join(autopath.HERE, "data", "nufw_authenticated2.xml")
#    gen_acls(acl_file.tmpfname, model_file)
#    expected = """[gwen0]
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 1 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 10001 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#DstPort = 80-80 

#[gwen1]
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 1 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 10001 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#DstPort = 443-443 

#[gwen2]
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 1 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 10001 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#DstPort = 3128-3128 

#[gwen3]
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 1 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 10001 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#DstPort = 8080-8080 

#[gwen0_gr_tous]
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 1 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 513 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#DstPort = 80-80 

#[gwen1_gr_tous]
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 1 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 513 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#DstPort = 443-443 

#[gwen2_gr_tous]
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 1 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 513 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#DstPort = 3128-3128 

#[gwen3_gr_tous]
#DstIP = 0.0.0.0/0 
#Proto = 6 
#Decision = 1 
#SrcPort = 1024-65535 
#indev = eth2 
#gid = 513 
#flags = 2 
#SrcIP = 0.0.0.0/0 
#DstPort = 8080-8080 

#[<zone:pedago>-<zone:exterieur>]
#Decision = 1 
#outdev = eth0 
#gid = 513 
#flags = 2 
#indev = eth2 

#[<zone:admin>-<zone:exterieur>]
#Decision = 1 
#outdev = eth0 
#gid = 513 
#flags = 2 
#indev = eth1 

#[<zone:bastion>-<zone:exterieur>]
#Decision = 1 
#outdev = eth0 
#gid = 513 
#flags = 2 
#SrcIP = 192.168.230.10 

#[<zone:exterieur>-<zone:pedago>]
#Decision = 0 
#outdev = eth2 
#gid = 513 
#flags = 2 
#indev = eth0 

#[<zone:admin>-<zone:pedago>]
#Decision = 1 
#outdev = eth2 
#gid = 513 
#flags = 2 
#indev = eth1 

#[<zone:bastion>-<zone:pedago>]
#Decision = 1 
#outdev = eth2 
#gid = 513 
#flags = 2 
#SrcIP = 192.168.230.10 

#[<zone:exterieur>-<zone:admin>]
#Decision = 0 
#outdev = eth1 
#gid = 513 
#flags = 2 
#indev = eth0 

#[<zone:pedago>-<zone:admin>]
#Decision = 0 
#outdev = eth1 
#gid = 513 
#flags = 2 
#indev = eth2 

#[<zone:bastion>-<zone:admin>]
#Decision = 1 
#outdev = eth1 
#gid = 513 
#flags = 2 
#SrcIP = 192.168.230.10 

#[<zone:exterieur>-<zone:bastion>]
#DstIP = 192.168.230.10 
#Decision = 0 
#indev = eth0 
#gid = 513 
#flags = 2 

#[<zone:pedago>-<zone:bastion>]
#DstIP = 192.168.230.10 
#Decision = 0 
#indev = eth2 
#gid = 513 
#flags = 2 

#[<zone:admin>-<zone:bastion>]
#DstIP = 192.168.230.10 
#Decision = 0 
#indev = eth1 
#gid = 513 
#flags = 2"""

#    assert expected in acl_file.read()

#    # enlevons les routes par défaut
#    routes = acl_file.read().split('[gwen3]')[0]
#    assert "indev" in routes
#    assert "outdev" not in routes
#    acl_file.clean()

