# -*- coding: UTF-8 -*-
"""Teste la génération des règles iptables
"""
import autopath
from utils import GenDirective 

from era.backend.processors import get_processor

DIRECTIVE_NODE = """<directive id='essai' service='serv1' priority='1' action='1' attrs='0' src_inv='0' dest_inv='0' serv_inv='0' libelle='pas de description'>
<source name='extr1' />
<source name='extr2' />
<destination name='extr3' />
</directive>
"""

RULES_NODE = """/sbin/iptables -t filter -A zon-zon -m state --state NEW -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -o lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.3/255.255.255.255 -j DROP
/sbin/iptables -t filter -A zon-zon -m state --state NEW -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -o lo -s 10.0.0.2/255.255.255.255 -d 10.0.0.3/255.255.255.255 -j DROP
"""

DIRECTIVE_REDIRECTION = """
<directive service="serv1" priority="2" action="4" 
           attrs="0" nat_port="3128" src_inv="0" 
           dest_inv="0" serv_inv="0" libelle="pas de description">
    <source name="extr1"/>
    <destination name="extr2"/>
</directive>
"""
# une regle implicite de redirection a ete ajoutee
RULES_REDIRECTION = """/sbin/iptables -t filter -A zon-bas -i lo -p tcp --dport 3128 -j ACCEPT
/sbin/iptables -t nat -A PREROUTING -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.2/255.255.255.255 -j REDIRECT --to-ports 3128
"""

DIRECTIVE_MASQUE = """<directive service="serv1" priority="1" action="16" 
            attrs="0" nat_extr="extr2" nat_port="0" 
            src_inv="0" dest_inv="0" serv_inv="0" libelle="pas de description">
   <source name="extr1"/>
   <destination name="extr2"/>
 </directive>
"""

# FIXME : la regle implicite est generee sur une autre liste
# /sbin/iptables -t filter -A zon-zon -p tcp --dport 80 -i lo -o lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.2/255.255.255.255 -j ACCEPT
RULES_MASQUE = """/sbin/iptables -t nat -A POSTROUTING -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -o lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.2/255.255.255.255 -j SNAT --to-source 10.0.0.2
"""

DIRECTIVE_DNAT = """<directive service="serv1" priority="4" action="8" 
           attrs="0" nat_extr="extr2" nat_port="80" 
           src_inv="0" dest_inv="0" serv_inv="0" libelle="pas de description">
    <source name="extr1"/>
    <destination name="extr3"/>
</directive>"""

DIRECTIVE_TIME = """<directive service="serv1" priority="4" action="8" 
           attrs="0" nat_extr="extr2" nat_port="80" 
           src_inv="0" dest_inv="0" serv_inv="0" libelle="pas de description" time="range1">
    <source name="extr1"/>
    <destination name="extr3"/>
</directive>"""

# FIXME : la regle implicite
# /sbin/iptables -t filter -A zon-zon -p tcp --dport 80 -i lo -o lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.2 -j ACCEPT
RULES_DNAT = """/sbin/iptables -t nat -A PREROUTING -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.3/255.255.255.255 -j DNAT --to-destination 10.0.0.2:80
"""
# FIXME : regle implicite
# /sbin/iptables -t filter -A zon-zon -p tcp --dport 80 -i lo -o lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.2 -m time --timestart 02:00 --timestop 19:00 -j ACCEPT

RULES_TIME = """/sbin/iptables -t nat -A PREROUTING -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.3/255.255.255.255 -m time --timestart 02:00 --timestop 19:00 -j DNAT --to-destination 10.0.0.2:80
"""


DIRECTIVE_OPTIONAL = """<directive id='essai' service='serv1' priority='1' action='1' attrs='1' src_inv='0' dest_inv='0' serv_inv='0' libelle='pas de description'>
<source name='extr1' />
<source name='extr2' />
<destination name='extr3' />
</directive>
"""

# FIXME la regle implicite est toujours la

RULES_OPTIONAL = """/sbin/iptables -t filter -A zon-zon -m state --state NEW -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -o lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.3/255.255.255.255 -j DROP
/sbin/iptables -t filter -A zon-zon -m state --state NEW -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -o lo -s 10.0.0.2/255.255.255.255 -d 10.0.0.3/255.255.255.255 -j DROP
"""

DIRECTIVE_OPTIONAL_ACTIVE = """<directive id='essai' service='serv1' priority='1' action='1' attrs='3' src_inv='0' dest_inv='0' serv_inv='0' libelle='pas de description'>
<source name='extr1' />
<source name='extr2' />
<destination name='extr3' />
</directive>
"""

RULES_OPTIONAL_ACTIVE = """/sbin/iptables -t filter -A zon-zon -m state --state NEW -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -o lo -s 10.0.0.1/255.255.255.255 -d 10.0.0.3/255.255.255.255 -j DROP
/sbin/iptables -t filter -A zon-zon -m state --state NEW -p tcp --dport 80 --tcp-flags SYN,RST,ACK SYN -i lo -o lo -s 10.0.0.2/255.255.255.255 -d 10.0.0.3/255.255.255.255 -j DROP
"""


# print GenDirective(DIRECTIVE_OPTIONAL_ACTIVE).get_rules()
# print GenDirective(DIRECTIVE_DNAT).get_rules()


#def test_directive_node():
#    """ Directive simple """
#    assert GenDirective(DIRECTIVE_NODE).get_rules() == RULES_NODE
#    
#def test_directive_redirection():
#    """Directive essai redirection
#    """
#    assert GenDirective(DIRECTIVE_REDIRECTION).get_rules() == RULES_REDIRECTION
#    
#def test_directive_masque():
#    """Directive essai masque
#    """
#    directive = GenDirective(DIRECTIVE_MASQUE)
#    proc = get_processor(directive.directive)

#    assert directive.get_rules() == RULES_MASQUE

#    
#def test_directive_dnat():
#    """Directive essai dnat
#    """
#    assert GenDirective(DIRECTIVE_DNAT).get_rules() == RULES_DNAT
#    
#def test_directive_time():
#    """Directive essai time
#    """
#    assert GenDirective(DIRECTIVE_TIME).get_rules() == RULES_TIME
#    
#def test_directive_optional():
#    """Directive essai optionnal
#    """
#    assert GenDirective(DIRECTIVE_OPTIONAL).get_rules() == RULES_OPTIONAL
#    
#def test_directive_optional_active():
#    """Directive essai optionnal_active
#    """
#    assert GenDirective(DIRECTIVE_OPTIONAL_ACTIVE).get_rules() == RULES_OPTIONAL_ACTIVE

